"""Add initial tables.

Revision ID: c07a23ff782b
Revises: 
Create Date: 2022-08-19 15:19:01.457470

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'c07a23ff782b'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('pipeline_schedule',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('pipeline_uuid', sa.String(length=255), nullable=True),
    sa.Column('schedule_type', sa.Enum('TIME', name='scheduletype'), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('schedule_interval', sa.String(length=50), nullable=True),
    sa.Column('status', sa.Enum('ACTIVE', 'INACTIVE', name='schedulestatus'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('pipeline_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('pipeline_schedule_id', sa.Integer(), nullable=True),
    sa.Column('pipeline_uuid', sa.String(length=255), nullable=True),
    sa.Column('execution_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('status', sa.Enum('INITIAL', 'RUNNING', 'COMPLETED', 'FAILED', 'CANCELLED', name='pipelinerunstatus'), nullable=True),
    sa.ForeignKeyConstraint(['pipeline_schedule_id'], ['pipeline_schedule.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('block_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('pipeline_run_id', sa.Integer(), nullable=True),
    sa.Column('block_uuid', sa.String(length=255), nullable=True),
    sa.Column('status', sa.Enum('INITIAL', 'QUEUED', 'RUNNING', 'COMPLETED', 'FAILED', 'CANCELLED', name='blockrunstatus'), nullable=True),
    sa.ForeignKeyConstraint(['pipeline_run_id'], ['pipeline_run.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('block_run')
    op.drop_table('pipeline_run')
    op.drop_table('pipeline_schedule')
    # ### end Alembic commands ###
