# Changelog

Start tracking notable changes. Our version numbers roughly follow 
[Semantic Versioning](http://semver.org/) except just shifted over
a digit during the pre-1.0.0 phase. So in 0.X.Y.Z releases, X is
breaking changes, Y is new features or larger non-breaking changes, and Z is small bug fixes.
However, it is still pre-release software, and does not claim to
be super stable.

## [0.13.2.0]

### Fixed
- Bug that cause a fair amount (~30%) of the LiveCodeBench test cases to always fail for the non-std-in funcs that took multiple args

### Changed
- Livecodebench default to version 6
- Style of the LiveCodeBench stdout in fail messages


## [0.13.1.0]

### Fixed
- make the evaluator not crash when a solution is None (instead if it should handle it with a failed eval with exeception noted)


## [0.13.1.0]

### Added
- LsFunctionDef.get_body_src include_prefix_comment arg for optionally just getting the body without a docstring


## [0.13.0.1]

### Fixed
- Remove some debug prints that were left in docker running


## [0.13.0.0]

### Added
- Inicial add of repocod
- memory_fs additions
  - create_project_dir_from_docker_img()
  - get_size
- Solution eval TestRunResultList now has collection_error, exec_error, and timeout


## [0.12.3.0]

### Changed
- Make livecodebench use release v5 instead of v1. Configurable in a yield_livecode_problems arg


## [0.12.2.0]

### Changed
- Make the edit tag render to not strip the text in the tags
- Make the edit tag render default to not use a stop tag for chat models


## [0.12.1.0]

### Fixed
- Work on fixing the issues with defects4j. The old docker broke when
  the old Ubuntu 23 went out of support, as well as some issues
  with Java version
- Redo some of the example scripts / make results table plot

## [0.12.0.0]

### Added
- Added a default completion prompt if none is given for chat models to tell them to continue the given code.


## [0.11.3.0] - 2025-04-26

### Added
- Better use of logging. Default mode is set to INFO, but can be
changed.


### Fixed
- It seemed like it was disabled to download the dypy docker. Reenable that.

### Changed
- Moved some of the internal stuff to better seperate the real synthdatasets and the internal helper stuff.


## [0.11.2.0] - 2025-04-02

### Changed
- Adjusted the livecode default timeout to be <30s instead
of 1000 realtime seconds. This seems in line with defaults
of the reference evaluator. In some cases I think some code
was reading from stdin and waiting for EOF, which would
cause the code to hang for 1000 seconds.

## [0.11.1.1] - 2025-04-02

### Added
- This changelog file

### Changed
- Adjusted the epicbox cleanup flow to hopefully not crash
during timeouts. This modifies the destroy() method to not
clear volumes, instead relying on the working_directory context
manager to do that. However, we aren't able to get a nice
synthetic repo of the crash, so still tbd if this actually
helps downstream.

