from pathlib import Path

from examples.run_human_eval import (
    get_experiment_solver_constructors,
    run_for_problems_and_serialize,
)
from synthegrator.synthdatasets.defects4j import yield_defects4j

cur_file = Path(__file__).parent.absolute()


def get_defects4j_one_line_results(
    output_directory: Path = cur_file / "results",
    read_file_if_exists=False,
):
    print("Gathering all problems...")
    problems = list(yield_defects4j())
    return run_for_problems_and_serialize(
        problems,
        "defects4j_one_line",
        output_directory=output_directory,
        read_file_if_exists=read_file_if_exists,
        solver_constructors=get_experiment_solver_constructors(use_edit_renders=True),
    )


if __name__ == "__main__":
    get_defects4j_one_line_results()
