from pathlib import Path

from examples.run_human_eval import run_for_problems_and_serialize
from synthegrator.synthdatasets.dypybench import yield_dypybench

try:
    import torch
except ImportError:
    torch = None


cur_file = Path(__file__).parent.absolute()


def get_dypy_results(
    output_directory: Path = cur_file / "results",
    read_file_if_exists=False,
):
    print("Gathering all problems...")
    problems = list(yield_dypybench())
    return run_for_problems_and_serialize(
        problems,
        "dypybench",
        output_directory=output_directory,
        read_file_if_exists=read_file_if_exists,
        max_limit=200,
    )


if __name__ == "__main__":
    get_dypy_results()
