from pathlib import Path

from examples.run_human_eval import run_for_problems_and_serialize
from synthegrator.synthdatasets.mbpp import yield_mbpp

cur_file = Path(__file__).parent.absolute()


def get_mbpp_results(
    output_directory: Path = cur_file / "results",
    read_file_if_exists=False,
    max_limit: int = 500,
):
    print("Gathering all problems...")
    problems = list(
        yield_mbpp(
            sanitized_only=True,
            only_with_passing_reference_solution=True,
            format_as_method_completion_problem=True,
        ),
    )
    return run_for_problems_and_serialize(
        problems,
        "mbpp_func",
        output_directory=output_directory,
        read_file_if_exists=read_file_if_exists,
        max_limit=max_limit,
    )


if __name__ == "__main__":
    get_mbpp_results()
