#!/usr/bin/env bash
set -o errexit
set -o nounset
set -o pipefail
if [[ "${TRACE-0}" == "1" ]]; then set -o xtrace; fi
cd "$(dirname "$0")"

# Format with ruff
ruff format .

# Lint with ruff
echo "run ruff"
ruff check --show-fixes --fix .

SHELL_SCRIPTS=("run_lint.sh" "generate_readme.sh")
# Format shell scripts
shfmt -l -w "${SHELL_SCRIPTS[@]}"

# Check shell scripts and autofix if possible
shellcheck -f diff "${SHELL_SCRIPTS[@]}" | git apply --allow-empty

# Display nonfixed
shellcheck "${SHELL_SCRIPTS[@]}"
