import os
import zipfile
from pathlib import Path

import pandas as pd

cur_dir = Path(__file__).parent.absolute()


zip_path = cur_dir / "Defects4J_projects_clean.zip"


def read_file_from_zip(path_in_zip) -> str:
    with zipfile.ZipFile(zip_path, "r") as zip_ref:
        with zip_ref.open(path_in_zip, "r") as file:
            # Read the file content as bytes, then decode to string
            content = file.read().decode("utf-8")
    return content


def loading():
    Path("Defects4J_projects").mkdir(exist_ok=True)
    df = pd.read_csv(
        cur_dir / "Defects4J_oneLiner_metadata.csv",
        header=None,
        names=["Project", "ID", "File_Path", "LOC"],
    )

    DEFECTS4J_COMMAND = "defects4j"
    for _, row in df.iterrows():
        project_name = row["Project"]
        project_id = str(row["ID"])

        buggy_path = f"Defects4J_projects/{project_name}_{project_id}"
        fixed_path = f"{buggy_path}_fixed"

        if not Path(buggy_path).exists():
            os.system(
                f"{DEFECTS4J_COMMAND} checkout -p {project_name} -v {project_id}b -w"
                f" {buggy_path}",
            )

        if not Path(fixed_path).exists():
            os.system(
                f"{DEFECTS4J_COMMAND} checkout -p {project_name} -v {project_id}f -w"
                f" {fixed_path}",
            )

        os.system(f"cp {fixed_path}/.defects4j.config {buggy_path}/.defects4j.config")


if __name__ == "__main__":
    loading()
