import shutil
from pathlib import Path

import pandas as pd

Path("Defects4J_projects_clean").mkdir(exist_ok=True)

df = pd.read_csv(
    "Defects4J_oneLiner_metadata.csv",
    header=None,
    names=["Project", "ID", "File_Path", "LOC"],
)


DEFECTS4J_COMMAND = "defects4j"

for _, row in df.iterrows():
    project_name = row["Project"]
    project_id = str(row["ID"])
    file_path = str(row["File_Path"])

    buggy_path = Path(
        f"/Users/claudio/Projects/synthegrator/Defects4J_projects/{project_name}_{project_id}/{file_path}",
    )
    fixed_path = Path(
        f"/Users/claudio/Projects/synthegrator/Defects4J_projects/{project_name}_{project_id}_fixed/{file_path}",
    )

    buggy_path_clean = Path(
        f"Defects4J_projects_clean/{project_name}_{project_id}/{file_path}",
    )
    fixed_path_clean = Path(
        f"Defects4J_projects_clean/{project_name}_{project_id}_fixed/{file_path}",
    )
    buggy_path_clean.parent.mkdir(exist_ok=True, parents=True)
    fixed_path_clean.parent.mkdir(exist_ok=True, parents=True)
    if buggy_path.exists() and fixed_path.exists():
        shutil.copy(buggy_path, buggy_path_clean)
        shutil.copy(fixed_path, fixed_path_clean)
    else:
        print("Warning! Files don't exist")
        print("Buggy", buggy_path.exists(), buggy_path)
        print("Fixed", fixed_path.exists(), fixed_path)
