from synthegrator.memory_fs import ProjectDir, ProjectFile
import pytest
from synthegrator.memory_fs import ProjectDir, ProjectFile


def test_fs():
    mydir = ProjectDir(
        {
            "a": ProjectDir(
                {
                    "b": ProjectFile("b", b"hello"),
                    "c": ProjectFile("c", b"world"),
                },
            ),
            "d": ProjectFile("d", b"!"),
        },
    )
    assert mydir["a"]["b"].content == b"hello"
    assert mydir["a"]["c"].content == b"world"
    assert mydir["d"].content == b"!"
    assert mydir["a"]["b"].name == "b"
    assert mydir["a"]["c"].name == "c"
    assert mydir["d"].name == "d"
    assert mydir["a"].contains_only_leafs()
    assert mydir["a/c"].content == b"world"
    assert not mydir.dirty

    edited = mydir.set_node("d", ProjectFile("d", b"!!", dirty=True))
    assert edited["d"].content == b"!!"
    assert mydir["d"].content == b"!"
    assert edited["a"]["b"].content == b"hello"
    assert not mydir.dirty
    assert edited.dirty
    assert edited["d"].dirty
    assert not edited["a"].dirty

    edited2 = mydir.set_node("a/b", ProjectFile("b", b"hello world"))
    assert edited2["a"]["b"].content == b"hello world"
    assert mydir["a"]["b"].content == b"hello"
    assert edited2["a"]["c"].content == b"world"


def test_fs2():
    mydir = ProjectDir(
        {
            "a": ProjectDir(
                {
                    "b": ProjectFile("b", b"hello"),
                    "c": ProjectFile("c", b"world"),
                },
            ),
            "d": ProjectFile("d", b"!"),
        },
    )
    mydir2 = mydir.set_node("a/b", ProjectFile("b", b"goodbye"))
    assert mydir2["a"]["b"].content == b"goodbye"
    assert mydir["a"]["b"].content == b"hello"


def test_fs3():
    mydir = ProjectDir(
        {
            "a": ProjectDir(
                {
                    "b": ProjectFile("b", b"hello"),
                    "c": ProjectFile("c", b"world"),
                },
            ),
            "d": ProjectFile("d", b"!"),
        },
    )
    mydir2 = ProjectDir.construct_with_files(
        [
            ("a/b", b"hello"),
            ("a/c", b"world"),
            ("d", b"!"),
        ],
    )
    assert mydir2["a"]["b"].content == b"hello"
    assert mydir2["a"]["b"].name == "b"
    assert mydir2["a/b"] == mydir2["a"]["b"]
    assert mydir2["a"]["c"].content == b"world"
    assert mydir == mydir2
    assert mydir.get_hash() == mydir2.get_hash()
    assert mydir != ProjectDir.construct_with_files(
        [
            ("a/b", b"hello"),
        ],
    )


def test_fs4():
    mydir = ProjectDir(
        {
            "a": ProjectDir(
                {
                    "b": ProjectFile("b", b"hello"),
                    "c": ProjectFile("c", b"world"),
                },
            ),
            "d": ProjectFile("d", b"!"),
        },
    )
    assert not mydir.dirty
    mydir = mydir.set_file_contents("a/b", b"goodbye")
    print()
    mydir.pretty_print()
    # fmt: off
    assert mydir.pretty_str() == (
        "a (Dirty)\n"
        "  b (Dirty)\n"
        "  c\n"
        "d\n"
    )
    # fmt: on
    assert mydir.dirty
    assert not mydir["d"].dirty
    assert mydir["a"].dirty
    assert mydir["a"]["b"].dirty
    assert mydir["a"]["b"] == mydir["a/b"]
    assert not mydir["d"].dirty
