from synthegrator.util import (
    estimate_best_overlap_span,
    find_after_first_occurrence_of_string,
)
import pytest


def tokenize(val):
    return val.split()


def test_best_overlap_span():
    span = estimate_best_overlap_span("a b c", None, "a b", tokenize)
    assert span == (0, 2)


def test_best_overlap_span2():
    span = estimate_best_overlap_span("a b c", None, "a b c", tokenize)
    assert span == (0, 3)


def test_best_overlap_span3():
    span = estimate_best_overlap_span("a b c d e", None, "b c d", tokenize)
    assert span == (1, 4)


def test_best_overlap_span4():
    span = estimate_best_overlap_span("a b c", None, "x a b c", tokenize)
    assert span == (0, 3)


@pytest.mark.skip(reason="Need to expand implementation to handle this case")
def test_best_overlap_span_weird():
    span = estimate_best_overlap_span(
        "a b c de f g",
        # Make the larger tokens split more
        ["a", "b", "c", "d", "e", "f", "g"],
        "c de f",
        tokenize,
    )
    assert span == (2, 5)


def test_find_after_first_occurrence_basic():
    assert find_after_first_occurrence_of_string(["My", " Name", " Is"], " Name") == (
        2,
        0,
    )


def test_find_after_first_occurrence_basic2():
    assert find_after_first_occurrence_of_string(["My", " Name", " Is"], "Name") == (
        2,
        0,
    )


def test_find_after_first_occurrence_spanning_parts():
    assert find_after_first_occurrence_of_string(
        ["My", " Name", " Is", " Bob"],
        "Name Is",
    ) == (3, 0)


def test_find_after_first_occurrence_within_part():
    assert find_after_first_occurrence_of_string(
        ["My", " Name", " Is Bob"],
        "Name Is",
    ) == (2, 3)


def test_find_after_first_occurrence_not_found():
    assert find_after_first_occurrence_of_string(
        ["My", " Name", " Is Bob"],
        "Random",
    ) == (None, None)


def test_find_after_first_occurrence_empty_string():
    assert find_after_first_occurrence_of_string([], "") == (None, None)


def test_find_after_first_occurrence_empty_search():
    assert find_after_first_occurrence_of_string(["Hello", "World"], "") == (0, 0)


def test_find_after_first_occurrence_only_part_matches():
    assert find_after_first_occurrence_of_string(["Hello", "World"], "World") == (2, 0)


def test_find_after_first_occurrence_split_str_at_start():
    assert find_after_first_occurrence_of_string(["Hello", " World"], "Hello") == (1, 0)
