/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.base.value;

import com.google.common.primitives.Ints;
import org.jf.dexlib2.formatter.DexFormatter;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;

public abstract class BaseFloatEncodedValue
implements FloatEncodedValue {
    public int hashCode() {
        return Float.floatToRawIntBits(this.getValue());
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof FloatEncodedValue) {
            return Float.floatToRawIntBits(this.getValue()) == Float.floatToRawIntBits(((FloatEncodedValue)o).getValue());
        }
        return false;
    }

    @Override
    public int compareTo(EncodedValue o) {
        int res = Ints.compare(this.getValueType(), o.getValueType());
        if (res != 0) {
            return res;
        }
        return Float.compare(this.getValue(), ((FloatEncodedValue)o).getValue());
    }

    @Override
    public int getValueType() {
        return 16;
    }

    public String toString() {
        return DexFormatter.INSTANCE.getEncodedValue(this);
    }
}

