import structlog

from mtmai.forge.sdk import settings_manager
from mtmai.forge.sdk.api.llm.exceptions import (  # MissingLLMProviderEnvVarsError,; NoProviderEnabledError,
    DuplicateLLMConfigError, InvalidLLMConfigError)
from mtmai.forge.sdk.api.llm.models import (LiteLLMParams, LLMConfig,
                                            LLMRouterConfig)
from mtmai.forge.sdk.settings_manager import SettingsManager

LOG = structlog.get_logger()


class LLMConfigRegistry:
    _configs: dict[str, LLMRouterConfig | LLMConfig] = {}

    @staticmethod
    def is_router_config(llm_key: str) -> bool:
        return isinstance(LLMConfigRegistry.get_config(llm_key), LLMRouterConfig)

    # @staticmethod
    # def validate_config(llm_key: str, config: LLMRouterConfig | LLMConfig) -> None:
    #     missing_env_vars = config.get_missing_env_vars()
    #     if missing_env_vars:
    #         raise MissingLLMProviderEnvVarsError(llm_key, missing_env_vars)

    @classmethod
    def register_config(cls, llm_key: str, config: LLMRouterConfig | LLMConfig) -> None:
        if llm_key in cls._configs:
            raise DuplicateLLMConfigError(llm_key)

        # cls.validate_config(llm_key, config)

        LOG.debug("Registering LLM config", llm_key=llm_key)
        cls._configs[llm_key] = config

    @classmethod
    def get_config(cls, llm_key: str) -> LLMRouterConfig | LLMConfig:
        if llm_key not in cls._configs:
            raise InvalidLLMConfigError(llm_key)

        return cls._configs[llm_key]


# if none of the LLM providers are enabled, raise an error
# if not any(
#     [
#         SettingsManager.get_settings().ENABLE_OPENAI,
#         SettingsManager.get_settings().ENABLE_ANTHROPIC,
#         SettingsManager.get_settings().ENABLE_AZURE,
#         SettingsManager.get_settings().ENABLE_AZURE_GPT4O_MINI,
#         SettingsManager.get_settings().ENABLE_BEDROCK,
#     ]
# ):
#     raise NoProviderEnabledError()


# LLMConfigRegistry.register_config(
#     "TOGETHER_LLAMA_31_70B_INSTRUCT_TURBO",
#     LLMConfig(
#         "together_ai/meta-llama/Meta-Llama-3.1-70B-Instruct-Turbo",
#         [],
#         supports_vision=False,
#         add_assistant_prefix=False,
#         # base_url="https://api.together.xyz/v1",
#     ),
# )
# LLMConfigRegistry.register_config(
#     "GROQ_LLAMA3_GROQ_70B_8192_TOOL_USE_PREVIEW",
#     LLMConfig(
#         "groq/llama3-groq-70b-8192-tool-use-preview",
#         [],
#         supports_vision=False,
#         add_assistant_prefix=False,
#         # base_url="https://api.groq.com/openai/v1",
#     ),
# )

# LLMConfigRegistry.register_config(
#     "DEFAULT",
#     LLMRouterConfig(
#         "default",
#         [],
#         supports_vision=False,
#         add_assistant_prefix=False,
#         # base_url="https://api.groq.com/openai/v1",
#     ),
# )

if SettingsManager.get_settings().ENABLE_OPENAI:
    # LLMConfigRegistry.register_config(
    #     "OPENAI_GPT4_TURBO",
    #     LLMConfig(
    #         "gpt-4-turbo",
    #         ["OPENAI_API_KEY"],
    #         supports_vision=False,
    #         add_assistant_prefix=False,

    #     ),
    # )
    # LLMConfigRegistry.register_config(
    #     "OPENAI_GPT4V",
    #     LLMConfig(
    #         "gpt-4-turbo",
    #         ["OPENAI_API_KEY"],
    #         supports_vision=True,
    #         add_assistant_prefix=False,
    #     ),
    # )
    LLMConfigRegistry.register_config(
        "OPENAI_GPT4O",
        LLMConfig(
            "gpt-4o",
            ["OPENAI_API_KEY"],
            supports_vision=True,
            add_assistant_prefix=False,
            litellm_params=LiteLLMParams(
                api_base=SettingsManager.get_settings().OPENAI_API_BASE,
                api_key=SettingsManager.get_settings().OPENAI_API_KEY,
            ),

        ),
    )
    # LLMConfigRegistry.register_config(
    #     "OPENAI_GPT4O_MINI",
    #     LLMConfig(
    #         "gpt-4o-mini",
    #         ["OPENAI_API_KEY"],
    #         supports_vision=True,
    #         add_assistant_prefix=False,
    #     ),
    # )
    # LLMConfigRegistry.register_config(
    #     "OPENAI_GPT-4O-2024-08-06",
    #     LLMConfig(
    #         "gpt-4o-2024-08-06",
    #         ["OPENAI_API_KEY"],
    #         supports_vision=True,
    #         add_assistant_prefix=False,
    #     ),
    # )


# if SettingsManager.get_settings().ENABLE_ANTHROPIC:
#     LLMConfigRegistry.register_config(
#         "ANTHROPIC_CLAUDE3",
#         LLMConfig(
#             "anthropic/claude-3-sonnet-20240229",
#             ["ANTHROPIC_API_KEY"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )
#     LLMConfigRegistry.register_config(
#         "ANTHROPIC_CLAUDE3_OPUS",
#         LLMConfig(
#             "anthropic/claude-3-opus-20240229",
#             ["ANTHROPIC_API_KEY"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )
#     LLMConfigRegistry.register_config(
#         "ANTHROPIC_CLAUDE3_SONNET",
#         LLMConfig(
#             "anthropic/claude-3-sonnet-20240229",
#             ["ANTHROPIC_API_KEY"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )
#     LLMConfigRegistry.register_config(
#         "ANTHROPIC_CLAUDE3_HAIKU",
#         LLMConfig(
#             "anthropic/claude-3-haiku-20240307",
#             ["ANTHROPIC_API_KEY"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )
#     LLMConfigRegistry.register_config(
#         "ANTHROPIC_CLAUDE3.5_SONNET",
#         LLMConfig(
#             "anthropic/claude-3-5-sonnet-latest",
#             ["ANTHROPIC_API_KEY"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )

# if SettingsManager.get_settings().ENABLE_BEDROCK:
#     # Supported through AWS IAM authentication
#     LLMConfigRegistry.register_config(
#         "BEDROCK_ANTHROPIC_CLAUDE3_OPUS",
#         LLMConfig(
#             "bedrock/anthropic.claude-3-opus-20240229-v1:0",
#             ["AWS_REGION"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )
#     LLMConfigRegistry.register_config(
#         "BEDROCK_ANTHROPIC_CLAUDE3_SONNET",
#         LLMConfig(
#             "bedrock/anthropic.claude-3-sonnet-20240229-v1:0",
#             ["AWS_REGION"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )
#     LLMConfigRegistry.register_config(
#         "BEDROCK_ANTHROPIC_CLAUDE3_HAIKU",
#         LLMConfig(
#             "bedrock/anthropic.claude-3-haiku-20240307-v1:0",
#             ["AWS_REGION"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )
#     LLMConfigRegistry.register_config(
#         "BEDROCK_ANTHROPIC_CLAUDE3.5_SONNET",
#         LLMConfig(
#             "bedrock/anthropic.claude-3-5-sonnet-20241022-v2:0",
#             ["AWS_REGION"],
#             supports_vision=True,
#             add_assistant_prefix=True,
#         ),
#     )


# if SettingsManager.get_settings().ENABLE_AZURE:
#     LLMConfigRegistry.register_config(
#         "AZURE_OPENAI",
#         LLMConfig(
#             f"azure/{SettingsManager.get_settings().AZURE_DEPLOYMENT}",
#             [
#                 "AZURE_DEPLOYMENT",
#                 "AZURE_API_KEY",
#                 "AZURE_API_BASE",
#                 "AZURE_API_VERSION",
#             ],
#             supports_vision=True,
#             add_assistant_prefix=False,
#         ),
#     )

# if SettingsManager.get_settings().ENABLE_AZURE_GPT4O_MINI:
#     LLMConfigRegistry.register_config(
#         "AZURE_OPENAI_GPT4O_MINI",
#         LLMConfig(
#             f"azure/{SettingsManager.get_settings().AZURE_GPT4O_MINI_DEPLOYMENT}",
#             [
#                 "AZURE_GPT4O_MINI_DEPLOYMENT",
#                 "AZURE_GPT4O_MINI_API_KEY",
#                 "AZURE_GPT4O_MINI_API_BASE",
#                 "AZURE_GPT4O_MINI_API_VERSION",
#             ],
#             litellm_params=LiteLLMParams(
#                 api_base=SettingsManager.get_settings().AZURE_GPT4O_MINI_API_BASE,
#                 api_key=SettingsManager.get_settings().AZURE_GPT4O_MINI_API_KEY,
#                 api_version=SettingsManager.get_settings().AZURE_GPT4O_MINI_API_VERSION,
#                 model_info={"model_name": "azure/gpt-4o-mini"},
#             ),
#             supports_vision=True,
#             add_assistant_prefix=False,
#         ),
#     )
