# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing_extensions import Literal, Annotated, TypedDict

from .._utils import PropertyInfo

__all__ = ["ApplicationListParams"]


class ApplicationListParams(TypedDict, total=False):
    environment: Literal["DEV", "PROD"]
    """Filter by application environment"""

    limit: int
    """Number of items to include in the result set."""

    order_by: Annotated[str, PropertyInfo(alias="orderBy")]
    """Field to order by in the result set."""

    order_dir: Annotated[Literal["asc", "desc"], PropertyInfo(alias="orderDir")]
    """Order direction."""

    skip: int
    """Number of items to skip before starting to collect the result set."""

    slug: str
    """Filter by application slug"""

    type: Literal["CHATBOT", "AGENT"]
    """Filter by application type"""
