# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 admin_name: pulumi.Input[str],
                 edition: pulumi.Input[str],
                 email: pulumi.Input[str],
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_rsa_public_key: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 must_change_password: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_group: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[str] admin_name: Login name of the initial administrative user of the account. A new user is created in the new account with this name and password and granted the ACCOUNTADMIN role in the account. A login name can be any string consisting of letters, numbers, and underscores. Login names are always case-insensitive.
        :param pulumi.Input[str] edition: [Snowflake Edition](https://docs.snowflake.com/en/user-guide/intro-editions.html) of the account. Valid values are: STANDARD | ENTERPRISE | BUSINESS_CRITICAL
        :param pulumi.Input[str] email: Email address of the initial administrative user of the account. This email address is used to send any notifications about the account.
        :param pulumi.Input[str] admin_password: Password for the initial administrative user of the account. Optional if the `ADMIN_RSA_PUBLIC_KEY` parameter is specified. For more information about passwords in Snowflake, see [Snowflake-provided Password Policy](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=Snowflake%2Dprovided%20Password%20Policy).
        :param pulumi.Input[str] admin_rsa_public_key: Assigns a public key to the initial administrative user of the account in order to implement [key pair authentication](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=key%20pair%20authentication) for the user. Optional if the `ADMIN_PASSWORD` parameter is specified.
        :param pulumi.Input[str] comment: Specifies a comment for the account.
        :param pulumi.Input[str] first_name: First name of the initial administrative user of the account
        :param pulumi.Input[str] last_name: Last name of the initial administrative user of the account
        :param pulumi.Input[bool] must_change_password: Specifies whether the new user created to administer the account is forced to change their password upon first login into the account.
        :param pulumi.Input[str] name: Specifies the identifier (i.e. name) for the account; must be unique within an organization, regardless of which Snowflake Region the account is in. In addition, the identifier must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        :param pulumi.Input[str] region: ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        :param pulumi.Input[str] region_group: ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        pulumi.set(__self__, "admin_name", admin_name)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "email", email)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_rsa_public_key is not None:
            pulumi.set(__self__, "admin_rsa_public_key", admin_rsa_public_key)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if must_change_password is not None:
            pulumi.set(__self__, "must_change_password", must_change_password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_group is not None:
            pulumi.set(__self__, "region_group", region_group)

    @property
    @pulumi.getter(name="adminName")
    def admin_name(self) -> pulumi.Input[str]:
        """
        Login name of the initial administrative user of the account. A new user is created in the new account with this name and password and granted the ACCOUNTADMIN role in the account. A login name can be any string consisting of letters, numbers, and underscores. Login names are always case-insensitive.
        """
        return pulumi.get(self, "admin_name")

    @admin_name.setter
    def admin_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_name", value)

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Input[str]:
        """
        [Snowflake Edition](https://docs.snowflake.com/en/user-guide/intro-editions.html) of the account. Valid values are: STANDARD | ENTERPRISE | BUSINESS_CRITICAL
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: pulumi.Input[str]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        Email address of the initial administrative user of the account. This email address is used to send any notifications about the account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the initial administrative user of the account. Optional if the `ADMIN_RSA_PUBLIC_KEY` parameter is specified. For more information about passwords in Snowflake, see [Snowflake-provided Password Policy](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=Snowflake%2Dprovided%20Password%20Policy).
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminRsaPublicKey")
    def admin_rsa_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Assigns a public key to the initial administrative user of the account in order to implement [key pair authentication](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=key%20pair%20authentication) for the user. Optional if the `ADMIN_PASSWORD` parameter is specified.
        """
        return pulumi.get(self, "admin_rsa_public_key")

    @admin_rsa_public_key.setter
    def admin_rsa_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_rsa_public_key", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the account.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        First name of the initial administrative user of the account
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        Last name of the initial administrative user of the account
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="mustChangePassword")
    def must_change_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the new user created to administer the account is forced to change their password upon first login into the account.
        """
        return pulumi.get(self, "must_change_password")

    @must_change_password.setter
    def must_change_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_change_password", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier (i.e. name) for the account; must be unique within an organization, regardless of which Snowflake Region the account is in. In addition, the identifier must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="regionGroup")
    def region_group(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region_group")

    @region_group.setter
    def region_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_group", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 admin_name: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_rsa_public_key: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 is_org_admin: Optional[pulumi.Input[bool]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 must_change_password: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_group: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[str] admin_name: Login name of the initial administrative user of the account. A new user is created in the new account with this name and password and granted the ACCOUNTADMIN role in the account. A login name can be any string consisting of letters, numbers, and underscores. Login names are always case-insensitive.
        :param pulumi.Input[str] admin_password: Password for the initial administrative user of the account. Optional if the `ADMIN_RSA_PUBLIC_KEY` parameter is specified. For more information about passwords in Snowflake, see [Snowflake-provided Password Policy](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=Snowflake%2Dprovided%20Password%20Policy).
        :param pulumi.Input[str] admin_rsa_public_key: Assigns a public key to the initial administrative user of the account in order to implement [key pair authentication](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=key%20pair%20authentication) for the user. Optional if the `ADMIN_PASSWORD` parameter is specified.
        :param pulumi.Input[str] comment: Specifies a comment for the account.
        :param pulumi.Input[str] edition: [Snowflake Edition](https://docs.snowflake.com/en/user-guide/intro-editions.html) of the account. Valid values are: STANDARD | ENTERPRISE | BUSINESS_CRITICAL
        :param pulumi.Input[str] email: Email address of the initial administrative user of the account. This email address is used to send any notifications about the account.
        :param pulumi.Input[str] first_name: First name of the initial administrative user of the account
        :param pulumi.Input[bool] is_org_admin: Indicates whether the ORGADMIN role is enabled in an account. If TRUE, the role is enabled.
        :param pulumi.Input[str] last_name: Last name of the initial administrative user of the account
        :param pulumi.Input[bool] must_change_password: Specifies whether the new user created to administer the account is forced to change their password upon first login into the account.
        :param pulumi.Input[str] name: Specifies the identifier (i.e. name) for the account; must be unique within an organization, regardless of which Snowflake Region the account is in. In addition, the identifier must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        :param pulumi.Input[str] region: ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        :param pulumi.Input[str] region_group: ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        if admin_name is not None:
            pulumi.set(__self__, "admin_name", admin_name)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_rsa_public_key is not None:
            pulumi.set(__self__, "admin_rsa_public_key", admin_rsa_public_key)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if is_org_admin is not None:
            pulumi.set(__self__, "is_org_admin", is_org_admin)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if must_change_password is not None:
            pulumi.set(__self__, "must_change_password", must_change_password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_group is not None:
            pulumi.set(__self__, "region_group", region_group)

    @property
    @pulumi.getter(name="adminName")
    def admin_name(self) -> Optional[pulumi.Input[str]]:
        """
        Login name of the initial administrative user of the account. A new user is created in the new account with this name and password and granted the ACCOUNTADMIN role in the account. A login name can be any string consisting of letters, numbers, and underscores. Login names are always case-insensitive.
        """
        return pulumi.get(self, "admin_name")

    @admin_name.setter
    def admin_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_name", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the initial administrative user of the account. Optional if the `ADMIN_RSA_PUBLIC_KEY` parameter is specified. For more information about passwords in Snowflake, see [Snowflake-provided Password Policy](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=Snowflake%2Dprovided%20Password%20Policy).
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminRsaPublicKey")
    def admin_rsa_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Assigns a public key to the initial administrative user of the account in order to implement [key pair authentication](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=key%20pair%20authentication) for the user. Optional if the `ADMIN_PASSWORD` parameter is specified.
        """
        return pulumi.get(self, "admin_rsa_public_key")

    @admin_rsa_public_key.setter
    def admin_rsa_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_rsa_public_key", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the account.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        [Snowflake Edition](https://docs.snowflake.com/en/user-guide/intro-editions.html) of the account. Valid values are: STANDARD | ENTERPRISE | BUSINESS_CRITICAL
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the initial administrative user of the account. This email address is used to send any notifications about the account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        First name of the initial administrative user of the account
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="isOrgAdmin")
    def is_org_admin(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the ORGADMIN role is enabled in an account. If TRUE, the role is enabled.
        """
        return pulumi.get(self, "is_org_admin")

    @is_org_admin.setter
    def is_org_admin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_org_admin", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        Last name of the initial administrative user of the account
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="mustChangePassword")
    def must_change_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the new user created to administer the account is forced to change their password upon first login into the account.
        """
        return pulumi.get(self, "must_change_password")

    @must_change_password.setter
    def must_change_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_change_password", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier (i.e. name) for the account; must be unique within an organization, regardless of which Snowflake Region the account is in. In addition, the identifier must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="regionGroup")
    def region_group(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region_group")

    @region_group.setter
    def region_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_group", value)


class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_name: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_rsa_public_key: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 must_change_password: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_group: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The account resource allows you to create and manage Snowflake accounts.

            **WARNING** This resource cannot be destroyed!!! The only way to delete accounts is to go through [Snowflake Support](https://docs.snowflake.com/en/user-guide/organizations-manage-accounts.html#deleting-an-account)
            
            **NOTE** ORGADMIN priviliges are required for this resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        orgadmin = snowflake.Provider("orgadmin", role="ORGADMIN")
        ac1 = snowflake.Account("ac1",
            admin_name="John Doe",
            admin_password="Abcd1234!",
            email="john.doe@snowflake.com",
            first_name="John",
            last_name="Doe",
            must_change_password=True,
            edition="STANDARD",
            comment="Snowflake Test Account",
            region="AWS_US_WEST_2",
            opts=pulumi.ResourceOptions(provider=snowflake["orgadmin"]))
        ```

        ## Import

        ```sh
         $ pulumi import snowflake:index/account:Account account <account_locator>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_name: Login name of the initial administrative user of the account. A new user is created in the new account with this name and password and granted the ACCOUNTADMIN role in the account. A login name can be any string consisting of letters, numbers, and underscores. Login names are always case-insensitive.
        :param pulumi.Input[str] admin_password: Password for the initial administrative user of the account. Optional if the `ADMIN_RSA_PUBLIC_KEY` parameter is specified. For more information about passwords in Snowflake, see [Snowflake-provided Password Policy](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=Snowflake%2Dprovided%20Password%20Policy).
        :param pulumi.Input[str] admin_rsa_public_key: Assigns a public key to the initial administrative user of the account in order to implement [key pair authentication](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=key%20pair%20authentication) for the user. Optional if the `ADMIN_PASSWORD` parameter is specified.
        :param pulumi.Input[str] comment: Specifies a comment for the account.
        :param pulumi.Input[str] edition: [Snowflake Edition](https://docs.snowflake.com/en/user-guide/intro-editions.html) of the account. Valid values are: STANDARD | ENTERPRISE | BUSINESS_CRITICAL
        :param pulumi.Input[str] email: Email address of the initial administrative user of the account. This email address is used to send any notifications about the account.
        :param pulumi.Input[str] first_name: First name of the initial administrative user of the account
        :param pulumi.Input[str] last_name: Last name of the initial administrative user of the account
        :param pulumi.Input[bool] must_change_password: Specifies whether the new user created to administer the account is forced to change their password upon first login into the account.
        :param pulumi.Input[str] name: Specifies the identifier (i.e. name) for the account; must be unique within an organization, regardless of which Snowflake Region the account is in. In addition, the identifier must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        :param pulumi.Input[str] region: ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        :param pulumi.Input[str] region_group: ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The account resource allows you to create and manage Snowflake accounts.

            **WARNING** This resource cannot be destroyed!!! The only way to delete accounts is to go through [Snowflake Support](https://docs.snowflake.com/en/user-guide/organizations-manage-accounts.html#deleting-an-account)
            
            **NOTE** ORGADMIN priviliges are required for this resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        orgadmin = snowflake.Provider("orgadmin", role="ORGADMIN")
        ac1 = snowflake.Account("ac1",
            admin_name="John Doe",
            admin_password="Abcd1234!",
            email="john.doe@snowflake.com",
            first_name="John",
            last_name="Doe",
            must_change_password=True,
            edition="STANDARD",
            comment="Snowflake Test Account",
            region="AWS_US_WEST_2",
            opts=pulumi.ResourceOptions(provider=snowflake["orgadmin"]))
        ```

        ## Import

        ```sh
         $ pulumi import snowflake:index/account:Account account <account_locator>
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_name: Optional[pulumi.Input[str]] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_rsa_public_key: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 must_change_password: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_group: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            if admin_name is None and not opts.urn:
                raise TypeError("Missing required property 'admin_name'")
            __props__.__dict__["admin_name"] = admin_name
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["admin_rsa_public_key"] = None if admin_rsa_public_key is None else pulumi.Output.secret(admin_rsa_public_key)
            __props__.__dict__["comment"] = comment
            if edition is None and not opts.urn:
                raise TypeError("Missing required property 'edition'")
            __props__.__dict__["edition"] = edition
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = None if email is None else pulumi.Output.secret(email)
            __props__.__dict__["first_name"] = None if first_name is None else pulumi.Output.secret(first_name)
            __props__.__dict__["last_name"] = None if last_name is None else pulumi.Output.secret(last_name)
            __props__.__dict__["must_change_password"] = must_change_password
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["region_group"] = region_group
            __props__.__dict__["is_org_admin"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword", "adminRsaPublicKey", "email", "firstName", "lastName"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'snowflake:index/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_name: Optional[pulumi.Input[str]] = None,
            admin_password: Optional[pulumi.Input[str]] = None,
            admin_rsa_public_key: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            edition: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            is_org_admin: Optional[pulumi.Input[bool]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            must_change_password: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            region_group: Optional[pulumi.Input[str]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_name: Login name of the initial administrative user of the account. A new user is created in the new account with this name and password and granted the ACCOUNTADMIN role in the account. A login name can be any string consisting of letters, numbers, and underscores. Login names are always case-insensitive.
        :param pulumi.Input[str] admin_password: Password for the initial administrative user of the account. Optional if the `ADMIN_RSA_PUBLIC_KEY` parameter is specified. For more information about passwords in Snowflake, see [Snowflake-provided Password Policy](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=Snowflake%2Dprovided%20Password%20Policy).
        :param pulumi.Input[str] admin_rsa_public_key: Assigns a public key to the initial administrative user of the account in order to implement [key pair authentication](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=key%20pair%20authentication) for the user. Optional if the `ADMIN_PASSWORD` parameter is specified.
        :param pulumi.Input[str] comment: Specifies a comment for the account.
        :param pulumi.Input[str] edition: [Snowflake Edition](https://docs.snowflake.com/en/user-guide/intro-editions.html) of the account. Valid values are: STANDARD | ENTERPRISE | BUSINESS_CRITICAL
        :param pulumi.Input[str] email: Email address of the initial administrative user of the account. This email address is used to send any notifications about the account.
        :param pulumi.Input[str] first_name: First name of the initial administrative user of the account
        :param pulumi.Input[bool] is_org_admin: Indicates whether the ORGADMIN role is enabled in an account. If TRUE, the role is enabled.
        :param pulumi.Input[str] last_name: Last name of the initial administrative user of the account
        :param pulumi.Input[bool] must_change_password: Specifies whether the new user created to administer the account is forced to change their password upon first login into the account.
        :param pulumi.Input[str] name: Specifies the identifier (i.e. name) for the account; must be unique within an organization, regardless of which Snowflake Region the account is in. In addition, the identifier must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        :param pulumi.Input[str] region: ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        :param pulumi.Input[str] region_group: ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["admin_name"] = admin_name
        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["admin_rsa_public_key"] = admin_rsa_public_key
        __props__.__dict__["comment"] = comment
        __props__.__dict__["edition"] = edition
        __props__.__dict__["email"] = email
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["is_org_admin"] = is_org_admin
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["must_change_password"] = must_change_password
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["region_group"] = region_group
        return Account(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminName")
    def admin_name(self) -> pulumi.Output[str]:
        """
        Login name of the initial administrative user of the account. A new user is created in the new account with this name and password and granted the ACCOUNTADMIN role in the account. A login name can be any string consisting of letters, numbers, and underscores. Login names are always case-insensitive.
        """
        return pulumi.get(self, "admin_name")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[Optional[str]]:
        """
        Password for the initial administrative user of the account. Optional if the `ADMIN_RSA_PUBLIC_KEY` parameter is specified. For more information about passwords in Snowflake, see [Snowflake-provided Password Policy](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=Snowflake%2Dprovided%20Password%20Policy).
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminRsaPublicKey")
    def admin_rsa_public_key(self) -> pulumi.Output[Optional[str]]:
        """
        Assigns a public key to the initial administrative user of the account in order to implement [key pair authentication](https://docs.snowflake.com/en/sql-reference/sql/create-account.html#:~:text=key%20pair%20authentication) for the user. Optional if the `ADMIN_PASSWORD` parameter is specified.
        """
        return pulumi.get(self, "admin_rsa_public_key")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a comment for the account.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Output[str]:
        """
        [Snowflake Edition](https://docs.snowflake.com/en/user-guide/intro-editions.html) of the account. Valid values are: STANDARD | ENTERPRISE | BUSINESS_CRITICAL
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        Email address of the initial administrative user of the account. This email address is used to send any notifications about the account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[str]]:
        """
        First name of the initial administrative user of the account
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="isOrgAdmin")
    def is_org_admin(self) -> pulumi.Output[bool]:
        """
        Indicates whether the ORGADMIN role is enabled in an account. If TRUE, the role is enabled.
        """
        return pulumi.get(self, "is_org_admin")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[str]]:
        """
        Last name of the initial administrative user of the account
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="mustChangePassword")
    def must_change_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the new user created to administer the account is forced to change their password upon first login into the account.
        """
        return pulumi.get(self, "must_change_password")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the identifier (i.e. name) for the account; must be unique within an organization, regardless of which Snowflake Region the account is in. In addition, the identifier must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="regionGroup")
    def region_group(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the Snowflake Region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region_group")

