# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

import types

__config__ = pulumi.Config('snowflake')


class _ExportableConfig(types.ModuleType):
    @property
    def account(self) -> Optional[str]:
        """
        The name of the Snowflake account. Can also come from the `SNOWFLAKE_ACCOUNT` environment variable. Required unless
        using profile.
        """
        return __config__.get('account') or _utilities.get_env('SNOWFLAKE_ACCOUNT')

    @property
    def browser_auth(self) -> Optional[bool]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_USE_BROWSER_AUTH` environment variable.
        """
        return __config__.get_bool('browserAuth') or _utilities.get_env_bool('SNOWFLAKE_USE_BROWSER_AUTH')

    @property
    def host(self) -> Optional[str]:
        """
        Supports passing in a custom host value to the snowflake go driver for use with privatelink.
        """
        return __config__.get('host') or _utilities.get_env('SNOWFLAKE_HOST')

    @property
    def insecure_mode(self) -> Optional[bool]:
        """
        If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the
        default value for testing or emergency situations only.
        """
        return __config__.get_bool('insecureMode')

    @property
    def oauth_access_token(self) -> Optional[str]:
        """
        Token for use with OAuth. Generating the token is left to other tools. Cannot be used with `browser_auth`,
        `private_key_path`, `oauth_refresh_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_ACCESS_TOKEN` environment
        variable.
        """
        return __config__.get('oauthAccessToken') or _utilities.get_env('SNOWFLAKE_OAUTH_ACCESS_TOKEN')

    @property
    def oauth_client_id(self) -> Optional[str]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        """
        return __config__.get('oauthClientId') or _utilities.get_env('SNOWFLAKE_OAUTH_CLIENT_ID')

    @property
    def oauth_client_secret(self) -> Optional[str]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        """
        return __config__.get('oauthClientSecret') or _utilities.get_env('SNOWFLAKE_OAUTH_CLIENT_SECRET')

    @property
    def oauth_endpoint(self) -> Optional[str]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_ENDPOINT` environment variable.
        """
        return __config__.get('oauthEndpoint') or _utilities.get_env('SNOWFLAKE_OAUTH_ENDPOINT')

    @property
    def oauth_redirect_url(self) -> Optional[str]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_REDIRECT_URL` environment variable.
        """
        return __config__.get('oauthRedirectUrl') or _utilities.get_env('SNOWFLAKE_OAUTH_REDIRECT_URL')

    @property
    def oauth_refresh_token(self) -> Optional[str]:
        """
        Token for use with OAuth. Setup and generation of the token is left to other tools. Should be used in conjunction with
        `oauth_client_id`, `oauth_client_secret`, `oauth_endpoint`, `oauth_redirect_url`. Cannot be used with `browser_auth`,
        `private_key_path`, `oauth_access_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_REFRESH_TOKEN` environment
        variable.
        """
        return __config__.get('oauthRefreshToken') or _utilities.get_env('SNOWFLAKE_OAUTH_REFRESH_TOKEN')

    @property
    def password(self) -> Optional[str]:
        """
        Password for username+password auth. Cannot be used with `browser_auth` or `private_key_path`. Can be sourced from
        `SNOWFLAKE_PASSWORD` environment variable.
        """
        return __config__.get('password') or _utilities.get_env('SNOWFLAKE_PASSWORD')

    @property
    def port(self) -> Optional[int]:
        """
        Support custom port values to snowflake go driver for use with privatelink. Can be sourced from `SNOWFLAKE_PORT`
        environment variable.
        """
        return __config__.get_int('port') or _utilities.get_env_int('SNOWFLAKE_PORT')

    @property
    def private_key(self) -> Optional[str]:
        """
        Private Key for username+private-key auth. Cannot be used with `browser_auth` or `password`. Can be sourced from
        `SNOWFLAKE_PRIVATE_KEY` environment variable.
        """
        return __config__.get('privateKey')

    @property
    def private_key_passphrase(self) -> Optional[str]:
        """
        Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and
        des-ede3-cbc
        """
        return __config__.get('privateKeyPassphrase') or _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PASSPHRASE')

    @property
    def private_key_path(self) -> Optional[str]:
        """
        Path to a private key for using keypair authentication. Cannot be used with `browser_auth`, `oauth_access_token` or
        `password`. Can be sourced from `SNOWFLAKE_PRIVATE_KEY_PATH` environment variable.
        """
        return __config__.get('privateKeyPath') or _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PATH')

    @property
    def profile(self) -> Optional[str]:
        """
        Sets the profile to read from ~/.snowflake/config file.
        """
        return __config__.get('profile')

    @property
    def protocol(self) -> Optional[str]:
        """
        Support custom protocols to snowflake go driver. Can be sourced from `SNOWFLAKE_PROTOCOL` environment variable.
        """
        return __config__.get('protocol') or _utilities.get_env('SNOWFLAKE_PROTOCOL')

    @property
    def region(self) -> Optional[str]:
        """
        [Snowflake region](https://docs.snowflake.com/en/user-guide/intro-regions.html) to use. Required if using the [legacy
        format for the `account`
        identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#format-2-legacy-account-locator-in-a-region)
        in the form of `<cloud_region_id>.<cloud>`. Can be sourced from the `SNOWFLAKE_REGION` environment variable.
        """
        return __config__.get('region') or _utilities.get_env('SNOWFLAKE_REGION')

    @property
    def role(self) -> Optional[str]:
        """
        Snowflake role to use for operations. If left unset, default role for user will be used. Can be sourced from the
        `SNOWFLAKE_ROLE` environment variable.
        """
        return __config__.get('role') or _utilities.get_env('SNOWFLAKE_ROLE')

    @property
    def username(self) -> Optional[str]:
        """
        Username for username+password authentication. Can come from the `SNOWFLAKE_USER` environment variable. Required unless
        using profile.
        """
        return __config__.get('username') or _utilities.get_env('SNOWFLAKE_USER')

    @property
    def warehouse(self) -> Optional[str]:
        """
        Sets the default warehouse. Optional. Can be sourced from SNOWFLAKE_WAREHOUSE environment variable.
        """
        return __config__.get('warehouse') or _utilities.get_env('SNOWFLAKE_WAREHOUSE')

