# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalFunctionArgs', 'ExternalFunction']

@pulumi.input_type
class ExternalFunctionArgs:
    def __init__(__self__, *,
                 api_integration: pulumi.Input[str],
                 database: pulumi.Input[str],
                 return_behavior: pulumi.Input[str],
                 return_type: pulumi.Input[str],
                 schema: pulumi.Input[str],
                 url_of_proxy_and_resource: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]] = None,
                 max_batch_rows: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 null_input_behavior: Optional[pulumi.Input[str]] = None,
                 request_translator: Optional[pulumi.Input[str]] = None,
                 response_translator: Optional[pulumi.Input[str]] = None,
                 return_null_allowed: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ExternalFunction resource.
        :param pulumi.Input[str] api_integration: The name of the API integration object that should be used to authenticate the call to the proxy service.
        :param pulumi.Input[str] database: The database in which to create the external function.
        :param pulumi.Input[str] return_behavior: Specifies the behavior of the function when returning results
        :param pulumi.Input[str] return_type: Specifies the data type returned by the external function.
        :param pulumi.Input[str] schema: The schema in which to create the external function.
        :param pulumi.Input[str] url_of_proxy_and_resource: This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]] args: Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        :param pulumi.Input[str] comment: A description of the external function.
        :param pulumi.Input[str] compression: If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] context_headers: Binds Snowflake context function results to HTTP headers.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]] headers: Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        :param pulumi.Input[int] max_batch_rows: This specifies the maximum number of rows in each batch sent to the proxy service.
        :param pulumi.Input[str] name: Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        :param pulumi.Input[str] null_input_behavior: Specifies the behavior of the external function when called with null inputs.
        :param pulumi.Input[str] request_translator: This specifies the name of the request translator function
        :param pulumi.Input[str] response_translator: This specifies the name of the response translator function.
        :param pulumi.Input[bool] return_null_allowed: Indicates whether the function can return NULL values or must return only NON-NULL values.
        """
        pulumi.set(__self__, "api_integration", api_integration)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "return_behavior", return_behavior)
        pulumi.set(__self__, "return_type", return_type)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "url_of_proxy_and_resource", url_of_proxy_and_resource)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if context_headers is not None:
            pulumi.set(__self__, "context_headers", context_headers)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if max_batch_rows is not None:
            pulumi.set(__self__, "max_batch_rows", max_batch_rows)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_input_behavior is not None:
            pulumi.set(__self__, "null_input_behavior", null_input_behavior)
        if request_translator is not None:
            pulumi.set(__self__, "request_translator", request_translator)
        if response_translator is not None:
            pulumi.set(__self__, "response_translator", response_translator)
        if return_null_allowed is not None:
            pulumi.set(__self__, "return_null_allowed", return_null_allowed)

    @property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> pulumi.Input[str]:
        """
        The name of the API integration object that should be used to authenticate the call to the proxy service.
        """
        return pulumi.get(self, "api_integration")

    @api_integration.setter
    def api_integration(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_integration", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The database in which to create the external function.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="returnBehavior")
    def return_behavior(self) -> pulumi.Input[str]:
        """
        Specifies the behavior of the function when returning results
        """
        return pulumi.get(self, "return_behavior")

    @return_behavior.setter
    def return_behavior(self, value: pulumi.Input[str]):
        pulumi.set(self, "return_behavior", value)

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Input[str]:
        """
        Specifies the data type returned by the external function.
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "return_type", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[str]:
        """
        The schema in which to create the external function.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="urlOfProxyAndResource")
    def url_of_proxy_and_resource(self) -> pulumi.Input[str]:
        """
        This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        return pulumi.get(self, "url_of_proxy_and_resource")

    @url_of_proxy_and_resource.setter
    def url_of_proxy_and_resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "url_of_proxy_and_resource", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]]:
        """
        Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the external function.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="contextHeaders")
    def context_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Binds Snowflake context function results to HTTP headers.
        """
        return pulumi.get(self, "context_headers")

    @context_headers.setter
    def context_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "context_headers", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]]:
        """
        Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="maxBatchRows")
    def max_batch_rows(self) -> Optional[pulumi.Input[int]]:
        """
        This specifies the maximum number of rows in each batch sent to the proxy service.
        """
        return pulumi.get(self, "max_batch_rows")

    @max_batch_rows.setter
    def max_batch_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_batch_rows", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the behavior of the external function when called with null inputs.
        """
        return pulumi.get(self, "null_input_behavior")

    @null_input_behavior.setter
    def null_input_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_input_behavior", value)

    @property
    @pulumi.getter(name="requestTranslator")
    def request_translator(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies the name of the request translator function
        """
        return pulumi.get(self, "request_translator")

    @request_translator.setter
    def request_translator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_translator", value)

    @property
    @pulumi.getter(name="responseTranslator")
    def response_translator(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies the name of the response translator function.
        """
        return pulumi.get(self, "response_translator")

    @response_translator.setter
    def response_translator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_translator", value)

    @property
    @pulumi.getter(name="returnNullAllowed")
    def return_null_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the function can return NULL values or must return only NON-NULL values.
        """
        return pulumi.get(self, "return_null_allowed")

    @return_null_allowed.setter
    def return_null_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_null_allowed", value)


@pulumi.input_type
class _ExternalFunctionState:
    def __init__(__self__, *,
                 api_integration: Optional[pulumi.Input[str]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]] = None,
                 max_batch_rows: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 null_input_behavior: Optional[pulumi.Input[str]] = None,
                 request_translator: Optional[pulumi.Input[str]] = None,
                 response_translator: Optional[pulumi.Input[str]] = None,
                 return_behavior: Optional[pulumi.Input[str]] = None,
                 return_null_allowed: Optional[pulumi.Input[bool]] = None,
                 return_type: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 url_of_proxy_and_resource: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalFunction resources.
        :param pulumi.Input[str] api_integration: The name of the API integration object that should be used to authenticate the call to the proxy service.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]] args: Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        :param pulumi.Input[str] comment: A description of the external function.
        :param pulumi.Input[str] compression: If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] context_headers: Binds Snowflake context function results to HTTP headers.
        :param pulumi.Input[str] created_on: Date and time when the external function was created.
        :param pulumi.Input[str] database: The database in which to create the external function.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]] headers: Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        :param pulumi.Input[int] max_batch_rows: This specifies the maximum number of rows in each batch sent to the proxy service.
        :param pulumi.Input[str] name: Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        :param pulumi.Input[str] null_input_behavior: Specifies the behavior of the external function when called with null inputs.
        :param pulumi.Input[str] request_translator: This specifies the name of the request translator function
        :param pulumi.Input[str] response_translator: This specifies the name of the response translator function.
        :param pulumi.Input[str] return_behavior: Specifies the behavior of the function when returning results
        :param pulumi.Input[bool] return_null_allowed: Indicates whether the function can return NULL values or must return only NON-NULL values.
        :param pulumi.Input[str] return_type: Specifies the data type returned by the external function.
        :param pulumi.Input[str] schema: The schema in which to create the external function.
        :param pulumi.Input[str] url_of_proxy_and_resource: This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        if api_integration is not None:
            pulumi.set(__self__, "api_integration", api_integration)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if context_headers is not None:
            pulumi.set(__self__, "context_headers", context_headers)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if max_batch_rows is not None:
            pulumi.set(__self__, "max_batch_rows", max_batch_rows)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_input_behavior is not None:
            pulumi.set(__self__, "null_input_behavior", null_input_behavior)
        if request_translator is not None:
            pulumi.set(__self__, "request_translator", request_translator)
        if response_translator is not None:
            pulumi.set(__self__, "response_translator", response_translator)
        if return_behavior is not None:
            pulumi.set(__self__, "return_behavior", return_behavior)
        if return_null_allowed is not None:
            pulumi.set(__self__, "return_null_allowed", return_null_allowed)
        if return_type is not None:
            pulumi.set(__self__, "return_type", return_type)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if url_of_proxy_and_resource is not None:
            pulumi.set(__self__, "url_of_proxy_and_resource", url_of_proxy_and_resource)

    @property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the API integration object that should be used to authenticate the call to the proxy service.
        """
        return pulumi.get(self, "api_integration")

    @api_integration.setter
    def api_integration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_integration", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]]:
        """
        Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionArgArgs']]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the external function.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="contextHeaders")
    def context_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Binds Snowflake context function results to HTTP headers.
        """
        return pulumi.get(self, "context_headers")

    @context_headers.setter
    def context_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "context_headers", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time when the external function was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The database in which to create the external function.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]]:
        """
        Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalFunctionHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="maxBatchRows")
    def max_batch_rows(self) -> Optional[pulumi.Input[int]]:
        """
        This specifies the maximum number of rows in each batch sent to the proxy service.
        """
        return pulumi.get(self, "max_batch_rows")

    @max_batch_rows.setter
    def max_batch_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_batch_rows", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the behavior of the external function when called with null inputs.
        """
        return pulumi.get(self, "null_input_behavior")

    @null_input_behavior.setter
    def null_input_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_input_behavior", value)

    @property
    @pulumi.getter(name="requestTranslator")
    def request_translator(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies the name of the request translator function
        """
        return pulumi.get(self, "request_translator")

    @request_translator.setter
    def request_translator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_translator", value)

    @property
    @pulumi.getter(name="responseTranslator")
    def response_translator(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies the name of the response translator function.
        """
        return pulumi.get(self, "response_translator")

    @response_translator.setter
    def response_translator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_translator", value)

    @property
    @pulumi.getter(name="returnBehavior")
    def return_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the behavior of the function when returning results
        """
        return pulumi.get(self, "return_behavior")

    @return_behavior.setter
    def return_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "return_behavior", value)

    @property
    @pulumi.getter(name="returnNullAllowed")
    def return_null_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the function can return NULL values or must return only NON-NULL values.
        """
        return pulumi.get(self, "return_null_allowed")

    @return_null_allowed.setter
    def return_null_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_null_allowed", value)

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data type returned by the external function.
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "return_type", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        The schema in which to create the external function.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="urlOfProxyAndResource")
    def url_of_proxy_and_resource(self) -> Optional[pulumi.Input[str]]:
        """
        This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        return pulumi.get(self, "url_of_proxy_and_resource")

    @url_of_proxy_and_resource.setter
    def url_of_proxy_and_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_of_proxy_and_resource", value)


class ExternalFunction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_integration: Optional[pulumi.Input[str]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionArgArgs']]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionHeaderArgs']]]]] = None,
                 max_batch_rows: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 null_input_behavior: Optional[pulumi.Input[str]] = None,
                 request_translator: Optional[pulumi.Input[str]] = None,
                 response_translator: Optional[pulumi.Input[str]] = None,
                 return_behavior: Optional[pulumi.Input[str]] = None,
                 return_null_allowed: Optional[pulumi.Input[bool]] = None,
                 return_type: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 url_of_proxy_and_resource: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        test_ext_func = snowflake.ExternalFunction("testExtFunc",
            api_integration="api_integration_name",
            args=[
                snowflake.ExternalFunctionArgArgs(
                    name="arg1",
                    type="varchar",
                ),
                snowflake.ExternalFunctionArgArgs(
                    name="arg2",
                    type="varchar",
                ),
            ],
            database="my_test_db",
            return_behavior="IMMUTABLE",
            return_type="variant",
            schema="my_test_schema",
            url_of_proxy_and_resource="https://123456.execute-api.us-west-2.amazonaws.com/prod/test_func")
        ```

        ## Import

        format is database name | schema name | external function name | <list of function arg types, separated with '-'>

        ```sh
         $ pulumi import snowflake:index/externalFunction:ExternalFunction example 'dbName|schemaName|externalFunctionName|varchar-varchar-varchar'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_integration: The name of the API integration object that should be used to authenticate the call to the proxy service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionArgArgs']]]] args: Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        :param pulumi.Input[str] comment: A description of the external function.
        :param pulumi.Input[str] compression: If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] context_headers: Binds Snowflake context function results to HTTP headers.
        :param pulumi.Input[str] database: The database in which to create the external function.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionHeaderArgs']]]] headers: Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        :param pulumi.Input[int] max_batch_rows: This specifies the maximum number of rows in each batch sent to the proxy service.
        :param pulumi.Input[str] name: Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        :param pulumi.Input[str] null_input_behavior: Specifies the behavior of the external function when called with null inputs.
        :param pulumi.Input[str] request_translator: This specifies the name of the request translator function
        :param pulumi.Input[str] response_translator: This specifies the name of the response translator function.
        :param pulumi.Input[str] return_behavior: Specifies the behavior of the function when returning results
        :param pulumi.Input[bool] return_null_allowed: Indicates whether the function can return NULL values or must return only NON-NULL values.
        :param pulumi.Input[str] return_type: Specifies the data type returned by the external function.
        :param pulumi.Input[str] schema: The schema in which to create the external function.
        :param pulumi.Input[str] url_of_proxy_and_resource: This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalFunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        test_ext_func = snowflake.ExternalFunction("testExtFunc",
            api_integration="api_integration_name",
            args=[
                snowflake.ExternalFunctionArgArgs(
                    name="arg1",
                    type="varchar",
                ),
                snowflake.ExternalFunctionArgArgs(
                    name="arg2",
                    type="varchar",
                ),
            ],
            database="my_test_db",
            return_behavior="IMMUTABLE",
            return_type="variant",
            schema="my_test_schema",
            url_of_proxy_and_resource="https://123456.execute-api.us-west-2.amazonaws.com/prod/test_func")
        ```

        ## Import

        format is database name | schema name | external function name | <list of function arg types, separated with '-'>

        ```sh
         $ pulumi import snowflake:index/externalFunction:ExternalFunction example 'dbName|schemaName|externalFunctionName|varchar-varchar-varchar'
        ```

        :param str resource_name: The name of the resource.
        :param ExternalFunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalFunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_integration: Optional[pulumi.Input[str]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionArgArgs']]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionHeaderArgs']]]]] = None,
                 max_batch_rows: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 null_input_behavior: Optional[pulumi.Input[str]] = None,
                 request_translator: Optional[pulumi.Input[str]] = None,
                 response_translator: Optional[pulumi.Input[str]] = None,
                 return_behavior: Optional[pulumi.Input[str]] = None,
                 return_null_allowed: Optional[pulumi.Input[bool]] = None,
                 return_type: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 url_of_proxy_and_resource: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalFunctionArgs.__new__(ExternalFunctionArgs)

            if api_integration is None and not opts.urn:
                raise TypeError("Missing required property 'api_integration'")
            __props__.__dict__["api_integration"] = api_integration
            __props__.__dict__["args"] = args
            __props__.__dict__["comment"] = comment
            __props__.__dict__["compression"] = compression
            __props__.__dict__["context_headers"] = context_headers
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["headers"] = headers
            __props__.__dict__["max_batch_rows"] = max_batch_rows
            __props__.__dict__["name"] = name
            __props__.__dict__["null_input_behavior"] = null_input_behavior
            __props__.__dict__["request_translator"] = request_translator
            __props__.__dict__["response_translator"] = response_translator
            if return_behavior is None and not opts.urn:
                raise TypeError("Missing required property 'return_behavior'")
            __props__.__dict__["return_behavior"] = return_behavior
            __props__.__dict__["return_null_allowed"] = return_null_allowed
            if return_type is None and not opts.urn:
                raise TypeError("Missing required property 'return_type'")
            __props__.__dict__["return_type"] = return_type
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            if url_of_proxy_and_resource is None and not opts.urn:
                raise TypeError("Missing required property 'url_of_proxy_and_resource'")
            __props__.__dict__["url_of_proxy_and_resource"] = url_of_proxy_and_resource
            __props__.__dict__["created_on"] = None
        super(ExternalFunction, __self__).__init__(
            'snowflake:index/externalFunction:ExternalFunction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_integration: Optional[pulumi.Input[str]] = None,
            args: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionArgArgs']]]]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            compression: Optional[pulumi.Input[str]] = None,
            context_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            created_on: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[str]] = None,
            headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionHeaderArgs']]]]] = None,
            max_batch_rows: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            null_input_behavior: Optional[pulumi.Input[str]] = None,
            request_translator: Optional[pulumi.Input[str]] = None,
            response_translator: Optional[pulumi.Input[str]] = None,
            return_behavior: Optional[pulumi.Input[str]] = None,
            return_null_allowed: Optional[pulumi.Input[bool]] = None,
            return_type: Optional[pulumi.Input[str]] = None,
            schema: Optional[pulumi.Input[str]] = None,
            url_of_proxy_and_resource: Optional[pulumi.Input[str]] = None) -> 'ExternalFunction':
        """
        Get an existing ExternalFunction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_integration: The name of the API integration object that should be used to authenticate the call to the proxy service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionArgArgs']]]] args: Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        :param pulumi.Input[str] comment: A description of the external function.
        :param pulumi.Input[str] compression: If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] context_headers: Binds Snowflake context function results to HTTP headers.
        :param pulumi.Input[str] created_on: Date and time when the external function was created.
        :param pulumi.Input[str] database: The database in which to create the external function.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalFunctionHeaderArgs']]]] headers: Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        :param pulumi.Input[int] max_batch_rows: This specifies the maximum number of rows in each batch sent to the proxy service.
        :param pulumi.Input[str] name: Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        :param pulumi.Input[str] null_input_behavior: Specifies the behavior of the external function when called with null inputs.
        :param pulumi.Input[str] request_translator: This specifies the name of the request translator function
        :param pulumi.Input[str] response_translator: This specifies the name of the response translator function.
        :param pulumi.Input[str] return_behavior: Specifies the behavior of the function when returning results
        :param pulumi.Input[bool] return_null_allowed: Indicates whether the function can return NULL values or must return only NON-NULL values.
        :param pulumi.Input[str] return_type: Specifies the data type returned by the external function.
        :param pulumi.Input[str] schema: The schema in which to create the external function.
        :param pulumi.Input[str] url_of_proxy_and_resource: This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalFunctionState.__new__(_ExternalFunctionState)

        __props__.__dict__["api_integration"] = api_integration
        __props__.__dict__["args"] = args
        __props__.__dict__["comment"] = comment
        __props__.__dict__["compression"] = compression
        __props__.__dict__["context_headers"] = context_headers
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["database"] = database
        __props__.__dict__["headers"] = headers
        __props__.__dict__["max_batch_rows"] = max_batch_rows
        __props__.__dict__["name"] = name
        __props__.__dict__["null_input_behavior"] = null_input_behavior
        __props__.__dict__["request_translator"] = request_translator
        __props__.__dict__["response_translator"] = response_translator
        __props__.__dict__["return_behavior"] = return_behavior
        __props__.__dict__["return_null_allowed"] = return_null_allowed
        __props__.__dict__["return_type"] = return_type
        __props__.__dict__["schema"] = schema
        __props__.__dict__["url_of_proxy_and_resource"] = url_of_proxy_and_resource
        return ExternalFunction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiIntegration")
    def api_integration(self) -> pulumi.Output[str]:
        """
        The name of the API integration object that should be used to authenticate the call to the proxy service.
        """
        return pulumi.get(self, "api_integration")

    @property
    @pulumi.getter
    def args(self) -> pulumi.Output[Optional[Sequence['outputs.ExternalFunctionArg']]]:
        """
        Specifies the arguments/inputs for the external function. These should correspond to the arguments that the remote service expects.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the external function.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def compression(self) -> pulumi.Output[Optional[str]]:
        """
        If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="contextHeaders")
    def context_headers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Binds Snowflake context function results to HTTP headers.
        """
        return pulumi.get(self, "context_headers")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[str]:
        """
        Date and time when the external function was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        The database in which to create the external function.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Sequence['outputs.ExternalFunctionHeader']]]:
        """
        Allows users to specify key-value metadata that is sent with every request as HTTP headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="maxBatchRows")
    def max_batch_rows(self) -> pulumi.Output[Optional[int]]:
        """
        This specifies the maximum number of rows in each batch sent to the proxy service.
        """
        return pulumi.get(self, "max_batch_rows")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the behavior of the external function when called with null inputs.
        """
        return pulumi.get(self, "null_input_behavior")

    @property
    @pulumi.getter(name="requestTranslator")
    def request_translator(self) -> pulumi.Output[Optional[str]]:
        """
        This specifies the name of the request translator function
        """
        return pulumi.get(self, "request_translator")

    @property
    @pulumi.getter(name="responseTranslator")
    def response_translator(self) -> pulumi.Output[Optional[str]]:
        """
        This specifies the name of the response translator function.
        """
        return pulumi.get(self, "response_translator")

    @property
    @pulumi.getter(name="returnBehavior")
    def return_behavior(self) -> pulumi.Output[str]:
        """
        Specifies the behavior of the function when returning results
        """
        return pulumi.get(self, "return_behavior")

    @property
    @pulumi.getter(name="returnNullAllowed")
    def return_null_allowed(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the function can return NULL values or must return only NON-NULL values.
        """
        return pulumi.get(self, "return_null_allowed")

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Output[str]:
        """
        Specifies the data type returned by the external function.
        """
        return pulumi.get(self, "return_type")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[str]:
        """
        The schema in which to create the external function.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="urlOfProxyAndResource")
    def url_of_proxy_and_resource(self) -> pulumi.Output[str]:
        """
        This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
        """
        return pulumi.get(self, "url_of_proxy_and_resource")

