# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalTableArgs', 'ExternalTable']

@pulumi.input_type
class ExternalTableArgs:
    def __init__(__self__, *,
                 columns: pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]],
                 database: pulumi.Input[str],
                 file_format: pulumi.Input[str],
                 location: pulumi.Input[str],
                 schema: pulumi.Input[str],
                 auto_refresh: Optional[pulumi.Input[bool]] = None,
                 aws_sns_topic: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 copy_grants: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 refresh_on_create: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]] = None):
        """
        The set of arguments for constructing a ExternalTable resource.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]] columns: Definitions of a column to create in the external table. Minimum one required.
        :param pulumi.Input[str] database: The database in which to create the external table.
        :param pulumi.Input[str] file_format: Specifies the file format for the external table.
        :param pulumi.Input[str] location: Specifies a location for the external table.
        :param pulumi.Input[str] schema: The schema in which to create the external table.
        :param pulumi.Input[bool] auto_refresh: Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        :param pulumi.Input[str] aws_sns_topic: Specifies the aws sns topic for the external table.
        :param pulumi.Input[str] comment: Specifies a comment for the external table.
        :param pulumi.Input[bool] copy_grants: Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        :param pulumi.Input[str] name: Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] partition_bies: Specifies any partition columns to evaluate for the external table.
        :param pulumi.Input[str] pattern: Specifies the file names and/or paths on the external stage to match.
        :param pulumi.Input[bool] refresh_on_create: Specifies weather to refresh when an external table is created.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]] tags: Definitions of a tag to associate with the resource.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "file_format", file_format)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "schema", schema)
        if auto_refresh is not None:
            pulumi.set(__self__, "auto_refresh", auto_refresh)
        if aws_sns_topic is not None:
            pulumi.set(__self__, "aws_sns_topic", aws_sns_topic)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_grants is not None:
            pulumi.set(__self__, "copy_grants", copy_grants)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_bies is not None:
            pulumi.set(__self__, "partition_bies", partition_bies)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if refresh_on_create is not None:
            pulumi.set(__self__, "refresh_on_create", refresh_on_create)
        if tags is not None:
            warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def columns(self) -> pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]:
        """
        Definitions of a column to create in the external table. Minimum one required.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The database in which to create the external table.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Input[str]:
        """
        Specifies the file format for the external table.
        """
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Specifies a location for the external table.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[str]:
        """
        The schema in which to create the external table.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="autoRefresh")
    def auto_refresh(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        """
        return pulumi.get(self, "auto_refresh")

    @auto_refresh.setter
    def auto_refresh(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_refresh", value)

    @property
    @pulumi.getter(name="awsSnsTopic")
    def aws_sns_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the aws sns topic for the external table.
        """
        return pulumi.get(self, "aws_sns_topic")

    @aws_sns_topic.setter
    def aws_sns_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_sns_topic", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the external table.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        """
        return pulumi.get(self, "copy_grants")

    @copy_grants.setter
    def copy_grants(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_grants", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="partitionBies")
    def partition_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies any partition columns to evaluate for the external table.
        """
        return pulumi.get(self, "partition_bies")

    @partition_bies.setter
    def partition_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "partition_bies", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file names and/or paths on the external stage to match.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="refreshOnCreate")
    def refresh_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies weather to refresh when an external table is created.
        """
        return pulumi.get(self, "refresh_on_create")

    @refresh_on_create.setter
    def refresh_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "refresh_on_create", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ExternalTableState:
    def __init__(__self__, *,
                 auto_refresh: Optional[pulumi.Input[bool]] = None,
                 aws_sns_topic: Optional[pulumi.Input[str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 copy_grants: Optional[pulumi.Input[bool]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 file_format: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 refresh_on_create: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering ExternalTable resources.
        :param pulumi.Input[bool] auto_refresh: Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        :param pulumi.Input[str] aws_sns_topic: Specifies the aws sns topic for the external table.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]] columns: Definitions of a column to create in the external table. Minimum one required.
        :param pulumi.Input[str] comment: Specifies a comment for the external table.
        :param pulumi.Input[bool] copy_grants: Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        :param pulumi.Input[str] database: The database in which to create the external table.
        :param pulumi.Input[str] file_format: Specifies the file format for the external table.
        :param pulumi.Input[str] location: Specifies a location for the external table.
        :param pulumi.Input[str] name: Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        :param pulumi.Input[str] owner: Name of the role that owns the external table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] partition_bies: Specifies any partition columns to evaluate for the external table.
        :param pulumi.Input[str] pattern: Specifies the file names and/or paths on the external stage to match.
        :param pulumi.Input[bool] refresh_on_create: Specifies weather to refresh when an external table is created.
        :param pulumi.Input[str] schema: The schema in which to create the external table.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]] tags: Definitions of a tag to associate with the resource.
        """
        if auto_refresh is not None:
            pulumi.set(__self__, "auto_refresh", auto_refresh)
        if aws_sns_topic is not None:
            pulumi.set(__self__, "aws_sns_topic", aws_sns_topic)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_grants is not None:
            pulumi.set(__self__, "copy_grants", copy_grants)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if partition_bies is not None:
            pulumi.set(__self__, "partition_bies", partition_bies)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if refresh_on_create is not None:
            pulumi.set(__self__, "refresh_on_create", refresh_on_create)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if tags is not None:
            warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoRefresh")
    def auto_refresh(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        """
        return pulumi.get(self, "auto_refresh")

    @auto_refresh.setter
    def auto_refresh(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_refresh", value)

    @property
    @pulumi.getter(name="awsSnsTopic")
    def aws_sns_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the aws sns topic for the external table.
        """
        return pulumi.get(self, "aws_sns_topic")

    @aws_sns_topic.setter
    def aws_sns_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_sns_topic", value)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]]:
        """
        Definitions of a column to create in the external table. Minimum one required.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the external table.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        """
        return pulumi.get(self, "copy_grants")

    @copy_grants.setter
    def copy_grants(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_grants", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The database in which to create the external table.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file format for the external table.
        """
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a location for the external table.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role that owns the external table.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="partitionBies")
    def partition_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies any partition columns to evaluate for the external table.
        """
        return pulumi.get(self, "partition_bies")

    @partition_bies.setter
    def partition_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "partition_bies", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file names and/or paths on the external stage to match.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="refreshOnCreate")
    def refresh_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies weather to refresh when an external table is created.
        """
        return pulumi.get(self, "refresh_on_create")

    @refresh_on_create.setter
    def refresh_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "refresh_on_create", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        The schema in which to create the external table.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]]):
        pulumi.set(self, "tags", value)


class ExternalTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_refresh: Optional[pulumi.Input[bool]] = None,
                 aws_sns_topic: Optional[pulumi.Input[str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableColumnArgs']]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 copy_grants: Optional[pulumi.Input[bool]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 file_format: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 refresh_on_create: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableTagArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        external_table = snowflake.ExternalTable("externalTable",
            columns=[
                snowflake.ExternalTableColumnArgs(
                    name="id",
                    type="int",
                ),
                snowflake.ExternalTableColumnArgs(
                    name="data",
                    type="text",
                ),
            ],
            comment="External table",
            database="db",
            file_format="TYPE = CSV FIELD_DELIMITER = '|'",
            schema="schema")
        ```

        ## Import

        format is database name | schema name | external table name

        ```sh
         $ pulumi import snowflake:index/externalTable:ExternalTable example 'dbName|schemaName|externalTableName'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_refresh: Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        :param pulumi.Input[str] aws_sns_topic: Specifies the aws sns topic for the external table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableColumnArgs']]]] columns: Definitions of a column to create in the external table. Minimum one required.
        :param pulumi.Input[str] comment: Specifies a comment for the external table.
        :param pulumi.Input[bool] copy_grants: Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        :param pulumi.Input[str] database: The database in which to create the external table.
        :param pulumi.Input[str] file_format: Specifies the file format for the external table.
        :param pulumi.Input[str] location: Specifies a location for the external table.
        :param pulumi.Input[str] name: Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] partition_bies: Specifies any partition columns to evaluate for the external table.
        :param pulumi.Input[str] pattern: Specifies the file names and/or paths on the external stage to match.
        :param pulumi.Input[bool] refresh_on_create: Specifies weather to refresh when an external table is created.
        :param pulumi.Input[str] schema: The schema in which to create the external table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableTagArgs']]]] tags: Definitions of a tag to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        external_table = snowflake.ExternalTable("externalTable",
            columns=[
                snowflake.ExternalTableColumnArgs(
                    name="id",
                    type="int",
                ),
                snowflake.ExternalTableColumnArgs(
                    name="data",
                    type="text",
                ),
            ],
            comment="External table",
            database="db",
            file_format="TYPE = CSV FIELD_DELIMITER = '|'",
            schema="schema")
        ```

        ## Import

        format is database name | schema name | external table name

        ```sh
         $ pulumi import snowflake:index/externalTable:ExternalTable example 'dbName|schemaName|externalTableName'
        ```

        :param str resource_name: The name of the resource.
        :param ExternalTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_refresh: Optional[pulumi.Input[bool]] = None,
                 aws_sns_topic: Optional[pulumi.Input[str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableColumnArgs']]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 copy_grants: Optional[pulumi.Input[bool]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 file_format: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pattern: Optional[pulumi.Input[str]] = None,
                 refresh_on_create: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalTableArgs.__new__(ExternalTableArgs)

            __props__.__dict__["auto_refresh"] = auto_refresh
            __props__.__dict__["aws_sns_topic"] = aws_sns_topic
            if columns is None and not opts.urn:
                raise TypeError("Missing required property 'columns'")
            __props__.__dict__["columns"] = columns
            __props__.__dict__["comment"] = comment
            __props__.__dict__["copy_grants"] = copy_grants
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            if file_format is None and not opts.urn:
                raise TypeError("Missing required property 'file_format'")
            __props__.__dict__["file_format"] = file_format
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["partition_bies"] = partition_bies
            __props__.__dict__["pattern"] = pattern
            __props__.__dict__["refresh_on_create"] = refresh_on_create
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            if tags is not None and not opts.urn:
                warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
                pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
            __props__.__dict__["tags"] = tags
            __props__.__dict__["owner"] = None
        super(ExternalTable, __self__).__init__(
            'snowflake:index/externalTable:ExternalTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_refresh: Optional[pulumi.Input[bool]] = None,
            aws_sns_topic: Optional[pulumi.Input[str]] = None,
            columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableColumnArgs']]]]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            copy_grants: Optional[pulumi.Input[bool]] = None,
            database: Optional[pulumi.Input[str]] = None,
            file_format: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            pattern: Optional[pulumi.Input[str]] = None,
            refresh_on_create: Optional[pulumi.Input[bool]] = None,
            schema: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableTagArgs']]]]] = None) -> 'ExternalTable':
        """
        Get an existing ExternalTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_refresh: Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        :param pulumi.Input[str] aws_sns_topic: Specifies the aws sns topic for the external table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableColumnArgs']]]] columns: Definitions of a column to create in the external table. Minimum one required.
        :param pulumi.Input[str] comment: Specifies a comment for the external table.
        :param pulumi.Input[bool] copy_grants: Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        :param pulumi.Input[str] database: The database in which to create the external table.
        :param pulumi.Input[str] file_format: Specifies the file format for the external table.
        :param pulumi.Input[str] location: Specifies a location for the external table.
        :param pulumi.Input[str] name: Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        :param pulumi.Input[str] owner: Name of the role that owns the external table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] partition_bies: Specifies any partition columns to evaluate for the external table.
        :param pulumi.Input[str] pattern: Specifies the file names and/or paths on the external stage to match.
        :param pulumi.Input[bool] refresh_on_create: Specifies weather to refresh when an external table is created.
        :param pulumi.Input[str] schema: The schema in which to create the external table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalTableTagArgs']]]] tags: Definitions of a tag to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalTableState.__new__(_ExternalTableState)

        __props__.__dict__["auto_refresh"] = auto_refresh
        __props__.__dict__["aws_sns_topic"] = aws_sns_topic
        __props__.__dict__["columns"] = columns
        __props__.__dict__["comment"] = comment
        __props__.__dict__["copy_grants"] = copy_grants
        __props__.__dict__["database"] = database
        __props__.__dict__["file_format"] = file_format
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["partition_bies"] = partition_bies
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["refresh_on_create"] = refresh_on_create
        __props__.__dict__["schema"] = schema
        __props__.__dict__["tags"] = tags
        return ExternalTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRefresh")
    def auto_refresh(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        """
        return pulumi.get(self, "auto_refresh")

    @property
    @pulumi.getter(name="awsSnsTopic")
    def aws_sns_topic(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the aws sns topic for the external table.
        """
        return pulumi.get(self, "aws_sns_topic")

    @property
    @pulumi.getter
    def columns(self) -> pulumi.Output[Sequence['outputs.ExternalTableColumn']]:
        """
        Definitions of a column to create in the external table. Minimum one required.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a comment for the external table.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        """
        return pulumi.get(self, "copy_grants")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        The database in which to create the external table.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Output[str]:
        """
        Specifies the file format for the external table.
        """
        return pulumi.get(self, "file_format")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Specifies a location for the external table.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        """
        Name of the role that owns the external table.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="partitionBies")
    def partition_bies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies any partition columns to evaluate for the external table.
        """
        return pulumi.get(self, "partition_bies")

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the file names and/or paths on the external stage to match.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="refreshOnCreate")
    def refresh_on_create(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies weather to refresh when an external table is created.
        """
        return pulumi.get(self, "refresh_on_create")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[str]:
        """
        The schema in which to create the external table.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ExternalTableTag']]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

