# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FileFormatArgs', 'FileFormat']

@pulumi.input_type
class FileFormatArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[str],
                 format_type: pulumi.Input[str],
                 schema: pulumi.Input[str],
                 allow_duplicate: Optional[pulumi.Input[bool]] = None,
                 binary_as_text: Optional[pulumi.Input[bool]] = None,
                 binary_format: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 disable_auto_convert: Optional[pulumi.Input[bool]] = None,
                 disable_snowflake_data: Optional[pulumi.Input[bool]] = None,
                 empty_field_as_null: Optional[pulumi.Input[bool]] = None,
                 enable_octal: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 error_on_column_count_mismatch: Optional[pulumi.Input[bool]] = None,
                 escape: Optional[pulumi.Input[str]] = None,
                 escape_unenclosed_field: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 field_optionally_enclosed_by: Optional[pulumi.Input[str]] = None,
                 file_extension: Optional[pulumi.Input[str]] = None,
                 ignore_utf8_errors: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_space: Optional[pulumi.Input[bool]] = None,
                 record_delimiter: Optional[pulumi.Input[str]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[bool]] = None,
                 skip_blank_lines: Optional[pulumi.Input[bool]] = None,
                 skip_byte_order_mark: Optional[pulumi.Input[bool]] = None,
                 skip_header: Optional[pulumi.Input[int]] = None,
                 strip_null_values: Optional[pulumi.Input[bool]] = None,
                 strip_outer_array: Optional[pulumi.Input[bool]] = None,
                 strip_outer_element: Optional[pulumi.Input[bool]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 trim_space: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a FileFormat resource.
        :param pulumi.Input[str] database: The database in which to create the file format.
        :param pulumi.Input[str] format_type: Specifies the format of the input files (for data loading) or output files (for data unloading).
        :param pulumi.Input[str] schema: The schema in which to create the file format.
        :param pulumi.Input[bool] allow_duplicate: Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        :param pulumi.Input[bool] binary_as_text: Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        :param pulumi.Input[str] binary_format: Defines the encoding format for binary input or output.
        :param pulumi.Input[str] comment: Specifies a comment for the file format.
        :param pulumi.Input[str] compression: Specifies the current compression algorithm for the data file.
        :param pulumi.Input[str] date_format: Defines the format of date values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[bool] disable_auto_convert: Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        :param pulumi.Input[bool] disable_snowflake_data: Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        :param pulumi.Input[bool] empty_field_as_null: Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        :param pulumi.Input[bool] enable_octal: Boolean that enables parsing of octal numbers.
        :param pulumi.Input[str] encoding: String (constant) that specifies the character set of the source data when loading data into a table.
        :param pulumi.Input[bool] error_on_column_count_mismatch: Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        :param pulumi.Input[str] escape: Single character string used as the escape character for field values.
        :param pulumi.Input[str] escape_unenclosed_field: Single character string used as the escape character for unenclosed field values only.
        :param pulumi.Input[str] field_delimiter: Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[str] field_optionally_enclosed_by: Character used to enclose strings.
        :param pulumi.Input[str] file_extension: Specifies the extension for files unloaded to a stage.
        :param pulumi.Input[bool] ignore_utf8_errors: Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        :param pulumi.Input[str] name: Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] null_ifs: String used to convert to and from SQL NULL.
        :param pulumi.Input[bool] preserve_space: Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        :param pulumi.Input[str] record_delimiter: Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[bool] replace_invalid_characters: Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        :param pulumi.Input[bool] skip_blank_lines: Boolean that specifies to skip any blank lines encountered in the data files.
        :param pulumi.Input[bool] skip_byte_order_mark: Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        :param pulumi.Input[int] skip_header: Number of lines at the start of the file to skip.
        :param pulumi.Input[bool] strip_null_values: Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        :param pulumi.Input[bool] strip_outer_array: Boolean that instructs the JSON parser to remove outer brackets.
        :param pulumi.Input[bool] strip_outer_element: Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        :param pulumi.Input[str] time_format: Defines the format of time values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[str] timestamp_format: Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[bool] trim_space: Boolean that specifies whether to remove white space from fields.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "format_type", format_type)
        pulumi.set(__self__, "schema", schema)
        if allow_duplicate is not None:
            pulumi.set(__self__, "allow_duplicate", allow_duplicate)
        if binary_as_text is not None:
            pulumi.set(__self__, "binary_as_text", binary_as_text)
        if binary_format is not None:
            pulumi.set(__self__, "binary_format", binary_format)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if disable_auto_convert is not None:
            pulumi.set(__self__, "disable_auto_convert", disable_auto_convert)
        if disable_snowflake_data is not None:
            pulumi.set(__self__, "disable_snowflake_data", disable_snowflake_data)
        if empty_field_as_null is not None:
            pulumi.set(__self__, "empty_field_as_null", empty_field_as_null)
        if enable_octal is not None:
            pulumi.set(__self__, "enable_octal", enable_octal)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if error_on_column_count_mismatch is not None:
            pulumi.set(__self__, "error_on_column_count_mismatch", error_on_column_count_mismatch)
        if escape is not None:
            pulumi.set(__self__, "escape", escape)
        if escape_unenclosed_field is not None:
            pulumi.set(__self__, "escape_unenclosed_field", escape_unenclosed_field)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if field_optionally_enclosed_by is not None:
            pulumi.set(__self__, "field_optionally_enclosed_by", field_optionally_enclosed_by)
        if file_extension is not None:
            pulumi.set(__self__, "file_extension", file_extension)
        if ignore_utf8_errors is not None:
            pulumi.set(__self__, "ignore_utf8_errors", ignore_utf8_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_ifs is not None:
            pulumi.set(__self__, "null_ifs", null_ifs)
        if preserve_space is not None:
            pulumi.set(__self__, "preserve_space", preserve_space)
        if record_delimiter is not None:
            pulumi.set(__self__, "record_delimiter", record_delimiter)
        if replace_invalid_characters is not None:
            pulumi.set(__self__, "replace_invalid_characters", replace_invalid_characters)
        if skip_blank_lines is not None:
            pulumi.set(__self__, "skip_blank_lines", skip_blank_lines)
        if skip_byte_order_mark is not None:
            pulumi.set(__self__, "skip_byte_order_mark", skip_byte_order_mark)
        if skip_header is not None:
            pulumi.set(__self__, "skip_header", skip_header)
        if strip_null_values is not None:
            pulumi.set(__self__, "strip_null_values", strip_null_values)
        if strip_outer_array is not None:
            pulumi.set(__self__, "strip_outer_array", strip_outer_array)
        if strip_outer_element is not None:
            pulumi.set(__self__, "strip_outer_element", strip_outer_element)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if trim_space is not None:
            pulumi.set(__self__, "trim_space", trim_space)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The database in which to create the file format.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> pulumi.Input[str]:
        """
        Specifies the format of the input files (for data loading) or output files (for data unloading).
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "format_type", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[str]:
        """
        The schema in which to create the file format.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="allowDuplicate")
    def allow_duplicate(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        """
        return pulumi.get(self, "allow_duplicate")

    @allow_duplicate.setter
    def allow_duplicate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_duplicate", value)

    @property
    @pulumi.getter(name="binaryAsText")
    def binary_as_text(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        """
        return pulumi.get(self, "binary_as_text")

    @binary_as_text.setter
    def binary_as_text(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "binary_as_text", value)

    @property
    @pulumi.getter(name="binaryFormat")
    def binary_format(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the encoding format for binary input or output.
        """
        return pulumi.get(self, "binary_format")

    @binary_format.setter
    def binary_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binary_format", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the file format.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the current compression algorithm for the data file.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the format of date values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter(name="disableAutoConvert")
    def disable_auto_convert(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        """
        return pulumi.get(self, "disable_auto_convert")

    @disable_auto_convert.setter
    def disable_auto_convert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_auto_convert", value)

    @property
    @pulumi.getter(name="disableSnowflakeData")
    def disable_snowflake_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        """
        return pulumi.get(self, "disable_snowflake_data")

    @disable_snowflake_data.setter
    def disable_snowflake_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_snowflake_data", value)

    @property
    @pulumi.getter(name="emptyFieldAsNull")
    def empty_field_as_null(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        """
        return pulumi.get(self, "empty_field_as_null")

    @empty_field_as_null.setter
    def empty_field_as_null(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "empty_field_as_null", value)

    @property
    @pulumi.getter(name="enableOctal")
    def enable_octal(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that enables parsing of octal numbers.
        """
        return pulumi.get(self, "enable_octal")

    @enable_octal.setter
    def enable_octal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_octal", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        String (constant) that specifies the character set of the source data when loading data into a table.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="errorOnColumnCountMismatch")
    def error_on_column_count_mismatch(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        """
        return pulumi.get(self, "error_on_column_count_mismatch")

    @error_on_column_count_mismatch.setter
    def error_on_column_count_mismatch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "error_on_column_count_mismatch", value)

    @property
    @pulumi.getter
    def escape(self) -> Optional[pulumi.Input[str]]:
        """
        Single character string used as the escape character for field values.
        """
        return pulumi.get(self, "escape")

    @escape.setter
    def escape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escape", value)

    @property
    @pulumi.getter(name="escapeUnenclosedField")
    def escape_unenclosed_field(self) -> Optional[pulumi.Input[str]]:
        """
        Single character string used as the escape character for unenclosed field values only.
        """
        return pulumi.get(self, "escape_unenclosed_field")

    @escape_unenclosed_field.setter
    def escape_unenclosed_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escape_unenclosed_field", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="fieldOptionallyEnclosedBy")
    def field_optionally_enclosed_by(self) -> Optional[pulumi.Input[str]]:
        """
        Character used to enclose strings.
        """
        return pulumi.get(self, "field_optionally_enclosed_by")

    @field_optionally_enclosed_by.setter
    def field_optionally_enclosed_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_optionally_enclosed_by", value)

    @property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the extension for files unloaded to a stage.
        """
        return pulumi.get(self, "file_extension")

    @file_extension.setter
    def file_extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_extension", value)

    @property
    @pulumi.getter(name="ignoreUtf8Errors")
    def ignore_utf8_errors(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        """
        return pulumi.get(self, "ignore_utf8_errors")

    @ignore_utf8_errors.setter
    def ignore_utf8_errors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_utf8_errors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nullIfs")
    def null_ifs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        String used to convert to and from SQL NULL.
        """
        return pulumi.get(self, "null_ifs")

    @null_ifs.setter
    def null_ifs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "null_ifs", value)

    @property
    @pulumi.getter(name="preserveSpace")
    def preserve_space(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        """
        return pulumi.get(self, "preserve_space")

    @preserve_space.setter
    def preserve_space(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_space", value)

    @property
    @pulumi.getter(name="recordDelimiter")
    def record_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "record_delimiter")

    @record_delimiter.setter
    def record_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_delimiter", value)

    @property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @replace_invalid_characters.setter
    def replace_invalid_characters(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace_invalid_characters", value)

    @property
    @pulumi.getter(name="skipBlankLines")
    def skip_blank_lines(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies to skip any blank lines encountered in the data files.
        """
        return pulumi.get(self, "skip_blank_lines")

    @skip_blank_lines.setter
    def skip_blank_lines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_blank_lines", value)

    @property
    @pulumi.getter(name="skipByteOrderMark")
    def skip_byte_order_mark(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        """
        return pulumi.get(self, "skip_byte_order_mark")

    @skip_byte_order_mark.setter
    def skip_byte_order_mark(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_byte_order_mark", value)

    @property
    @pulumi.getter(name="skipHeader")
    def skip_header(self) -> Optional[pulumi.Input[int]]:
        """
        Number of lines at the start of the file to skip.
        """
        return pulumi.get(self, "skip_header")

    @skip_header.setter
    def skip_header(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "skip_header", value)

    @property
    @pulumi.getter(name="stripNullValues")
    def strip_null_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        """
        return pulumi.get(self, "strip_null_values")

    @strip_null_values.setter
    def strip_null_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_null_values", value)

    @property
    @pulumi.getter(name="stripOuterArray")
    def strip_outer_array(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that instructs the JSON parser to remove outer brackets.
        """
        return pulumi.get(self, "strip_outer_array")

    @strip_outer_array.setter
    def strip_outer_array(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_outer_array", value)

    @property
    @pulumi.getter(name="stripOuterElement")
    def strip_outer_element(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        """
        return pulumi.get(self, "strip_outer_element")

    @strip_outer_element.setter
    def strip_outer_element(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_outer_element", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the format of time values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)

    @property
    @pulumi.getter(name="trimSpace")
    def trim_space(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to remove white space from fields.
        """
        return pulumi.get(self, "trim_space")

    @trim_space.setter
    def trim_space(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trim_space", value)


@pulumi.input_type
class _FileFormatState:
    def __init__(__self__, *,
                 allow_duplicate: Optional[pulumi.Input[bool]] = None,
                 binary_as_text: Optional[pulumi.Input[bool]] = None,
                 binary_format: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 disable_auto_convert: Optional[pulumi.Input[bool]] = None,
                 disable_snowflake_data: Optional[pulumi.Input[bool]] = None,
                 empty_field_as_null: Optional[pulumi.Input[bool]] = None,
                 enable_octal: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 error_on_column_count_mismatch: Optional[pulumi.Input[bool]] = None,
                 escape: Optional[pulumi.Input[str]] = None,
                 escape_unenclosed_field: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 field_optionally_enclosed_by: Optional[pulumi.Input[str]] = None,
                 file_extension: Optional[pulumi.Input[str]] = None,
                 format_type: Optional[pulumi.Input[str]] = None,
                 ignore_utf8_errors: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_space: Optional[pulumi.Input[bool]] = None,
                 record_delimiter: Optional[pulumi.Input[str]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 skip_blank_lines: Optional[pulumi.Input[bool]] = None,
                 skip_byte_order_mark: Optional[pulumi.Input[bool]] = None,
                 skip_header: Optional[pulumi.Input[int]] = None,
                 strip_null_values: Optional[pulumi.Input[bool]] = None,
                 strip_outer_array: Optional[pulumi.Input[bool]] = None,
                 strip_outer_element: Optional[pulumi.Input[bool]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 trim_space: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering FileFormat resources.
        :param pulumi.Input[bool] allow_duplicate: Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        :param pulumi.Input[bool] binary_as_text: Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        :param pulumi.Input[str] binary_format: Defines the encoding format for binary input or output.
        :param pulumi.Input[str] comment: Specifies a comment for the file format.
        :param pulumi.Input[str] compression: Specifies the current compression algorithm for the data file.
        :param pulumi.Input[str] database: The database in which to create the file format.
        :param pulumi.Input[str] date_format: Defines the format of date values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[bool] disable_auto_convert: Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        :param pulumi.Input[bool] disable_snowflake_data: Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        :param pulumi.Input[bool] empty_field_as_null: Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        :param pulumi.Input[bool] enable_octal: Boolean that enables parsing of octal numbers.
        :param pulumi.Input[str] encoding: String (constant) that specifies the character set of the source data when loading data into a table.
        :param pulumi.Input[bool] error_on_column_count_mismatch: Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        :param pulumi.Input[str] escape: Single character string used as the escape character for field values.
        :param pulumi.Input[str] escape_unenclosed_field: Single character string used as the escape character for unenclosed field values only.
        :param pulumi.Input[str] field_delimiter: Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[str] field_optionally_enclosed_by: Character used to enclose strings.
        :param pulumi.Input[str] file_extension: Specifies the extension for files unloaded to a stage.
        :param pulumi.Input[str] format_type: Specifies the format of the input files (for data loading) or output files (for data unloading).
        :param pulumi.Input[bool] ignore_utf8_errors: Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        :param pulumi.Input[str] name: Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] null_ifs: String used to convert to and from SQL NULL.
        :param pulumi.Input[bool] preserve_space: Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        :param pulumi.Input[str] record_delimiter: Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[bool] replace_invalid_characters: Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        :param pulumi.Input[str] schema: The schema in which to create the file format.
        :param pulumi.Input[bool] skip_blank_lines: Boolean that specifies to skip any blank lines encountered in the data files.
        :param pulumi.Input[bool] skip_byte_order_mark: Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        :param pulumi.Input[int] skip_header: Number of lines at the start of the file to skip.
        :param pulumi.Input[bool] strip_null_values: Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        :param pulumi.Input[bool] strip_outer_array: Boolean that instructs the JSON parser to remove outer brackets.
        :param pulumi.Input[bool] strip_outer_element: Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        :param pulumi.Input[str] time_format: Defines the format of time values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[str] timestamp_format: Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[bool] trim_space: Boolean that specifies whether to remove white space from fields.
        """
        if allow_duplicate is not None:
            pulumi.set(__self__, "allow_duplicate", allow_duplicate)
        if binary_as_text is not None:
            pulumi.set(__self__, "binary_as_text", binary_as_text)
        if binary_format is not None:
            pulumi.set(__self__, "binary_format", binary_format)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if disable_auto_convert is not None:
            pulumi.set(__self__, "disable_auto_convert", disable_auto_convert)
        if disable_snowflake_data is not None:
            pulumi.set(__self__, "disable_snowflake_data", disable_snowflake_data)
        if empty_field_as_null is not None:
            pulumi.set(__self__, "empty_field_as_null", empty_field_as_null)
        if enable_octal is not None:
            pulumi.set(__self__, "enable_octal", enable_octal)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if error_on_column_count_mismatch is not None:
            pulumi.set(__self__, "error_on_column_count_mismatch", error_on_column_count_mismatch)
        if escape is not None:
            pulumi.set(__self__, "escape", escape)
        if escape_unenclosed_field is not None:
            pulumi.set(__self__, "escape_unenclosed_field", escape_unenclosed_field)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if field_optionally_enclosed_by is not None:
            pulumi.set(__self__, "field_optionally_enclosed_by", field_optionally_enclosed_by)
        if file_extension is not None:
            pulumi.set(__self__, "file_extension", file_extension)
        if format_type is not None:
            pulumi.set(__self__, "format_type", format_type)
        if ignore_utf8_errors is not None:
            pulumi.set(__self__, "ignore_utf8_errors", ignore_utf8_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_ifs is not None:
            pulumi.set(__self__, "null_ifs", null_ifs)
        if preserve_space is not None:
            pulumi.set(__self__, "preserve_space", preserve_space)
        if record_delimiter is not None:
            pulumi.set(__self__, "record_delimiter", record_delimiter)
        if replace_invalid_characters is not None:
            pulumi.set(__self__, "replace_invalid_characters", replace_invalid_characters)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if skip_blank_lines is not None:
            pulumi.set(__self__, "skip_blank_lines", skip_blank_lines)
        if skip_byte_order_mark is not None:
            pulumi.set(__self__, "skip_byte_order_mark", skip_byte_order_mark)
        if skip_header is not None:
            pulumi.set(__self__, "skip_header", skip_header)
        if strip_null_values is not None:
            pulumi.set(__self__, "strip_null_values", strip_null_values)
        if strip_outer_array is not None:
            pulumi.set(__self__, "strip_outer_array", strip_outer_array)
        if strip_outer_element is not None:
            pulumi.set(__self__, "strip_outer_element", strip_outer_element)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if trim_space is not None:
            pulumi.set(__self__, "trim_space", trim_space)

    @property
    @pulumi.getter(name="allowDuplicate")
    def allow_duplicate(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        """
        return pulumi.get(self, "allow_duplicate")

    @allow_duplicate.setter
    def allow_duplicate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_duplicate", value)

    @property
    @pulumi.getter(name="binaryAsText")
    def binary_as_text(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        """
        return pulumi.get(self, "binary_as_text")

    @binary_as_text.setter
    def binary_as_text(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "binary_as_text", value)

    @property
    @pulumi.getter(name="binaryFormat")
    def binary_format(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the encoding format for binary input or output.
        """
        return pulumi.get(self, "binary_format")

    @binary_format.setter
    def binary_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binary_format", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the file format.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the current compression algorithm for the data file.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The database in which to create the file format.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the format of date values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter(name="disableAutoConvert")
    def disable_auto_convert(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        """
        return pulumi.get(self, "disable_auto_convert")

    @disable_auto_convert.setter
    def disable_auto_convert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_auto_convert", value)

    @property
    @pulumi.getter(name="disableSnowflakeData")
    def disable_snowflake_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        """
        return pulumi.get(self, "disable_snowflake_data")

    @disable_snowflake_data.setter
    def disable_snowflake_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_snowflake_data", value)

    @property
    @pulumi.getter(name="emptyFieldAsNull")
    def empty_field_as_null(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        """
        return pulumi.get(self, "empty_field_as_null")

    @empty_field_as_null.setter
    def empty_field_as_null(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "empty_field_as_null", value)

    @property
    @pulumi.getter(name="enableOctal")
    def enable_octal(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that enables parsing of octal numbers.
        """
        return pulumi.get(self, "enable_octal")

    @enable_octal.setter
    def enable_octal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_octal", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        String (constant) that specifies the character set of the source data when loading data into a table.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="errorOnColumnCountMismatch")
    def error_on_column_count_mismatch(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        """
        return pulumi.get(self, "error_on_column_count_mismatch")

    @error_on_column_count_mismatch.setter
    def error_on_column_count_mismatch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "error_on_column_count_mismatch", value)

    @property
    @pulumi.getter
    def escape(self) -> Optional[pulumi.Input[str]]:
        """
        Single character string used as the escape character for field values.
        """
        return pulumi.get(self, "escape")

    @escape.setter
    def escape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escape", value)

    @property
    @pulumi.getter(name="escapeUnenclosedField")
    def escape_unenclosed_field(self) -> Optional[pulumi.Input[str]]:
        """
        Single character string used as the escape character for unenclosed field values only.
        """
        return pulumi.get(self, "escape_unenclosed_field")

    @escape_unenclosed_field.setter
    def escape_unenclosed_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escape_unenclosed_field", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="fieldOptionallyEnclosedBy")
    def field_optionally_enclosed_by(self) -> Optional[pulumi.Input[str]]:
        """
        Character used to enclose strings.
        """
        return pulumi.get(self, "field_optionally_enclosed_by")

    @field_optionally_enclosed_by.setter
    def field_optionally_enclosed_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_optionally_enclosed_by", value)

    @property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the extension for files unloaded to a stage.
        """
        return pulumi.get(self, "file_extension")

    @file_extension.setter
    def file_extension(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_extension", value)

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the format of the input files (for data loading) or output files (for data unloading).
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format_type", value)

    @property
    @pulumi.getter(name="ignoreUtf8Errors")
    def ignore_utf8_errors(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        """
        return pulumi.get(self, "ignore_utf8_errors")

    @ignore_utf8_errors.setter
    def ignore_utf8_errors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_utf8_errors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nullIfs")
    def null_ifs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        String used to convert to and from SQL NULL.
        """
        return pulumi.get(self, "null_ifs")

    @null_ifs.setter
    def null_ifs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "null_ifs", value)

    @property
    @pulumi.getter(name="preserveSpace")
    def preserve_space(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        """
        return pulumi.get(self, "preserve_space")

    @preserve_space.setter
    def preserve_space(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_space", value)

    @property
    @pulumi.getter(name="recordDelimiter")
    def record_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "record_delimiter")

    @record_delimiter.setter
    def record_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_delimiter", value)

    @property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @replace_invalid_characters.setter
    def replace_invalid_characters(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace_invalid_characters", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        The schema in which to create the file format.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="skipBlankLines")
    def skip_blank_lines(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies to skip any blank lines encountered in the data files.
        """
        return pulumi.get(self, "skip_blank_lines")

    @skip_blank_lines.setter
    def skip_blank_lines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_blank_lines", value)

    @property
    @pulumi.getter(name="skipByteOrderMark")
    def skip_byte_order_mark(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        """
        return pulumi.get(self, "skip_byte_order_mark")

    @skip_byte_order_mark.setter
    def skip_byte_order_mark(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_byte_order_mark", value)

    @property
    @pulumi.getter(name="skipHeader")
    def skip_header(self) -> Optional[pulumi.Input[int]]:
        """
        Number of lines at the start of the file to skip.
        """
        return pulumi.get(self, "skip_header")

    @skip_header.setter
    def skip_header(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "skip_header", value)

    @property
    @pulumi.getter(name="stripNullValues")
    def strip_null_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        """
        return pulumi.get(self, "strip_null_values")

    @strip_null_values.setter
    def strip_null_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_null_values", value)

    @property
    @pulumi.getter(name="stripOuterArray")
    def strip_outer_array(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that instructs the JSON parser to remove outer brackets.
        """
        return pulumi.get(self, "strip_outer_array")

    @strip_outer_array.setter
    def strip_outer_array(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_outer_array", value)

    @property
    @pulumi.getter(name="stripOuterElement")
    def strip_outer_element(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        """
        return pulumi.get(self, "strip_outer_element")

    @strip_outer_element.setter
    def strip_outer_element(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_outer_element", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the format of time values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)

    @property
    @pulumi.getter(name="trimSpace")
    def trim_space(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean that specifies whether to remove white space from fields.
        """
        return pulumi.get(self, "trim_space")

    @trim_space.setter
    def trim_space(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trim_space", value)


class FileFormat(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_duplicate: Optional[pulumi.Input[bool]] = None,
                 binary_as_text: Optional[pulumi.Input[bool]] = None,
                 binary_format: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 disable_auto_convert: Optional[pulumi.Input[bool]] = None,
                 disable_snowflake_data: Optional[pulumi.Input[bool]] = None,
                 empty_field_as_null: Optional[pulumi.Input[bool]] = None,
                 enable_octal: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 error_on_column_count_mismatch: Optional[pulumi.Input[bool]] = None,
                 escape: Optional[pulumi.Input[str]] = None,
                 escape_unenclosed_field: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 field_optionally_enclosed_by: Optional[pulumi.Input[str]] = None,
                 file_extension: Optional[pulumi.Input[str]] = None,
                 format_type: Optional[pulumi.Input[str]] = None,
                 ignore_utf8_errors: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_space: Optional[pulumi.Input[bool]] = None,
                 record_delimiter: Optional[pulumi.Input[str]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 skip_blank_lines: Optional[pulumi.Input[bool]] = None,
                 skip_byte_order_mark: Optional[pulumi.Input[bool]] = None,
                 skip_header: Optional[pulumi.Input[int]] = None,
                 strip_null_values: Optional[pulumi.Input[bool]] = None,
                 strip_outer_array: Optional[pulumi.Input[bool]] = None,
                 strip_outer_element: Optional[pulumi.Input[bool]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 trim_space: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        example_file_format = snowflake.FileFormat("exampleFileFormat",
            database="EXAMPLE_DB",
            format_type="CSV",
            schema="EXAMPLE_SCHEMA")
        ```

        ## Import

        format is database name | schema name | file format name

        ```sh
         $ pulumi import snowflake:index/fileFormat:FileFormat example 'dbName|schemaName|fileFormatName'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_duplicate: Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        :param pulumi.Input[bool] binary_as_text: Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        :param pulumi.Input[str] binary_format: Defines the encoding format for binary input or output.
        :param pulumi.Input[str] comment: Specifies a comment for the file format.
        :param pulumi.Input[str] compression: Specifies the current compression algorithm for the data file.
        :param pulumi.Input[str] database: The database in which to create the file format.
        :param pulumi.Input[str] date_format: Defines the format of date values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[bool] disable_auto_convert: Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        :param pulumi.Input[bool] disable_snowflake_data: Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        :param pulumi.Input[bool] empty_field_as_null: Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        :param pulumi.Input[bool] enable_octal: Boolean that enables parsing of octal numbers.
        :param pulumi.Input[str] encoding: String (constant) that specifies the character set of the source data when loading data into a table.
        :param pulumi.Input[bool] error_on_column_count_mismatch: Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        :param pulumi.Input[str] escape: Single character string used as the escape character for field values.
        :param pulumi.Input[str] escape_unenclosed_field: Single character string used as the escape character for unenclosed field values only.
        :param pulumi.Input[str] field_delimiter: Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[str] field_optionally_enclosed_by: Character used to enclose strings.
        :param pulumi.Input[str] file_extension: Specifies the extension for files unloaded to a stage.
        :param pulumi.Input[str] format_type: Specifies the format of the input files (for data loading) or output files (for data unloading).
        :param pulumi.Input[bool] ignore_utf8_errors: Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        :param pulumi.Input[str] name: Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] null_ifs: String used to convert to and from SQL NULL.
        :param pulumi.Input[bool] preserve_space: Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        :param pulumi.Input[str] record_delimiter: Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[bool] replace_invalid_characters: Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        :param pulumi.Input[str] schema: The schema in which to create the file format.
        :param pulumi.Input[bool] skip_blank_lines: Boolean that specifies to skip any blank lines encountered in the data files.
        :param pulumi.Input[bool] skip_byte_order_mark: Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        :param pulumi.Input[int] skip_header: Number of lines at the start of the file to skip.
        :param pulumi.Input[bool] strip_null_values: Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        :param pulumi.Input[bool] strip_outer_array: Boolean that instructs the JSON parser to remove outer brackets.
        :param pulumi.Input[bool] strip_outer_element: Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        :param pulumi.Input[str] time_format: Defines the format of time values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[str] timestamp_format: Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[bool] trim_space: Boolean that specifies whether to remove white space from fields.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileFormatArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        example_file_format = snowflake.FileFormat("exampleFileFormat",
            database="EXAMPLE_DB",
            format_type="CSV",
            schema="EXAMPLE_SCHEMA")
        ```

        ## Import

        format is database name | schema name | file format name

        ```sh
         $ pulumi import snowflake:index/fileFormat:FileFormat example 'dbName|schemaName|fileFormatName'
        ```

        :param str resource_name: The name of the resource.
        :param FileFormatArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileFormatArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_duplicate: Optional[pulumi.Input[bool]] = None,
                 binary_as_text: Optional[pulumi.Input[bool]] = None,
                 binary_format: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 disable_auto_convert: Optional[pulumi.Input[bool]] = None,
                 disable_snowflake_data: Optional[pulumi.Input[bool]] = None,
                 empty_field_as_null: Optional[pulumi.Input[bool]] = None,
                 enable_octal: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 error_on_column_count_mismatch: Optional[pulumi.Input[bool]] = None,
                 escape: Optional[pulumi.Input[str]] = None,
                 escape_unenclosed_field: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 field_optionally_enclosed_by: Optional[pulumi.Input[str]] = None,
                 file_extension: Optional[pulumi.Input[str]] = None,
                 format_type: Optional[pulumi.Input[str]] = None,
                 ignore_utf8_errors: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_space: Optional[pulumi.Input[bool]] = None,
                 record_delimiter: Optional[pulumi.Input[str]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 skip_blank_lines: Optional[pulumi.Input[bool]] = None,
                 skip_byte_order_mark: Optional[pulumi.Input[bool]] = None,
                 skip_header: Optional[pulumi.Input[int]] = None,
                 strip_null_values: Optional[pulumi.Input[bool]] = None,
                 strip_outer_array: Optional[pulumi.Input[bool]] = None,
                 strip_outer_element: Optional[pulumi.Input[bool]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 trim_space: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileFormatArgs.__new__(FileFormatArgs)

            __props__.__dict__["allow_duplicate"] = allow_duplicate
            __props__.__dict__["binary_as_text"] = binary_as_text
            __props__.__dict__["binary_format"] = binary_format
            __props__.__dict__["comment"] = comment
            __props__.__dict__["compression"] = compression
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["date_format"] = date_format
            __props__.__dict__["disable_auto_convert"] = disable_auto_convert
            __props__.__dict__["disable_snowflake_data"] = disable_snowflake_data
            __props__.__dict__["empty_field_as_null"] = empty_field_as_null
            __props__.__dict__["enable_octal"] = enable_octal
            __props__.__dict__["encoding"] = encoding
            __props__.__dict__["error_on_column_count_mismatch"] = error_on_column_count_mismatch
            __props__.__dict__["escape"] = escape
            __props__.__dict__["escape_unenclosed_field"] = escape_unenclosed_field
            __props__.__dict__["field_delimiter"] = field_delimiter
            __props__.__dict__["field_optionally_enclosed_by"] = field_optionally_enclosed_by
            __props__.__dict__["file_extension"] = file_extension
            if format_type is None and not opts.urn:
                raise TypeError("Missing required property 'format_type'")
            __props__.__dict__["format_type"] = format_type
            __props__.__dict__["ignore_utf8_errors"] = ignore_utf8_errors
            __props__.__dict__["name"] = name
            __props__.__dict__["null_ifs"] = null_ifs
            __props__.__dict__["preserve_space"] = preserve_space
            __props__.__dict__["record_delimiter"] = record_delimiter
            __props__.__dict__["replace_invalid_characters"] = replace_invalid_characters
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["skip_blank_lines"] = skip_blank_lines
            __props__.__dict__["skip_byte_order_mark"] = skip_byte_order_mark
            __props__.__dict__["skip_header"] = skip_header
            __props__.__dict__["strip_null_values"] = strip_null_values
            __props__.__dict__["strip_outer_array"] = strip_outer_array
            __props__.__dict__["strip_outer_element"] = strip_outer_element
            __props__.__dict__["time_format"] = time_format
            __props__.__dict__["timestamp_format"] = timestamp_format
            __props__.__dict__["trim_space"] = trim_space
        super(FileFormat, __self__).__init__(
            'snowflake:index/fileFormat:FileFormat',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_duplicate: Optional[pulumi.Input[bool]] = None,
            binary_as_text: Optional[pulumi.Input[bool]] = None,
            binary_format: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            compression: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[str]] = None,
            date_format: Optional[pulumi.Input[str]] = None,
            disable_auto_convert: Optional[pulumi.Input[bool]] = None,
            disable_snowflake_data: Optional[pulumi.Input[bool]] = None,
            empty_field_as_null: Optional[pulumi.Input[bool]] = None,
            enable_octal: Optional[pulumi.Input[bool]] = None,
            encoding: Optional[pulumi.Input[str]] = None,
            error_on_column_count_mismatch: Optional[pulumi.Input[bool]] = None,
            escape: Optional[pulumi.Input[str]] = None,
            escape_unenclosed_field: Optional[pulumi.Input[str]] = None,
            field_delimiter: Optional[pulumi.Input[str]] = None,
            field_optionally_enclosed_by: Optional[pulumi.Input[str]] = None,
            file_extension: Optional[pulumi.Input[str]] = None,
            format_type: Optional[pulumi.Input[str]] = None,
            ignore_utf8_errors: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            null_ifs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            preserve_space: Optional[pulumi.Input[bool]] = None,
            record_delimiter: Optional[pulumi.Input[str]] = None,
            replace_invalid_characters: Optional[pulumi.Input[bool]] = None,
            schema: Optional[pulumi.Input[str]] = None,
            skip_blank_lines: Optional[pulumi.Input[bool]] = None,
            skip_byte_order_mark: Optional[pulumi.Input[bool]] = None,
            skip_header: Optional[pulumi.Input[int]] = None,
            strip_null_values: Optional[pulumi.Input[bool]] = None,
            strip_outer_array: Optional[pulumi.Input[bool]] = None,
            strip_outer_element: Optional[pulumi.Input[bool]] = None,
            time_format: Optional[pulumi.Input[str]] = None,
            timestamp_format: Optional[pulumi.Input[str]] = None,
            trim_space: Optional[pulumi.Input[bool]] = None) -> 'FileFormat':
        """
        Get an existing FileFormat resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_duplicate: Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        :param pulumi.Input[bool] binary_as_text: Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        :param pulumi.Input[str] binary_format: Defines the encoding format for binary input or output.
        :param pulumi.Input[str] comment: Specifies a comment for the file format.
        :param pulumi.Input[str] compression: Specifies the current compression algorithm for the data file.
        :param pulumi.Input[str] database: The database in which to create the file format.
        :param pulumi.Input[str] date_format: Defines the format of date values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[bool] disable_auto_convert: Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        :param pulumi.Input[bool] disable_snowflake_data: Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        :param pulumi.Input[bool] empty_field_as_null: Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        :param pulumi.Input[bool] enable_octal: Boolean that enables parsing of octal numbers.
        :param pulumi.Input[str] encoding: String (constant) that specifies the character set of the source data when loading data into a table.
        :param pulumi.Input[bool] error_on_column_count_mismatch: Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        :param pulumi.Input[str] escape: Single character string used as the escape character for field values.
        :param pulumi.Input[str] escape_unenclosed_field: Single character string used as the escape character for unenclosed field values only.
        :param pulumi.Input[str] field_delimiter: Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[str] field_optionally_enclosed_by: Character used to enclose strings.
        :param pulumi.Input[str] file_extension: Specifies the extension for files unloaded to a stage.
        :param pulumi.Input[str] format_type: Specifies the format of the input files (for data loading) or output files (for data unloading).
        :param pulumi.Input[bool] ignore_utf8_errors: Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        :param pulumi.Input[str] name: Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] null_ifs: String used to convert to and from SQL NULL.
        :param pulumi.Input[bool] preserve_space: Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        :param pulumi.Input[str] record_delimiter: Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        :param pulumi.Input[bool] replace_invalid_characters: Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        :param pulumi.Input[str] schema: The schema in which to create the file format.
        :param pulumi.Input[bool] skip_blank_lines: Boolean that specifies to skip any blank lines encountered in the data files.
        :param pulumi.Input[bool] skip_byte_order_mark: Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        :param pulumi.Input[int] skip_header: Number of lines at the start of the file to skip.
        :param pulumi.Input[bool] strip_null_values: Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        :param pulumi.Input[bool] strip_outer_array: Boolean that instructs the JSON parser to remove outer brackets.
        :param pulumi.Input[bool] strip_outer_element: Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        :param pulumi.Input[str] time_format: Defines the format of time values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[str] timestamp_format: Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        :param pulumi.Input[bool] trim_space: Boolean that specifies whether to remove white space from fields.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileFormatState.__new__(_FileFormatState)

        __props__.__dict__["allow_duplicate"] = allow_duplicate
        __props__.__dict__["binary_as_text"] = binary_as_text
        __props__.__dict__["binary_format"] = binary_format
        __props__.__dict__["comment"] = comment
        __props__.__dict__["compression"] = compression
        __props__.__dict__["database"] = database
        __props__.__dict__["date_format"] = date_format
        __props__.__dict__["disable_auto_convert"] = disable_auto_convert
        __props__.__dict__["disable_snowflake_data"] = disable_snowflake_data
        __props__.__dict__["empty_field_as_null"] = empty_field_as_null
        __props__.__dict__["enable_octal"] = enable_octal
        __props__.__dict__["encoding"] = encoding
        __props__.__dict__["error_on_column_count_mismatch"] = error_on_column_count_mismatch
        __props__.__dict__["escape"] = escape
        __props__.__dict__["escape_unenclosed_field"] = escape_unenclosed_field
        __props__.__dict__["field_delimiter"] = field_delimiter
        __props__.__dict__["field_optionally_enclosed_by"] = field_optionally_enclosed_by
        __props__.__dict__["file_extension"] = file_extension
        __props__.__dict__["format_type"] = format_type
        __props__.__dict__["ignore_utf8_errors"] = ignore_utf8_errors
        __props__.__dict__["name"] = name
        __props__.__dict__["null_ifs"] = null_ifs
        __props__.__dict__["preserve_space"] = preserve_space
        __props__.__dict__["record_delimiter"] = record_delimiter
        __props__.__dict__["replace_invalid_characters"] = replace_invalid_characters
        __props__.__dict__["schema"] = schema
        __props__.__dict__["skip_blank_lines"] = skip_blank_lines
        __props__.__dict__["skip_byte_order_mark"] = skip_byte_order_mark
        __props__.__dict__["skip_header"] = skip_header
        __props__.__dict__["strip_null_values"] = strip_null_values
        __props__.__dict__["strip_outer_array"] = strip_outer_array
        __props__.__dict__["strip_outer_element"] = strip_outer_element
        __props__.__dict__["time_format"] = time_format
        __props__.__dict__["timestamp_format"] = timestamp_format
        __props__.__dict__["trim_space"] = trim_space
        return FileFormat(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowDuplicate")
    def allow_duplicate(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
        """
        return pulumi.get(self, "allow_duplicate")

    @property
    @pulumi.getter(name="binaryAsText")
    def binary_as_text(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
        """
        return pulumi.get(self, "binary_as_text")

    @property
    @pulumi.getter(name="binaryFormat")
    def binary_format(self) -> pulumi.Output[Optional[str]]:
        """
        Defines the encoding format for binary input or output.
        """
        return pulumi.get(self, "binary_format")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a comment for the file format.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def compression(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the current compression algorithm for the data file.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        The database in which to create the file format.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> pulumi.Output[Optional[str]]:
        """
        Defines the format of date values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "date_format")

    @property
    @pulumi.getter(name="disableAutoConvert")
    def disable_auto_convert(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
        """
        return pulumi.get(self, "disable_auto_convert")

    @property
    @pulumi.getter(name="disableSnowflakeData")
    def disable_snowflake_data(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
        """
        return pulumi.get(self, "disable_snowflake_data")

    @property
    @pulumi.getter(name="emptyFieldAsNull")
    def empty_field_as_null(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
        """
        return pulumi.get(self, "empty_field_as_null")

    @property
    @pulumi.getter(name="enableOctal")
    def enable_octal(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that enables parsing of octal numbers.
        """
        return pulumi.get(self, "enable_octal")

    @property
    @pulumi.getter
    def encoding(self) -> pulumi.Output[Optional[str]]:
        """
        String (constant) that specifies the character set of the source data when loading data into a table.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="errorOnColumnCountMismatch")
    def error_on_column_count_mismatch(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
        """
        return pulumi.get(self, "error_on_column_count_mismatch")

    @property
    @pulumi.getter
    def escape(self) -> pulumi.Output[Optional[str]]:
        """
        Single character string used as the escape character for field values.
        """
        return pulumi.get(self, "escape")

    @property
    @pulumi.getter(name="escapeUnenclosedField")
    def escape_unenclosed_field(self) -> pulumi.Output[Optional[str]]:
        """
        Single character string used as the escape character for unenclosed field values only.
        """
        return pulumi.get(self, "escape_unenclosed_field")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="fieldOptionallyEnclosedBy")
    def field_optionally_enclosed_by(self) -> pulumi.Output[Optional[str]]:
        """
        Character used to enclose strings.
        """
        return pulumi.get(self, "field_optionally_enclosed_by")

    @property
    @pulumi.getter(name="fileExtension")
    def file_extension(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the extension for files unloaded to a stage.
        """
        return pulumi.get(self, "file_extension")

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> pulumi.Output[str]:
        """
        Specifies the format of the input files (for data loading) or output files (for data unloading).
        """
        return pulumi.get(self, "format_type")

    @property
    @pulumi.getter(name="ignoreUtf8Errors")
    def ignore_utf8_errors(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether UTF-8 encoding errors produce error conditions.
        """
        return pulumi.get(self, "ignore_utf8_errors")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nullIfs")
    def null_ifs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        String used to convert to and from SQL NULL.
        """
        return pulumi.get(self, "null_ifs")

    @property
    @pulumi.getter(name="preserveSpace")
    def preserve_space(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
        """
        return pulumi.get(self, "preserve_space")

    @property
    @pulumi.getter(name="recordDelimiter")
    def record_delimiter(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
        """
        return pulumi.get(self, "record_delimiter")

    @property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[str]:
        """
        The schema in which to create the file format.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="skipBlankLines")
    def skip_blank_lines(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies to skip any blank lines encountered in the data files.
        """
        return pulumi.get(self, "skip_blank_lines")

    @property
    @pulumi.getter(name="skipByteOrderMark")
    def skip_byte_order_mark(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
        """
        return pulumi.get(self, "skip_byte_order_mark")

    @property
    @pulumi.getter(name="skipHeader")
    def skip_header(self) -> pulumi.Output[Optional[int]]:
        """
        Number of lines at the start of the file to skip.
        """
        return pulumi.get(self, "skip_header")

    @property
    @pulumi.getter(name="stripNullValues")
    def strip_null_values(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
        """
        return pulumi.get(self, "strip_null_values")

    @property
    @pulumi.getter(name="stripOuterArray")
    def strip_outer_array(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that instructs the JSON parser to remove outer brackets.
        """
        return pulumi.get(self, "strip_outer_array")

    @property
    @pulumi.getter(name="stripOuterElement")
    def strip_outer_element(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
        """
        return pulumi.get(self, "strip_outer_element")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> pulumi.Output[Optional[str]]:
        """
        Defines the format of time values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> pulumi.Output[Optional[str]]:
        """
        Defines the format of timestamp values in the data files (data loading) or table (data unloading).
        """
        return pulumi.get(self, "timestamp_format")

    @property
    @pulumi.getter(name="trimSpace")
    def trim_space(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean that specifies whether to remove white space from fields.
        """
        return pulumi.get(self, "trim_space")

