# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetRowAccessPoliciesResult',
    'AwaitableGetRowAccessPoliciesResult',
    'get_row_access_policies',
    'get_row_access_policies_output',
]

@pulumi.output_type
class GetRowAccessPoliciesResult:
    """
    A collection of values returned by getRowAccessPolicies.
    """
    def __init__(__self__, database=None, id=None, row_access_policies=None, schema=None):
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if row_access_policies and not isinstance(row_access_policies, list):
            raise TypeError("Expected argument 'row_access_policies' to be a list")
        pulumi.set(__self__, "row_access_policies", row_access_policies)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="rowAccessPolicies")
    def row_access_policies(self) -> Sequence['outputs.GetRowAccessPoliciesRowAccessPolicyResult']:
        """
        The row access policy in the schema
        """
        return pulumi.get(self, "row_access_policies")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the row access policyfrom.
        """
        return pulumi.get(self, "schema")


class AwaitableGetRowAccessPoliciesResult(GetRowAccessPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRowAccessPoliciesResult(
            database=self.database,
            id=self.id,
            row_access_policies=self.row_access_policies,
            schema=self.schema)


def get_row_access_policies(database: Optional[str] = None,
                            schema: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRowAccessPoliciesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_snowflake as snowflake

    current = snowflake.get_row_access_policies(database="MYDB",
        schema="MYSCHEMA")
    ```


    :param str database: The database from which to return the schemas from.
    :param str schema: The schema from which to return the row access policyfrom.
    """
    __args__ = dict()
    __args__['database'] = database
    __args__['schema'] = schema
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('snowflake:index/getRowAccessPolicies:getRowAccessPolicies', __args__, opts=opts, typ=GetRowAccessPoliciesResult).value

    return AwaitableGetRowAccessPoliciesResult(
        database=__ret__.database,
        id=__ret__.id,
        row_access_policies=__ret__.row_access_policies,
        schema=__ret__.schema)


@_utilities.lift_output_func(get_row_access_policies)
def get_row_access_policies_output(database: Optional[pulumi.Input[str]] = None,
                                   schema: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRowAccessPoliciesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_snowflake as snowflake

    current = snowflake.get_row_access_policies(database="MYDB",
        schema="MYSCHEMA")
    ```


    :param str database: The database from which to return the schemas from.
    :param str schema: The schema from which to return the row access policyfrom.
    """
    ...
