# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'AlertAlertSchedule',
    'AlertAlertScheduleCron',
    'DatabaseReplicationConfiguration',
    'ExternalFunctionArg',
    'ExternalFunctionHeader',
    'ExternalTableColumn',
    'ExternalTableTag',
    'FailoverGroupFromReplica',
    'FailoverGroupReplicationSchedule',
    'FailoverGroupReplicationScheduleCron',
    'FunctionArgument',
    'MaskingPolicySignature',
    'MaskingPolicySignatureColumn',
    'MaterializedViewTag',
    'ObjectParameterObjectIdentifier',
    'ProcedureArgument',
    'RoleTag',
    'SchemaTag',
    'StageTag',
    'TableColumn',
    'TableColumnDefault',
    'TableColumnIdentity',
    'TableConstraintForeignKeyProperties',
    'TableConstraintForeignKeyPropertiesReferences',
    'TablePrimaryKey',
    'TableTag',
    'TagAssociationObjectIdentifier',
    'UserTag',
    'ViewTag',
    'GetAccountsAccountResult',
    'GetAlertsAlertResult',
    'GetDatabaseRolesDatabaseRoleResult',
    'GetDatabasesDatabaseResult',
    'GetDatabasesDatabaseReplicationConfigurationResult',
    'GetExternalFunctionsExternalFunctionResult',
    'GetExternalTablesExternalTableResult',
    'GetFailoverGroupsFailoverGroupResult',
    'GetFileFormatsFileFormatResult',
    'GetFunctionsFunctionResult',
    'GetGrantsFutureGrantsInResult',
    'GetGrantsFutureGrantsInSchemaResult',
    'GetGrantsFutureGrantsToResult',
    'GetGrantsGrantResult',
    'GetGrantsGrantsOfResult',
    'GetGrantsGrantsOnResult',
    'GetGrantsGrantsToResult',
    'GetMaskingPoliciesMaskingPolicyResult',
    'GetMaterializedViewsMaterializedViewResult',
    'GetParametersParameterResult',
    'GetPipesPipeResult',
    'GetProceduresProcedureResult',
    'GetResourceMonitorsResourceMonitorResult',
    'GetRolesRoleResult',
    'GetRowAccessPoliciesRowAccessPolicyResult',
    'GetSchemasSchemaResult',
    'GetSequencesSequenceResult',
    'GetSharesShareResult',
    'GetStagesStageResult',
    'GetStorageIntegrationsStorageIntegrationResult',
    'GetStreamsStreamResult',
    'GetTablesTableResult',
    'GetTasksTaskResult',
    'GetUsersUserResult',
    'GetViewsViewResult',
    'GetWarehousesWarehouseResult',
]

@pulumi.output_type
class AlertAlertSchedule(dict):
    def __init__(__self__, *,
                 cron: Optional['outputs.AlertAlertScheduleCron'] = None,
                 interval: Optional[int] = None):
        """
        :param 'AlertAlertScheduleCronArgs' cron: Specifies the cron expression for the alert. The cron expression must be in the following format: "minute hour day-of-month month day-of-week". The following values are supported: minute: 0-59 hour: 0-23 day-of-month: 1-31 month: 1-12 day-of-week: 0-6 (0 is Sunday)
        :param int interval: Specifies the interval in minutes for the alert schedule. The interval must be greater than 0 and less than 1440 (24 hours).
        """
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @property
    @pulumi.getter
    def cron(self) -> Optional['outputs.AlertAlertScheduleCron']:
        """
        Specifies the cron expression for the alert. The cron expression must be in the following format: "minute hour day-of-month month day-of-week". The following values are supported: minute: 0-59 hour: 0-23 day-of-month: 1-31 month: 1-12 day-of-week: 0-6 (0 is Sunday)
        """
        return pulumi.get(self, "cron")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Specifies the interval in minutes for the alert schedule. The interval must be greater than 0 and less than 1440 (24 hours).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class AlertAlertScheduleCron(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertAlertScheduleCron. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertAlertScheduleCron.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertAlertScheduleCron.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: str,
                 time_zone: str):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class DatabaseReplicationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreEditionCheck":
            suggest = "ignore_edition_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseReplicationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseReplicationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseReplicationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accounts: Sequence[str],
                 ignore_edition_check: Optional[bool] = None):
        pulumi.set(__self__, "accounts", accounts)
        if ignore_edition_check is not None:
            pulumi.set(__self__, "ignore_edition_check", ignore_edition_check)

    @property
    @pulumi.getter
    def accounts(self) -> Sequence[str]:
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter(name="ignoreEditionCheck")
    def ignore_edition_check(self) -> Optional[bool]:
        return pulumi.get(self, "ignore_edition_check")


@pulumi.output_type
class ExternalFunctionArg(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: Argument name
        :param str type: Argument type, e.g. VARCHAR
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Argument name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Argument type, e.g. VARCHAR
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ExternalFunctionHeader(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Header name
        :param str value: Header value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Header name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Header value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ExternalTableColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "as":
            suggest = "as_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalTableColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalTableColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalTableColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 as_: str,
                 name: str,
                 type: str):
        """
        :param str as_: String that specifies the expression for the column. When queried, the column returns results derived from this expression.
        :param str name: Column name
        :param str type: Column type, e.g. VARIANT
        """
        pulumi.set(__self__, "as_", as_)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="as")
    def as_(self) -> str:
        """
        String that specifies the expression for the column. When queried, the column returns results derived from this expression.
        """
        return pulumi.get(self, "as_")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Column name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Column type, e.g. VARIANT
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ExternalTableTag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Tag name, e.g. department.
        :param str value: Tag value, e.g. marketing_info.
        :param str database: Name of the database that the tag was created in.
        :param str schema: Name of the schema that the tag was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Tag name, e.g. department.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value, e.g. marketing_info.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the tag was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the tag was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class FailoverGroupFromReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "organizationName":
            suggest = "organization_name"
        elif key == "sourceAccountName":
            suggest = "source_account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverGroupFromReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverGroupFromReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverGroupFromReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 organization_name: str,
                 source_account_name: str):
        """
        :param str name: Identifier for the primary failover group in the source account.
        :param str organization_name: Name of your Snowflake organization.
        :param str source_account_name: Source account from which you are enabling replication and failover of the specified objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "source_account_name", source_account_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Identifier for the primary failover group in the source account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> str:
        """
        Name of your Snowflake organization.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="sourceAccountName")
    def source_account_name(self) -> str:
        """
        Source account from which you are enabling replication and failover of the specified objects.
        """
        return pulumi.get(self, "source_account_name")


@pulumi.output_type
class FailoverGroupReplicationSchedule(dict):
    def __init__(__self__, *,
                 cron: Optional['outputs.FailoverGroupReplicationScheduleCron'] = None,
                 interval: Optional[int] = None):
        """
        :param 'FailoverGroupReplicationScheduleCronArgs' cron: Specifies the cron expression for the replication schedule. The cron expression must be in the following format: "minute hour day-of-month month day-of-week". The following values are supported: minute: 0-59 hour: 0-23 day-of-month: 1-31 month: 1-12 day-of-week: 0-6 (0 is Sunday)
        :param int interval: Specifies the interval in minutes for the replication schedule. The interval must be greater than 0 and less than 1440 (24 hours).
        """
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @property
    @pulumi.getter
    def cron(self) -> Optional['outputs.FailoverGroupReplicationScheduleCron']:
        """
        Specifies the cron expression for the replication schedule. The cron expression must be in the following format: "minute hour day-of-month month day-of-week". The following values are supported: minute: 0-59 hour: 0-23 day-of-month: 1-31 month: 1-12 day-of-week: 0-6 (0 is Sunday)
        """
        return pulumi.get(self, "cron")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Specifies the interval in minutes for the replication schedule. The interval must be greater than 0 and less than 1440 (24 hours).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class FailoverGroupReplicationScheduleCron(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverGroupReplicationScheduleCron. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverGroupReplicationScheduleCron.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverGroupReplicationScheduleCron.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: str,
                 time_zone: str):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class FunctionArgument(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: The argument name
        :param str type: The argument type
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The argument name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The argument type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MaskingPolicySignature(dict):
    def __init__(__self__, *,
                 columns: Sequence['outputs.MaskingPolicySignatureColumn']):
        pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.MaskingPolicySignatureColumn']:
        return pulumi.get(self, "columns")


@pulumi.output_type
class MaskingPolicySignatureColumn(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: Specifies the identifier for the masking policy; must be unique for the database and schema in which the masking policy is created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the identifier for the masking policy; must be unique for the database and schema in which the masking policy is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class MaterializedViewTag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Tag name, e.g. department.
        :param str value: Tag value, e.g. marketing_info.
        :param str database: Name of the database that the tag was created in.
        :param str schema: Name of the schema that the tag was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Tag name, e.g. department.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value, e.g. marketing_info.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the tag was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the tag was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class ObjectParameterObjectIdentifier(dict):
    def __init__(__self__, *,
                 name: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Name of the object to set the parameter for.
        :param str database: Name of the database that the object was created in.
        :param str schema: Name of the schema that the object was created in.
        """
        pulumi.set(__self__, "name", name)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the object to set the parameter for.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the object was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the object was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class ProcedureArgument(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: The argument name
        :param str type: The argument type
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The argument name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The argument type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RoleTag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Tag name, e.g. department.
        :param str value: Tag value, e.g. marketing_info.
        :param str database: Name of the database that the tag was created in.
        :param str schema: Name of the schema that the tag was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Tag name, e.g. department.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value, e.g. marketing_info.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the tag was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the tag was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class SchemaTag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Tag name, e.g. department.
        :param str value: Tag value, e.g. marketing_info.
        :param str database: Name of the database that the tag was created in.
        :param str schema: Name of the schema that the tag was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Tag name, e.g. department.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value, e.g. marketing_info.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the tag was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the tag was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class StageTag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Tag name, e.g. department.
        :param str value: Tag value, e.g. marketing_info.
        :param str database: Name of the database that the tag was created in.
        :param str schema: Name of the schema that the tag was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Tag name, e.g. department.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value, e.g. marketing_info.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the tag was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the tag was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class TableColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maskingPolicy":
            suggest = "masking_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 comment: Optional[str] = None,
                 default: Optional['outputs.TableColumnDefault'] = None,
                 identity: Optional['outputs.TableColumnIdentity'] = None,
                 masking_policy: Optional[str] = None,
                 nullable: Optional[bool] = None):
        """
        :param str name: Column name
        :param str type: Column type, e.g. VARIANT
        :param str comment: Column comment
        :param 'TableColumnDefaultArgs' default: Defines the column default value; note due to limitations of Snowflake's ALTER TABLE ADD/MODIFY COLUMN updates to default will not be applied
        :param 'TableColumnIdentityArgs' identity: Defines the identity start/step values for a column. **Note** Identity/default are mutually exclusive.
        :param str masking_policy: Masking policy to apply on column
        :param bool nullable: Whether this column can contain null values. **Note**: Depending on your Snowflake version, the default value will not suffice if this column is used in a primary key constraint.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if masking_policy is not None:
            pulumi.set(__self__, "masking_policy", masking_policy)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Column name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Column type, e.g. VARIANT
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Column comment
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def default(self) -> Optional['outputs.TableColumnDefault']:
        """
        Defines the column default value; note due to limitations of Snowflake's ALTER TABLE ADD/MODIFY COLUMN updates to default will not be applied
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.TableColumnIdentity']:
        """
        Defines the identity start/step values for a column. **Note** Identity/default are mutually exclusive.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="maskingPolicy")
    def masking_policy(self) -> Optional[str]:
        """
        Masking policy to apply on column
        """
        return pulumi.get(self, "masking_policy")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        Whether this column can contain null values. **Note**: Depending on your Snowflake version, the default value will not suffice if this column is used in a primary key constraint.
        """
        return pulumi.get(self, "nullable")


@pulumi.output_type
class TableColumnDefault(dict):
    def __init__(__self__, *,
                 constant: Optional[str] = None,
                 expression: Optional[str] = None,
                 sequence: Optional[str] = None):
        if constant is not None:
            pulumi.set(__self__, "constant", constant)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if sequence is not None:
            pulumi.set(__self__, "sequence", sequence)

    @property
    @pulumi.getter
    def constant(self) -> Optional[str]:
        return pulumi.get(self, "constant")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def sequence(self) -> Optional[str]:
        return pulumi.get(self, "sequence")


@pulumi.output_type
class TableColumnIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startNum":
            suggest = "start_num"
        elif key == "stepNum":
            suggest = "step_num"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableColumnIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableColumnIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableColumnIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_num: Optional[int] = None,
                 step_num: Optional[int] = None):
        if start_num is not None:
            pulumi.set(__self__, "start_num", start_num)
        if step_num is not None:
            pulumi.set(__self__, "step_num", step_num)

    @property
    @pulumi.getter(name="startNum")
    def start_num(self) -> Optional[int]:
        return pulumi.get(self, "start_num")

    @property
    @pulumi.getter(name="stepNum")
    def step_num(self) -> Optional[int]:
        return pulumi.get(self, "step_num")


@pulumi.output_type
class TableConstraintForeignKeyProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDelete":
            suggest = "on_delete"
        elif key == "onUpdate":
            suggest = "on_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableConstraintForeignKeyProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableConstraintForeignKeyProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableConstraintForeignKeyProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match: Optional[str] = None,
                 on_delete: Optional[str] = None,
                 on_update: Optional[str] = None,
                 references: Optional['outputs.TableConstraintForeignKeyPropertiesReferences'] = None):
        """
        :param str match: The match type for the foreign key. Not applicable for primary/unique keys
        :param str on_delete: Specifies the action performed when the primary/unique key for the foreign key is deleted. Not applicable for primary/unique keys
        :param str on_update: Specifies the action performed when the primary/unique key for the foreign key is updated. Not applicable for primary/unique keys
        :param 'TableConstraintForeignKeyPropertiesReferencesArgs' references: The table and columns that the foreign key references. Not applicable for primary/unique keys
        """
        if match is not None:
            pulumi.set(__self__, "match", match)
        if on_delete is not None:
            pulumi.set(__self__, "on_delete", on_delete)
        if on_update is not None:
            pulumi.set(__self__, "on_update", on_update)
        if references is not None:
            pulumi.set(__self__, "references", references)

    @property
    @pulumi.getter
    def match(self) -> Optional[str]:
        """
        The match type for the foreign key. Not applicable for primary/unique keys
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="onDelete")
    def on_delete(self) -> Optional[str]:
        """
        Specifies the action performed when the primary/unique key for the foreign key is deleted. Not applicable for primary/unique keys
        """
        return pulumi.get(self, "on_delete")

    @property
    @pulumi.getter(name="onUpdate")
    def on_update(self) -> Optional[str]:
        """
        Specifies the action performed when the primary/unique key for the foreign key is updated. Not applicable for primary/unique keys
        """
        return pulumi.get(self, "on_update")

    @property
    @pulumi.getter
    def references(self) -> Optional['outputs.TableConstraintForeignKeyPropertiesReferences']:
        """
        The table and columns that the foreign key references. Not applicable for primary/unique keys
        """
        return pulumi.get(self, "references")


@pulumi.output_type
class TableConstraintForeignKeyPropertiesReferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableConstraintForeignKeyPropertiesReferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableConstraintForeignKeyPropertiesReferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableConstraintForeignKeyPropertiesReferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Sequence[str],
                 table_id: str):
        """
        :param Sequence[str] columns: Columns to use in constraint key
        :param str table_id: Idenfifier for table to create constraint on. Must be of the form Note: format must follow: "\\n\\n"."\\n\\n"."\\n\\n" or "\\n\\n.\\n\\n.\\n\\n" or "\\n\\n|\\n\\n.\\n\\n" (snowflake*table.my*table.id)
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter
    def columns(self) -> Sequence[str]:
        """
        Columns to use in constraint key
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        Idenfifier for table to create constraint on. Must be of the form Note: format must follow: "\\n\\n"."\\n\\n"."\\n\\n" or "\\n\\n.\\n\\n.\\n\\n" or "\\n\\n|\\n\\n.\\n\\n" (snowflake*table.my*table.id)
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class TablePrimaryKey(dict):
    def __init__(__self__, *,
                 keys: Sequence[str],
                 name: Optional[str] = None):
        """
        :param Sequence[str] keys: Columns to use in primary key
        :param str name: Name of constraint
        """
        pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        Columns to use in primary key
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of constraint
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TableTag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Tag name, e.g. department.
        :param str value: Tag value, e.g. marketing_info.
        :param str database: Name of the database that the tag was created in.
        :param str schema: Name of the schema that the tag was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Tag name, e.g. department.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value, e.g. marketing_info.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the tag was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the tag was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class TagAssociationObjectIdentifier(dict):
    def __init__(__self__, *,
                 name: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Name of the object to associate the tag with.
        :param str database: Name of the database that the object was created in.
        :param str schema: Name of the schema that the object was created in.
        """
        pulumi.set(__self__, "name", name)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the object to associate the tag with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the object was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the object was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class UserTag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Tag name, e.g. department.
        :param str value: Tag value, e.g. marketing_info.
        :param str database: Name of the database that the tag was created in.
        :param str schema: Name of the schema that the tag was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Tag name, e.g. department.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value, e.g. marketing_info.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the tag was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the tag was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class ViewTag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 database: Optional[str] = None,
                 schema: Optional[str] = None):
        """
        :param str name: Tag name, e.g. department.
        :param str value: Tag value, e.g. marketing_info.
        :param str database: Name of the database that the tag was created in.
        :param str schema: Name of the schema that the tag was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Tag name, e.g. department.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value, e.g. marketing_info.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Name of the database that the tag was created in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Name of the schema that the tag was created in.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_locator: str,
                 account_locator_url: str,
                 account_name: str,
                 account_url: str,
                 comment: str,
                 consumption_billing_entity_name: str,
                 created_on: str,
                 edition: str,
                 is_org_admin: bool,
                 managed_accounts: int,
                 marketplace_consumer_billing_entity_name: str,
                 marketplace_provider_billing_entity_name: str,
                 old_account_url: str,
                 organization_name: str,
                 region_group: str,
                 snowflake_region: str):
        pulumi.set(__self__, "account_locator", account_locator)
        pulumi.set(__self__, "account_locator_url", account_locator_url)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_url", account_url)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "consumption_billing_entity_name", consumption_billing_entity_name)
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "is_org_admin", is_org_admin)
        pulumi.set(__self__, "managed_accounts", managed_accounts)
        pulumi.set(__self__, "marketplace_consumer_billing_entity_name", marketplace_consumer_billing_entity_name)
        pulumi.set(__self__, "marketplace_provider_billing_entity_name", marketplace_provider_billing_entity_name)
        pulumi.set(__self__, "old_account_url", old_account_url)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "region_group", region_group)
        pulumi.set(__self__, "snowflake_region", snowflake_region)

    @property
    @pulumi.getter(name="accountLocator")
    def account_locator(self) -> str:
        return pulumi.get(self, "account_locator")

    @property
    @pulumi.getter(name="accountLocatorUrl")
    def account_locator_url(self) -> str:
        return pulumi.get(self, "account_locator_url")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountUrl")
    def account_url(self) -> str:
        return pulumi.get(self, "account_url")

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="consumptionBillingEntityName")
    def consumption_billing_entity_name(self) -> str:
        return pulumi.get(self, "consumption_billing_entity_name")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def edition(self) -> str:
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="isOrgAdmin")
    def is_org_admin(self) -> bool:
        return pulumi.get(self, "is_org_admin")

    @property
    @pulumi.getter(name="managedAccounts")
    def managed_accounts(self) -> int:
        return pulumi.get(self, "managed_accounts")

    @property
    @pulumi.getter(name="marketplaceConsumerBillingEntityName")
    def marketplace_consumer_billing_entity_name(self) -> str:
        return pulumi.get(self, "marketplace_consumer_billing_entity_name")

    @property
    @pulumi.getter(name="marketplaceProviderBillingEntityName")
    def marketplace_provider_billing_entity_name(self) -> str:
        return pulumi.get(self, "marketplace_provider_billing_entity_name")

    @property
    @pulumi.getter(name="oldAccountUrl")
    def old_account_url(self) -> str:
        return pulumi.get(self, "old_account_url")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> str:
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="regionGroup")
    def region_group(self) -> str:
        return pulumi.get(self, "region_group")

    @property
    @pulumi.getter(name="snowflakeRegion")
    def snowflake_region(self) -> str:
        return pulumi.get(self, "snowflake_region")


@pulumi.output_type
class GetAlertsAlertResult(dict):
    def __init__(__self__, *,
                 action: str,
                 comment: str,
                 condition: str,
                 database_name: str,
                 name: str,
                 owner: str,
                 schema_name: str):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def condition(self) -> str:
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        return pulumi.get(self, "schema_name")


@pulumi.output_type
class GetDatabaseRolesDatabaseRoleResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 name: str,
                 owner: str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")


@pulumi.output_type
class GetDatabasesDatabaseResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 created_on: str,
                 is_current: bool,
                 is_default: bool,
                 name: str,
                 options: str,
                 origin: str,
                 owner: str,
                 replication_configurations: Sequence['outputs.GetDatabasesDatabaseReplicationConfigurationResult'],
                 retention_time: int):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_current", is_current)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "replication_configurations", replication_configurations)
        pulumi.set(__self__, "retention_time", retention_time)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isCurrent")
    def is_current(self) -> bool:
        return pulumi.get(self, "is_current")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> str:
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def origin(self) -> str:
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="replicationConfigurations")
    def replication_configurations(self) -> Sequence['outputs.GetDatabasesDatabaseReplicationConfigurationResult']:
        return pulumi.get(self, "replication_configurations")

    @property
    @pulumi.getter(name="retentionTime")
    def retention_time(self) -> int:
        return pulumi.get(self, "retention_time")


@pulumi.output_type
class GetDatabasesDatabaseReplicationConfigurationResult(dict):
    def __init__(__self__, *,
                 accounts: Sequence[str],
                 ignore_edition_check: bool):
        pulumi.set(__self__, "accounts", accounts)
        pulumi.set(__self__, "ignore_edition_check", ignore_edition_check)

    @property
    @pulumi.getter
    def accounts(self) -> Sequence[str]:
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter(name="ignoreEditionCheck")
    def ignore_edition_check(self) -> bool:
        return pulumi.get(self, "ignore_edition_check")


@pulumi.output_type
class GetExternalFunctionsExternalFunctionResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 language: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the external functions from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def language(self) -> str:
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the external functions from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetExternalTablesExternalTableResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the external tables from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the external tables from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetFailoverGroupsFailoverGroupResult(dict):
    def __init__(__self__, *,
                 account_locator: str,
                 account_name: str,
                 allowed_accounts: Sequence[Any],
                 allowed_integration_types: Sequence[Any],
                 comment: str,
                 created_on: str,
                 is_primary: bool,
                 next_scheduled_refresh: str,
                 object_types: Sequence[Any],
                 organization_name: str,
                 owner: str,
                 primary: str,
                 region_group: str,
                 replication_schedule: str,
                 secondary_state: str,
                 snowflake_region: str,
                 type: str):
        pulumi.set(__self__, "account_locator", account_locator)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "allowed_accounts", allowed_accounts)
        pulumi.set(__self__, "allowed_integration_types", allowed_integration_types)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "next_scheduled_refresh", next_scheduled_refresh)
        pulumi.set(__self__, "object_types", object_types)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "region_group", region_group)
        pulumi.set(__self__, "replication_schedule", replication_schedule)
        pulumi.set(__self__, "secondary_state", secondary_state)
        pulumi.set(__self__, "snowflake_region", snowflake_region)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountLocator")
    def account_locator(self) -> str:
        return pulumi.get(self, "account_locator")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="allowedAccounts")
    def allowed_accounts(self) -> Sequence[Any]:
        return pulumi.get(self, "allowed_accounts")

    @property
    @pulumi.getter(name="allowedIntegrationTypes")
    def allowed_integration_types(self) -> Sequence[Any]:
        return pulumi.get(self, "allowed_integration_types")

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="nextScheduledRefresh")
    def next_scheduled_refresh(self) -> str:
        return pulumi.get(self, "next_scheduled_refresh")

    @property
    @pulumi.getter(name="objectTypes")
    def object_types(self) -> Sequence[Any]:
        return pulumi.get(self, "object_types")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> str:
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def primary(self) -> str:
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="regionGroup")
    def region_group(self) -> str:
        return pulumi.get(self, "region_group")

    @property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> str:
        return pulumi.get(self, "replication_schedule")

    @property
    @pulumi.getter(name="secondaryState")
    def secondary_state(self) -> str:
        return pulumi.get(self, "secondary_state")

    @property
    @pulumi.getter(name="snowflakeRegion")
    def snowflake_region(self) -> str:
        return pulumi.get(self, "snowflake_region")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFileFormatsFileFormatResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 format_type: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the file formats from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "format_type", format_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> str:
        return pulumi.get(self, "format_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the file formats from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetFunctionsFunctionResult(dict):
    def __init__(__self__, *,
                 argument_types: Sequence[str],
                 comment: str,
                 database: str,
                 name: str,
                 return_type: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the functions from.
        """
        pulumi.set(__self__, "argument_types", argument_types)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "return_type", return_type)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="argumentTypes")
    def argument_types(self) -> Sequence[str]:
        return pulumi.get(self, "argument_types")

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> str:
        return pulumi.get(self, "return_type")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the functions from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetGrantsFutureGrantsInResult(dict):
    def __init__(__self__, *,
                 database: Optional[str] = None,
                 schema: Optional['outputs.GetGrantsFutureGrantsInSchemaResult'] = None):
        """
        :param str database: Lists all privileges on new (i.e. future) objects of a specified type in the database granted to a role.
        :param 'GetGrantsFutureGrantsInSchemaArgs' schema: Lists all privileges on new (i.e. future) objects of a specified type in the schema granted to a role.
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        Lists all privileges on new (i.e. future) objects of a specified type in the database granted to a role.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def schema(self) -> Optional['outputs.GetGrantsFutureGrantsInSchemaResult']:
        """
        Lists all privileges on new (i.e. future) objects of a specified type in the schema granted to a role.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetGrantsFutureGrantsInSchemaResult(dict):
    def __init__(__self__, *,
                 schema_name: str,
                 database_name: Optional[str] = None):
        pulumi.set(__self__, "schema_name", schema_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        return pulumi.get(self, "database_name")


@pulumi.output_type
class GetGrantsFutureGrantsToResult(dict):
    def __init__(__self__, *,
                 role: str):
        """
        :param str role: Lists all privileges on new (i.e. future) objects of a specified type in a database or schema granted to the role.
        """
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Lists all privileges on new (i.e. future) objects of a specified type in a database or schema granted to the role.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetGrantsGrantResult(dict):
    def __init__(__self__, *,
                 created_on: str,
                 grant_option: bool,
                 granted_by: str,
                 granted_on: str,
                 granted_to: str,
                 grantee_name: str,
                 name: str,
                 privilege: str):
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "grant_option", grant_option)
        pulumi.set(__self__, "granted_by", granted_by)
        pulumi.set(__self__, "granted_on", granted_on)
        pulumi.set(__self__, "granted_to", granted_to)
        pulumi.set(__self__, "grantee_name", grantee_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "privilege", privilege)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="grantOption")
    def grant_option(self) -> bool:
        return pulumi.get(self, "grant_option")

    @property
    @pulumi.getter(name="grantedBy")
    def granted_by(self) -> str:
        return pulumi.get(self, "granted_by")

    @property
    @pulumi.getter(name="grantedOn")
    def granted_on(self) -> str:
        return pulumi.get(self, "granted_on")

    @property
    @pulumi.getter(name="grantedTo")
    def granted_to(self) -> str:
        return pulumi.get(self, "granted_to")

    @property
    @pulumi.getter(name="granteeName")
    def grantee_name(self) -> str:
        return pulumi.get(self, "grantee_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def privilege(self) -> str:
        return pulumi.get(self, "privilege")


@pulumi.output_type
class GetGrantsGrantsOfResult(dict):
    def __init__(__self__, *,
                 role: Optional[str] = None,
                 share: Optional[str] = None):
        """
        :param str role: Lists all users and roles to which the role has been granted
        :param str share: Lists all the accounts for the share and indicates the accounts that are using the share.
        """
        if role is not None:
            pulumi.set(__self__, "role", role)
        if share is not None:
            pulumi.set(__self__, "share", share)

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Lists all users and roles to which the role has been granted
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def share(self) -> Optional[str]:
        """
        Lists all the accounts for the share and indicates the accounts that are using the share.
        """
        return pulumi.get(self, "share")


@pulumi.output_type
class GetGrantsGrantsOnResult(dict):
    def __init__(__self__, *,
                 account: Optional[bool] = None,
                 object_name: Optional[str] = None,
                 object_type: Optional[str] = None):
        """
        :param bool account: Object hierarchy to list privileges on. The only valid value is: ACCOUNT. Setting this attribute lists all the account-level (i.e. global) privileges that have been granted to roles.
        :param str object_name: Name of object to list privileges on
        :param str object_type: Type of object to list privileges on.
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if object_name is not None:
            pulumi.set(__self__, "object_name", object_name)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)

    @property
    @pulumi.getter
    def account(self) -> Optional[bool]:
        """
        Object hierarchy to list privileges on. The only valid value is: ACCOUNT. Setting this attribute lists all the account-level (i.e. global) privileges that have been granted to roles.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> Optional[str]:
        """
        Name of object to list privileges on
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[str]:
        """
        Type of object to list privileges on.
        """
        return pulumi.get(self, "object_type")


@pulumi.output_type
class GetGrantsGrantsToResult(dict):
    def __init__(__self__, *,
                 role: Optional[str] = None,
                 share: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str role: Lists all privileges and roles granted to the role
        :param str share: Lists all the privileges granted to the share
        :param str user: Lists all the roles granted to the user. Note that the PUBLIC role, which is automatically available to every user, is not listed
        """
        if role is not None:
            pulumi.set(__self__, "role", role)
        if share is not None:
            pulumi.set(__self__, "share", share)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Lists all privileges and roles granted to the role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def share(self) -> Optional[str]:
        """
        Lists all the privileges granted to the share
        """
        return pulumi.get(self, "share")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Lists all the roles granted to the user. Note that the PUBLIC role, which is automatically available to every user, is not listed
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetMaskingPoliciesMaskingPolicyResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 kind: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the maskingPolicies from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the maskingPolicies from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetMaterializedViewsMaterializedViewResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the views from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the views from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetParametersParameterResult(dict):
    def __init__(__self__, *,
                 default: str,
                 description: str,
                 key: str,
                 level: str,
                 type: str,
                 value: str):
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def default(self) -> str:
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def level(self) -> str:
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetPipesPipeResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 integration: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the pipes from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "integration", integration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def integration(self) -> str:
        return pulumi.get(self, "integration")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the pipes from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetProceduresProcedureResult(dict):
    def __init__(__self__, *,
                 argument_types: Sequence[str],
                 comment: str,
                 database: str,
                 name: str,
                 return_type: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the procedures from.
        """
        pulumi.set(__self__, "argument_types", argument_types)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "return_type", return_type)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="argumentTypes")
    def argument_types(self) -> Sequence[str]:
        return pulumi.get(self, "argument_types")

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> str:
        return pulumi.get(self, "return_type")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the procedures from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetResourceMonitorsResourceMonitorResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 credit_quota: str,
                 frequency: str,
                 name: str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "credit_quota", credit_quota)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="creditQuota")
    def credit_quota(self) -> str:
        return pulumi.get(self, "credit_quota")

    @property
    @pulumi.getter
    def frequency(self) -> str:
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetRolesRoleResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 name: str,
                 owner: str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")


@pulumi.output_type
class GetRowAccessPoliciesRowAccessPolicyResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the row access policyfrom.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the row access policyfrom.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetSchemasSchemaResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str):
        """
        :param str database: The database from which to return the schemas from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSequencesSequenceResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the sequences from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the sequences from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetSharesShareResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 kind: str,
                 name: str,
                 owner: str,
                 tos: Sequence[Any]):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "tos", tos)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def tos(self) -> Sequence[Any]:
        return pulumi.get(self, "tos")


@pulumi.output_type
class GetStagesStageResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str,
                 storage_integration: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the stages from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "storage_integration", storage_integration)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the stages from.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="storageIntegration")
    def storage_integration(self) -> str:
        return pulumi.get(self, "storage_integration")


@pulumi.output_type
class GetStorageIntegrationsStorageIntegrationResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 enabled: bool,
                 name: str,
                 type: str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetStreamsStreamResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str,
                 table: str):
        """
        :param str database: The database from which to return the streams from.
        :param str schema: The schema from which to return the streams from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the streams from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the streams from.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def table(self) -> str:
        return pulumi.get(self, "table")


@pulumi.output_type
class GetTablesTableResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the tables from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the tables from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetTasksTaskResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str,
                 warehouse: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the tasks from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "warehouse", warehouse)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the tasks from.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def warehouse(self) -> str:
        return pulumi.get(self, "warehouse")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 default_namespace: str,
                 default_role: str,
                 default_secondary_roles: Sequence[str],
                 default_warehouse: str,
                 disabled: bool,
                 display_name: str,
                 email: str,
                 first_name: str,
                 has_rsa_public_key: bool,
                 last_name: str,
                 login_name: str,
                 name: str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "default_namespace", default_namespace)
        pulumi.set(__self__, "default_role", default_role)
        pulumi.set(__self__, "default_secondary_roles", default_secondary_roles)
        pulumi.set(__self__, "default_warehouse", default_warehouse)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "has_rsa_public_key", has_rsa_public_key)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "login_name", login_name)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="defaultNamespace")
    def default_namespace(self) -> str:
        return pulumi.get(self, "default_namespace")

    @property
    @pulumi.getter(name="defaultRole")
    def default_role(self) -> str:
        return pulumi.get(self, "default_role")

    @property
    @pulumi.getter(name="defaultSecondaryRoles")
    def default_secondary_roles(self) -> Sequence[str]:
        return pulumi.get(self, "default_secondary_roles")

    @property
    @pulumi.getter(name="defaultWarehouse")
    def default_warehouse(self) -> str:
        return pulumi.get(self, "default_warehouse")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="hasRsaPublicKey")
    def has_rsa_public_key(self) -> bool:
        return pulumi.get(self, "has_rsa_public_key")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> str:
        return pulumi.get(self, "login_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetViewsViewResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 database: str,
                 name: str,
                 schema: str):
        """
        :param str database: The database from which to return the schemas from.
        :param str schema: The schema from which to return the views from.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        The database from which to return the schemas from.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The schema from which to return the views from.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetWarehousesWarehouseResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 name: str,
                 scaling_policy: str,
                 size: str,
                 state: str,
                 type: str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scaling_policy", scaling_policy)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> str:
        return pulumi.get(self, "scaling_policy")

    @property
    @pulumi.getter
    def size(self) -> str:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


