# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PasswordPolicyArgs', 'PasswordPolicy']

@pulumi.input_type
class PasswordPolicyArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[str],
                 schema: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 if_not_exists: Optional[pulumi.Input[bool]] = None,
                 lockout_time_mins: Optional[pulumi.Input[int]] = None,
                 max_age_days: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_lower_case_chars: Optional[pulumi.Input[int]] = None,
                 min_numeric_chars: Optional[pulumi.Input[int]] = None,
                 min_special_chars: Optional[pulumi.Input[int]] = None,
                 min_upper_case_chars: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 or_replace: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a PasswordPolicy resource.
        :param pulumi.Input[str] database: The database this password policy belongs to.
        :param pulumi.Input[str] schema: The schema this password policy belongs to.
        :param pulumi.Input[str] comment: Adds a comment or overwrites an existing comment for the password policy.
        :param pulumi.Input[bool] if_not_exists: Prevent overwriting a previous password policy with the same name.
        :param pulumi.Input[int] lockout_time_mins: Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        :param pulumi.Input[int] max_age_days: Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        :param pulumi.Input[int] max_length: Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        :param pulumi.Input[int] max_retries: Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        :param pulumi.Input[int] min_length: Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        :param pulumi.Input[int] min_lower_case_chars: Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_numeric_chars: Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_special_chars: Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_upper_case_chars: Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[str] name: Identifier for the password policy; must be unique for your account.
        :param pulumi.Input[bool] or_replace: Whether to override a previous password policy with the same name.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if if_not_exists is not None:
            pulumi.set(__self__, "if_not_exists", if_not_exists)
        if lockout_time_mins is not None:
            pulumi.set(__self__, "lockout_time_mins", lockout_time_mins)
        if max_age_days is not None:
            pulumi.set(__self__, "max_age_days", max_age_days)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_lower_case_chars is not None:
            pulumi.set(__self__, "min_lower_case_chars", min_lower_case_chars)
        if min_numeric_chars is not None:
            pulumi.set(__self__, "min_numeric_chars", min_numeric_chars)
        if min_special_chars is not None:
            pulumi.set(__self__, "min_special_chars", min_special_chars)
        if min_upper_case_chars is not None:
            pulumi.set(__self__, "min_upper_case_chars", min_upper_case_chars)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if or_replace is not None:
            pulumi.set(__self__, "or_replace", or_replace)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The database this password policy belongs to.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[str]:
        """
        The schema this password policy belongs to.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Adds a comment or overwrites an existing comment for the password policy.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="ifNotExists")
    def if_not_exists(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent overwriting a previous password policy with the same name.
        """
        return pulumi.get(self, "if_not_exists")

    @if_not_exists.setter
    def if_not_exists(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "if_not_exists", value)

    @property
    @pulumi.getter(name="lockoutTimeMins")
    def lockout_time_mins(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        """
        return pulumi.get(self, "lockout_time_mins")

    @lockout_time_mins.setter
    def lockout_time_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lockout_time_mins", value)

    @property
    @pulumi.getter(name="maxAgeDays")
    def max_age_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        """
        return pulumi.get(self, "max_age_days")

    @max_age_days.setter
    def max_age_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_days", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_length", value)

    @property
    @pulumi.getter(name="minLowerCaseChars")
    def min_lower_case_chars(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_lower_case_chars")

    @min_lower_case_chars.setter
    def min_lower_case_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_lower_case_chars", value)

    @property
    @pulumi.getter(name="minNumericChars")
    def min_numeric_chars(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_numeric_chars")

    @min_numeric_chars.setter
    def min_numeric_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_numeric_chars", value)

    @property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_special_chars")

    @min_special_chars.setter
    def min_special_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_special_chars", value)

    @property
    @pulumi.getter(name="minUpperCaseChars")
    def min_upper_case_chars(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_upper_case_chars")

    @min_upper_case_chars.setter
    def min_upper_case_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_upper_case_chars", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the password policy; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to override a previous password policy with the same name.
        """
        return pulumi.get(self, "or_replace")

    @or_replace.setter
    def or_replace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "or_replace", value)


@pulumi.input_type
class _PasswordPolicyState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 if_not_exists: Optional[pulumi.Input[bool]] = None,
                 lockout_time_mins: Optional[pulumi.Input[int]] = None,
                 max_age_days: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_lower_case_chars: Optional[pulumi.Input[int]] = None,
                 min_numeric_chars: Optional[pulumi.Input[int]] = None,
                 min_special_chars: Optional[pulumi.Input[int]] = None,
                 min_upper_case_chars: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 or_replace: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PasswordPolicy resources.
        :param pulumi.Input[str] comment: Adds a comment or overwrites an existing comment for the password policy.
        :param pulumi.Input[str] database: The database this password policy belongs to.
        :param pulumi.Input[bool] if_not_exists: Prevent overwriting a previous password policy with the same name.
        :param pulumi.Input[int] lockout_time_mins: Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        :param pulumi.Input[int] max_age_days: Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        :param pulumi.Input[int] max_length: Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        :param pulumi.Input[int] max_retries: Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        :param pulumi.Input[int] min_length: Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        :param pulumi.Input[int] min_lower_case_chars: Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_numeric_chars: Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_special_chars: Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_upper_case_chars: Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[str] name: Identifier for the password policy; must be unique for your account.
        :param pulumi.Input[bool] or_replace: Whether to override a previous password policy with the same name.
        :param pulumi.Input[str] schema: The schema this password policy belongs to.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if if_not_exists is not None:
            pulumi.set(__self__, "if_not_exists", if_not_exists)
        if lockout_time_mins is not None:
            pulumi.set(__self__, "lockout_time_mins", lockout_time_mins)
        if max_age_days is not None:
            pulumi.set(__self__, "max_age_days", max_age_days)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_lower_case_chars is not None:
            pulumi.set(__self__, "min_lower_case_chars", min_lower_case_chars)
        if min_numeric_chars is not None:
            pulumi.set(__self__, "min_numeric_chars", min_numeric_chars)
        if min_special_chars is not None:
            pulumi.set(__self__, "min_special_chars", min_special_chars)
        if min_upper_case_chars is not None:
            pulumi.set(__self__, "min_upper_case_chars", min_upper_case_chars)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if or_replace is not None:
            pulumi.set(__self__, "or_replace", or_replace)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Adds a comment or overwrites an existing comment for the password policy.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The database this password policy belongs to.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="ifNotExists")
    def if_not_exists(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent overwriting a previous password policy with the same name.
        """
        return pulumi.get(self, "if_not_exists")

    @if_not_exists.setter
    def if_not_exists(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "if_not_exists", value)

    @property
    @pulumi.getter(name="lockoutTimeMins")
    def lockout_time_mins(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        """
        return pulumi.get(self, "lockout_time_mins")

    @lockout_time_mins.setter
    def lockout_time_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lockout_time_mins", value)

    @property
    @pulumi.getter(name="maxAgeDays")
    def max_age_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        """
        return pulumi.get(self, "max_age_days")

    @max_age_days.setter
    def max_age_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_days", value)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_length", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_length", value)

    @property
    @pulumi.getter(name="minLowerCaseChars")
    def min_lower_case_chars(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_lower_case_chars")

    @min_lower_case_chars.setter
    def min_lower_case_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_lower_case_chars", value)

    @property
    @pulumi.getter(name="minNumericChars")
    def min_numeric_chars(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_numeric_chars")

    @min_numeric_chars.setter
    def min_numeric_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_numeric_chars", value)

    @property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_special_chars")

    @min_special_chars.setter
    def min_special_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_special_chars", value)

    @property
    @pulumi.getter(name="minUpperCaseChars")
    def min_upper_case_chars(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_upper_case_chars")

    @min_upper_case_chars.setter
    def min_upper_case_chars(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_upper_case_chars", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the password policy; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to override a previous password policy with the same name.
        """
        return pulumi.get(self, "or_replace")

    @or_replace.setter
    def or_replace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "or_replace", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        The schema this password policy belongs to.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)


class PasswordPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 if_not_exists: Optional[pulumi.Input[bool]] = None,
                 lockout_time_mins: Optional[pulumi.Input[int]] = None,
                 max_age_days: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_lower_case_chars: Optional[pulumi.Input[int]] = None,
                 min_numeric_chars: Optional[pulumi.Input[int]] = None,
                 min_special_chars: Optional[pulumi.Input[int]] = None,
                 min_upper_case_chars: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 or_replace: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A password policy specifies the requirements that must be met to create and reset a password to authenticate to Snowflake.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: Adds a comment or overwrites an existing comment for the password policy.
        :param pulumi.Input[str] database: The database this password policy belongs to.
        :param pulumi.Input[bool] if_not_exists: Prevent overwriting a previous password policy with the same name.
        :param pulumi.Input[int] lockout_time_mins: Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        :param pulumi.Input[int] max_age_days: Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        :param pulumi.Input[int] max_length: Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        :param pulumi.Input[int] max_retries: Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        :param pulumi.Input[int] min_length: Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        :param pulumi.Input[int] min_lower_case_chars: Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_numeric_chars: Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_special_chars: Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_upper_case_chars: Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[str] name: Identifier for the password policy; must be unique for your account.
        :param pulumi.Input[bool] or_replace: Whether to override a previous password policy with the same name.
        :param pulumi.Input[str] schema: The schema this password policy belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PasswordPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A password policy specifies the requirements that must be met to create and reset a password to authenticate to Snowflake.

        :param str resource_name: The name of the resource.
        :param PasswordPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PasswordPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 if_not_exists: Optional[pulumi.Input[bool]] = None,
                 lockout_time_mins: Optional[pulumi.Input[int]] = None,
                 max_age_days: Optional[pulumi.Input[int]] = None,
                 max_length: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 min_length: Optional[pulumi.Input[int]] = None,
                 min_lower_case_chars: Optional[pulumi.Input[int]] = None,
                 min_numeric_chars: Optional[pulumi.Input[int]] = None,
                 min_special_chars: Optional[pulumi.Input[int]] = None,
                 min_upper_case_chars: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 or_replace: Optional[pulumi.Input[bool]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PasswordPolicyArgs.__new__(PasswordPolicyArgs)

            __props__.__dict__["comment"] = comment
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["if_not_exists"] = if_not_exists
            __props__.__dict__["lockout_time_mins"] = lockout_time_mins
            __props__.__dict__["max_age_days"] = max_age_days
            __props__.__dict__["max_length"] = max_length
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["min_length"] = min_length
            __props__.__dict__["min_lower_case_chars"] = min_lower_case_chars
            __props__.__dict__["min_numeric_chars"] = min_numeric_chars
            __props__.__dict__["min_special_chars"] = min_special_chars
            __props__.__dict__["min_upper_case_chars"] = min_upper_case_chars
            __props__.__dict__["name"] = name
            __props__.__dict__["or_replace"] = or_replace
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
        super(PasswordPolicy, __self__).__init__(
            'snowflake:index/passwordPolicy:PasswordPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[str]] = None,
            if_not_exists: Optional[pulumi.Input[bool]] = None,
            lockout_time_mins: Optional[pulumi.Input[int]] = None,
            max_age_days: Optional[pulumi.Input[int]] = None,
            max_length: Optional[pulumi.Input[int]] = None,
            max_retries: Optional[pulumi.Input[int]] = None,
            min_length: Optional[pulumi.Input[int]] = None,
            min_lower_case_chars: Optional[pulumi.Input[int]] = None,
            min_numeric_chars: Optional[pulumi.Input[int]] = None,
            min_special_chars: Optional[pulumi.Input[int]] = None,
            min_upper_case_chars: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            or_replace: Optional[pulumi.Input[bool]] = None,
            schema: Optional[pulumi.Input[str]] = None) -> 'PasswordPolicy':
        """
        Get an existing PasswordPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: Adds a comment or overwrites an existing comment for the password policy.
        :param pulumi.Input[str] database: The database this password policy belongs to.
        :param pulumi.Input[bool] if_not_exists: Prevent overwriting a previous password policy with the same name.
        :param pulumi.Input[int] lockout_time_mins: Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        :param pulumi.Input[int] max_age_days: Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        :param pulumi.Input[int] max_length: Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        :param pulumi.Input[int] max_retries: Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        :param pulumi.Input[int] min_length: Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        :param pulumi.Input[int] min_lower_case_chars: Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_numeric_chars: Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_special_chars: Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[int] min_upper_case_chars: Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[str] name: Identifier for the password policy; must be unique for your account.
        :param pulumi.Input[bool] or_replace: Whether to override a previous password policy with the same name.
        :param pulumi.Input[str] schema: The schema this password policy belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PasswordPolicyState.__new__(_PasswordPolicyState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["database"] = database
        __props__.__dict__["if_not_exists"] = if_not_exists
        __props__.__dict__["lockout_time_mins"] = lockout_time_mins
        __props__.__dict__["max_age_days"] = max_age_days
        __props__.__dict__["max_length"] = max_length
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["min_length"] = min_length
        __props__.__dict__["min_lower_case_chars"] = min_lower_case_chars
        __props__.__dict__["min_numeric_chars"] = min_numeric_chars
        __props__.__dict__["min_special_chars"] = min_special_chars
        __props__.__dict__["min_upper_case_chars"] = min_upper_case_chars
        __props__.__dict__["name"] = name
        __props__.__dict__["or_replace"] = or_replace
        __props__.__dict__["schema"] = schema
        return PasswordPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        Adds a comment or overwrites an existing comment for the password policy.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        The database this password policy belongs to.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="ifNotExists")
    def if_not_exists(self) -> pulumi.Output[Optional[bool]]:
        """
        Prevent overwriting a previous password policy with the same name.
        """
        return pulumi.get(self, "if_not_exists")

    @property
    @pulumi.getter(name="lockoutTimeMins")
    def lockout_time_mins(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        """
        return pulumi.get(self, "lockout_time_mins")

    @property
    @pulumi.getter(name="maxAgeDays")
    def max_age_days(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        """
        return pulumi.get(self, "max_age_days")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="minLowerCaseChars")
    def min_lower_case_chars(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_lower_case_chars")

    @property
    @pulumi.getter(name="minNumericChars")
    def min_numeric_chars(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_numeric_chars")

    @property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_special_chars")

    @property
    @pulumi.getter(name="minUpperCaseChars")
    def min_upper_case_chars(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_upper_case_chars")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Identifier for the password policy; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to override a previous password policy with the same name.
        """
        return pulumi.get(self, "or_replace")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[str]:
        """
        The schema this password policy belongs to.
        """
        return pulumi.get(self, "schema")

