# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[str]] = None,
                 browser_auth: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 insecure_mode: Optional[pulumi.Input[bool]] = None,
                 oauth_access_token: Optional[pulumi.Input[str]] = None,
                 oauth_client_id: Optional[pulumi.Input[str]] = None,
                 oauth_client_secret: Optional[pulumi.Input[str]] = None,
                 oauth_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth_redirect_url: Optional[pulumi.Input[str]] = None,
                 oauth_refresh_token: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[str]] = None,
                 private_key_path: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 warehouse: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] account: The name of the Snowflake account. Can also come from the `SNOWFLAKE_ACCOUNT` environment variable. Required unless
               using profile.
        :param pulumi.Input[bool] browser_auth: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_USE_BROWSER_AUTH` environment variable.
        :param pulumi.Input[str] host: Supports passing in a custom host value to the snowflake go driver for use with privatelink.
        :param pulumi.Input[bool] insecure_mode: If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the
               default value for testing or emergency situations only.
        :param pulumi.Input[str] oauth_access_token: Token for use with OAuth. Generating the token is left to other tools. Cannot be used with `browser_auth`,
               `private_key_path`, `oauth_refresh_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_ACCESS_TOKEN` environment
               variable.
        :param pulumi.Input[str] oauth_client_id: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        :param pulumi.Input[str] oauth_client_secret: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        :param pulumi.Input[str] oauth_endpoint: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_ENDPOINT` environment variable.
        :param pulumi.Input[str] oauth_redirect_url: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_REDIRECT_URL` environment variable.
        :param pulumi.Input[str] oauth_refresh_token: Token for use with OAuth. Setup and generation of the token is left to other tools. Should be used in conjunction with
               `oauth_client_id`, `oauth_client_secret`, `oauth_endpoint`, `oauth_redirect_url`. Cannot be used with `browser_auth`,
               `private_key_path`, `oauth_access_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_REFRESH_TOKEN` environment
               variable.
        :param pulumi.Input[str] password: Password for username+password auth. Cannot be used with `browser_auth` or `private_key_path`. Can be sourced from
               `SNOWFLAKE_PASSWORD` environment variable.
        :param pulumi.Input[int] port: Support custom port values to snowflake go driver for use with privatelink. Can be sourced from `SNOWFLAKE_PORT`
               environment variable.
        :param pulumi.Input[str] private_key: Private Key for username+private-key auth. Cannot be used with `browser_auth` or `password`. Can be sourced from
               `SNOWFLAKE_PRIVATE_KEY` environment variable.
        :param pulumi.Input[str] private_key_passphrase: Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and
               des-ede3-cbc
        :param pulumi.Input[str] private_key_path: Path to a private key for using keypair authentication. Cannot be used with `browser_auth`, `oauth_access_token` or
               `password`. Can be sourced from `SNOWFLAKE_PRIVATE_KEY_PATH` environment variable.
        :param pulumi.Input[str] profile: Sets the profile to read from ~/.snowflake/config file.
        :param pulumi.Input[str] protocol: Support custom protocols to snowflake go driver. Can be sourced from `SNOWFLAKE_PROTOCOL` environment variable.
        :param pulumi.Input[str] region: [Snowflake region](https://docs.snowflake.com/en/user-guide/intro-regions.html) to use. Required if using the [legacy
               format for the `account`
               identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#format-2-legacy-account-locator-in-a-region)
               in the form of `<cloud_region_id>.<cloud>`. Can be sourced from the `SNOWFLAKE_REGION` environment variable.
        :param pulumi.Input[str] role: Snowflake role to use for operations. If left unset, default role for user will be used. Can be sourced from the
               `SNOWFLAKE_ROLE` environment variable.
        :param pulumi.Input[str] username: Username for username+password authentication. Can come from the `SNOWFLAKE_USER` environment variable. Required unless
               using profile.
        :param pulumi.Input[str] warehouse: Sets the default warehouse. Optional. Can be sourced from SNOWFLAKE_WAREHOUSE environment variable.
        """
        if account is None:
            account = _utilities.get_env('SNOWFLAKE_ACCOUNT')
        if account is not None:
            pulumi.set(__self__, "account", account)
        if browser_auth is None:
            browser_auth = _utilities.get_env_bool('SNOWFLAKE_USE_BROWSER_AUTH')
        if browser_auth is not None:
            pulumi.set(__self__, "browser_auth", browser_auth)
        if host is None:
            host = _utilities.get_env('SNOWFLAKE_HOST')
        if host is not None:
            pulumi.set(__self__, "host", host)
        if insecure_mode is not None:
            pulumi.set(__self__, "insecure_mode", insecure_mode)
        if oauth_access_token is None:
            oauth_access_token = _utilities.get_env('SNOWFLAKE_OAUTH_ACCESS_TOKEN')
        if oauth_access_token is not None:
            pulumi.set(__self__, "oauth_access_token", oauth_access_token)
        if oauth_client_id is None:
            oauth_client_id = _utilities.get_env('SNOWFLAKE_OAUTH_CLIENT_ID')
        if oauth_client_id is not None:
            pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        if oauth_client_secret is None:
            oauth_client_secret = _utilities.get_env('SNOWFLAKE_OAUTH_CLIENT_SECRET')
        if oauth_client_secret is not None:
            pulumi.set(__self__, "oauth_client_secret", oauth_client_secret)
        if oauth_endpoint is None:
            oauth_endpoint = _utilities.get_env('SNOWFLAKE_OAUTH_ENDPOINT')
        if oauth_endpoint is not None:
            pulumi.set(__self__, "oauth_endpoint", oauth_endpoint)
        if oauth_redirect_url is None:
            oauth_redirect_url = _utilities.get_env('SNOWFLAKE_OAUTH_REDIRECT_URL')
        if oauth_redirect_url is not None:
            pulumi.set(__self__, "oauth_redirect_url", oauth_redirect_url)
        if oauth_refresh_token is None:
            oauth_refresh_token = _utilities.get_env('SNOWFLAKE_OAUTH_REFRESH_TOKEN')
        if oauth_refresh_token is not None:
            pulumi.set(__self__, "oauth_refresh_token", oauth_refresh_token)
        if password is None:
            password = _utilities.get_env('SNOWFLAKE_PASSWORD')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is None:
            port = _utilities.get_env_int('SNOWFLAKE_PORT')
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_passphrase is None:
            private_key_passphrase = _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PASSPHRASE')
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if private_key_path is None:
            private_key_path = _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PATH')
        if private_key_path is not None:
            pulumi.set(__self__, "private_key_path", private_key_path)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if protocol is None:
            protocol = _utilities.get_env('SNOWFLAKE_PROTOCOL')
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is None:
            region = _utilities.get_env('SNOWFLAKE_REGION')
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is None:
            role = _utilities.get_env('SNOWFLAKE_ROLE')
        if role is not None:
            pulumi.set(__self__, "role", role)
        if username is None:
            username = _utilities.get_env('SNOWFLAKE_USER')
        if username is not None:
            pulumi.set(__self__, "username", username)
        if warehouse is None:
            warehouse = _utilities.get_env('SNOWFLAKE_WAREHOUSE')
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Snowflake account. Can also come from the `SNOWFLAKE_ACCOUNT` environment variable. Required unless
        using profile.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter(name="browserAuth")
    def browser_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_USE_BROWSER_AUTH` environment variable.
        """
        return pulumi.get(self, "browser_auth")

    @browser_auth.setter
    def browser_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "browser_auth", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Supports passing in a custom host value to the snowflake go driver for use with privatelink.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="insecureMode")
    def insecure_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the
        default value for testing or emergency situations only.
        """
        return pulumi.get(self, "insecure_mode")

    @insecure_mode.setter
    def insecure_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure_mode", value)

    @property
    @pulumi.getter(name="oauthAccessToken")
    def oauth_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Token for use with OAuth. Generating the token is left to other tools. Cannot be used with `browser_auth`,
        `private_key_path`, `oauth_refresh_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_ACCESS_TOKEN` environment
        variable.
        """
        return pulumi.get(self, "oauth_access_token")

    @oauth_access_token.setter
    def oauth_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_access_token", value)

    @property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        """
        return pulumi.get(self, "oauth_client_id")

    @oauth_client_id.setter
    def oauth_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_client_id", value)

    @property
    @pulumi.getter(name="oauthClientSecret")
    def oauth_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        """
        return pulumi.get(self, "oauth_client_secret")

    @oauth_client_secret.setter
    def oauth_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_client_secret", value)

    @property
    @pulumi.getter(name="oauthEndpoint")
    def oauth_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_ENDPOINT` environment variable.
        """
        return pulumi.get(self, "oauth_endpoint")

    @oauth_endpoint.setter
    def oauth_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_endpoint", value)

    @property
    @pulumi.getter(name="oauthRedirectUrl")
    def oauth_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_REDIRECT_URL` environment variable.
        """
        return pulumi.get(self, "oauth_redirect_url")

    @oauth_redirect_url.setter
    def oauth_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_redirect_url", value)

    @property
    @pulumi.getter(name="oauthRefreshToken")
    def oauth_refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        Token for use with OAuth. Setup and generation of the token is left to other tools. Should be used in conjunction with
        `oauth_client_id`, `oauth_client_secret`, `oauth_endpoint`, `oauth_redirect_url`. Cannot be used with `browser_auth`,
        `private_key_path`, `oauth_access_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_REFRESH_TOKEN` environment
        variable.
        """
        return pulumi.get(self, "oauth_refresh_token")

    @oauth_refresh_token.setter
    def oauth_refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_refresh_token", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for username+password auth. Cannot be used with `browser_auth` or `private_key_path`. Can be sourced from
        `SNOWFLAKE_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Support custom port values to snowflake go driver for use with privatelink. Can be sourced from `SNOWFLAKE_PORT`
        environment variable.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Private Key for username+private-key auth. Cannot be used with `browser_auth` or `password`. Can be sourced from
        `SNOWFLAKE_PRIVATE_KEY` environment variable.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and
        des-ede3-cbc
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a private key for using keypair authentication. Cannot be used with `browser_auth`, `oauth_access_token` or
        `password`. Can be sourced from `SNOWFLAKE_PRIVATE_KEY_PATH` environment variable.
        """
        return pulumi.get(self, "private_key_path")

    @private_key_path.setter
    def private_key_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_path", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the profile to read from ~/.snowflake/config file.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Support custom protocols to snowflake go driver. Can be sourced from `SNOWFLAKE_PROTOCOL` environment variable.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        [Snowflake region](https://docs.snowflake.com/en/user-guide/intro-regions.html) to use. Required if using the [legacy
        format for the `account`
        identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#format-2-legacy-account-locator-in-a-region)
        in the form of `<cloud_region_id>.<cloud>`. Can be sourced from the `SNOWFLAKE_REGION` environment variable.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Snowflake role to use for operations. If left unset, default role for user will be used. Can be sourced from the
        `SNOWFLAKE_ROLE` environment variable.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for username+password authentication. Can come from the `SNOWFLAKE_USER` environment variable. Required unless
        using profile.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the default warehouse. Optional. Can be sourced from SNOWFLAKE_WAREHOUSE environment variable.
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 browser_auth: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 insecure_mode: Optional[pulumi.Input[bool]] = None,
                 oauth_access_token: Optional[pulumi.Input[str]] = None,
                 oauth_client_id: Optional[pulumi.Input[str]] = None,
                 oauth_client_secret: Optional[pulumi.Input[str]] = None,
                 oauth_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth_redirect_url: Optional[pulumi.Input[str]] = None,
                 oauth_refresh_token: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[str]] = None,
                 private_key_path: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 warehouse: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the snowflake package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account: The name of the Snowflake account. Can also come from the `SNOWFLAKE_ACCOUNT` environment variable. Required unless
               using profile.
        :param pulumi.Input[bool] browser_auth: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_USE_BROWSER_AUTH` environment variable.
        :param pulumi.Input[str] host: Supports passing in a custom host value to the snowflake go driver for use with privatelink.
        :param pulumi.Input[bool] insecure_mode: If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the
               default value for testing or emergency situations only.
        :param pulumi.Input[str] oauth_access_token: Token for use with OAuth. Generating the token is left to other tools. Cannot be used with `browser_auth`,
               `private_key_path`, `oauth_refresh_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_ACCESS_TOKEN` environment
               variable.
        :param pulumi.Input[str] oauth_client_id: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        :param pulumi.Input[str] oauth_client_secret: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        :param pulumi.Input[str] oauth_endpoint: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_ENDPOINT` environment variable.
        :param pulumi.Input[str] oauth_redirect_url: Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_REDIRECT_URL` environment variable.
        :param pulumi.Input[str] oauth_refresh_token: Token for use with OAuth. Setup and generation of the token is left to other tools. Should be used in conjunction with
               `oauth_client_id`, `oauth_client_secret`, `oauth_endpoint`, `oauth_redirect_url`. Cannot be used with `browser_auth`,
               `private_key_path`, `oauth_access_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_REFRESH_TOKEN` environment
               variable.
        :param pulumi.Input[str] password: Password for username+password auth. Cannot be used with `browser_auth` or `private_key_path`. Can be sourced from
               `SNOWFLAKE_PASSWORD` environment variable.
        :param pulumi.Input[int] port: Support custom port values to snowflake go driver for use with privatelink. Can be sourced from `SNOWFLAKE_PORT`
               environment variable.
        :param pulumi.Input[str] private_key: Private Key for username+private-key auth. Cannot be used with `browser_auth` or `password`. Can be sourced from
               `SNOWFLAKE_PRIVATE_KEY` environment variable.
        :param pulumi.Input[str] private_key_passphrase: Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and
               des-ede3-cbc
        :param pulumi.Input[str] private_key_path: Path to a private key for using keypair authentication. Cannot be used with `browser_auth`, `oauth_access_token` or
               `password`. Can be sourced from `SNOWFLAKE_PRIVATE_KEY_PATH` environment variable.
        :param pulumi.Input[str] profile: Sets the profile to read from ~/.snowflake/config file.
        :param pulumi.Input[str] protocol: Support custom protocols to snowflake go driver. Can be sourced from `SNOWFLAKE_PROTOCOL` environment variable.
        :param pulumi.Input[str] region: [Snowflake region](https://docs.snowflake.com/en/user-guide/intro-regions.html) to use. Required if using the [legacy
               format for the `account`
               identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#format-2-legacy-account-locator-in-a-region)
               in the form of `<cloud_region_id>.<cloud>`. Can be sourced from the `SNOWFLAKE_REGION` environment variable.
        :param pulumi.Input[str] role: Snowflake role to use for operations. If left unset, default role for user will be used. Can be sourced from the
               `SNOWFLAKE_ROLE` environment variable.
        :param pulumi.Input[str] username: Username for username+password authentication. Can come from the `SNOWFLAKE_USER` environment variable. Required unless
               using profile.
        :param pulumi.Input[str] warehouse: Sets the default warehouse. Optional. Can be sourced from SNOWFLAKE_WAREHOUSE environment variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the snowflake package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 browser_auth: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 insecure_mode: Optional[pulumi.Input[bool]] = None,
                 oauth_access_token: Optional[pulumi.Input[str]] = None,
                 oauth_client_id: Optional[pulumi.Input[str]] = None,
                 oauth_client_secret: Optional[pulumi.Input[str]] = None,
                 oauth_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth_redirect_url: Optional[pulumi.Input[str]] = None,
                 oauth_refresh_token: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[str]] = None,
                 private_key_path: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 warehouse: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if account is None:
                account = _utilities.get_env('SNOWFLAKE_ACCOUNT')
            __props__.__dict__["account"] = account
            if browser_auth is None:
                browser_auth = _utilities.get_env_bool('SNOWFLAKE_USE_BROWSER_AUTH')
            __props__.__dict__["browser_auth"] = pulumi.Output.from_input(browser_auth).apply(pulumi.runtime.to_json) if browser_auth is not None else None
            if host is None:
                host = _utilities.get_env('SNOWFLAKE_HOST')
            __props__.__dict__["host"] = host
            __props__.__dict__["insecure_mode"] = pulumi.Output.from_input(insecure_mode).apply(pulumi.runtime.to_json) if insecure_mode is not None else None
            if oauth_access_token is None:
                oauth_access_token = _utilities.get_env('SNOWFLAKE_OAUTH_ACCESS_TOKEN')
            __props__.__dict__["oauth_access_token"] = None if oauth_access_token is None else pulumi.Output.secret(oauth_access_token)
            if oauth_client_id is None:
                oauth_client_id = _utilities.get_env('SNOWFLAKE_OAUTH_CLIENT_ID')
            __props__.__dict__["oauth_client_id"] = None if oauth_client_id is None else pulumi.Output.secret(oauth_client_id)
            if oauth_client_secret is None:
                oauth_client_secret = _utilities.get_env('SNOWFLAKE_OAUTH_CLIENT_SECRET')
            __props__.__dict__["oauth_client_secret"] = None if oauth_client_secret is None else pulumi.Output.secret(oauth_client_secret)
            if oauth_endpoint is None:
                oauth_endpoint = _utilities.get_env('SNOWFLAKE_OAUTH_ENDPOINT')
            __props__.__dict__["oauth_endpoint"] = None if oauth_endpoint is None else pulumi.Output.secret(oauth_endpoint)
            if oauth_redirect_url is None:
                oauth_redirect_url = _utilities.get_env('SNOWFLAKE_OAUTH_REDIRECT_URL')
            __props__.__dict__["oauth_redirect_url"] = None if oauth_redirect_url is None else pulumi.Output.secret(oauth_redirect_url)
            if oauth_refresh_token is None:
                oauth_refresh_token = _utilities.get_env('SNOWFLAKE_OAUTH_REFRESH_TOKEN')
            __props__.__dict__["oauth_refresh_token"] = None if oauth_refresh_token is None else pulumi.Output.secret(oauth_refresh_token)
            if password is None:
                password = _utilities.get_env('SNOWFLAKE_PASSWORD')
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if port is None:
                port = _utilities.get_env_int('SNOWFLAKE_PORT')
            __props__.__dict__["port"] = pulumi.Output.from_input(port).apply(pulumi.runtime.to_json) if port is not None else None
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if private_key_passphrase is None:
                private_key_passphrase = _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PASSPHRASE')
            __props__.__dict__["private_key_passphrase"] = None if private_key_passphrase is None else pulumi.Output.secret(private_key_passphrase)
            if private_key_path is None:
                private_key_path = _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PATH')
            __props__.__dict__["private_key_path"] = None if private_key_path is None else pulumi.Output.secret(private_key_path)
            __props__.__dict__["profile"] = profile
            if protocol is None:
                protocol = _utilities.get_env('SNOWFLAKE_PROTOCOL')
            __props__.__dict__["protocol"] = protocol
            if region is None:
                region = _utilities.get_env('SNOWFLAKE_REGION')
            __props__.__dict__["region"] = region
            if role is None:
                role = _utilities.get_env('SNOWFLAKE_ROLE')
            __props__.__dict__["role"] = role
            if username is None:
                username = _utilities.get_env('SNOWFLAKE_USER')
            __props__.__dict__["username"] = username
            if warehouse is None:
                warehouse = _utilities.get_env('SNOWFLAKE_WAREHOUSE')
            __props__.__dict__["warehouse"] = warehouse
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["oauthAccessToken", "oauthClientId", "oauthClientSecret", "oauthEndpoint", "oauthRedirectUrl", "oauthRefreshToken", "password", "privateKey", "privateKeyPassphrase", "privateKeyPath"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'snowflake',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Snowflake account. Can also come from the `SNOWFLAKE_ACCOUNT` environment variable. Required unless
        using profile.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[str]]:
        """
        Supports passing in a custom host value to the snowflake go driver for use with privatelink.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="oauthAccessToken")
    def oauth_access_token(self) -> pulumi.Output[Optional[str]]:
        """
        Token for use with OAuth. Generating the token is left to other tools. Cannot be used with `browser_auth`,
        `private_key_path`, `oauth_refresh_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_ACCESS_TOKEN` environment
        variable.
        """
        return pulumi.get(self, "oauth_access_token")

    @property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> pulumi.Output[Optional[str]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        """
        return pulumi.get(self, "oauth_client_id")

    @property
    @pulumi.getter(name="oauthClientSecret")
    def oauth_client_secret(self) -> pulumi.Output[Optional[str]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        """
        return pulumi.get(self, "oauth_client_secret")

    @property
    @pulumi.getter(name="oauthEndpoint")
    def oauth_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_ENDPOINT` environment variable.
        """
        return pulumi.get(self, "oauth_endpoint")

    @property
    @pulumi.getter(name="oauthRedirectUrl")
    def oauth_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        Required when `oauth_refresh_token` is used. Can be sourced from `SNOWFLAKE_OAUTH_REDIRECT_URL` environment variable.
        """
        return pulumi.get(self, "oauth_redirect_url")

    @property
    @pulumi.getter(name="oauthRefreshToken")
    def oauth_refresh_token(self) -> pulumi.Output[Optional[str]]:
        """
        Token for use with OAuth. Setup and generation of the token is left to other tools. Should be used in conjunction with
        `oauth_client_id`, `oauth_client_secret`, `oauth_endpoint`, `oauth_redirect_url`. Cannot be used with `browser_auth`,
        `private_key_path`, `oauth_access_token` or `password`. Can be sourced from `SNOWFLAKE_OAUTH_REFRESH_TOKEN` environment
        variable.
        """
        return pulumi.get(self, "oauth_refresh_token")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Password for username+password auth. Cannot be used with `browser_auth` or `private_key_path`. Can be sourced from
        `SNOWFLAKE_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[str]]:
        """
        Private Key for username+private-key auth. Cannot be used with `browser_auth` or `password`. Can be sourced from
        `SNOWFLAKE_PRIVATE_KEY` environment variable.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> pulumi.Output[Optional[str]]:
        """
        Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and
        des-ede3-cbc
        """
        return pulumi.get(self, "private_key_passphrase")

    @property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> pulumi.Output[Optional[str]]:
        """
        Path to a private key for using keypair authentication. Cannot be used with `browser_auth`, `oauth_access_token` or
        `password`. Can be sourced from `SNOWFLAKE_PRIVATE_KEY_PATH` environment variable.
        """
        return pulumi.get(self, "private_key_path")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[str]]:
        """
        Sets the profile to read from ~/.snowflake/config file.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Support custom protocols to snowflake go driver. Can be sourced from `SNOWFLAKE_PROTOCOL` environment variable.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        [Snowflake region](https://docs.snowflake.com/en/user-guide/intro-regions.html) to use. Required if using the [legacy
        format for the `account`
        identifier](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#format-2-legacy-account-locator-in-a-region)
        in the form of `<cloud_region_id>.<cloud>`. Can be sourced from the `SNOWFLAKE_REGION` environment variable.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        Snowflake role to use for operations. If left unset, default role for user will be used. Can be sourced from the
        `SNOWFLAKE_ROLE` environment variable.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        Username for username+password authentication. Can come from the `SNOWFLAKE_USER` environment variable. Required unless
        using profile.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def warehouse(self) -> pulumi.Output[Optional[str]]:
        """
        Sets the default warehouse. Optional. Can be sourced from SNOWFLAKE_WAREHOUSE environment variable.
        """
        return pulumi.get(self, "warehouse")

