# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SamlIntegrationArgs', 'SamlIntegration']

@pulumi.input_type
class SamlIntegrationArgs:
    def __init__(__self__, *,
                 saml2_issuer: pulumi.Input[str],
                 saml2_provider: pulumi.Input[str],
                 saml2_sso_url: pulumi.Input[str],
                 saml2_x509_cert: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 saml2_enable_sp_initiated: Optional[pulumi.Input[bool]] = None,
                 saml2_force_authn: Optional[pulumi.Input[bool]] = None,
                 saml2_post_logout_redirect_url: Optional[pulumi.Input[str]] = None,
                 saml2_requested_nameid_format: Optional[pulumi.Input[str]] = None,
                 saml2_sign_request: Optional[pulumi.Input[bool]] = None,
                 saml2_snowflake_acs_url: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_issuer_url: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_x509_cert: Optional[pulumi.Input[str]] = None,
                 saml2_sp_initiated_login_page_label: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SamlIntegration resource.
        :param pulumi.Input[str] saml2_issuer: The string containing the IdP EntityID / Issuer.
        :param pulumi.Input[str] saml2_provider: The string describing the IdP. One of the following: OKTA, ADFS, Custom.
        :param pulumi.Input[str] saml2_sso_url: The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        :param pulumi.Input[str] saml2_x509_cert: The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        :param pulumi.Input[bool] enabled: Specifies whether this security integration is enabled or disabled.
        :param pulumi.Input[str] name: Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
        :param pulumi.Input[bool] saml2_enable_sp_initiated: The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
        :param pulumi.Input[bool] saml2_force_authn: The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
        :param pulumi.Input[str] saml2_post_logout_redirect_url: The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        :param pulumi.Input[str] saml2_requested_nameid_format: The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
        :param pulumi.Input[bool] saml2_sign_request: The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
        :param pulumi.Input[str] saml2_snowflake_acs_url: The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://\\n\\n.\\n\\n.snowflakecomputing.com/fed/login
        :param pulumi.Input[str] saml2_snowflake_issuer_url: The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
        :param pulumi.Input[str] saml2_snowflake_x509_cert: The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests. You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
        :param pulumi.Input[str] saml2_sp_initiated_login_page_label: The string containing the label to display after the Log In With button on the login page.
        """
        pulumi.set(__self__, "saml2_issuer", saml2_issuer)
        pulumi.set(__self__, "saml2_provider", saml2_provider)
        pulumi.set(__self__, "saml2_sso_url", saml2_sso_url)
        pulumi.set(__self__, "saml2_x509_cert", saml2_x509_cert)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if saml2_enable_sp_initiated is not None:
            pulumi.set(__self__, "saml2_enable_sp_initiated", saml2_enable_sp_initiated)
        if saml2_force_authn is not None:
            pulumi.set(__self__, "saml2_force_authn", saml2_force_authn)
        if saml2_post_logout_redirect_url is not None:
            pulumi.set(__self__, "saml2_post_logout_redirect_url", saml2_post_logout_redirect_url)
        if saml2_requested_nameid_format is not None:
            pulumi.set(__self__, "saml2_requested_nameid_format", saml2_requested_nameid_format)
        if saml2_sign_request is not None:
            pulumi.set(__self__, "saml2_sign_request", saml2_sign_request)
        if saml2_snowflake_acs_url is not None:
            pulumi.set(__self__, "saml2_snowflake_acs_url", saml2_snowflake_acs_url)
        if saml2_snowflake_issuer_url is not None:
            pulumi.set(__self__, "saml2_snowflake_issuer_url", saml2_snowflake_issuer_url)
        if saml2_snowflake_x509_cert is not None:
            pulumi.set(__self__, "saml2_snowflake_x509_cert", saml2_snowflake_x509_cert)
        if saml2_sp_initiated_login_page_label is not None:
            pulumi.set(__self__, "saml2_sp_initiated_login_page_label", saml2_sp_initiated_login_page_label)

    @property
    @pulumi.getter(name="saml2Issuer")
    def saml2_issuer(self) -> pulumi.Input[str]:
        """
        The string containing the IdP EntityID / Issuer.
        """
        return pulumi.get(self, "saml2_issuer")

    @saml2_issuer.setter
    def saml2_issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "saml2_issuer", value)

    @property
    @pulumi.getter(name="saml2Provider")
    def saml2_provider(self) -> pulumi.Input[str]:
        """
        The string describing the IdP. One of the following: OKTA, ADFS, Custom.
        """
        return pulumi.get(self, "saml2_provider")

    @saml2_provider.setter
    def saml2_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "saml2_provider", value)

    @property
    @pulumi.getter(name="saml2SsoUrl")
    def saml2_sso_url(self) -> pulumi.Input[str]:
        """
        The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        """
        return pulumi.get(self, "saml2_sso_url")

    @saml2_sso_url.setter
    def saml2_sso_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "saml2_sso_url", value)

    @property
    @pulumi.getter(name="saml2X509Cert")
    def saml2_x509_cert(self) -> pulumi.Input[str]:
        """
        The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        return pulumi.get(self, "saml2_x509_cert")

    @saml2_x509_cert.setter
    def saml2_x509_cert(self, value: pulumi.Input[str]):
        pulumi.set(self, "saml2_x509_cert", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether this security integration is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="saml2EnableSpInitiated")
    def saml2_enable_sp_initiated(self) -> Optional[pulumi.Input[bool]]:
        """
        The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
        """
        return pulumi.get(self, "saml2_enable_sp_initiated")

    @saml2_enable_sp_initiated.setter
    def saml2_enable_sp_initiated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml2_enable_sp_initiated", value)

    @property
    @pulumi.getter(name="saml2ForceAuthn")
    def saml2_force_authn(self) -> Optional[pulumi.Input[bool]]:
        """
        The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
        """
        return pulumi.get(self, "saml2_force_authn")

    @saml2_force_authn.setter
    def saml2_force_authn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml2_force_authn", value)

    @property
    @pulumi.getter(name="saml2PostLogoutRedirectUrl")
    def saml2_post_logout_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        """
        return pulumi.get(self, "saml2_post_logout_redirect_url")

    @saml2_post_logout_redirect_url.setter
    def saml2_post_logout_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_post_logout_redirect_url", value)

    @property
    @pulumi.getter(name="saml2RequestedNameidFormat")
    def saml2_requested_nameid_format(self) -> Optional[pulumi.Input[str]]:
        """
        The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
        """
        return pulumi.get(self, "saml2_requested_nameid_format")

    @saml2_requested_nameid_format.setter
    def saml2_requested_nameid_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_requested_nameid_format", value)

    @property
    @pulumi.getter(name="saml2SignRequest")
    def saml2_sign_request(self) -> Optional[pulumi.Input[bool]]:
        """
        The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
        """
        return pulumi.get(self, "saml2_sign_request")

    @saml2_sign_request.setter
    def saml2_sign_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml2_sign_request", value)

    @property
    @pulumi.getter(name="saml2SnowflakeAcsUrl")
    def saml2_snowflake_acs_url(self) -> Optional[pulumi.Input[str]]:
        """
        The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://\\n\\n.\\n\\n.snowflakecomputing.com/fed/login
        """
        return pulumi.get(self, "saml2_snowflake_acs_url")

    @saml2_snowflake_acs_url.setter
    def saml2_snowflake_acs_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_snowflake_acs_url", value)

    @property
    @pulumi.getter(name="saml2SnowflakeIssuerUrl")
    def saml2_snowflake_issuer_url(self) -> Optional[pulumi.Input[str]]:
        """
        The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
        """
        return pulumi.get(self, "saml2_snowflake_issuer_url")

    @saml2_snowflake_issuer_url.setter
    def saml2_snowflake_issuer_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_snowflake_issuer_url", value)

    @property
    @pulumi.getter(name="saml2SnowflakeX509Cert")
    def saml2_snowflake_x509_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests. You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
        """
        return pulumi.get(self, "saml2_snowflake_x509_cert")

    @saml2_snowflake_x509_cert.setter
    def saml2_snowflake_x509_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_snowflake_x509_cert", value)

    @property
    @pulumi.getter(name="saml2SpInitiatedLoginPageLabel")
    def saml2_sp_initiated_login_page_label(self) -> Optional[pulumi.Input[str]]:
        """
        The string containing the label to display after the Log In With button on the login page.
        """
        return pulumi.get(self, "saml2_sp_initiated_login_page_label")

    @saml2_sp_initiated_login_page_label.setter
    def saml2_sp_initiated_login_page_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_sp_initiated_login_page_label", value)


@pulumi.input_type
class _SamlIntegrationState:
    def __init__(__self__, *,
                 created_on: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 saml2_digest_methods_used: Optional[pulumi.Input[str]] = None,
                 saml2_enable_sp_initiated: Optional[pulumi.Input[bool]] = None,
                 saml2_force_authn: Optional[pulumi.Input[bool]] = None,
                 saml2_issuer: Optional[pulumi.Input[str]] = None,
                 saml2_post_logout_redirect_url: Optional[pulumi.Input[str]] = None,
                 saml2_provider: Optional[pulumi.Input[str]] = None,
                 saml2_requested_nameid_format: Optional[pulumi.Input[str]] = None,
                 saml2_sign_request: Optional[pulumi.Input[bool]] = None,
                 saml2_signature_methods_used: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_acs_url: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_issuer_url: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_metadata: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_x509_cert: Optional[pulumi.Input[str]] = None,
                 saml2_sp_initiated_login_page_label: Optional[pulumi.Input[str]] = None,
                 saml2_sso_url: Optional[pulumi.Input[str]] = None,
                 saml2_x509_cert: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SamlIntegration resources.
        :param pulumi.Input[str] created_on: Date and time when the SAML integration was created.
        :param pulumi.Input[bool] enabled: Specifies whether this security integration is enabled or disabled.
        :param pulumi.Input[str] name: Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
        :param pulumi.Input[bool] saml2_enable_sp_initiated: The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
        :param pulumi.Input[bool] saml2_force_authn: The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
        :param pulumi.Input[str] saml2_issuer: The string containing the IdP EntityID / Issuer.
        :param pulumi.Input[str] saml2_post_logout_redirect_url: The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        :param pulumi.Input[str] saml2_provider: The string describing the IdP. One of the following: OKTA, ADFS, Custom.
        :param pulumi.Input[str] saml2_requested_nameid_format: The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
        :param pulumi.Input[bool] saml2_sign_request: The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
        :param pulumi.Input[str] saml2_snowflake_acs_url: The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://\\n\\n.\\n\\n.snowflakecomputing.com/fed/login
        :param pulumi.Input[str] saml2_snowflake_issuer_url: The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
        :param pulumi.Input[str] saml2_snowflake_metadata: Metadata created by Snowflake to provide to SAML2 provider.
        :param pulumi.Input[str] saml2_snowflake_x509_cert: The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests. You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
        :param pulumi.Input[str] saml2_sp_initiated_login_page_label: The string containing the label to display after the Log In With button on the login page.
        :param pulumi.Input[str] saml2_sso_url: The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        :param pulumi.Input[str] saml2_x509_cert: The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if saml2_digest_methods_used is not None:
            pulumi.set(__self__, "saml2_digest_methods_used", saml2_digest_methods_used)
        if saml2_enable_sp_initiated is not None:
            pulumi.set(__self__, "saml2_enable_sp_initiated", saml2_enable_sp_initiated)
        if saml2_force_authn is not None:
            pulumi.set(__self__, "saml2_force_authn", saml2_force_authn)
        if saml2_issuer is not None:
            pulumi.set(__self__, "saml2_issuer", saml2_issuer)
        if saml2_post_logout_redirect_url is not None:
            pulumi.set(__self__, "saml2_post_logout_redirect_url", saml2_post_logout_redirect_url)
        if saml2_provider is not None:
            pulumi.set(__self__, "saml2_provider", saml2_provider)
        if saml2_requested_nameid_format is not None:
            pulumi.set(__self__, "saml2_requested_nameid_format", saml2_requested_nameid_format)
        if saml2_sign_request is not None:
            pulumi.set(__self__, "saml2_sign_request", saml2_sign_request)
        if saml2_signature_methods_used is not None:
            pulumi.set(__self__, "saml2_signature_methods_used", saml2_signature_methods_used)
        if saml2_snowflake_acs_url is not None:
            pulumi.set(__self__, "saml2_snowflake_acs_url", saml2_snowflake_acs_url)
        if saml2_snowflake_issuer_url is not None:
            pulumi.set(__self__, "saml2_snowflake_issuer_url", saml2_snowflake_issuer_url)
        if saml2_snowflake_metadata is not None:
            pulumi.set(__self__, "saml2_snowflake_metadata", saml2_snowflake_metadata)
        if saml2_snowflake_x509_cert is not None:
            pulumi.set(__self__, "saml2_snowflake_x509_cert", saml2_snowflake_x509_cert)
        if saml2_sp_initiated_login_page_label is not None:
            pulumi.set(__self__, "saml2_sp_initiated_login_page_label", saml2_sp_initiated_login_page_label)
        if saml2_sso_url is not None:
            pulumi.set(__self__, "saml2_sso_url", saml2_sso_url)
        if saml2_x509_cert is not None:
            pulumi.set(__self__, "saml2_x509_cert", saml2_x509_cert)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time when the SAML integration was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether this security integration is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="saml2DigestMethodsUsed")
    def saml2_digest_methods_used(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "saml2_digest_methods_used")

    @saml2_digest_methods_used.setter
    def saml2_digest_methods_used(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_digest_methods_used", value)

    @property
    @pulumi.getter(name="saml2EnableSpInitiated")
    def saml2_enable_sp_initiated(self) -> Optional[pulumi.Input[bool]]:
        """
        The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
        """
        return pulumi.get(self, "saml2_enable_sp_initiated")

    @saml2_enable_sp_initiated.setter
    def saml2_enable_sp_initiated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml2_enable_sp_initiated", value)

    @property
    @pulumi.getter(name="saml2ForceAuthn")
    def saml2_force_authn(self) -> Optional[pulumi.Input[bool]]:
        """
        The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
        """
        return pulumi.get(self, "saml2_force_authn")

    @saml2_force_authn.setter
    def saml2_force_authn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml2_force_authn", value)

    @property
    @pulumi.getter(name="saml2Issuer")
    def saml2_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The string containing the IdP EntityID / Issuer.
        """
        return pulumi.get(self, "saml2_issuer")

    @saml2_issuer.setter
    def saml2_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_issuer", value)

    @property
    @pulumi.getter(name="saml2PostLogoutRedirectUrl")
    def saml2_post_logout_redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        """
        return pulumi.get(self, "saml2_post_logout_redirect_url")

    @saml2_post_logout_redirect_url.setter
    def saml2_post_logout_redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_post_logout_redirect_url", value)

    @property
    @pulumi.getter(name="saml2Provider")
    def saml2_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The string describing the IdP. One of the following: OKTA, ADFS, Custom.
        """
        return pulumi.get(self, "saml2_provider")

    @saml2_provider.setter
    def saml2_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_provider", value)

    @property
    @pulumi.getter(name="saml2RequestedNameidFormat")
    def saml2_requested_nameid_format(self) -> Optional[pulumi.Input[str]]:
        """
        The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
        """
        return pulumi.get(self, "saml2_requested_nameid_format")

    @saml2_requested_nameid_format.setter
    def saml2_requested_nameid_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_requested_nameid_format", value)

    @property
    @pulumi.getter(name="saml2SignRequest")
    def saml2_sign_request(self) -> Optional[pulumi.Input[bool]]:
        """
        The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
        """
        return pulumi.get(self, "saml2_sign_request")

    @saml2_sign_request.setter
    def saml2_sign_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml2_sign_request", value)

    @property
    @pulumi.getter(name="saml2SignatureMethodsUsed")
    def saml2_signature_methods_used(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "saml2_signature_methods_used")

    @saml2_signature_methods_used.setter
    def saml2_signature_methods_used(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_signature_methods_used", value)

    @property
    @pulumi.getter(name="saml2SnowflakeAcsUrl")
    def saml2_snowflake_acs_url(self) -> Optional[pulumi.Input[str]]:
        """
        The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://\\n\\n.\\n\\n.snowflakecomputing.com/fed/login
        """
        return pulumi.get(self, "saml2_snowflake_acs_url")

    @saml2_snowflake_acs_url.setter
    def saml2_snowflake_acs_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_snowflake_acs_url", value)

    @property
    @pulumi.getter(name="saml2SnowflakeIssuerUrl")
    def saml2_snowflake_issuer_url(self) -> Optional[pulumi.Input[str]]:
        """
        The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
        """
        return pulumi.get(self, "saml2_snowflake_issuer_url")

    @saml2_snowflake_issuer_url.setter
    def saml2_snowflake_issuer_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_snowflake_issuer_url", value)

    @property
    @pulumi.getter(name="saml2SnowflakeMetadata")
    def saml2_snowflake_metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata created by Snowflake to provide to SAML2 provider.
        """
        return pulumi.get(self, "saml2_snowflake_metadata")

    @saml2_snowflake_metadata.setter
    def saml2_snowflake_metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_snowflake_metadata", value)

    @property
    @pulumi.getter(name="saml2SnowflakeX509Cert")
    def saml2_snowflake_x509_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests. You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
        """
        return pulumi.get(self, "saml2_snowflake_x509_cert")

    @saml2_snowflake_x509_cert.setter
    def saml2_snowflake_x509_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_snowflake_x509_cert", value)

    @property
    @pulumi.getter(name="saml2SpInitiatedLoginPageLabel")
    def saml2_sp_initiated_login_page_label(self) -> Optional[pulumi.Input[str]]:
        """
        The string containing the label to display after the Log In With button on the login page.
        """
        return pulumi.get(self, "saml2_sp_initiated_login_page_label")

    @saml2_sp_initiated_login_page_label.setter
    def saml2_sp_initiated_login_page_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_sp_initiated_login_page_label", value)

    @property
    @pulumi.getter(name="saml2SsoUrl")
    def saml2_sso_url(self) -> Optional[pulumi.Input[str]]:
        """
        The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        """
        return pulumi.get(self, "saml2_sso_url")

    @saml2_sso_url.setter
    def saml2_sso_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_sso_url", value)

    @property
    @pulumi.getter(name="saml2X509Cert")
    def saml2_x509_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        return pulumi.get(self, "saml2_x509_cert")

    @saml2_x509_cert.setter
    def saml2_x509_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml2_x509_cert", value)


class SamlIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 saml2_enable_sp_initiated: Optional[pulumi.Input[bool]] = None,
                 saml2_force_authn: Optional[pulumi.Input[bool]] = None,
                 saml2_issuer: Optional[pulumi.Input[str]] = None,
                 saml2_post_logout_redirect_url: Optional[pulumi.Input[str]] = None,
                 saml2_provider: Optional[pulumi.Input[str]] = None,
                 saml2_requested_nameid_format: Optional[pulumi.Input[str]] = None,
                 saml2_sign_request: Optional[pulumi.Input[bool]] = None,
                 saml2_snowflake_acs_url: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_issuer_url: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_x509_cert: Optional[pulumi.Input[str]] = None,
                 saml2_sp_initiated_login_page_label: Optional[pulumi.Input[str]] = None,
                 saml2_sso_url: Optional[pulumi.Input[str]] = None,
                 saml2_x509_cert: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        saml_integration = snowflake.SamlIntegration("samlIntegration",
            enabled=True,
            saml2_issuer="test_issuer",
            saml2_provider="CUSTOM",
            saml2_sso_url="https://testsamlissuer.com",
            saml2_x509_cert="MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiMD6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO")
        ```

        ## Import

        ```sh
         $ pulumi import snowflake:index/samlIntegration:SamlIntegration example name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Specifies whether this security integration is enabled or disabled.
        :param pulumi.Input[str] name: Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
        :param pulumi.Input[bool] saml2_enable_sp_initiated: The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
        :param pulumi.Input[bool] saml2_force_authn: The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
        :param pulumi.Input[str] saml2_issuer: The string containing the IdP EntityID / Issuer.
        :param pulumi.Input[str] saml2_post_logout_redirect_url: The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        :param pulumi.Input[str] saml2_provider: The string describing the IdP. One of the following: OKTA, ADFS, Custom.
        :param pulumi.Input[str] saml2_requested_nameid_format: The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
        :param pulumi.Input[bool] saml2_sign_request: The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
        :param pulumi.Input[str] saml2_snowflake_acs_url: The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://\\n\\n.\\n\\n.snowflakecomputing.com/fed/login
        :param pulumi.Input[str] saml2_snowflake_issuer_url: The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
        :param pulumi.Input[str] saml2_snowflake_x509_cert: The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests. You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
        :param pulumi.Input[str] saml2_sp_initiated_login_page_label: The string containing the label to display after the Log In With button on the login page.
        :param pulumi.Input[str] saml2_sso_url: The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        :param pulumi.Input[str] saml2_x509_cert: The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SamlIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        saml_integration = snowflake.SamlIntegration("samlIntegration",
            enabled=True,
            saml2_issuer="test_issuer",
            saml2_provider="CUSTOM",
            saml2_sso_url="https://testsamlissuer.com",
            saml2_x509_cert="MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiMD6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO")
        ```

        ## Import

        ```sh
         $ pulumi import snowflake:index/samlIntegration:SamlIntegration example name
        ```

        :param str resource_name: The name of the resource.
        :param SamlIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SamlIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 saml2_enable_sp_initiated: Optional[pulumi.Input[bool]] = None,
                 saml2_force_authn: Optional[pulumi.Input[bool]] = None,
                 saml2_issuer: Optional[pulumi.Input[str]] = None,
                 saml2_post_logout_redirect_url: Optional[pulumi.Input[str]] = None,
                 saml2_provider: Optional[pulumi.Input[str]] = None,
                 saml2_requested_nameid_format: Optional[pulumi.Input[str]] = None,
                 saml2_sign_request: Optional[pulumi.Input[bool]] = None,
                 saml2_snowflake_acs_url: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_issuer_url: Optional[pulumi.Input[str]] = None,
                 saml2_snowflake_x509_cert: Optional[pulumi.Input[str]] = None,
                 saml2_sp_initiated_login_page_label: Optional[pulumi.Input[str]] = None,
                 saml2_sso_url: Optional[pulumi.Input[str]] = None,
                 saml2_x509_cert: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SamlIntegrationArgs.__new__(SamlIntegrationArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["saml2_enable_sp_initiated"] = saml2_enable_sp_initiated
            __props__.__dict__["saml2_force_authn"] = saml2_force_authn
            if saml2_issuer is None and not opts.urn:
                raise TypeError("Missing required property 'saml2_issuer'")
            __props__.__dict__["saml2_issuer"] = saml2_issuer
            __props__.__dict__["saml2_post_logout_redirect_url"] = saml2_post_logout_redirect_url
            if saml2_provider is None and not opts.urn:
                raise TypeError("Missing required property 'saml2_provider'")
            __props__.__dict__["saml2_provider"] = saml2_provider
            __props__.__dict__["saml2_requested_nameid_format"] = saml2_requested_nameid_format
            __props__.__dict__["saml2_sign_request"] = saml2_sign_request
            __props__.__dict__["saml2_snowflake_acs_url"] = saml2_snowflake_acs_url
            __props__.__dict__["saml2_snowflake_issuer_url"] = saml2_snowflake_issuer_url
            __props__.__dict__["saml2_snowflake_x509_cert"] = saml2_snowflake_x509_cert
            __props__.__dict__["saml2_sp_initiated_login_page_label"] = saml2_sp_initiated_login_page_label
            if saml2_sso_url is None and not opts.urn:
                raise TypeError("Missing required property 'saml2_sso_url'")
            __props__.__dict__["saml2_sso_url"] = saml2_sso_url
            if saml2_x509_cert is None and not opts.urn:
                raise TypeError("Missing required property 'saml2_x509_cert'")
            __props__.__dict__["saml2_x509_cert"] = saml2_x509_cert
            __props__.__dict__["created_on"] = None
            __props__.__dict__["saml2_digest_methods_used"] = None
            __props__.__dict__["saml2_signature_methods_used"] = None
            __props__.__dict__["saml2_snowflake_metadata"] = None
        super(SamlIntegration, __self__).__init__(
            'snowflake:index/samlIntegration:SamlIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_on: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            saml2_digest_methods_used: Optional[pulumi.Input[str]] = None,
            saml2_enable_sp_initiated: Optional[pulumi.Input[bool]] = None,
            saml2_force_authn: Optional[pulumi.Input[bool]] = None,
            saml2_issuer: Optional[pulumi.Input[str]] = None,
            saml2_post_logout_redirect_url: Optional[pulumi.Input[str]] = None,
            saml2_provider: Optional[pulumi.Input[str]] = None,
            saml2_requested_nameid_format: Optional[pulumi.Input[str]] = None,
            saml2_sign_request: Optional[pulumi.Input[bool]] = None,
            saml2_signature_methods_used: Optional[pulumi.Input[str]] = None,
            saml2_snowflake_acs_url: Optional[pulumi.Input[str]] = None,
            saml2_snowflake_issuer_url: Optional[pulumi.Input[str]] = None,
            saml2_snowflake_metadata: Optional[pulumi.Input[str]] = None,
            saml2_snowflake_x509_cert: Optional[pulumi.Input[str]] = None,
            saml2_sp_initiated_login_page_label: Optional[pulumi.Input[str]] = None,
            saml2_sso_url: Optional[pulumi.Input[str]] = None,
            saml2_x509_cert: Optional[pulumi.Input[str]] = None) -> 'SamlIntegration':
        """
        Get an existing SamlIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_on: Date and time when the SAML integration was created.
        :param pulumi.Input[bool] enabled: Specifies whether this security integration is enabled or disabled.
        :param pulumi.Input[str] name: Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
        :param pulumi.Input[bool] saml2_enable_sp_initiated: The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
        :param pulumi.Input[bool] saml2_force_authn: The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
        :param pulumi.Input[str] saml2_issuer: The string containing the IdP EntityID / Issuer.
        :param pulumi.Input[str] saml2_post_logout_redirect_url: The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        :param pulumi.Input[str] saml2_provider: The string describing the IdP. One of the following: OKTA, ADFS, Custom.
        :param pulumi.Input[str] saml2_requested_nameid_format: The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
        :param pulumi.Input[bool] saml2_sign_request: The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
        :param pulumi.Input[str] saml2_snowflake_acs_url: The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://\\n\\n.\\n\\n.snowflakecomputing.com/fed/login
        :param pulumi.Input[str] saml2_snowflake_issuer_url: The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
        :param pulumi.Input[str] saml2_snowflake_metadata: Metadata created by Snowflake to provide to SAML2 provider.
        :param pulumi.Input[str] saml2_snowflake_x509_cert: The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests. You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
        :param pulumi.Input[str] saml2_sp_initiated_login_page_label: The string containing the label to display after the Log In With button on the login page.
        :param pulumi.Input[str] saml2_sso_url: The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        :param pulumi.Input[str] saml2_x509_cert: The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SamlIntegrationState.__new__(_SamlIntegrationState)

        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["saml2_digest_methods_used"] = saml2_digest_methods_used
        __props__.__dict__["saml2_enable_sp_initiated"] = saml2_enable_sp_initiated
        __props__.__dict__["saml2_force_authn"] = saml2_force_authn
        __props__.__dict__["saml2_issuer"] = saml2_issuer
        __props__.__dict__["saml2_post_logout_redirect_url"] = saml2_post_logout_redirect_url
        __props__.__dict__["saml2_provider"] = saml2_provider
        __props__.__dict__["saml2_requested_nameid_format"] = saml2_requested_nameid_format
        __props__.__dict__["saml2_sign_request"] = saml2_sign_request
        __props__.__dict__["saml2_signature_methods_used"] = saml2_signature_methods_used
        __props__.__dict__["saml2_snowflake_acs_url"] = saml2_snowflake_acs_url
        __props__.__dict__["saml2_snowflake_issuer_url"] = saml2_snowflake_issuer_url
        __props__.__dict__["saml2_snowflake_metadata"] = saml2_snowflake_metadata
        __props__.__dict__["saml2_snowflake_x509_cert"] = saml2_snowflake_x509_cert
        __props__.__dict__["saml2_sp_initiated_login_page_label"] = saml2_sp_initiated_login_page_label
        __props__.__dict__["saml2_sso_url"] = saml2_sso_url
        __props__.__dict__["saml2_x509_cert"] = saml2_x509_cert
        return SamlIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[str]:
        """
        Date and time when the SAML integration was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether this security integration is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="saml2DigestMethodsUsed")
    def saml2_digest_methods_used(self) -> pulumi.Output[str]:
        return pulumi.get(self, "saml2_digest_methods_used")

    @property
    @pulumi.getter(name="saml2EnableSpInitiated")
    def saml2_enable_sp_initiated(self) -> pulumi.Output[Optional[bool]]:
        """
        The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
        """
        return pulumi.get(self, "saml2_enable_sp_initiated")

    @property
    @pulumi.getter(name="saml2ForceAuthn")
    def saml2_force_authn(self) -> pulumi.Output[Optional[bool]]:
        """
        The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
        """
        return pulumi.get(self, "saml2_force_authn")

    @property
    @pulumi.getter(name="saml2Issuer")
    def saml2_issuer(self) -> pulumi.Output[str]:
        """
        The string containing the IdP EntityID / Issuer.
        """
        return pulumi.get(self, "saml2_issuer")

    @property
    @pulumi.getter(name="saml2PostLogoutRedirectUrl")
    def saml2_post_logout_redirect_url(self) -> pulumi.Output[Optional[str]]:
        """
        The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        """
        return pulumi.get(self, "saml2_post_logout_redirect_url")

    @property
    @pulumi.getter(name="saml2Provider")
    def saml2_provider(self) -> pulumi.Output[str]:
        """
        The string describing the IdP. One of the following: OKTA, ADFS, Custom.
        """
        return pulumi.get(self, "saml2_provider")

    @property
    @pulumi.getter(name="saml2RequestedNameidFormat")
    def saml2_requested_nameid_format(self) -> pulumi.Output[Optional[str]]:
        """
        The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
        """
        return pulumi.get(self, "saml2_requested_nameid_format")

    @property
    @pulumi.getter(name="saml2SignRequest")
    def saml2_sign_request(self) -> pulumi.Output[Optional[bool]]:
        """
        The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
        """
        return pulumi.get(self, "saml2_sign_request")

    @property
    @pulumi.getter(name="saml2SignatureMethodsUsed")
    def saml2_signature_methods_used(self) -> pulumi.Output[str]:
        return pulumi.get(self, "saml2_signature_methods_used")

    @property
    @pulumi.getter(name="saml2SnowflakeAcsUrl")
    def saml2_snowflake_acs_url(self) -> pulumi.Output[str]:
        """
        The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://\\n\\n.\\n\\n.snowflakecomputing.com/fed/login
        """
        return pulumi.get(self, "saml2_snowflake_acs_url")

    @property
    @pulumi.getter(name="saml2SnowflakeIssuerUrl")
    def saml2_snowflake_issuer_url(self) -> pulumi.Output[str]:
        """
        The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
        """
        return pulumi.get(self, "saml2_snowflake_issuer_url")

    @property
    @pulumi.getter(name="saml2SnowflakeMetadata")
    def saml2_snowflake_metadata(self) -> pulumi.Output[str]:
        """
        Metadata created by Snowflake to provide to SAML2 provider.
        """
        return pulumi.get(self, "saml2_snowflake_metadata")

    @property
    @pulumi.getter(name="saml2SnowflakeX509Cert")
    def saml2_snowflake_x509_cert(self) -> pulumi.Output[str]:
        """
        The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests. You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
        """
        return pulumi.get(self, "saml2_snowflake_x509_cert")

    @property
    @pulumi.getter(name="saml2SpInitiatedLoginPageLabel")
    def saml2_sp_initiated_login_page_label(self) -> pulumi.Output[Optional[str]]:
        """
        The string containing the label to display after the Log In With button on the login page.
        """
        return pulumi.get(self, "saml2_sp_initiated_login_page_label")

    @property
    @pulumi.getter(name="saml2SsoUrl")
    def saml2_sso_url(self) -> pulumi.Output[str]:
        """
        The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        """
        return pulumi.get(self, "saml2_sso_url")

    @property
    @pulumi.getter(name="saml2X509Cert")
    def saml2_x509_cert(self) -> pulumi.Output[str]:
        """
        The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        return pulumi.get(self, "saml2_x509_cert")

