# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SchemaArgs', 'Schema']

@pulumi.input_type
class SchemaArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 data_retention_days: Optional[pulumi.Input[int]] = None,
                 is_managed: Optional[pulumi.Input[bool]] = None,
                 is_transient: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['SchemaTagArgs']]]] = None):
        """
        The set of arguments for constructing a Schema resource.
        :param pulumi.Input[str] database: The database in which to create the schema.
        :param pulumi.Input[str] comment: Specifies a comment for the schema.
        :param pulumi.Input[int] data_retention_days: Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
        :param pulumi.Input[bool] is_managed: Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
        :param pulumi.Input[bool] is_transient: Specifies a schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        :param pulumi.Input[str] name: Specifies the identifier for the schema; must be unique for the database in which the schema is created.
        :param pulumi.Input[Sequence[pulumi.Input['SchemaTagArgs']]] tags: Definitions of a tag to associate with the resource.
        """
        pulumi.set(__self__, "database", database)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_retention_days is not None:
            pulumi.set(__self__, "data_retention_days", data_retention_days)
        if is_managed is not None:
            pulumi.set(__self__, "is_managed", is_managed)
        if is_transient is not None:
            pulumi.set(__self__, "is_transient", is_transient)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The database in which to create the schema.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the schema.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="dataRetentionDays")
    def data_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
        """
        return pulumi.get(self, "data_retention_days")

    @data_retention_days.setter
    def data_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_retention_days", value)

    @property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
        """
        return pulumi.get(self, "is_managed")

    @is_managed.setter
    def is_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_managed", value)

    @property
    @pulumi.getter(name="isTransient")
    def is_transient(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies a schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        """
        return pulumi.get(self, "is_transient")

    @is_transient.setter
    def is_transient(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_transient", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the schema; must be unique for the database in which the schema is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchemaTagArgs']]]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchemaTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SchemaState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 data_retention_days: Optional[pulumi.Input[int]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 is_managed: Optional[pulumi.Input[bool]] = None,
                 is_transient: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['SchemaTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering Schema resources.
        :param pulumi.Input[str] comment: Specifies a comment for the schema.
        :param pulumi.Input[int] data_retention_days: Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
        :param pulumi.Input[str] database: The database in which to create the schema.
        :param pulumi.Input[bool] is_managed: Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
        :param pulumi.Input[bool] is_transient: Specifies a schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        :param pulumi.Input[str] name: Specifies the identifier for the schema; must be unique for the database in which the schema is created.
        :param pulumi.Input[Sequence[pulumi.Input['SchemaTagArgs']]] tags: Definitions of a tag to associate with the resource.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_retention_days is not None:
            pulumi.set(__self__, "data_retention_days", data_retention_days)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if is_managed is not None:
            pulumi.set(__self__, "is_managed", is_managed)
        if is_transient is not None:
            pulumi.set(__self__, "is_transient", is_transient)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the schema.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="dataRetentionDays")
    def data_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
        """
        return pulumi.get(self, "data_retention_days")

    @data_retention_days.setter
    def data_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_retention_days", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The database in which to create the schema.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
        """
        return pulumi.get(self, "is_managed")

    @is_managed.setter
    def is_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_managed", value)

    @property
    @pulumi.getter(name="isTransient")
    def is_transient(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies a schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        """
        return pulumi.get(self, "is_transient")

    @is_transient.setter
    def is_transient(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_transient", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the schema; must be unique for the database in which the schema is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchemaTagArgs']]]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchemaTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Schema(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 data_retention_days: Optional[pulumi.Input[int]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 is_managed: Optional[pulumi.Input[bool]] = None,
                 is_transient: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SchemaTagArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        schema = snowflake.Schema("schema",
            comment="A schema.",
            data_retention_days=1,
            database="database",
            is_managed=False,
            is_transient=False)
        ```

        ## Import

        format is dbName | schemaName

        ```sh
         $ pulumi import snowflake:index/schema:Schema example 'dbName|schemaName'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: Specifies a comment for the schema.
        :param pulumi.Input[int] data_retention_days: Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
        :param pulumi.Input[str] database: The database in which to create the schema.
        :param pulumi.Input[bool] is_managed: Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
        :param pulumi.Input[bool] is_transient: Specifies a schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        :param pulumi.Input[str] name: Specifies the identifier for the schema; must be unique for the database in which the schema is created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SchemaTagArgs']]]] tags: Definitions of a tag to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        schema = snowflake.Schema("schema",
            comment="A schema.",
            data_retention_days=1,
            database="database",
            is_managed=False,
            is_transient=False)
        ```

        ## Import

        format is dbName | schemaName

        ```sh
         $ pulumi import snowflake:index/schema:Schema example 'dbName|schemaName'
        ```

        :param str resource_name: The name of the resource.
        :param SchemaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 data_retention_days: Optional[pulumi.Input[int]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 is_managed: Optional[pulumi.Input[bool]] = None,
                 is_transient: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SchemaTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaArgs.__new__(SchemaArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["data_retention_days"] = data_retention_days
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["is_managed"] = is_managed
            __props__.__dict__["is_transient"] = is_transient
            __props__.__dict__["name"] = name
            if tags is not None and not opts.urn:
                warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
                pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
            __props__.__dict__["tags"] = tags
        super(Schema, __self__).__init__(
            'snowflake:index/schema:Schema',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[str]] = None,
            data_retention_days: Optional[pulumi.Input[int]] = None,
            database: Optional[pulumi.Input[str]] = None,
            is_managed: Optional[pulumi.Input[bool]] = None,
            is_transient: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SchemaTagArgs']]]]] = None) -> 'Schema':
        """
        Get an existing Schema resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: Specifies a comment for the schema.
        :param pulumi.Input[int] data_retention_days: Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
        :param pulumi.Input[str] database: The database in which to create the schema.
        :param pulumi.Input[bool] is_managed: Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
        :param pulumi.Input[bool] is_transient: Specifies a schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        :param pulumi.Input[str] name: Specifies the identifier for the schema; must be unique for the database in which the schema is created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SchemaTagArgs']]]] tags: Definitions of a tag to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchemaState.__new__(_SchemaState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["data_retention_days"] = data_retention_days
        __props__.__dict__["database"] = database
        __props__.__dict__["is_managed"] = is_managed
        __props__.__dict__["is_transient"] = is_transient
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return Schema(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a comment for the schema.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="dataRetentionDays")
    def data_retention_days(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
        """
        return pulumi.get(self, "data_retention_days")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        The database in which to create the schema.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
        """
        return pulumi.get(self, "is_managed")

    @property
    @pulumi.getter(name="isTransient")
    def is_transient(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies a schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        """
        return pulumi.get(self, "is_transient")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the identifier for the schema; must be unique for the database in which the schema is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.SchemaTag']]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

