# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TagMaskingPolicyAssociationArgs', 'TagMaskingPolicyAssociation']

@pulumi.input_type
class TagMaskingPolicyAssociationArgs:
    def __init__(__self__, *,
                 masking_policy_id: pulumi.Input[str],
                 tag_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a TagMaskingPolicyAssociation resource.
        :param pulumi.Input[str] masking_policy_id: The resource id of the masking policy
        :param pulumi.Input[str] tag_id: Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
        """
        pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        pulumi.set(__self__, "tag_id", tag_id)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> pulumi.Input[str]:
        """
        The resource id of the masking policy
        """
        return pulumi.get(self, "masking_policy_id")

    @masking_policy_id.setter
    def masking_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "masking_policy_id", value)

    @property
    @pulumi.getter(name="tagId")
    def tag_id(self) -> pulumi.Input[str]:
        """
        Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
        """
        return pulumi.get(self, "tag_id")

    @tag_id.setter
    def tag_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tag_id", value)


@pulumi.input_type
class _TagMaskingPolicyAssociationState:
    def __init__(__self__, *,
                 masking_policy_id: Optional[pulumi.Input[str]] = None,
                 tag_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TagMaskingPolicyAssociation resources.
        :param pulumi.Input[str] masking_policy_id: The resource id of the masking policy
        :param pulumi.Input[str] tag_id: Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
        """
        if masking_policy_id is not None:
            pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if tag_id is not None:
            pulumi.set(__self__, "tag_id", tag_id)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the masking policy
        """
        return pulumi.get(self, "masking_policy_id")

    @masking_policy_id.setter
    def masking_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "masking_policy_id", value)

    @property
    @pulumi.getter(name="tagId")
    def tag_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
        """
        return pulumi.get(self, "tag_id")

    @tag_id.setter
    def tag_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_id", value)


class TagMaskingPolicyAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 masking_policy_id: Optional[pulumi.Input[str]] = None,
                 tag_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Attach a masking policy to a tag. Requires a current warehouse to be set. Either with SNOWFLAKE_WAREHOUSE env variable or in current session. If no warehouse is provided, a temporary warehouse will be created.

        ## Import

        format is tag database name | tag schema name | tag name | masking policy database | masking policy schema | masking policy name

        ```sh
         $ pulumi import snowflake:index/tagMaskingPolicyAssociation:TagMaskingPolicyAssociation example 'tag_db|tag_schema|tag_name|mp_db|mp_schema|mp_name'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] masking_policy_id: The resource id of the masking policy
        :param pulumi.Input[str] tag_id: Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagMaskingPolicyAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attach a masking policy to a tag. Requires a current warehouse to be set. Either with SNOWFLAKE_WAREHOUSE env variable or in current session. If no warehouse is provided, a temporary warehouse will be created.

        ## Import

        format is tag database name | tag schema name | tag name | masking policy database | masking policy schema | masking policy name

        ```sh
         $ pulumi import snowflake:index/tagMaskingPolicyAssociation:TagMaskingPolicyAssociation example 'tag_db|tag_schema|tag_name|mp_db|mp_schema|mp_name'
        ```

        :param str resource_name: The name of the resource.
        :param TagMaskingPolicyAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagMaskingPolicyAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 masking_policy_id: Optional[pulumi.Input[str]] = None,
                 tag_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagMaskingPolicyAssociationArgs.__new__(TagMaskingPolicyAssociationArgs)

            if masking_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'masking_policy_id'")
            __props__.__dict__["masking_policy_id"] = masking_policy_id
            if tag_id is None and not opts.urn:
                raise TypeError("Missing required property 'tag_id'")
            __props__.__dict__["tag_id"] = tag_id
        super(TagMaskingPolicyAssociation, __self__).__init__(
            'snowflake:index/tagMaskingPolicyAssociation:TagMaskingPolicyAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            masking_policy_id: Optional[pulumi.Input[str]] = None,
            tag_id: Optional[pulumi.Input[str]] = None) -> 'TagMaskingPolicyAssociation':
        """
        Get an existing TagMaskingPolicyAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] masking_policy_id: The resource id of the masking policy
        :param pulumi.Input[str] tag_id: Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagMaskingPolicyAssociationState.__new__(_TagMaskingPolicyAssociationState)

        __props__.__dict__["masking_policy_id"] = masking_policy_id
        __props__.__dict__["tag_id"] = tag_id
        return TagMaskingPolicyAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> pulumi.Output[str]:
        """
        The resource id of the masking policy
        """
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter(name="tagId")
    def tag_id(self) -> pulumi.Output[str]:
        """
        Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
        """
        return pulumi.get(self, "tag_id")

