# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TaskArgs', 'Task']

@pulumi.input_type
class TaskArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[str],
                 schema: pulumi.Input[str],
                 sql_statement: pulumi.Input[str],
                 afters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_overlapping_execution: Optional[pulumi.Input[bool]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 error_integration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 session_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[str]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[int]] = None,
                 warehouse: Optional[pulumi.Input[str]] = None,
                 when: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Task resource.
        :param pulumi.Input[str] database: The database in which to create the task.
        :param pulumi.Input[str] schema: The schema in which to create the task.
        :param pulumi.Input[str] sql_statement: Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] afters: Specifies one or more predecessor tasks for the current task. Use this option to create a DAG of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies.
        :param pulumi.Input[bool] allow_overlapping_execution: By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap.
        :param pulumi.Input[str] comment: Specifies a comment for the task.
        :param pulumi.Input[bool] enabled: Specifies if the task should be started (enabled) after creation or should remain suspended (default).
        :param pulumi.Input[str] error_integration: Specifies the name of the notification integration used for error notifications.
        :param pulumi.Input[str] name: Specifies the identifier for the task; must be unique for the database and schema in which the task is created.
        :param pulumi.Input[str] schedule: The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] session_parameters: Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
        :param pulumi.Input[str] user_task_managed_initial_warehouse_size: Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
        :param pulumi.Input[int] user_task_timeout_ms: Specifies the time limit on a single run of the task before it times out (in milliseconds).
        :param pulumi.Input[str] warehouse: The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user*task*managed*initial*warehouse_size)
        :param pulumi.Input[str] when: Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "sql_statement", sql_statement)
        if afters is not None:
            pulumi.set(__self__, "afters", afters)
        if allow_overlapping_execution is not None:
            pulumi.set(__self__, "allow_overlapping_execution", allow_overlapping_execution)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if error_integration is not None:
            pulumi.set(__self__, "error_integration", error_integration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if session_parameters is not None:
            pulumi.set(__self__, "session_parameters", session_parameters)
        if user_task_managed_initial_warehouse_size is not None:
            pulumi.set(__self__, "user_task_managed_initial_warehouse_size", user_task_managed_initial_warehouse_size)
        if user_task_timeout_ms is not None:
            pulumi.set(__self__, "user_task_timeout_ms", user_task_timeout_ms)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)
        if when is not None:
            pulumi.set(__self__, "when", when)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The database in which to create the task.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[str]:
        """
        The schema in which to create the task.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="sqlStatement")
    def sql_statement(self) -> pulumi.Input[str]:
        """
        Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        """
        return pulumi.get(self, "sql_statement")

    @sql_statement.setter
    def sql_statement(self, value: pulumi.Input[str]):
        pulumi.set(self, "sql_statement", value)

    @property
    @pulumi.getter
    def afters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies one or more predecessor tasks for the current task. Use this option to create a DAG of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies.
        """
        return pulumi.get(self, "afters")

    @afters.setter
    def afters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "afters", value)

    @property
    @pulumi.getter(name="allowOverlappingExecution")
    def allow_overlapping_execution(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap.
        """
        return pulumi.get(self, "allow_overlapping_execution")

    @allow_overlapping_execution.setter
    def allow_overlapping_execution(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_overlapping_execution", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the task.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the task should be started (enabled) after creation or should remain suspended (default).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="errorIntegration")
    def error_integration(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the notification integration used for error notifications.
        """
        return pulumi.get(self, "error_integration")

    @error_integration.setter
    def error_integration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_integration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the task; must be unique for the database and schema in which the task is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after)
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="sessionParameters")
    def session_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
        """
        return pulumi.get(self, "session_parameters")

    @session_parameters.setter
    def session_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "session_parameters", value)

    @property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @user_task_managed_initial_warehouse_size.setter
    def user_task_managed_initial_warehouse_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_task_managed_initial_warehouse_size", value)

    @property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the time limit on a single run of the task before it times out (in milliseconds).
        """
        return pulumi.get(self, "user_task_timeout_ms")

    @user_task_timeout_ms.setter
    def user_task_timeout_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_task_timeout_ms", value)

    @property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[str]]:
        """
        The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user*task*managed*initial*warehouse_size)
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse", value)

    @property
    @pulumi.getter
    def when(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
        """
        return pulumi.get(self, "when")

    @when.setter
    def when(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "when", value)


@pulumi.input_type
class _TaskState:
    def __init__(__self__, *,
                 afters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_overlapping_execution: Optional[pulumi.Input[bool]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 error_integration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 session_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sql_statement: Optional[pulumi.Input[str]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[str]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[int]] = None,
                 warehouse: Optional[pulumi.Input[str]] = None,
                 when: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Task resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] afters: Specifies one or more predecessor tasks for the current task. Use this option to create a DAG of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies.
        :param pulumi.Input[bool] allow_overlapping_execution: By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap.
        :param pulumi.Input[str] comment: Specifies a comment for the task.
        :param pulumi.Input[str] database: The database in which to create the task.
        :param pulumi.Input[bool] enabled: Specifies if the task should be started (enabled) after creation or should remain suspended (default).
        :param pulumi.Input[str] error_integration: Specifies the name of the notification integration used for error notifications.
        :param pulumi.Input[str] name: Specifies the identifier for the task; must be unique for the database and schema in which the task is created.
        :param pulumi.Input[str] schedule: The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after)
        :param pulumi.Input[str] schema: The schema in which to create the task.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] session_parameters: Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
        :param pulumi.Input[str] sql_statement: Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        :param pulumi.Input[str] user_task_managed_initial_warehouse_size: Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
        :param pulumi.Input[int] user_task_timeout_ms: Specifies the time limit on a single run of the task before it times out (in milliseconds).
        :param pulumi.Input[str] warehouse: The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user*task*managed*initial*warehouse_size)
        :param pulumi.Input[str] when: Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
        """
        if afters is not None:
            pulumi.set(__self__, "afters", afters)
        if allow_overlapping_execution is not None:
            pulumi.set(__self__, "allow_overlapping_execution", allow_overlapping_execution)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if error_integration is not None:
            pulumi.set(__self__, "error_integration", error_integration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if session_parameters is not None:
            pulumi.set(__self__, "session_parameters", session_parameters)
        if sql_statement is not None:
            pulumi.set(__self__, "sql_statement", sql_statement)
        if user_task_managed_initial_warehouse_size is not None:
            pulumi.set(__self__, "user_task_managed_initial_warehouse_size", user_task_managed_initial_warehouse_size)
        if user_task_timeout_ms is not None:
            pulumi.set(__self__, "user_task_timeout_ms", user_task_timeout_ms)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)
        if when is not None:
            pulumi.set(__self__, "when", when)

    @property
    @pulumi.getter
    def afters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies one or more predecessor tasks for the current task. Use this option to create a DAG of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies.
        """
        return pulumi.get(self, "afters")

    @afters.setter
    def afters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "afters", value)

    @property
    @pulumi.getter(name="allowOverlappingExecution")
    def allow_overlapping_execution(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap.
        """
        return pulumi.get(self, "allow_overlapping_execution")

    @allow_overlapping_execution.setter
    def allow_overlapping_execution(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_overlapping_execution", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comment for the task.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The database in which to create the task.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the task should be started (enabled) after creation or should remain suspended (default).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="errorIntegration")
    def error_integration(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the notification integration used for error notifications.
        """
        return pulumi.get(self, "error_integration")

    @error_integration.setter
    def error_integration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_integration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier for the task; must be unique for the database and schema in which the task is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after)
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        The schema in which to create the task.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="sessionParameters")
    def session_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
        """
        return pulumi.get(self, "session_parameters")

    @session_parameters.setter
    def session_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "session_parameters", value)

    @property
    @pulumi.getter(name="sqlStatement")
    def sql_statement(self) -> Optional[pulumi.Input[str]]:
        """
        Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        """
        return pulumi.get(self, "sql_statement")

    @sql_statement.setter
    def sql_statement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_statement", value)

    @property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @user_task_managed_initial_warehouse_size.setter
    def user_task_managed_initial_warehouse_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_task_managed_initial_warehouse_size", value)

    @property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the time limit on a single run of the task before it times out (in milliseconds).
        """
        return pulumi.get(self, "user_task_timeout_ms")

    @user_task_timeout_ms.setter
    def user_task_timeout_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_task_timeout_ms", value)

    @property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[str]]:
        """
        The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user*task*managed*initial*warehouse_size)
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse", value)

    @property
    @pulumi.getter
    def when(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
        """
        return pulumi.get(self, "when")

    @when.setter
    def when(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "when", value)


class Task(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 afters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_overlapping_execution: Optional[pulumi.Input[bool]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 error_integration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 session_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sql_statement: Optional[pulumi.Input[str]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[str]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[int]] = None,
                 warehouse: Optional[pulumi.Input[str]] = None,
                 when: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        task = snowflake.Task("task",
            comment="my task",
            database="database",
            schema="schema",
            warehouse="warehouse",
            schedule="10 MINUTE",
            sql_statement="select * from foo;",
            session_parameters={
                "foo": "bar",
            },
            user_task_timeout_ms=10000,
            afters="preceding_task",
            when="foo AND bar",
            enabled=True)
        serverless_task = snowflake.Task("serverlessTask",
            comment="my serverless task",
            database="db",
            schema="schema",
            schedule="10 MINUTE",
            sql_statement="select * from foo;",
            session_parameters={
                "foo": "bar",
            },
            user_task_timeout_ms=10000,
            user_task_managed_initial_warehouse_size="XSMALL",
            afters=[task.name],
            when="foo AND bar",
            enabled=True)
        test_task = snowflake.Task("testTask",
            comment="task with allow_overlapping_execution",
            database="database",
            schema="schema",
            sql_statement="select 1 as c;",
            allow_overlapping_execution=True,
            enabled=True)
        ```

        ## Import

        format is database name | schema name | task name

        ```sh
         $ pulumi import snowflake:index/task:Task example 'dbName|schemaName|taskName'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] afters: Specifies one or more predecessor tasks for the current task. Use this option to create a DAG of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies.
        :param pulumi.Input[bool] allow_overlapping_execution: By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap.
        :param pulumi.Input[str] comment: Specifies a comment for the task.
        :param pulumi.Input[str] database: The database in which to create the task.
        :param pulumi.Input[bool] enabled: Specifies if the task should be started (enabled) after creation or should remain suspended (default).
        :param pulumi.Input[str] error_integration: Specifies the name of the notification integration used for error notifications.
        :param pulumi.Input[str] name: Specifies the identifier for the task; must be unique for the database and schema in which the task is created.
        :param pulumi.Input[str] schedule: The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after)
        :param pulumi.Input[str] schema: The schema in which to create the task.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] session_parameters: Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
        :param pulumi.Input[str] sql_statement: Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        :param pulumi.Input[str] user_task_managed_initial_warehouse_size: Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
        :param pulumi.Input[int] user_task_timeout_ms: Specifies the time limit on a single run of the task before it times out (in milliseconds).
        :param pulumi.Input[str] warehouse: The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user*task*managed*initial*warehouse_size)
        :param pulumi.Input[str] when: Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        task = snowflake.Task("task",
            comment="my task",
            database="database",
            schema="schema",
            warehouse="warehouse",
            schedule="10 MINUTE",
            sql_statement="select * from foo;",
            session_parameters={
                "foo": "bar",
            },
            user_task_timeout_ms=10000,
            afters="preceding_task",
            when="foo AND bar",
            enabled=True)
        serverless_task = snowflake.Task("serverlessTask",
            comment="my serverless task",
            database="db",
            schema="schema",
            schedule="10 MINUTE",
            sql_statement="select * from foo;",
            session_parameters={
                "foo": "bar",
            },
            user_task_timeout_ms=10000,
            user_task_managed_initial_warehouse_size="XSMALL",
            afters=[task.name],
            when="foo AND bar",
            enabled=True)
        test_task = snowflake.Task("testTask",
            comment="task with allow_overlapping_execution",
            database="database",
            schema="schema",
            sql_statement="select 1 as c;",
            allow_overlapping_execution=True,
            enabled=True)
        ```

        ## Import

        format is database name | schema name | task name

        ```sh
         $ pulumi import snowflake:index/task:Task example 'dbName|schemaName|taskName'
        ```

        :param str resource_name: The name of the resource.
        :param TaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 afters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_overlapping_execution: Optional[pulumi.Input[bool]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 error_integration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 session_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sql_statement: Optional[pulumi.Input[str]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[str]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[int]] = None,
                 warehouse: Optional[pulumi.Input[str]] = None,
                 when: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskArgs.__new__(TaskArgs)

            __props__.__dict__["afters"] = afters
            __props__.__dict__["allow_overlapping_execution"] = allow_overlapping_execution
            __props__.__dict__["comment"] = comment
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["error_integration"] = error_integration
            __props__.__dict__["name"] = name
            __props__.__dict__["schedule"] = schedule
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["session_parameters"] = session_parameters
            if sql_statement is None and not opts.urn:
                raise TypeError("Missing required property 'sql_statement'")
            __props__.__dict__["sql_statement"] = sql_statement
            __props__.__dict__["user_task_managed_initial_warehouse_size"] = user_task_managed_initial_warehouse_size
            __props__.__dict__["user_task_timeout_ms"] = user_task_timeout_ms
            __props__.__dict__["warehouse"] = warehouse
            __props__.__dict__["when"] = when
        super(Task, __self__).__init__(
            'snowflake:index/task:Task',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            afters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allow_overlapping_execution: Optional[pulumi.Input[bool]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            error_integration: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            schedule: Optional[pulumi.Input[str]] = None,
            schema: Optional[pulumi.Input[str]] = None,
            session_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            sql_statement: Optional[pulumi.Input[str]] = None,
            user_task_managed_initial_warehouse_size: Optional[pulumi.Input[str]] = None,
            user_task_timeout_ms: Optional[pulumi.Input[int]] = None,
            warehouse: Optional[pulumi.Input[str]] = None,
            when: Optional[pulumi.Input[str]] = None) -> 'Task':
        """
        Get an existing Task resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] afters: Specifies one or more predecessor tasks for the current task. Use this option to create a DAG of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies.
        :param pulumi.Input[bool] allow_overlapping_execution: By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap.
        :param pulumi.Input[str] comment: Specifies a comment for the task.
        :param pulumi.Input[str] database: The database in which to create the task.
        :param pulumi.Input[bool] enabled: Specifies if the task should be started (enabled) after creation or should remain suspended (default).
        :param pulumi.Input[str] error_integration: Specifies the name of the notification integration used for error notifications.
        :param pulumi.Input[str] name: Specifies the identifier for the task; must be unique for the database and schema in which the task is created.
        :param pulumi.Input[str] schedule: The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after)
        :param pulumi.Input[str] schema: The schema in which to create the task.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] session_parameters: Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
        :param pulumi.Input[str] sql_statement: Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        :param pulumi.Input[str] user_task_managed_initial_warehouse_size: Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
        :param pulumi.Input[int] user_task_timeout_ms: Specifies the time limit on a single run of the task before it times out (in milliseconds).
        :param pulumi.Input[str] warehouse: The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user*task*managed*initial*warehouse_size)
        :param pulumi.Input[str] when: Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaskState.__new__(_TaskState)

        __props__.__dict__["afters"] = afters
        __props__.__dict__["allow_overlapping_execution"] = allow_overlapping_execution
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database"] = database
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["error_integration"] = error_integration
        __props__.__dict__["name"] = name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["schema"] = schema
        __props__.__dict__["session_parameters"] = session_parameters
        __props__.__dict__["sql_statement"] = sql_statement
        __props__.__dict__["user_task_managed_initial_warehouse_size"] = user_task_managed_initial_warehouse_size
        __props__.__dict__["user_task_timeout_ms"] = user_task_timeout_ms
        __props__.__dict__["warehouse"] = warehouse
        __props__.__dict__["when"] = when
        return Task(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def afters(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies one or more predecessor tasks for the current task. Use this option to create a DAG of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies.
        """
        return pulumi.get(self, "afters")

    @property
    @pulumi.getter(name="allowOverlappingExecution")
    def allow_overlapping_execution(self) -> pulumi.Output[Optional[bool]]:
        """
        By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap.
        """
        return pulumi.get(self, "allow_overlapping_execution")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a comment for the task.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        The database in which to create the task.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if the task should be started (enabled) after creation or should remain suspended (default).
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="errorIntegration")
    def error_integration(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the name of the notification integration used for error notifications.
        """
        return pulumi.get(self, "error_integration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the identifier for the task; must be unique for the database and schema in which the task is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional[str]]:
        """
        The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after)
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[str]:
        """
        The schema in which to create the task.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="sessionParameters")
    def session_parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
        """
        return pulumi.get(self, "session_parameters")

    @property
    @pulumi.getter(name="sqlStatement")
    def sql_statement(self) -> pulumi.Output[str]:
        """
        Any single SQL statement, or a call to a stored procedure, executed when the task runs.
        """
        return pulumi.get(self, "sql_statement")

    @property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the time limit on a single run of the task before it times out (in milliseconds).
        """
        return pulumi.get(self, "user_task_timeout_ms")

    @property
    @pulumi.getter
    def warehouse(self) -> pulumi.Output[Optional[str]]:
        """
        The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user*task*managed*initial*warehouse_size)
        """
        return pulumi.get(self, "warehouse")

    @property
    @pulumi.getter
    def when(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
        """
        return pulumi.get(self, "when")

