# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['WarehouseArgs', 'Warehouse']

@pulumi.input_type
class WarehouseArgs:
    def __init__(__self__, *,
                 auto_resume: Optional[pulumi.Input[bool]] = None,
                 auto_suspend: Optional[pulumi.Input[int]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 enable_query_acceleration: Optional[pulumi.Input[bool]] = None,
                 initially_suspended: Optional[pulumi.Input[bool]] = None,
                 max_cluster_count: Optional[pulumi.Input[int]] = None,
                 max_concurrency_level: Optional[pulumi.Input[int]] = None,
                 min_cluster_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_acceleration_max_scale_factor: Optional[pulumi.Input[int]] = None,
                 resource_monitor: Optional[pulumi.Input[str]] = None,
                 scaling_policy: Optional[pulumi.Input[str]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 wait_for_provisioning: Optional[pulumi.Input[bool]] = None,
                 warehouse_size: Optional[pulumi.Input[str]] = None,
                 warehouse_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Warehouse resource.
        :param pulumi.Input[bool] auto_resume: Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
        :param pulumi.Input[int] auto_suspend: Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        :param pulumi.Input[bool] enable_query_acceleration: Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources.
        :param pulumi.Input[bool] initially_suspended: Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        :param pulumi.Input[int] max_cluster_count: Specifies the maximum number of server clusters for the warehouse.
        :param pulumi.Input[int] max_concurrency_level: Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        :param pulumi.Input[int] min_cluster_count: Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        :param pulumi.Input[str] name: Identifier for the virtual warehouse; must be unique for your account.
        :param pulumi.Input[int] query_acceleration_max_scale_factor: Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        :param pulumi.Input[str] resource_monitor: Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
        :param pulumi.Input[str] scaling_policy: Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
        :param pulumi.Input[int] statement_queued_timeout_in_seconds: Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        :param pulumi.Input[int] statement_timeout_in_seconds: Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        :param pulumi.Input[bool] wait_for_provisioning: Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
        :param pulumi.Input[str] warehouse_size: Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
        :param pulumi.Input[str] warehouse_type: Specifies a STANDARD or SNOWPARK-OPTIMIZED warehouse
        """
        if auto_resume is not None:
            pulumi.set(__self__, "auto_resume", auto_resume)
        if auto_suspend is not None:
            pulumi.set(__self__, "auto_suspend", auto_suspend)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enable_query_acceleration is not None:
            pulumi.set(__self__, "enable_query_acceleration", enable_query_acceleration)
        if initially_suspended is not None:
            pulumi.set(__self__, "initially_suspended", initially_suspended)
        if max_cluster_count is not None:
            pulumi.set(__self__, "max_cluster_count", max_cluster_count)
        if max_concurrency_level is not None:
            pulumi.set(__self__, "max_concurrency_level", max_concurrency_level)
        if min_cluster_count is not None:
            pulumi.set(__self__, "min_cluster_count", min_cluster_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_acceleration_max_scale_factor is not None:
            pulumi.set(__self__, "query_acceleration_max_scale_factor", query_acceleration_max_scale_factor)
        if resource_monitor is not None:
            pulumi.set(__self__, "resource_monitor", resource_monitor)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if statement_queued_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_queued_timeout_in_seconds", statement_queued_timeout_in_seconds)
        if statement_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_timeout_in_seconds", statement_timeout_in_seconds)
        if wait_for_provisioning is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major version of the provider. It doesn't do anything and should be removed from your configuration.""", DeprecationWarning)
            pulumi.log.warn("""wait_for_provisioning is deprecated: This field is deprecated and will be removed in the next major version of the provider. It doesn't do anything and should be removed from your configuration.""")
        if wait_for_provisioning is not None:
            pulumi.set(__self__, "wait_for_provisioning", wait_for_provisioning)
        if warehouse_size is not None:
            pulumi.set(__self__, "warehouse_size", warehouse_size)
        if warehouse_type is not None:
            pulumi.set(__self__, "warehouse_type", warehouse_type)

    @property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
        """
        return pulumi.get(self, "auto_resume")

    @auto_resume.setter
    def auto_resume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_resume", value)

    @property
    @pulumi.getter(name="autoSuspend")
    def auto_suspend(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        """
        return pulumi.get(self, "auto_suspend")

    @auto_suspend.setter
    def auto_suspend(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_suspend", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="enableQueryAcceleration")
    def enable_query_acceleration(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources.
        """
        return pulumi.get(self, "enable_query_acceleration")

    @enable_query_acceleration.setter
    def enable_query_acceleration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_query_acceleration", value)

    @property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        """
        return pulumi.get(self, "initially_suspended")

    @initially_suspended.setter
    def initially_suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "initially_suspended", value)

    @property
    @pulumi.getter(name="maxClusterCount")
    def max_cluster_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of server clusters for the warehouse.
        """
        return pulumi.get(self, "max_cluster_count")

    @max_cluster_count.setter
    def max_cluster_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cluster_count", value)

    @property
    @pulumi.getter(name="maxConcurrencyLevel")
    def max_concurrency_level(self) -> Optional[pulumi.Input[int]]:
        """
        Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        """
        return pulumi.get(self, "max_concurrency_level")

    @max_concurrency_level.setter
    def max_concurrency_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrency_level", value)

    @property
    @pulumi.getter(name="minClusterCount")
    def min_cluster_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        """
        return pulumi.get(self, "min_cluster_count")

    @min_cluster_count.setter
    def min_cluster_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_cluster_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the virtual warehouse; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="queryAccelerationMaxScaleFactor")
    def query_acceleration_max_scale_factor(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        """
        return pulumi.get(self, "query_acceleration_max_scale_factor")

    @query_acceleration_max_scale_factor.setter
    def query_acceleration_max_scale_factor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_acceleration_max_scale_factor", value)

    @property
    @pulumi.getter(name="resourceMonitor")
    def resource_monitor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
        """
        return pulumi.get(self, "resource_monitor")

    @resource_monitor.setter
    def resource_monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_monitor", value)

    @property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy", value)

    @property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @statement_queued_timeout_in_seconds.setter
    def statement_queued_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "statement_queued_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @statement_timeout_in_seconds.setter
    def statement_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "statement_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="waitForProvisioning")
    def wait_for_provisioning(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
        """
        return pulumi.get(self, "wait_for_provisioning")

    @wait_for_provisioning.setter
    def wait_for_provisioning(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_provisioning", value)

    @property
    @pulumi.getter(name="warehouseSize")
    def warehouse_size(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
        """
        return pulumi.get(self, "warehouse_size")

    @warehouse_size.setter
    def warehouse_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse_size", value)

    @property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a STANDARD or SNOWPARK-OPTIMIZED warehouse
        """
        return pulumi.get(self, "warehouse_type")

    @warehouse_type.setter
    def warehouse_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse_type", value)


@pulumi.input_type
class _WarehouseState:
    def __init__(__self__, *,
                 auto_resume: Optional[pulumi.Input[bool]] = None,
                 auto_suspend: Optional[pulumi.Input[int]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 enable_query_acceleration: Optional[pulumi.Input[bool]] = None,
                 initially_suspended: Optional[pulumi.Input[bool]] = None,
                 max_cluster_count: Optional[pulumi.Input[int]] = None,
                 max_concurrency_level: Optional[pulumi.Input[int]] = None,
                 min_cluster_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_acceleration_max_scale_factor: Optional[pulumi.Input[int]] = None,
                 resource_monitor: Optional[pulumi.Input[str]] = None,
                 scaling_policy: Optional[pulumi.Input[str]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 wait_for_provisioning: Optional[pulumi.Input[bool]] = None,
                 warehouse_size: Optional[pulumi.Input[str]] = None,
                 warehouse_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Warehouse resources.
        :param pulumi.Input[bool] auto_resume: Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
        :param pulumi.Input[int] auto_suspend: Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        :param pulumi.Input[bool] enable_query_acceleration: Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources.
        :param pulumi.Input[bool] initially_suspended: Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        :param pulumi.Input[int] max_cluster_count: Specifies the maximum number of server clusters for the warehouse.
        :param pulumi.Input[int] max_concurrency_level: Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        :param pulumi.Input[int] min_cluster_count: Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        :param pulumi.Input[str] name: Identifier for the virtual warehouse; must be unique for your account.
        :param pulumi.Input[int] query_acceleration_max_scale_factor: Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        :param pulumi.Input[str] resource_monitor: Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
        :param pulumi.Input[str] scaling_policy: Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
        :param pulumi.Input[int] statement_queued_timeout_in_seconds: Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        :param pulumi.Input[int] statement_timeout_in_seconds: Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        :param pulumi.Input[bool] wait_for_provisioning: Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
        :param pulumi.Input[str] warehouse_size: Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
        :param pulumi.Input[str] warehouse_type: Specifies a STANDARD or SNOWPARK-OPTIMIZED warehouse
        """
        if auto_resume is not None:
            pulumi.set(__self__, "auto_resume", auto_resume)
        if auto_suspend is not None:
            pulumi.set(__self__, "auto_suspend", auto_suspend)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enable_query_acceleration is not None:
            pulumi.set(__self__, "enable_query_acceleration", enable_query_acceleration)
        if initially_suspended is not None:
            pulumi.set(__self__, "initially_suspended", initially_suspended)
        if max_cluster_count is not None:
            pulumi.set(__self__, "max_cluster_count", max_cluster_count)
        if max_concurrency_level is not None:
            pulumi.set(__self__, "max_concurrency_level", max_concurrency_level)
        if min_cluster_count is not None:
            pulumi.set(__self__, "min_cluster_count", min_cluster_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_acceleration_max_scale_factor is not None:
            pulumi.set(__self__, "query_acceleration_max_scale_factor", query_acceleration_max_scale_factor)
        if resource_monitor is not None:
            pulumi.set(__self__, "resource_monitor", resource_monitor)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if statement_queued_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_queued_timeout_in_seconds", statement_queued_timeout_in_seconds)
        if statement_timeout_in_seconds is not None:
            pulumi.set(__self__, "statement_timeout_in_seconds", statement_timeout_in_seconds)
        if wait_for_provisioning is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major version of the provider. It doesn't do anything and should be removed from your configuration.""", DeprecationWarning)
            pulumi.log.warn("""wait_for_provisioning is deprecated: This field is deprecated and will be removed in the next major version of the provider. It doesn't do anything and should be removed from your configuration.""")
        if wait_for_provisioning is not None:
            pulumi.set(__self__, "wait_for_provisioning", wait_for_provisioning)
        if warehouse_size is not None:
            pulumi.set(__self__, "warehouse_size", warehouse_size)
        if warehouse_type is not None:
            pulumi.set(__self__, "warehouse_type", warehouse_type)

    @property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
        """
        return pulumi.get(self, "auto_resume")

    @auto_resume.setter
    def auto_resume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_resume", value)

    @property
    @pulumi.getter(name="autoSuspend")
    def auto_suspend(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        """
        return pulumi.get(self, "auto_suspend")

    @auto_suspend.setter
    def auto_suspend(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_suspend", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="enableQueryAcceleration")
    def enable_query_acceleration(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources.
        """
        return pulumi.get(self, "enable_query_acceleration")

    @enable_query_acceleration.setter
    def enable_query_acceleration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_query_acceleration", value)

    @property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        """
        return pulumi.get(self, "initially_suspended")

    @initially_suspended.setter
    def initially_suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "initially_suspended", value)

    @property
    @pulumi.getter(name="maxClusterCount")
    def max_cluster_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of server clusters for the warehouse.
        """
        return pulumi.get(self, "max_cluster_count")

    @max_cluster_count.setter
    def max_cluster_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cluster_count", value)

    @property
    @pulumi.getter(name="maxConcurrencyLevel")
    def max_concurrency_level(self) -> Optional[pulumi.Input[int]]:
        """
        Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        """
        return pulumi.get(self, "max_concurrency_level")

    @max_concurrency_level.setter
    def max_concurrency_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrency_level", value)

    @property
    @pulumi.getter(name="minClusterCount")
    def min_cluster_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        """
        return pulumi.get(self, "min_cluster_count")

    @min_cluster_count.setter
    def min_cluster_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_cluster_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the virtual warehouse; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="queryAccelerationMaxScaleFactor")
    def query_acceleration_max_scale_factor(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        """
        return pulumi.get(self, "query_acceleration_max_scale_factor")

    @query_acceleration_max_scale_factor.setter
    def query_acceleration_max_scale_factor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_acceleration_max_scale_factor", value)

    @property
    @pulumi.getter(name="resourceMonitor")
    def resource_monitor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
        """
        return pulumi.get(self, "resource_monitor")

    @resource_monitor.setter
    def resource_monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_monitor", value)

    @property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy", value)

    @property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @statement_queued_timeout_in_seconds.setter
    def statement_queued_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "statement_queued_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @statement_timeout_in_seconds.setter
    def statement_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "statement_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="waitForProvisioning")
    def wait_for_provisioning(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
        """
        return pulumi.get(self, "wait_for_provisioning")

    @wait_for_provisioning.setter
    def wait_for_provisioning(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_provisioning", value)

    @property
    @pulumi.getter(name="warehouseSize")
    def warehouse_size(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
        """
        return pulumi.get(self, "warehouse_size")

    @warehouse_size.setter
    def warehouse_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse_size", value)

    @property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a STANDARD or SNOWPARK-OPTIMIZED warehouse
        """
        return pulumi.get(self, "warehouse_type")

    @warehouse_type.setter
    def warehouse_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse_type", value)


class Warehouse(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resume: Optional[pulumi.Input[bool]] = None,
                 auto_suspend: Optional[pulumi.Input[int]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 enable_query_acceleration: Optional[pulumi.Input[bool]] = None,
                 initially_suspended: Optional[pulumi.Input[bool]] = None,
                 max_cluster_count: Optional[pulumi.Input[int]] = None,
                 max_concurrency_level: Optional[pulumi.Input[int]] = None,
                 min_cluster_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_acceleration_max_scale_factor: Optional[pulumi.Input[int]] = None,
                 resource_monitor: Optional[pulumi.Input[str]] = None,
                 scaling_policy: Optional[pulumi.Input[str]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 wait_for_provisioning: Optional[pulumi.Input[bool]] = None,
                 warehouse_size: Optional[pulumi.Input[str]] = None,
                 warehouse_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        warehouse = snowflake.Warehouse("warehouse",
            comment="foo",
            warehouse_size="small")
        ```

        ## Import

        ```sh
         $ pulumi import snowflake:index/warehouse:Warehouse example warehouseName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_resume: Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
        :param pulumi.Input[int] auto_suspend: Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        :param pulumi.Input[bool] enable_query_acceleration: Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources.
        :param pulumi.Input[bool] initially_suspended: Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        :param pulumi.Input[int] max_cluster_count: Specifies the maximum number of server clusters for the warehouse.
        :param pulumi.Input[int] max_concurrency_level: Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        :param pulumi.Input[int] min_cluster_count: Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        :param pulumi.Input[str] name: Identifier for the virtual warehouse; must be unique for your account.
        :param pulumi.Input[int] query_acceleration_max_scale_factor: Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        :param pulumi.Input[str] resource_monitor: Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
        :param pulumi.Input[str] scaling_policy: Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
        :param pulumi.Input[int] statement_queued_timeout_in_seconds: Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        :param pulumi.Input[int] statement_timeout_in_seconds: Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        :param pulumi.Input[bool] wait_for_provisioning: Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
        :param pulumi.Input[str] warehouse_size: Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
        :param pulumi.Input[str] warehouse_type: Specifies a STANDARD or SNOWPARK-OPTIMIZED warehouse
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[WarehouseArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_snowflake as snowflake

        warehouse = snowflake.Warehouse("warehouse",
            comment="foo",
            warehouse_size="small")
        ```

        ## Import

        ```sh
         $ pulumi import snowflake:index/warehouse:Warehouse example warehouseName
        ```

        :param str resource_name: The name of the resource.
        :param WarehouseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WarehouseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resume: Optional[pulumi.Input[bool]] = None,
                 auto_suspend: Optional[pulumi.Input[int]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 enable_query_acceleration: Optional[pulumi.Input[bool]] = None,
                 initially_suspended: Optional[pulumi.Input[bool]] = None,
                 max_cluster_count: Optional[pulumi.Input[int]] = None,
                 max_concurrency_level: Optional[pulumi.Input[int]] = None,
                 min_cluster_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_acceleration_max_scale_factor: Optional[pulumi.Input[int]] = None,
                 resource_monitor: Optional[pulumi.Input[str]] = None,
                 scaling_policy: Optional[pulumi.Input[str]] = None,
                 statement_queued_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 statement_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 wait_for_provisioning: Optional[pulumi.Input[bool]] = None,
                 warehouse_size: Optional[pulumi.Input[str]] = None,
                 warehouse_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WarehouseArgs.__new__(WarehouseArgs)

            __props__.__dict__["auto_resume"] = auto_resume
            __props__.__dict__["auto_suspend"] = auto_suspend
            __props__.__dict__["comment"] = comment
            __props__.__dict__["enable_query_acceleration"] = enable_query_acceleration
            __props__.__dict__["initially_suspended"] = initially_suspended
            __props__.__dict__["max_cluster_count"] = max_cluster_count
            __props__.__dict__["max_concurrency_level"] = max_concurrency_level
            __props__.__dict__["min_cluster_count"] = min_cluster_count
            __props__.__dict__["name"] = name
            __props__.__dict__["query_acceleration_max_scale_factor"] = query_acceleration_max_scale_factor
            __props__.__dict__["resource_monitor"] = resource_monitor
            __props__.__dict__["scaling_policy"] = scaling_policy
            __props__.__dict__["statement_queued_timeout_in_seconds"] = statement_queued_timeout_in_seconds
            __props__.__dict__["statement_timeout_in_seconds"] = statement_timeout_in_seconds
            if wait_for_provisioning is not None and not opts.urn:
                warnings.warn("""This field is deprecated and will be removed in the next major version of the provider. It doesn't do anything and should be removed from your configuration.""", DeprecationWarning)
                pulumi.log.warn("""wait_for_provisioning is deprecated: This field is deprecated and will be removed in the next major version of the provider. It doesn't do anything and should be removed from your configuration.""")
            __props__.__dict__["wait_for_provisioning"] = wait_for_provisioning
            __props__.__dict__["warehouse_size"] = warehouse_size
            __props__.__dict__["warehouse_type"] = warehouse_type
        super(Warehouse, __self__).__init__(
            'snowflake:index/warehouse:Warehouse',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_resume: Optional[pulumi.Input[bool]] = None,
            auto_suspend: Optional[pulumi.Input[int]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            enable_query_acceleration: Optional[pulumi.Input[bool]] = None,
            initially_suspended: Optional[pulumi.Input[bool]] = None,
            max_cluster_count: Optional[pulumi.Input[int]] = None,
            max_concurrency_level: Optional[pulumi.Input[int]] = None,
            min_cluster_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            query_acceleration_max_scale_factor: Optional[pulumi.Input[int]] = None,
            resource_monitor: Optional[pulumi.Input[str]] = None,
            scaling_policy: Optional[pulumi.Input[str]] = None,
            statement_queued_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
            statement_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
            wait_for_provisioning: Optional[pulumi.Input[bool]] = None,
            warehouse_size: Optional[pulumi.Input[str]] = None,
            warehouse_type: Optional[pulumi.Input[str]] = None) -> 'Warehouse':
        """
        Get an existing Warehouse resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_resume: Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
        :param pulumi.Input[int] auto_suspend: Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        :param pulumi.Input[bool] enable_query_acceleration: Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources.
        :param pulumi.Input[bool] initially_suspended: Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        :param pulumi.Input[int] max_cluster_count: Specifies the maximum number of server clusters for the warehouse.
        :param pulumi.Input[int] max_concurrency_level: Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        :param pulumi.Input[int] min_cluster_count: Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        :param pulumi.Input[str] name: Identifier for the virtual warehouse; must be unique for your account.
        :param pulumi.Input[int] query_acceleration_max_scale_factor: Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        :param pulumi.Input[str] resource_monitor: Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
        :param pulumi.Input[str] scaling_policy: Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
        :param pulumi.Input[int] statement_queued_timeout_in_seconds: Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        :param pulumi.Input[int] statement_timeout_in_seconds: Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        :param pulumi.Input[bool] wait_for_provisioning: Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
        :param pulumi.Input[str] warehouse_size: Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
        :param pulumi.Input[str] warehouse_type: Specifies a STANDARD or SNOWPARK-OPTIMIZED warehouse
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WarehouseState.__new__(_WarehouseState)

        __props__.__dict__["auto_resume"] = auto_resume
        __props__.__dict__["auto_suspend"] = auto_suspend
        __props__.__dict__["comment"] = comment
        __props__.__dict__["enable_query_acceleration"] = enable_query_acceleration
        __props__.__dict__["initially_suspended"] = initially_suspended
        __props__.__dict__["max_cluster_count"] = max_cluster_count
        __props__.__dict__["max_concurrency_level"] = max_concurrency_level
        __props__.__dict__["min_cluster_count"] = min_cluster_count
        __props__.__dict__["name"] = name
        __props__.__dict__["query_acceleration_max_scale_factor"] = query_acceleration_max_scale_factor
        __props__.__dict__["resource_monitor"] = resource_monitor
        __props__.__dict__["scaling_policy"] = scaling_policy
        __props__.__dict__["statement_queued_timeout_in_seconds"] = statement_queued_timeout_in_seconds
        __props__.__dict__["statement_timeout_in_seconds"] = statement_timeout_in_seconds
        __props__.__dict__["wait_for_provisioning"] = wait_for_provisioning
        __props__.__dict__["warehouse_size"] = warehouse_size
        __props__.__dict__["warehouse_type"] = warehouse_type
        return Warehouse(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> pulumi.Output[bool]:
        """
        Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
        """
        return pulumi.get(self, "auto_resume")

    @property
    @pulumi.getter(name="autoSuspend")
    def auto_suspend(self) -> pulumi.Output[int]:
        """
        Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
        """
        return pulumi.get(self, "auto_suspend")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="enableQueryAcceleration")
    def enable_query_acceleration(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources.
        """
        return pulumi.get(self, "enable_query_acceleration")

    @property
    @pulumi.getter(name="initiallySuspended")
    def initially_suspended(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the warehouse is created initially in the ‘Suspended’ state.
        """
        return pulumi.get(self, "initially_suspended")

    @property
    @pulumi.getter(name="maxClusterCount")
    def max_cluster_count(self) -> pulumi.Output[int]:
        """
        Specifies the maximum number of server clusters for the warehouse.
        """
        return pulumi.get(self, "max_cluster_count")

    @property
    @pulumi.getter(name="maxConcurrencyLevel")
    def max_concurrency_level(self) -> pulumi.Output[Optional[int]]:
        """
        Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
        """
        return pulumi.get(self, "max_concurrency_level")

    @property
    @pulumi.getter(name="minClusterCount")
    def min_cluster_count(self) -> pulumi.Output[int]:
        """
        Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
        """
        return pulumi.get(self, "min_cluster_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Identifier for the virtual warehouse; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryAccelerationMaxScaleFactor")
    def query_acceleration_max_scale_factor(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
        """
        return pulumi.get(self, "query_acceleration_max_scale_factor")

    @property
    @pulumi.getter(name="resourceMonitor")
    def resource_monitor(self) -> pulumi.Output[str]:
        """
        Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
        """
        return pulumi.get(self, "resource_monitor")

    @property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> pulumi.Output[str]:
        """
        Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
        """
        return pulumi.get(self, "scaling_policy")

    @property
    @pulumi.getter(name="statementQueuedTimeoutInSeconds")
    def statement_queued_timeout_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
        """
        return pulumi.get(self, "statement_queued_timeout_in_seconds")

    @property
    @pulumi.getter(name="statementTimeoutInSeconds")
    def statement_timeout_in_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
        """
        return pulumi.get(self, "statement_timeout_in_seconds")

    @property
    @pulumi.getter(name="waitForProvisioning")
    def wait_for_provisioning(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
        """
        return pulumi.get(self, "wait_for_provisioning")

    @property
    @pulumi.getter(name="warehouseSize")
    def warehouse_size(self) -> pulumi.Output[str]:
        """
        Specifies the size of the virtual warehouse. Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
        """
        return pulumi.get(self, "warehouse_size")

    @property
    @pulumi.getter(name="warehouseType")
    def warehouse_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a STANDARD or SNOWPARK-OPTIMIZED warehouse
        """
        return pulumi.get(self, "warehouse_type")

