## ReferenceDataAccess
A python wrapper for accessing Reference data using RduAccess API's. 
To get more details on it, Please refer https://rduaccess.smartstreamrdu.com/getting-started

## RduAccess
RduAccess provides an easier way of accessing reference data over different asset type (Future, Options, Strategies, Equity, etc) using Rest Api, popularly known as RduAccess.

You can find all the api's at https://rduaccess.smartstreamrdu.com/. 
It also has a limited period free version for accessing the data.


## Purpose of ReferenceDataAccess
Accessing data from Rest API would typically involve below steps
* Call the respective rest api to fetch the json data
* Parse the Json Data and extract the required attributes 
* Use these attributes value to integrate it with your application.

RduAccess also provides rest api to fetch the data. However to integrate with your python application, you would also have to do above steps.

The intention of this library is to encapsulate all the above steps and give a simpler way of fetching the data from RduAccess into pandas dataframe. Once you have the data attributes in dataframe, you can easily integrate it with your application.


## Install
To install the package use:
```shell
pip install ReferenceDataAccess
```
Or install with pandas support, simply install pandas too:
```shell
pip install ReferenceDataAccess pandas
```
Note - Pandas version should be atleast 1.0.3 

## News
* From version 0.0.1.1, support to fetch reference data for Derivatives(Future, Options and Strategies) asset type .
* From version 0.0.1.3, added a method to get the output column's description, and the methods can now take an optional paramter, column_list, where you can specify the output column's.
* From version 0.0.3, added support to fetch reference data for Equity.

## Usage

# Etd - Derivative Data

To get data from the API, simply import the library and call the object with your API key. Next, get ready for some high quality reference data. 
You may get a key from https://rduaccess.smartstreamrdu.com/
```python
from dataAccess.EtdApi import EtdApi
etd = EtdApi(key="<<your key>>")

```
There are various api's through which data can be fetch
* Fetch By Isin
* Fetch By ticker and exchange code.
* Fetch By Isin along with underlying data

Example of fetch by isin.
Replace the isin with the isin for which data needs to be fetched
```
data = etd.get_by_isin(isin='ISIN')
```
 



Example of fetch by ticker and exchange code
```
dt = etd.get_by_ticker('ticker', 'exchange code') 
```

Example of fetch by isin along with underlying data - It fetches the etd data along with the underlying data
Replace the isin with the isin for which data needs to be fetched
```
data = etd.get_by_isin_with_underlier_data(isin='ISIN')
```



The above methods also has an option of passing an optional parameter column_list, where we can specify the list column's that we want in the output.
```
column_list = ['ct_exchCd','c_isin']
data = etd.get_by_isin(isin='ISIN', columnList= column_list)
```
In the above code, data will have two columns 'ct_exchCd','c_isin'



## Output Column Prefix and its description
The output dataframe has some column with prefix. Below is the description of the prefix

Prefix | Description
--- | --- 
ult_under 	| It means Ultimate Underlier. For OOF (Option on Future) Contracts, this will be the underlier of the future contract. For other contracts, these represent the actual underlier.
immed_under | It means immediate underlier. For OOF (Option on Future) Contracts, this will be option underlier i.e future contract. For other contracts, it will be null


## Output Column and its description
The output of above method is a pandas dataframe. Below is the list of column names and its description.

Column Name | Description
--- | --- 
actFl 	|	"Yes/No flag, indicating the active/inactive status of the contract's trading line: N = Indicates Inactive  Y = Indicates Active"
exchCd 	|	Exchange code of the session in where the security is trading.
lstngCycleTp 	|	"Listing cycle type. More specifically: Smallest unit of time between two or more contracts for a specific ETD product, provided that the ETD does not have an irregular listing cycle. Contracts from that same ETD product that initially are listed with a larger unit of time between them, but contain the same expiration date policy, are assumed to flow into that smallest unit of time and therefore, bear the same Listing Cycle Type as of their first listing date.For example, Options on Comex Gold futures at CMEG (OG) shall be listed for trading in each of the nearest twenty (20) consecutive futures contract months. In addition, June and December will be listed for 72 months from the current listed month. And therefore the listing cycle type is Monthly."
omic 	|	ISO 10383 operating MIC in case the Exchange Code is a segment MIC.
segTp 	|	Identifies the segment (venue) of the contract's trading line. Possible values are: Electronic, Pit , OTC or Composite.
smic 	|	ISO 10383 MIC in case the Exchange Code is a segment MIC
tckSz 	|	A contract's minimum price change
tckVal 	|	The value of a contract's minimum price change. 
trdStsTp 	|	Indicates whether the contract's trading line is active, inactive or expired.
vndrExchCd 	|	Vendor exchange code of the session in where the security is trading, and can return for all the sources the original exchange code value.
ticker	|	Exchange symbol (also known as Ticker or Trade Symbol) of contract.
bbgIdBBGlobal	|	The Bloomberg ID_BB_GLOBAL code of the contract.
bbgCompositeIdBbGlobal	|	The Bloomberg COMPOSITE_ID_BB_GLOBAL code of the contract.
gmiFullPrdCd	|	"GMI (Newedge Back Office System) ETD full product code constructed based on their three internal codes: - Exchange code; - ETD Product code;- Sub-type code."
clrngCd 	|	The code used by the exchanges for clearing for contracts from this product.
roundLotSz 	|	The minimum number of units from the product's contracts that can be traded on the exchange. 
trdCtyCd 	|	Trade currency of the contracts corresponding to this product.
trdCcyMajorFl 	|	Yes/No flag, indicating whether the trade currency is a major currency or not.
trdCcyCd 	|	Trade currency of the contracts corresponding to this product.
dayNum 	|	"In case the exchange provides different exchange prefixes for daily contracts, this attribute will provide the day code. Therefore for daily products, the day code (1 to 31) associated to the product contracts."
maxOrdSz 	|	The maximum size allowed under a single order in a contract from this product.
tckSzDnmntr 	|	When the tick size is expressed as a fraction, the fraction denominator (e.g. 32, for 1/32).
flexElgblFl 	|	Indicates whether the product is eligible for flex contracts.
clrngCcyCd 	|	Clearing currency of the contracts corresponding to this product.
msrmntUntCd 	|	Unit code in which contract size is specified. For example: Metric Tons, US Dollar, US Dollar cents, Million BTU's, etc.
tckSzNmrtr 	|	When the tick size is expressed as a fraction, the fraction numerator (e.g. 1, for 1/32).
spotMnthPosLmt 	|	Product Spot Month Position Limit. Position limit, or the maximum amount the trader may own or control, separately or in combination, net long or short, for the spot month, or the month when the contract reaches maturity and becomes deliverable.
mnthPosLmt 	|	Product Month Position Limit. Position limit, or the maximum amount the trader may own or control, for all contracts for a single month for this product.
allMnthPosLmt 	|	Product All Month Position Limit. Position limit, or the maximum amount the trader may own or control, netting as permitted by the regulator, for all contracts for this product.
blckTrdElgblFl 	|	Yes/No flag, indicating whether the product is eligible for block trades contracts.
exchRptngLvl 	|	Size of positions, in any single futures or option expiration month, set by the exchange at or above which commodity traders or brokers who carry these accounts must make daily reports about the entire position in all futures and options expiration months in that commodity, regardless of size. 
cftcRptngLvl 	|	Size of positions, in any single futures or option expiration month, set by the CFTC at or above which commodity traders or brokers who carry these accounts must make daily reports about the entire position in all futures and options expiration months in that commodity, regardless of size. 
trdStsTp 	|	Indicates whether the product is active or inactive.
cftcRegFl 	|	Yes/No Flag, identifying whether the trading venue is identified as a regulated market by the US Commoditiy Futures Trading Commission (CFTC).
undlRltnsTp 	|	"For derivative products in which the payoff of their contract is based on more than one price reference and/or underlying security.
assetTp 	|	Asset type classification of the contract, intended to be provided the most granular asset type classification where possible.
expDt 	|	The date on which the contract is no longer valid and ceases to exist.
lstTrdDt 	|	Last date that the contract is available for trade.   
settleDt 	|	Date on which payment is due to settle a trade.
frstDlvryDt 	|	The first date on which the underlying may be delivered into a futures contract. 
frstNtcDt 	|	The first day on which a notice of intent to deliver can be made by the clearinghouse to a buyer. 
lstDlvryDt 	|	The last date on which the underlying may be delivered into a futures contract. 
name 	|	The name of the contract.
vndrAssetTp 	|	Data vendor value of the asset type of the contract.
strikePx 	|	The strike price of the option contract.
cfi 	|	ISO 10962 (International Organization for Standardization) code 10962 which represents a standard classification of the features of a security.  The first character represents the category of the security, the second character represents the group of the security, and the third through sixth characters represent the attributes of the security. 
yrCd 	|	Contract period year code.
settleTp 	|	Indicates whether the product's contracts are cash settled or by physical delivery.
ctrSz 	|	The smallest available value of tradable contract. 
frstTrdDt 	|	The date a contract is first eligible to be traded.
settleFixDt 	|	"Date on which the value of the underlying is determined and used for final contract cash settlement.  For example, a Eurodollar futures on CMEG (GE), which has as underlying the 3-Months USD LIBOR, has a fixing date from the second London bank business day immediately preceding the third Wednesday of the contract?s month of delivery. "
numOfLegs 	|	Total number of legs applicable for this strategy.
accrlStrtDt 	|	The first date in which the divident accrual calculation begins for the dividend future.
accrlEndDt 	|	The last date in which the divident accrual calculation begins for the dividend future.
mnthCd 	|	Contract period month code.
dayNum 	|	Contract expiration day code.
pntVal 	|	"The value of one point (One point = Tick Value / Tick Size).  
flexFl 	|	Yes/No flag, indicating whether certain attributes of the contract is adjusted, in correspondence to the flex elgibility of the corresponding product.
actFl 	|	"Yes/No flag, indicating the active/inactive status of the contract:
wkNum 	|	Contract expiration week code.
lstNtcDt 	|	The final day on which a notice of intent to deliver on a contract may be issued.
trdStsTp 	|	Indicates whether the contract is active, inactive or expired.
cfiCd 	|	ISO 10962 (International Organization for Standardization) code 10962:2015 which represents a standard classification of the features of a security.  The first character represents the category of the security, the second character represents the group of the security, and the third through sixth characters represent the attributes of the security. 
isin 	|	The ISIN code .
bbgTicker 	|	"Bloomberg DataLicense TICKER:
bbgIdBbUnique 	|	Bloomberg ID_BB_UNIQUE code.



## Note 
If there are multiple underliers, then the column will be suffix by _1, _2 and so on. Contracts having only one underlier, the underlier data will be present against _1 column suffix.

# Equity Data

To get data from the API, simply import the library and call the object with your API key. Next, get ready for some high quality reference data. 
You may get a key from https://rduaccess.smartstreamrdu.com/
```python
from dataAccess.EquityApi import EquityApi
equity = EquityApi(key="<<your key>>")

```
There are various api's through which data can be fetch
* Fetch By Isin
* Fetch By Isin and exchange code


Example of fetch by isin.
Replace the isin with the isin for which data needs to be fetched
```
data = equity.get_by_isin(isin='ISIN')
```

Example of fetch by isin and exchangeCode.
Replace the isin and exchange code with the isin and exchange code for which data needs to be fetched
```
data = equity.get_by_isin(isin, exchange)
```






## Contributing
Contributing is always welcome. Just contact us on how best you can contribute, add an issue, or make a PR. 


## TODOs:
* Enhancing this library to provide access to other asset type like Equity,Fixed Income etc. 
* Adding support access to access data provided by Regulatory Service like MIFID II, SFTR, etc. 



## Star if you like it.
If you like or use this project, consider showing your support by starring it.


## Contact:
You can reach/follow us by mail
	