from metaflow import step, pypi, kubernetes
from obproject import ProjectFlow
from src.flow_templates import NeuralNetworkFlow
from src.step_decorators import smart_pypi


class CustomizedTrainingFlow(ProjectFlow, NeuralNetworkFlow):

    # @kubernetes(compute_pool='eddie-test')
    @smart_pypi
    @step
    def start(self):
        self._resolve_nn_config() # via NeuralNetworkFlow.
        self.next(self.end)

    @smart_pypi
    @step
    def end(self):
        # stdout should show your override value and another default value.
        print("Resolved config:", self.config)


if __name__ == "__main__":
    CustomizedTrainingFlow()
