import sys
from metaflow import StepMutator


class smart_pypi(StepMutator):

    '''
    Selectively add @pypi decorator based on the presence of @kubernetes decorator.
    Actively disable the step if it is run locally, to avoid reinstalling the packages 
    already installed using pip install -e .
    The only automatically added contents are those that match the /src module.
    Users interact with the same API as @pypi if they want to add extra packages.
    '''

    def init(self, *args, **kwargs):
        self.python = kwargs.get("python", "3.12")
        self.packages = kwargs.get("packages", {})
    
    def mutate(self, mutable_step):
        has_k8s_deco = False
        for s in mutable_step.decorator_specs:
            if s[0] == 'kubernetes':
                has_k8s_deco = True
                break
        if has_k8s_deco or 'kubernetes' in ' '.join(sys.argv) or 'argo-workflows' in ' '.join(sys.argv):
            packages = self.packages | {"min-obproject": "0.1.5"}
            mutable_step.add_decorator("pypi", deco_kwargs={"python": self.python, "packages": packages})
        else:
            mutable_step.add_decorator("pypi", deco_kwargs={"disabled": True})