"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.07
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.catalogue import Catalogue
from agilicus_api.model.catalogue_entry import CatalogueEntry
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_catalogue_entries_response import ListCatalogueEntriesResponse
from agilicus_api.model.list_catalogues_response import ListCataloguesResponse


class CataloguesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_catalogue(
            self,
            catalogue,
            **kwargs
        ):
            """create a catalogue  # noqa: E501

            create a catalogue  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_catalogue(catalogue, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue (Catalogue): Catalogue

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Catalogue
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue'] = \
                catalogue
            return self.call_with_http_info(**kwargs)

        if self.create_catalogue is None:
            self.create_catalogue = _Endpoint(
                settings={
                    'response_type': (Catalogue,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues',
                    'operation_id': 'create_catalogue',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue',
                    ],
                    'required': [
                        'catalogue',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue':
                            (Catalogue,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'catalogue': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_catalogue
            )

        def __create_catalogue_entry(
            self,
            catalogue_id,
            catalogue_entry,
            **kwargs
        ):
            """create a catalogue entry  # noqa: E501

            create a catalogue entry  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_catalogue_entry(catalogue_id, catalogue_entry, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue_id (str): catalogue_id path
                catalogue_entry (CatalogueEntry): CatalogueEntry

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CatalogueEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue_id'] = \
                catalogue_id
            kwargs['catalogue_entry'] = \
                catalogue_entry
            return self.call_with_http_info(**kwargs)

        if self.create_catalogue_entry is None:
            self.create_catalogue_entry = _Endpoint(
                settings={
                    'response_type': (CatalogueEntry,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues/{catalogue_id}/catalogue_entries',
                    'operation_id': 'create_catalogue_entry',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue_id',
                        'catalogue_entry',
                    ],
                    'required': [
                        'catalogue_id',
                        'catalogue_entry',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue_id':
                            (str,),
                        'catalogue_entry':
                            (CatalogueEntry,),
                    },
                    'attribute_map': {
                        'catalogue_id': 'catalogue_id',
                    },
                    'location_map': {
                        'catalogue_id': 'path',
                        'catalogue_entry': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_catalogue_entry
            )

        def __delete_catalogue(
            self,
            catalogue_id,
            **kwargs
        ):
            """Delete the catalogue specified by catalogue_id  # noqa: E501

            Delete the catalogue specified by catalogue_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_catalogue(catalogue_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue_id (str): catalogue_id path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue_id'] = \
                catalogue_id
            return self.call_with_http_info(**kwargs)

        if self.delete_catalogue is None:
            self.delete_catalogue = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues/{catalogue_id}',
                    'operation_id': 'delete_catalogue',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue_id',
                    ],
                    'required': [
                        'catalogue_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue_id':
                            (str,),
                    },
                    'attribute_map': {
                        'catalogue_id': 'catalogue_id',
                    },
                    'location_map': {
                        'catalogue_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_catalogue
            )

        def __delete_catalogue_entry(
            self,
            catalogue_id,
            catalogue_entry_id,
            **kwargs
        ):
            """Delete the catalogue specified by catalogue_entry_id  # noqa: E501

            Delete the catalogue specified by catalogue_entry_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_catalogue_entry(catalogue_id, catalogue_entry_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue_id (str): catalogue_id path
                catalogue_entry_id (str): catalogue_entry_id path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue_id'] = \
                catalogue_id
            kwargs['catalogue_entry_id'] = \
                catalogue_entry_id
            return self.call_with_http_info(**kwargs)

        if self.delete_catalogue_entry is None:
            self.delete_catalogue_entry = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id}',
                    'operation_id': 'delete_catalogue_entry',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue_id',
                        'catalogue_entry_id',
                    ],
                    'required': [
                        'catalogue_id',
                        'catalogue_entry_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue_id':
                            (str,),
                        'catalogue_entry_id':
                            (str,),
                    },
                    'attribute_map': {
                        'catalogue_id': 'catalogue_id',
                        'catalogue_entry_id': 'catalogue_entry_id',
                    },
                    'location_map': {
                        'catalogue_id': 'path',
                        'catalogue_entry_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_catalogue_entry
            )

        def __get_catalogue(
            self,
            catalogue_id,
            **kwargs
        ):
            """Get the catalogue specified by catalogue_id  # noqa: E501

            Get the catalogue specified by catalogue_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_catalogue(catalogue_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue_id (str): catalogue_id path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Catalogue
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue_id'] = \
                catalogue_id
            return self.call_with_http_info(**kwargs)

        if self.get_catalogue is None:
            self.get_catalogue = _Endpoint(
                settings={
                    'response_type': (Catalogue,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues/{catalogue_id}',
                    'operation_id': 'get_catalogue',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue_id',
                    ],
                    'required': [
                        'catalogue_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue_id':
                            (str,),
                    },
                    'attribute_map': {
                        'catalogue_id': 'catalogue_id',
                    },
                    'location_map': {
                        'catalogue_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_catalogue
            )

        def __get_catalogue_entry(
            self,
            catalogue_id,
            catalogue_entry_id,
            **kwargs
        ):
            """Get the catalogue entry by id for the given catalogue  # noqa: E501

            Get the catalogue entry by id for the given catalogue  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_catalogue_entry(catalogue_id, catalogue_entry_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue_id (str): catalogue_id path
                catalogue_entry_id (str): catalogue_entry_id path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CatalogueEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue_id'] = \
                catalogue_id
            kwargs['catalogue_entry_id'] = \
                catalogue_entry_id
            return self.call_with_http_info(**kwargs)

        if self.get_catalogue_entry is None:
            self.get_catalogue_entry = _Endpoint(
                settings={
                    'response_type': (CatalogueEntry,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id}',
                    'operation_id': 'get_catalogue_entry',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue_id',
                        'catalogue_entry_id',
                    ],
                    'required': [
                        'catalogue_id',
                        'catalogue_entry_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue_id':
                            (str,),
                        'catalogue_entry_id':
                            (str,),
                    },
                    'attribute_map': {
                        'catalogue_id': 'catalogue_id',
                        'catalogue_entry_id': 'catalogue_entry_id',
                    },
                    'location_map': {
                        'catalogue_id': 'path',
                        'catalogue_entry_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_catalogue_entry
            )

        def __list_all_catalogue_entries(
            self,
            **kwargs
        ):
            """List all catalogue entries independant of the catalogue they belong to  # noqa: E501

            List all catalogue entries independant of the catalogue they belong to  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_all_catalogue_entries(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                catalogue_entry_name (str): Query based on a catalogue entries name. [optional]
                catalogue_category (str): Query based on a catalogue's category. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListCatalogueEntriesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_all_catalogue_entries is None:
            self.list_all_catalogue_entries = _Endpoint(
                settings={
                    'response_type': (ListCatalogueEntriesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogue_entries',
                    'operation_id': 'list_all_catalogue_entries',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'catalogue_entry_name',
                        'catalogue_category',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'catalogue_entry_name':
                            (str,),
                        'catalogue_category':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'catalogue_entry_name': 'catalogue_entry_name',
                        'catalogue_category': 'catalogue_category',
                    },
                    'location_map': {
                        'limit': 'query',
                        'catalogue_entry_name': 'query',
                        'catalogue_category': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_all_catalogue_entries
            )

        def __list_catalogue_entries(
            self,
            catalogue_id,
            **kwargs
        ):
            """List catalogue entries in the catalogue  # noqa: E501

            List catalogue entries in the catalogue  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_catalogue_entries(catalogue_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue_id (str): catalogue_id path

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                catalogue_entry_name (str): Query based on a catalogue entries name. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListCatalogueEntriesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue_id'] = \
                catalogue_id
            return self.call_with_http_info(**kwargs)

        if self.list_catalogue_entries is None:
            self.list_catalogue_entries = _Endpoint(
                settings={
                    'response_type': (ListCatalogueEntriesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues/{catalogue_id}/catalogue_entries',
                    'operation_id': 'list_catalogue_entries',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue_id',
                        'limit',
                        'catalogue_entry_name',
                    ],
                    'required': [
                        'catalogue_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue_id':
                            (str,),
                        'limit':
                            (int,),
                        'catalogue_entry_name':
                            (str,),
                    },
                    'attribute_map': {
                        'catalogue_id': 'catalogue_id',
                        'limit': 'limit',
                        'catalogue_entry_name': 'catalogue_entry_name',
                    },
                    'location_map': {
                        'catalogue_id': 'path',
                        'limit': 'query',
                        'catalogue_entry_name': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_catalogue_entries
            )

        def __list_catalogues(
            self,
            **kwargs
        ):
            """List all catalogues  # noqa: E501

            List all catalogues  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_catalogues(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                catalogue_category (str): Query based on a catalogue's category. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListCataloguesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_catalogues is None:
            self.list_catalogues = _Endpoint(
                settings={
                    'response_type': (ListCataloguesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues',
                    'operation_id': 'list_catalogues',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'catalogue_category',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'catalogue_category':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'catalogue_category': 'catalogue_category',
                    },
                    'location_map': {
                        'limit': 'query',
                        'catalogue_category': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_catalogues
            )

        def __replace_catalogue(
            self,
            catalogue_id,
            catalogue,
            **kwargs
        ):
            """Replace the catalogue specified by catalogue_id  # noqa: E501

            Replace the catalogue specified by catalogue_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_catalogue(catalogue_id, catalogue, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue_id (str): catalogue_id path
                catalogue (Catalogue): Catalogue

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Catalogue
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue_id'] = \
                catalogue_id
            kwargs['catalogue'] = \
                catalogue
            return self.call_with_http_info(**kwargs)

        if self.replace_catalogue is None:
            self.replace_catalogue = _Endpoint(
                settings={
                    'response_type': (Catalogue,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues/{catalogue_id}',
                    'operation_id': 'replace_catalogue',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue_id',
                        'catalogue',
                    ],
                    'required': [
                        'catalogue_id',
                        'catalogue',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue_id':
                            (str,),
                        'catalogue':
                            (Catalogue,),
                    },
                    'attribute_map': {
                        'catalogue_id': 'catalogue_id',
                    },
                    'location_map': {
                        'catalogue_id': 'path',
                        'catalogue': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_catalogue
            )

        def __replace_catalogue_entry(
            self,
            catalogue_id,
            catalogue_entry_id,
            catalogue_entry,
            **kwargs
        ):
            """Replace the catalogue entry specified by catalogue_entry_id  # noqa: E501

            Replace the catalogue entry specified by catalogue_entry_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_catalogue_entry(catalogue_id, catalogue_entry_id, catalogue_entry, async_req=True)
            >>> result = thread.get()

            Args:
                catalogue_id (str): catalogue_id path
                catalogue_entry_id (str): catalogue_entry_id path
                catalogue_entry (CatalogueEntry): CatalogueEntry

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CatalogueEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalogue_id'] = \
                catalogue_id
            kwargs['catalogue_entry_id'] = \
                catalogue_entry_id
            kwargs['catalogue_entry'] = \
                catalogue_entry
            return self.call_with_http_info(**kwargs)

        if self.replace_catalogue_entry is None:
            self.replace_catalogue_entry = _Endpoint(
                settings={
                    'response_type': (CatalogueEntry,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/catalogues/{catalogue_id}/catalogue_entries/{catalogue_entry_id}',
                    'operation_id': 'replace_catalogue_entry',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'catalogue_id',
                        'catalogue_entry_id',
                        'catalogue_entry',
                    ],
                    'required': [
                        'catalogue_id',
                        'catalogue_entry_id',
                        'catalogue_entry',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'catalogue_id':
                            (str,),
                        'catalogue_entry_id':
                            (str,),
                        'catalogue_entry':
                            (CatalogueEntry,),
                    },
                    'attribute_map': {
                        'catalogue_id': 'catalogue_id',
                        'catalogue_entry_id': 'catalogue_entry_id',
                    },
                    'location_map': {
                        'catalogue_id': 'path',
                        'catalogue_entry_id': 'path',
                        'catalogue_entry': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_catalogue_entry
            )

    create_catalogue = None 
    create_catalogue_entry = None 
    delete_catalogue = None 
    delete_catalogue_entry = None 
    get_catalogue = None 
    get_catalogue_entry = None 
    list_all_catalogue_entries = None 
    list_catalogue_entries = None 
    list_catalogues = None 
    replace_catalogue = None 
    replace_catalogue_entry = None 
