"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.07
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.bulk_delete_labelled_objects_request import BulkDeleteLabelledObjectsRequest
from agilicus_api.model.bulk_delete_labelled_objects_response import BulkDeleteLabelledObjectsResponse
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.label import Label
from agilicus_api.model.label_association import LabelAssociation
from agilicus_api.model.label_name import LabelName
from agilicus_api.model.labelled_object import LabelledObject
from agilicus_api.model.list_labelled_objects_response import ListLabelledObjectsResponse
from agilicus_api.model.list_labels_response import ListLabelsResponse
from agilicus_api.model.object_type import ObjectType


class LabelsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __bulk_delete_labelled_objects(
            self,
            bulk_delete_labelled_objects_request,
            **kwargs
        ):
            """Delete many label associations  # noqa: E501

            Deletes many label associations. Will also remove any labels if they are no longer referenced and they were automatically created.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bulk_delete_labelled_objects(bulk_delete_labelled_objects_request, async_req=True)
            >>> result = thread.get()

            Args:
                bulk_delete_labelled_objects_request (BulkDeleteLabelledObjectsRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BulkDeleteLabelledObjectsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bulk_delete_labelled_objects_request'] = \
                bulk_delete_labelled_objects_request
            return self.call_with_http_info(**kwargs)

        if self.bulk_delete_labelled_objects is None:
            self.bulk_delete_labelled_objects = _Endpoint(
                settings={
                    'response_type': (BulkDeleteLabelledObjectsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labelled_objects/bulk_delete',
                    'operation_id': 'bulk_delete_labelled_objects',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'bulk_delete_labelled_objects_request',
                    ],
                    'required': [
                        'bulk_delete_labelled_objects_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'bulk_delete_labelled_objects_request':
                            (BulkDeleteLabelledObjectsRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'bulk_delete_labelled_objects_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__bulk_delete_labelled_objects
            )

        def __create_labelled_object(
            self,
            labelled_object,
            **kwargs
        ):
            """Add a labelled object  # noqa: E501

            Adds a new labelled object. The association must have a unique object_id, object_type and label_name within an organsation. If it does not, then the create will return a 409 including the conflicting object.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_labelled_object(labelled_object, async_req=True)
            >>> result = thread.get()

            Args:
                labelled_object (LabelledObject):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelledObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['labelled_object'] = \
                labelled_object
            return self.call_with_http_info(**kwargs)

        if self.create_labelled_object is None:
            self.create_labelled_object = _Endpoint(
                settings={
                    'response_type': (LabelledObject,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labelled_objects',
                    'operation_id': 'create_labelled_object',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'labelled_object',
                    ],
                    'required': [
                        'labelled_object',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'labelled_object':
                            (LabelledObject,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'labelled_object': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_labelled_object
            )

        def __create_labelled_object_label(
            self,
            labelled_object_id,
            label_association,
            **kwargs
        ):
            """Add a label association  # noqa: E501

            Associates a label with an object. If already associated, this will return a 409 including the conflicting object. Note that a new label will be created if one with the provided name does not yet exist.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_labelled_object_label(labelled_object_id, label_association, async_req=True)
            >>> result = thread.get()

            Args:
                labelled_object_id (str): A labelled object ID
                label_association (LabelAssociation):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelAssociation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['labelled_object_id'] = \
                labelled_object_id
            kwargs['label_association'] = \
                label_association
            return self.call_with_http_info(**kwargs)

        if self.create_labelled_object_label is None:
            self.create_labelled_object_label = _Endpoint(
                settings={
                    'response_type': (LabelAssociation,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labelled_objects/{labelled_object_id}/labels',
                    'operation_id': 'create_labelled_object_label',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'labelled_object_id',
                        'label_association',
                    ],
                    'required': [
                        'labelled_object_id',
                        'label_association',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'labelled_object_id':
                            (str,),
                        'label_association':
                            (LabelAssociation,),
                    },
                    'attribute_map': {
                        'labelled_object_id': 'labelled_object_id',
                    },
                    'location_map': {
                        'labelled_object_id': 'path',
                        'label_association': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_labelled_object_label
            )

        def __create_object_label(
            self,
            label,
            **kwargs
        ):
            """Add a label  # noqa: E501

            Adds a label. Labels must have unique names within an org. If the name is not unique, a 409 will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_object_label(label, async_req=True)
            >>> result = thread.get()

            Args:
                label (Label):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Label
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label'] = \
                label
            return self.call_with_http_info(**kwargs)

        if self.create_object_label is None:
            self.create_object_label = _Endpoint(
                settings={
                    'response_type': (Label,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labels',
                    'operation_id': 'create_object_label',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'label',
                    ],
                    'required': [
                        'label',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'label':
                            (Label,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'label': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_object_label
            )

        def __delete_labelled_object(
            self,
            labelled_object_id,
            **kwargs
        ):
            """Delete a labelled object  # noqa: E501

            Delete a labelled object  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_labelled_object(labelled_object_id, async_req=True)
            >>> result = thread.get()

            Args:
                labelled_object_id (str): A labelled object ID

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['labelled_object_id'] = \
                labelled_object_id
            return self.call_with_http_info(**kwargs)

        if self.delete_labelled_object is None:
            self.delete_labelled_object = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labelled_objects/{labelled_object_id}',
                    'operation_id': 'delete_labelled_object',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'labelled_object_id',
                        'org_id',
                    ],
                    'required': [
                        'labelled_object_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'labelled_object_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'labelled_object_id': 'labelled_object_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'labelled_object_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_labelled_object
            )

        def __delete_labelled_object_label(
            self,
            labelled_object_id,
            label_name,
            **kwargs
        ):
            """Delete a label association  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_labelled_object_label(labelled_object_id, label_name, async_req=True)
            >>> result = thread.get()

            Args:
                labelled_object_id (str): A labelled object ID
                label_name (LabelName): A label name

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['labelled_object_id'] = \
                labelled_object_id
            kwargs['label_name'] = \
                label_name
            return self.call_with_http_info(**kwargs)

        if self.delete_labelled_object_label is None:
            self.delete_labelled_object_label = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labelled_objects/{labelled_object_id}/labels/{label_name}',
                    'operation_id': 'delete_labelled_object_label',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'labelled_object_id',
                        'label_name',
                        'org_id',
                    ],
                    'required': [
                        'labelled_object_id',
                        'label_name',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'labelled_object_id':
                            (str,),
                        'label_name':
                            (LabelName,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'labelled_object_id': 'labelled_object_id',
                        'label_name': 'label_name',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'labelled_object_id': 'path',
                        'label_name': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_labelled_object_label
            )

        def __delete_object_label(
            self,
            label_id,
            **kwargs
        ):
            """Delete a label  # noqa: E501

            Delete a label  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_object_label(label_id, async_req=True)
            >>> result = thread.get()

            Args:
                label_id (str): A label Id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        if self.delete_object_label is None:
            self.delete_object_label = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labels/{label_id}',
                    'operation_id': 'delete_object_label',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'label_id',
                        'org_id',
                    ],
                    'required': [
                        'label_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'label_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'label_id': 'label_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'label_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_object_label
            )

        def __get_labelled_object(
            self,
            labelled_object_id,
            **kwargs
        ):
            """Get a labelled object  # noqa: E501

            Get a labelled object  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_labelled_object(labelled_object_id, async_req=True)
            >>> result = thread.get()

            Args:
                labelled_object_id (str): A labelled object ID

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelledObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['labelled_object_id'] = \
                labelled_object_id
            return self.call_with_http_info(**kwargs)

        if self.get_labelled_object is None:
            self.get_labelled_object = _Endpoint(
                settings={
                    'response_type': (LabelledObject,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labelled_objects/{labelled_object_id}',
                    'operation_id': 'get_labelled_object',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'labelled_object_id',
                        'org_id',
                    ],
                    'required': [
                        'labelled_object_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'labelled_object_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'labelled_object_id': 'labelled_object_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'labelled_object_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_labelled_object
            )

        def __get_object_label(
            self,
            label_id,
            **kwargs
        ):
            """Get a label  # noqa: E501

            Get a label  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_label(label_id, async_req=True)
            >>> result = thread.get()

            Args:
                label_id (str): A label Id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Label
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        if self.get_object_label is None:
            self.get_object_label = _Endpoint(
                settings={
                    'response_type': (Label,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labels/{label_id}',
                    'operation_id': 'get_object_label',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'label_id',
                        'org_id',
                    ],
                    'required': [
                        'label_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'label_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'label_id': 'label_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'label_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_object_label
            )

        def __list_labelled_objects(
            self,
            **kwargs
        ):
            """List all labelled objects  # noqa: E501

            List all labelled objects matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning. Searching for label_id will return any tree that references that label.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_labelled_objects(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                includes_any_label ([LabelName]): A list of labels to match against. Matches objects with any of the labels. [optional]
                excludes_any_label ([LabelName]): A list of labels to match against. Matches objects with none of the labels. [optional]
                object_id (str): search by object id. [optional]
                object_type (ObjectType): An object type. [optional]
                object_types ([ObjectType]): A list of object types. Returns all items which match at least one of the types. . [optional]
                object_ids ([str]): A list of object IDs. Returns all items which match at least one of the . . [optional]
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListLabelledObjectsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_labelled_objects is None:
            self.list_labelled_objects = _Endpoint(
                settings={
                    'response_type': (ListLabelledObjectsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labelled_objects',
                    'operation_id': 'list_labelled_objects',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'includes_any_label',
                        'excludes_any_label',
                        'object_id',
                        'object_type',
                        'object_types',
                        'object_ids',
                        'org_ids',
                        'page_at_id',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'includes_any_label':
                            ([LabelName],),
                        'excludes_any_label':
                            ([LabelName],),
                        'object_id':
                            (str,),
                        'object_type':
                            (ObjectType,),
                        'object_types':
                            ([ObjectType],),
                        'object_ids':
                            ([str],),
                        'org_ids':
                            ([str],),
                        'page_at_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'includes_any_label': 'includes_any_label',
                        'excludes_any_label': 'excludes_any_label',
                        'object_id': 'object_id',
                        'object_type': 'object_type',
                        'object_types': 'object_types',
                        'object_ids': 'object_ids',
                        'org_ids': 'org_ids',
                        'page_at_id': 'page_at_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'includes_any_label': 'query',
                        'excludes_any_label': 'query',
                        'object_id': 'query',
                        'object_type': 'query',
                        'object_types': 'query',
                        'object_ids': 'query',
                        'org_ids': 'query',
                        'page_at_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                        'includes_any_label': 'multi',
                        'excludes_any_label': 'multi',
                        'object_types': 'multi',
                        'object_ids': 'multi',
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_labelled_objects
            )

        def __list_object_labels(
            self,
            **kwargs
        ):
            """List all labels  # noqa: E501

            List all labels matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_object_labels(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                label_name (LabelName): A label name. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                org_id (str): Organisation Unique identifier. [optional]
                navigation_enabled (bool): Only return labels used for navigation. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListLabelsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_object_labels is None:
            self.list_object_labels = _Endpoint(
                settings={
                    'response_type': (ListLabelsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labels',
                    'operation_id': 'list_object_labels',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'label_name',
                        'page_at_id',
                        'org_id',
                        'navigation_enabled',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'label_name':
                            (LabelName,),
                        'page_at_id':
                            (str,),
                        'org_id':
                            (str,),
                        'navigation_enabled':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'label_name': 'label_name',
                        'page_at_id': 'page_at_id',
                        'org_id': 'org_id',
                        'navigation_enabled': 'navigation_enabled',
                    },
                    'location_map': {
                        'limit': 'query',
                        'label_name': 'query',
                        'page_at_id': 'query',
                        'org_id': 'query',
                        'navigation_enabled': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_object_labels
            )

        def __replace_labelled_object(
            self,
            labelled_object_id,
            **kwargs
        ):
            """update a labelled object  # noqa: E501

            update a labelled object  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_labelled_object(labelled_object_id, async_req=True)
            >>> result = thread.get()

            Args:
                labelled_object_id (str): A labelled object ID

            Keyword Args:
                labelled_object (LabelledObject): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabelledObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['labelled_object_id'] = \
                labelled_object_id
            return self.call_with_http_info(**kwargs)

        if self.replace_labelled_object is None:
            self.replace_labelled_object = _Endpoint(
                settings={
                    'response_type': (LabelledObject,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labelled_objects/{labelled_object_id}',
                    'operation_id': 'replace_labelled_object',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'labelled_object_id',
                        'labelled_object',
                    ],
                    'required': [
                        'labelled_object_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'labelled_object_id':
                            (str,),
                        'labelled_object':
                            (LabelledObject,),
                    },
                    'attribute_map': {
                        'labelled_object_id': 'labelled_object_id',
                    },
                    'location_map': {
                        'labelled_object_id': 'path',
                        'labelled_object': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_labelled_object
            )

        def __replace_object_label(
            self,
            label_id,
            **kwargs
        ):
            """update a label  # noqa: E501

            update a label  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_object_label(label_id, async_req=True)
            >>> result = thread.get()

            Args:
                label_id (str): A label Id

            Keyword Args:
                label (Label): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Label
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        if self.replace_object_label is None:
            self.replace_object_label = _Endpoint(
                settings={
                    'response_type': (Label,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/labels/{label_id}',
                    'operation_id': 'replace_object_label',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'label_id',
                        'label',
                    ],
                    'required': [
                        'label_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'label_id':
                            (str,),
                        'label':
                            (Label,),
                    },
                    'attribute_map': {
                        'label_id': 'label_id',
                    },
                    'location_map': {
                        'label_id': 'path',
                        'label': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_object_label
            )

    bulk_delete_labelled_objects = None 
    create_labelled_object = None 
    create_labelled_object_label = None 
    create_object_label = None 
    delete_labelled_object = None 
    delete_labelled_object_label = None 
    delete_object_label = None 
    get_labelled_object = None 
    get_object_label = None 
    list_labelled_objects = None 
    list_object_labels = None 
    replace_labelled_object = None 
    replace_object_label = None 
