"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.07
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_trusted_certificate import ListTrustedCertificate
from agilicus_api.model.list_trusted_certificate_bundle import ListTrustedCertificateBundle
from agilicus_api.model.list_trusted_certificate_label import ListTrustedCertificateLabel
from agilicus_api.model.list_trusted_certificate_org import ListTrustedCertificateOrg
from agilicus_api.model.trusted_certificate import TrustedCertificate
from agilicus_api.model.trusted_certificate_bundle import TrustedCertificateBundle
from agilicus_api.model.trusted_certificate_bundle_name import TrustedCertificateBundleName
from agilicus_api.model.trusted_certificate_label import TrustedCertificateLabel
from agilicus_api.model.trusted_certificate_label_name import TrustedCertificateLabelName


class TrustedCertsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_bundle(
            self,
            trusted_certificate_bundle,
            **kwargs
        ):
            """Creates a TrustedCertificateBundle  # noqa: E501

            Creates a TrustedCertificateBundle   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_bundle(trusted_certificate_bundle, async_req=True)
            >>> result = thread.get()

            Args:
                trusted_certificate_bundle (TrustedCertificateBundle):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TrustedCertificateBundle
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['trusted_certificate_bundle'] = \
                trusted_certificate_bundle
            return self.call_with_http_info(**kwargs)

        if self.create_bundle is None:
            self.create_bundle = _Endpoint(
                settings={
                    'response_type': (TrustedCertificateBundle,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_bundles',
                    'operation_id': 'create_bundle',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'trusted_certificate_bundle',
                    ],
                    'required': [
                        'trusted_certificate_bundle',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'trusted_certificate_bundle':
                            (TrustedCertificateBundle,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'trusted_certificate_bundle': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_bundle
            )

        def __create_label(
            self,
            trusted_certificate_label,
            **kwargs
        ):
            """Creates a TrustedCertificateLabel  # noqa: E501

            Creates a TrustedCertificateLabel   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_label(trusted_certificate_label, async_req=True)
            >>> result = thread.get()

            Args:
                trusted_certificate_label (TrustedCertificateLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TrustedCertificateLabel
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['trusted_certificate_label'] = \
                trusted_certificate_label
            return self.call_with_http_info(**kwargs)

        if self.create_label is None:
            self.create_label = _Endpoint(
                settings={
                    'response_type': (TrustedCertificateLabel,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_labels',
                    'operation_id': 'create_label',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'trusted_certificate_label',
                    ],
                    'required': [
                        'trusted_certificate_label',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'trusted_certificate_label':
                            (TrustedCertificateLabel,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'trusted_certificate_label': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_label
            )

        def __create_trusted_cert(
            self,
            trusted_certificate,
            **kwargs
        ):
            """Creates a TrustedCertificate  # noqa: E501

            Creates a TrustedCertificate   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_trusted_cert(trusted_certificate, async_req=True)
            >>> result = thread.get()

            Args:
                trusted_certificate (TrustedCertificate):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TrustedCertificate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['trusted_certificate'] = \
                trusted_certificate
            return self.call_with_http_info(**kwargs)

        if self.create_trusted_cert is None:
            self.create_trusted_cert = _Endpoint(
                settings={
                    'response_type': (TrustedCertificate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_certs',
                    'operation_id': 'create_trusted_cert',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'trusted_certificate',
                    ],
                    'required': [
                        'trusted_certificate',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'trusted_certificate':
                            (TrustedCertificate,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'trusted_certificate': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_trusted_cert
            )

        def __delete_bundle(
            self,
            bundle,
            **kwargs
        ):
            """Delete a TrustedCertificateBundle  # noqa: E501

            Delete a TrustedCertificateBundle  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_bundle(bundle, async_req=True)
            >>> result = thread.get()

            Args:
                bundle (TrustedCertificateBundleName): A TrustedCertificateBundleName

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bundle'] = \
                bundle
            return self.call_with_http_info(**kwargs)

        if self.delete_bundle is None:
            self.delete_bundle = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_bundles/{bundle}',
                    'operation_id': 'delete_bundle',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'bundle',
                        'org_id',
                    ],
                    'required': [
                        'bundle',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'bundle':
                            (TrustedCertificateBundleName,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'bundle': 'bundle',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'bundle': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_bundle
            )

        def __delete_label(
            self,
            label,
            **kwargs
        ):
            """Delete a TrustedCertificateLabel  # noqa: E501

            Delete a TrustedCertificateLabel  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_label(label, async_req=True)
            >>> result = thread.get()

            Args:
                label (TrustedCertificateLabelName): A TrustedCertificateLabelName

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label'] = \
                label
            return self.call_with_http_info(**kwargs)

        if self.delete_label is None:
            self.delete_label = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_labels/{label}',
                    'operation_id': 'delete_label',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'label',
                        'org_id',
                    ],
                    'required': [
                        'label',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'label':
                            (TrustedCertificateLabelName,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'label': 'label',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'label': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_label
            )

        def __delete_trusted_cert(
            self,
            certificate_id,
            **kwargs
        ):
            """Delete a TrustedCertificate  # noqa: E501

            Delete a TrustedCertificate  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_trusted_cert(certificate_id, async_req=True)
            >>> result = thread.get()

            Args:
                certificate_id (str): A certificate id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['certificate_id'] = \
                certificate_id
            return self.call_with_http_info(**kwargs)

        if self.delete_trusted_cert is None:
            self.delete_trusted_cert = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_certs/{certificate_id}',
                    'operation_id': 'delete_trusted_cert',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'certificate_id',
                        'org_id',
                    ],
                    'required': [
                        'certificate_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'certificate_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'certificate_id': 'certificate_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'certificate_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_trusted_cert
            )

        def __get_bundle(
            self,
            bundle,
            **kwargs
        ):
            """Get a TrustedCertificateBundle  # noqa: E501

            Get a TrustedCertificateBundle  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_bundle(bundle, async_req=True)
            >>> result = thread.get()

            Args:
                bundle (TrustedCertificateBundleName): A TrustedCertificateBundleName

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                trusted_cert_bundle_etag (str): The entity tag (etag) for a requested bundle. If the returned etag matches the requested etag, then no data is returned, along with status code 304. . [optional]
                get_certs (bool): When querying a bundle, return all certs associated with bundle . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TrustedCertificateBundle
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bundle'] = \
                bundle
            return self.call_with_http_info(**kwargs)

        if self.get_bundle is None:
            self.get_bundle = _Endpoint(
                settings={
                    'response_type': (TrustedCertificateBundle,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_bundles/{bundle}',
                    'operation_id': 'get_bundle',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'bundle',
                        'org_id',
                        'trusted_cert_bundle_etag',
                        'get_certs',
                    ],
                    'required': [
                        'bundle',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'bundle':
                            (TrustedCertificateBundleName,),
                        'org_id':
                            (str,),
                        'trusted_cert_bundle_etag':
                            (str,),
                        'get_certs':
                            (bool,),
                    },
                    'attribute_map': {
                        'bundle': 'bundle',
                        'org_id': 'org_id',
                        'trusted_cert_bundle_etag': 'trusted_cert_bundle_etag',
                        'get_certs': 'get_certs',
                    },
                    'location_map': {
                        'bundle': 'path',
                        'org_id': 'query',
                        'trusted_cert_bundle_etag': 'query',
                        'get_certs': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_bundle
            )

        def __get_label(
            self,
            label,
            **kwargs
        ):
            """Get a TrustedCertificateLabel  # noqa: E501

            Get a TrustedCertificateLabel  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_label(label, async_req=True)
            >>> result = thread.get()

            Args:
                label (TrustedCertificateLabelName): A TrustedCertificateLabelName

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TrustedCertificateLabel
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['label'] = \
                label
            return self.call_with_http_info(**kwargs)

        if self.get_label is None:
            self.get_label = _Endpoint(
                settings={
                    'response_type': (TrustedCertificateLabel,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_labels/{label}',
                    'operation_id': 'get_label',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'label',
                        'org_id',
                    ],
                    'required': [
                        'label',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'label':
                            (TrustedCertificateLabelName,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'label': 'label',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'label': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_label
            )

        def __get_trusted_cert(
            self,
            certificate_id,
            **kwargs
        ):
            """Get a TrustedCertificate  # noqa: E501

            Get a TrustedCertificate  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_trusted_cert(certificate_id, async_req=True)
            >>> result = thread.get()

            Args:
                certificate_id (str): A certificate id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TrustedCertificate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['certificate_id'] = \
                certificate_id
            return self.call_with_http_info(**kwargs)

        if self.get_trusted_cert is None:
            self.get_trusted_cert = _Endpoint(
                settings={
                    'response_type': (TrustedCertificate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_certs/{certificate_id}',
                    'operation_id': 'get_trusted_cert',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'certificate_id',
                        'org_id',
                    ],
                    'required': [
                        'certificate_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'certificate_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'certificate_id': 'certificate_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'certificate_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_trusted_cert
            )

        def __list_bundles(
            self,
            **kwargs
        ):
            """list TrustedCertificateBundle  # noqa: E501

            List TrustedCertificateBundle   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_bundles(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListTrustedCertificateBundle
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_bundles is None:
            self.list_bundles = _Endpoint(
                settings={
                    'response_type': (ListTrustedCertificateBundle,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_bundles',
                    'operation_id': 'list_bundles',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_bundles
            )

        def __list_cert_orgs(
            self,
            **kwargs
        ):
            """list orgs that have available certificates  # noqa: E501

            List orgs that have available trusted certificates   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_cert_orgs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListTrustedCertificateOrg
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_cert_orgs is None:
            self.list_cert_orgs = _Endpoint(
                settings={
                    'response_type': (ListTrustedCertificateOrg,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_certs/orgs',
                    'operation_id': 'list_cert_orgs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_cert_orgs
            )

        def __list_labels(
            self,
            **kwargs
        ):
            """list TrustedCertificateLabel  # noqa: E501

            List TrustedCertificateLabel   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_labels(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                label (str): Filters based on whether or not the items in the collection have the given label. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListTrustedCertificateLabel
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_labels is None:
            self.list_labels = _Endpoint(
                settings={
                    'response_type': (ListTrustedCertificateLabel,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_labels',
                    'operation_id': 'list_labels',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'label',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'label':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'label': 'label',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'label': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_labels
            )

        def __list_trusted_certs(
            self,
            **kwargs
        ):
            """list certificates  # noqa: E501

            List certificates   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_trusted_certs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                trusted_cert_label (TrustedCertificateLabelName): Query TrustedCertificates with a matching label name. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                subject (str): Query a certificate based on subject name. This is an exact match query. . [optional]
                subject_search (str): Query a certificate based on subject name. Query for any certificates which contain this value as a case insensitive substring . [optional]
                subject_sha1 (str): Query a certificate based on the subject name sha128 . [optional]
                subject_sha256 (str): Query a certificate based on the subject name sha256 . [optional]
                cert_issuer (str): Query a certificate based on the issuer. . [optional]
                cert_issuer_search (str): Query a certificate based on the issuer Query for any certificates which contain this value as a case insensitive substring . [optional]
                serial_number (str): Query a certificate based on the serial number . [optional]
                skid (str): Query a certificate based on the subject key identifier . [optional]
                public_key_sha1 (str): Query a certificate based on the public key sha128 . [optional]
                public_key_sha256 (str): Query a certificate based on the public key sha256 . [optional]
                cert_root (bool): Query a certificates that are designated as a root . [optional]
                key_usage_extension_search (str): Query a certificates that have a matching key_usage_extension string. Query for any certificates which contain this value as a case insensitive substring . [optional]
                key_usage_crl_sign (bool): Query certificates that have key usage crl_sign . [optional]
                key_usage_key_cert_sign (bool): Query certificates that have key usage key_cert_sign . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListTrustedCertificate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_trusted_certs is None:
            self.list_trusted_certs = _Endpoint(
                settings={
                    'response_type': (ListTrustedCertificate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_certs',
                    'operation_id': 'list_trusted_certs',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'trusted_cert_label',
                        'page_at_id',
                        'subject',
                        'subject_search',
                        'subject_sha1',
                        'subject_sha256',
                        'cert_issuer',
                        'cert_issuer_search',
                        'serial_number',
                        'skid',
                        'public_key_sha1',
                        'public_key_sha256',
                        'cert_root',
                        'key_usage_extension_search',
                        'key_usage_crl_sign',
                        'key_usage_key_cert_sign',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'trusted_cert_label':
                            (TrustedCertificateLabelName,),
                        'page_at_id':
                            (str,),
                        'subject':
                            (str,),
                        'subject_search':
                            (str,),
                        'subject_sha1':
                            (str,),
                        'subject_sha256':
                            (str,),
                        'cert_issuer':
                            (str,),
                        'cert_issuer_search':
                            (str,),
                        'serial_number':
                            (str,),
                        'skid':
                            (str,),
                        'public_key_sha1':
                            (str,),
                        'public_key_sha256':
                            (str,),
                        'cert_root':
                            (bool,),
                        'key_usage_extension_search':
                            (str,),
                        'key_usage_crl_sign':
                            (bool,),
                        'key_usage_key_cert_sign':
                            (bool,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'trusted_cert_label': 'trusted_cert_label',
                        'page_at_id': 'page_at_id',
                        'subject': 'subject',
                        'subject_search': 'subject_search',
                        'subject_sha1': 'subject_sha1',
                        'subject_sha256': 'subject_sha256',
                        'cert_issuer': 'cert_issuer',
                        'cert_issuer_search': 'cert_issuer_search',
                        'serial_number': 'serial_number',
                        'skid': 'skid',
                        'public_key_sha1': 'public_key_sha1',
                        'public_key_sha256': 'public_key_sha256',
                        'cert_root': 'cert_root',
                        'key_usage_extension_search': 'key_usage_extension_search',
                        'key_usage_crl_sign': 'key_usage_crl_sign',
                        'key_usage_key_cert_sign': 'key_usage_key_cert_sign',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'trusted_cert_label': 'query',
                        'page_at_id': 'query',
                        'subject': 'query',
                        'subject_search': 'query',
                        'subject_sha1': 'query',
                        'subject_sha256': 'query',
                        'cert_issuer': 'query',
                        'cert_issuer_search': 'query',
                        'serial_number': 'query',
                        'skid': 'query',
                        'public_key_sha1': 'query',
                        'public_key_sha256': 'query',
                        'cert_root': 'query',
                        'key_usage_extension_search': 'query',
                        'key_usage_crl_sign': 'query',
                        'key_usage_key_cert_sign': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_trusted_certs
            )

        def __replace_bundle(
            self,
            bundle,
            trusted_certificate_bundle,
            **kwargs
        ):
            """Update a TrustedCertificateBundle  # noqa: E501

            Update a TrustedCertificateBundle   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_bundle(bundle, trusted_certificate_bundle, async_req=True)
            >>> result = thread.get()

            Args:
                bundle (TrustedCertificateBundleName): A TrustedCertificateBundleName
                trusted_certificate_bundle (TrustedCertificateBundle):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TrustedCertificateBundle
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bundle'] = \
                bundle
            kwargs['trusted_certificate_bundle'] = \
                trusted_certificate_bundle
            return self.call_with_http_info(**kwargs)

        if self.replace_bundle is None:
            self.replace_bundle = _Endpoint(
                settings={
                    'response_type': (TrustedCertificateBundle,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_cert_bundles/{bundle}',
                    'operation_id': 'replace_bundle',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'bundle',
                        'trusted_certificate_bundle',
                    ],
                    'required': [
                        'bundle',
                        'trusted_certificate_bundle',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'bundle':
                            (TrustedCertificateBundleName,),
                        'trusted_certificate_bundle':
                            (TrustedCertificateBundle,),
                    },
                    'attribute_map': {
                        'bundle': 'bundle',
                    },
                    'location_map': {
                        'bundle': 'path',
                        'trusted_certificate_bundle': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_bundle
            )

        def __replace_trusted_cert(
            self,
            certificate_id,
            trusted_certificate,
            **kwargs
        ):
            """Update a TrustedCertificate  # noqa: E501

            Update a TrustedCertificate   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_trusted_cert(certificate_id, trusted_certificate, async_req=True)
            >>> result = thread.get()

            Args:
                certificate_id (str): A certificate id
                trusted_certificate (TrustedCertificate):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TrustedCertificate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['certificate_id'] = \
                certificate_id
            kwargs['trusted_certificate'] = \
                trusted_certificate
            return self.call_with_http_info(**kwargs)

        if self.replace_trusted_cert is None:
            self.replace_trusted_cert = _Endpoint(
                settings={
                    'response_type': (TrustedCertificate,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/trusted_certs/{certificate_id}',
                    'operation_id': 'replace_trusted_cert',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'certificate_id',
                        'trusted_certificate',
                    ],
                    'required': [
                        'certificate_id',
                        'trusted_certificate',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'certificate_id':
                            (str,),
                        'trusted_certificate':
                            (TrustedCertificate,),
                    },
                    'attribute_map': {
                        'certificate_id': 'certificate_id',
                    },
                    'location_map': {
                        'certificate_id': 'path',
                        'trusted_certificate': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_trusted_cert
            )

    create_bundle = None 
    create_label = None 
    create_trusted_cert = None 
    delete_bundle = None 
    delete_label = None 
    delete_trusted_cert = None 
    get_bundle = None 
    get_label = None 
    get_trusted_cert = None 
    list_bundles = None 
    list_cert_orgs = None 
    list_labels = None 
    list_trusted_certs = None 
    replace_bundle = None 
    replace_trusted_cert = None 
