"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.07
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError


def lazy_import():
    from agilicus_api.model.application_config import ApplicationConfig
    from agilicus_api.model.application_service import ApplicationService
    from agilicus_api.model.environment_status import EnvironmentStatus
    from agilicus_api.model.k8s_slug import K8sSlug
    globals()['ApplicationConfig'] = ApplicationConfig
    globals()['ApplicationService'] = ApplicationService
    globals()['EnvironmentStatus'] = EnvironmentStatus
    globals()['K8sSlug'] = K8sSlug


class Environment(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('proxy_location',): {
            'IN_CLOUD': "in_cloud",
            'ON_SITE': "on_site",
        },
    }

    validations = {
        ('name',): {
            'max_length': 40,
            'min_length': 1,
        },
        ('maintenance_org_id',): {
            'max_length': 40,
            'min_length': 1,
        },
        ('version_tag',): {
            'max_length': 40,
            'min_length': 1,
        },
    }

    @property
    def created(self):
       return self.get("created")

    @created.setter
    def created(self, new_value):
       self.created = new_value

    @property
    def name(self):
       return self.get("name")

    @name.setter
    def name(self, new_value):
       self.name = new_value

    @property
    def maintenance_org_id(self):
       return self.get("maintenance_org_id")

    @maintenance_org_id.setter
    def maintenance_org_id(self, new_value):
       self.maintenance_org_id = new_value

    @property
    def domain_aliases(self):
       return self.get("domain_aliases")

    @domain_aliases.setter
    def domain_aliases(self, new_value):
       self.domain_aliases = new_value

    @property
    def version_tag(self):
       return self.get("version_tag")

    @version_tag.setter
    def version_tag(self, new_value):
       self.version_tag = new_value

    @property
    def config_mount_path(self):
       return self.get("config_mount_path")

    @config_mount_path.setter
    def config_mount_path(self, new_value):
       self.config_mount_path = new_value

    @property
    def config_as_mount(self):
       return self.get("config_as_mount")

    @config_as_mount.setter
    def config_as_mount(self, new_value):
       self.config_as_mount = new_value

    @property
    def config_as_env(self):
       return self.get("config_as_env")

    @config_as_env.setter
    def config_as_env(self, new_value):
       self.config_as_env = new_value

    @property
    def secrets_mount_path(self):
       return self.get("secrets_mount_path")

    @secrets_mount_path.setter
    def secrets_mount_path(self, new_value):
       self.secrets_mount_path = new_value

    @property
    def secrets_as_mount(self):
       return self.get("secrets_as_mount")

    @secrets_as_mount.setter
    def secrets_as_mount(self, new_value):
       self.secrets_as_mount = new_value

    @property
    def secrets_as_env(self):
       return self.get("secrets_as_env")

    @secrets_as_env.setter
    def secrets_as_env(self, new_value):
       self.secrets_as_env = new_value

    @property
    def application_services(self):
       return self.get("application_services")

    @application_services.setter
    def application_services(self, new_value):
       self.application_services = new_value

    @property
    def serverless_image(self):
       return self.get("serverless_image")

    @serverless_image.setter
    def serverless_image(self, new_value):
       self.serverless_image = new_value

    @property
    def status(self):
       return self.get("status")

    @status.setter
    def status(self, new_value):
       self.status = new_value

    @property
    def updated(self):
       return self.get("updated")

    @updated.setter
    def updated(self, new_value):
       self.updated = new_value

    @property
    def application_configs(self):
       return self.get("application_configs")

    @application_configs.setter
    def application_configs(self, new_value):
       self.application_configs = new_value

    @property
    def scopes(self):
       return self.get("scopes")

    @scopes.setter
    def scopes(self, new_value):
       self.scopes = new_value

    @property
    def name_slug(self):
       return self.get("name_slug")

    @name_slug.setter
    def name_slug(self, new_value):
       self.name_slug = new_value

    @property
    def migrated_app_id(self):
       return self.get("migrated_app_id")

    @migrated_app_id.setter
    def migrated_app_id(self, new_value):
       self.migrated_app_id = new_value

    @property
    def proxy_location(self):
       return self.get("proxy_location")

    @proxy_location.setter
    def proxy_location(self, new_value):
       self.proxy_location = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'name': (str,),  # noqa: E501
            'created': (datetime,),  # noqa: E501
            'maintenance_org_id': (str,),  # noqa: E501
            'domain_aliases': ([str],),  # noqa: E501
            'version_tag': (str,),  # noqa: E501
            'config_mount_path': (str,),  # noqa: E501
            'config_as_mount': (str,),  # noqa: E501
            'config_as_env': (str,),  # noqa: E501
            'secrets_mount_path': (str,),  # noqa: E501
            'secrets_as_mount': (str,),  # noqa: E501
            'secrets_as_env': (str,),  # noqa: E501
            'application_services': ([ApplicationService],),  # noqa: E501
            'serverless_image': (str,),  # noqa: E501
            'status': (EnvironmentStatus,),  # noqa: E501
            'updated': (datetime,),  # noqa: E501
            'application_configs': (ApplicationConfig,),  # noqa: E501
            'scopes': ([str],),  # noqa: E501
            'name_slug': (K8sSlug,),  # noqa: E501
            'migrated_app_id': (str,),  # noqa: E501
            'proxy_location': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'name': 'name',  # noqa: E501
        'created': 'created',  # noqa: E501
        'maintenance_org_id': 'maintenance_org_id',  # noqa: E501
        'domain_aliases': 'domain_aliases',  # noqa: E501
        'version_tag': 'version_tag',  # noqa: E501
        'config_mount_path': 'config_mount_path',  # noqa: E501
        'config_as_mount': 'config_as_mount',  # noqa: E501
        'config_as_env': 'config_as_env',  # noqa: E501
        'secrets_mount_path': 'secrets_mount_path',  # noqa: E501
        'secrets_as_mount': 'secrets_as_mount',  # noqa: E501
        'secrets_as_env': 'secrets_as_env',  # noqa: E501
        'application_services': 'application_services',  # noqa: E501
        'serverless_image': 'serverless_image',  # noqa: E501
        'status': 'status',  # noqa: E501
        'updated': 'updated',  # noqa: E501
        'application_configs': 'application_configs',  # noqa: E501
        'scopes': 'scopes',  # noqa: E501
        'name_slug': 'name_slug',  # noqa: E501
        'migrated_app_id': 'migrated_app_id',  # noqa: E501
        'proxy_location': 'proxy_location',  # noqa: E501
    }

    read_only_vars = {
        'created',  # noqa: E501
        'application_services',  # noqa: E501
        'updated',  # noqa: E501
        'scopes',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, name, *args, **kwargs):  # noqa: E501
        """Environment - a model defined in OpenAPI

        Args:
            name (str): Environment name

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            created (datetime): Creation time. [optional]  # noqa: E501
            maintenance_org_id (str): The Organisation which is responsibile for maintaining this Environment. Often this will be the same Organisation as the owning Application. However, sometimes it makes sense to delegate this responsibility to another Organisation. To do so, set this field to that Organisation's identifier. Users with sufficient permissions in that organisation will be able to modify this Environment. If the maintenance_org_id is not provided, it will populated with that of the parent application's organisation. . [optional]  # noqa: E501
            domain_aliases ([str]): A list of alternative domains for an instance. This can be used if you want to use a different FQDN for your application instead of the default `appname.org_subdomain`. Multiple different names can be useful if an application is multi-tenant, that is it can be accessed by multiple organisations and you don't want your users to see it any different to existing web applications. A certificate will be generated for all valid domains. All aliases entered must have a cname assignment pointing to the FQDN of the cluster hosting your application. . [optional]  # noqa: E501
            version_tag (str): The version of the container to run. Required if the owning application is hosted. . [optional]  # noqa: E501
            config_mount_path (str): config_as_mount file path. [optional]  # noqa: E501
            config_as_mount (str): A json object of config applied as file mounted. [optional]  # noqa: E501
            config_as_env (str): A json object of config applied as environment. [optional]  # noqa: E501
            secrets_mount_path (str): secret_as_mount file path. [optional]  # noqa: E501
            secrets_as_mount (str): A json object of secrets applied as file mounted. [optional]  # noqa: E501
            secrets_as_env (str): A json object of secrets applied as environment. [optional]  # noqa: E501
            application_services ([ApplicationService]): The services used by the application for this environment. Note that in order to add a service to the environment, this environment must be added to the list of assignments for that service in the ApplicationService collection for the organisation. . [optional]  # noqa: E501
            serverless_image (str): serverless image path. [optional]  # noqa: E501
            status (EnvironmentStatus): [optional]  # noqa: E501
            updated (datetime): Update time. [optional]  # noqa: E501
            application_configs (ApplicationConfig): [optional]  # noqa: E501
            scopes ([str]): A list of scopes to be requested on behalf of the user of the application and as well as configured based on the application launchers that launch this application/environment. This field is only populated on a GET request when the query parameter get_scopes=True is passed. . [optional]  # noqa: E501
            name_slug (K8sSlug): [optional]  # noqa: E501
            migrated_app_id (str): Environments are in transition to be deprecated. When an environment is migrated, an application is created specific for the environment. This property provides the id of the application that this environment has been migrated to. . [optional]  # noqa: E501
            proxy_location (str): If this application is a simple Web Application Firewall proxy, this field controls where the proxy runs. The possible values have the following meanings:  - `in_cloud`. An application which is `in_cloud` runs the proxy in the Agilicus cloud. This means that the application's data will be decrypted in the Agilicus cloud so that the proxy may perform authentication, authorization, sanitisiation and modification tasks prior to forwarding the request to the destination service. - `on_site`: An application which is `on_site` runs the proxy as part of an AgentConnector located on a machine run by you. The application's data is not decrypted until it reaches that machine. Any secrets required to do this (such as private keys for TLS Certificates) stay on that machine; they are never transmitted to Agilicus. The proxy running on site will decrypt the data, and perform authentication, authorisation and modification tasks prior to forwarding the request to the destination service. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, name, *args, **kwargs):  # noqa: E501
        """Environment - a model defined in OpenAPI

        Args:
            name (str): Environment name

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            created (datetime): Creation time. [optional]  # noqa: E501
            maintenance_org_id (str): The Organisation which is responsibile for maintaining this Environment. Often this will be the same Organisation as the owning Application. However, sometimes it makes sense to delegate this responsibility to another Organisation. To do so, set this field to that Organisation's identifier. Users with sufficient permissions in that organisation will be able to modify this Environment. If the maintenance_org_id is not provided, it will populated with that of the parent application's organisation. . [optional]  # noqa: E501
            domain_aliases ([str]): A list of alternative domains for an instance. This can be used if you want to use a different FQDN for your application instead of the default `appname.org_subdomain`. Multiple different names can be useful if an application is multi-tenant, that is it can be accessed by multiple organisations and you don't want your users to see it any different to existing web applications. A certificate will be generated for all valid domains. All aliases entered must have a cname assignment pointing to the FQDN of the cluster hosting your application. . [optional]  # noqa: E501
            version_tag (str): The version of the container to run. Required if the owning application is hosted. . [optional]  # noqa: E501
            config_mount_path (str): config_as_mount file path. [optional]  # noqa: E501
            config_as_mount (str): A json object of config applied as file mounted. [optional]  # noqa: E501
            config_as_env (str): A json object of config applied as environment. [optional]  # noqa: E501
            secrets_mount_path (str): secret_as_mount file path. [optional]  # noqa: E501
            secrets_as_mount (str): A json object of secrets applied as file mounted. [optional]  # noqa: E501
            secrets_as_env (str): A json object of secrets applied as environment. [optional]  # noqa: E501
            application_services ([ApplicationService]): The services used by the application for this environment. Note that in order to add a service to the environment, this environment must be added to the list of assignments for that service in the ApplicationService collection for the organisation. . [optional]  # noqa: E501
            serverless_image (str): serverless image path. [optional]  # noqa: E501
            status (EnvironmentStatus): [optional]  # noqa: E501
            updated (datetime): Update time. [optional]  # noqa: E501
            application_configs (ApplicationConfig): [optional]  # noqa: E501
            scopes ([str]): A list of scopes to be requested on behalf of the user of the application and as well as configured based on the application launchers that launch this application/environment. This field is only populated on a GET request when the query parameter get_scopes=True is passed. . [optional]  # noqa: E501
            name_slug (K8sSlug): [optional]  # noqa: E501
            migrated_app_id (str): Environments are in transition to be deprecated. When an environment is migrated, an application is created specific for the environment. This property provides the id of the application that this environment has been migrated to. . [optional]  # noqa: E501
            proxy_location (str): If this application is a simple Web Application Firewall proxy, this field controls where the proxy runs. The possible values have the following meanings:  - `in_cloud`. An application which is `in_cloud` runs the proxy in the Agilicus cloud. This means that the application's data will be decrypted in the Agilicus cloud so that the proxy may perform authentication, authorization, sanitisiation and modification tasks prior to forwarding the request to the destination service. - `on_site`: An application which is `on_site` runs the proxy as part of an AgentConnector located on a machine run by you. The application's data is not decrypted until it reaches that machine. Any secrets required to do this (such as private keys for TLS Certificates) stay on that machine; they are never transmitted to Agilicus. The proxy running on site will decrypt the data, and perform authentication, authorisation and modification tasks prior to forwarding the request to the destination service. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

