"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.07
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError


def lazy_import():
    from agilicus_api.model.admin_status import AdminStatus
    from agilicus_api.model.application_upstream_identity_provider import ApplicationUpstreamIdentityProvider
    from agilicus_api.model.issuer_client import IssuerClient
    from agilicus_api.model.issuer_status import IssuerStatus
    from agilicus_api.model.k8s_slug import K8sSlug
    from agilicus_api.model.kerberos_upstream_identity_provider import KerberosUpstreamIdentityProvider
    from agilicus_api.model.local_auth_upstream_identity_provider import LocalAuthUpstreamIdentityProvider
    from agilicus_api.model.managed_upstream_identity_provider import ManagedUpstreamIdentityProvider
    from agilicus_api.model.oidc_upstream_identity_provider import OIDCUpstreamIdentityProvider
    from agilicus_api.model.operational_status import OperationalStatus
    from agilicus_api.model.upstream_group_mapping import UpstreamGroupMapping
    globals()['AdminStatus'] = AdminStatus
    globals()['ApplicationUpstreamIdentityProvider'] = ApplicationUpstreamIdentityProvider
    globals()['IssuerClient'] = IssuerClient
    globals()['IssuerStatus'] = IssuerStatus
    globals()['K8sSlug'] = K8sSlug
    globals()['KerberosUpstreamIdentityProvider'] = KerberosUpstreamIdentityProvider
    globals()['LocalAuthUpstreamIdentityProvider'] = LocalAuthUpstreamIdentityProvider
    globals()['ManagedUpstreamIdentityProvider'] = ManagedUpstreamIdentityProvider
    globals()['OIDCUpstreamIdentityProvider'] = OIDCUpstreamIdentityProvider
    globals()['OperationalStatus'] = OperationalStatus
    globals()['UpstreamGroupMapping'] = UpstreamGroupMapping


class Issuer(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('issuer',): {
            'max_length': 100,
            'min_length': 1,
        },
        ('org_id',): {
            'max_length': 40,
        },
        ('theme_file_id',): {
            'max_length': 40,
        },
        ('upstream_redirect_uri',): {
            'max_length': 511,
        },
        ('managed_upstreams',): {
        },
        ('oidc_upstreams',): {
        },
        ('local_auth_upstreams',): {
        },
        ('application_upstreams',): {
        },
        ('kerberos_upstreams',): {
        },
        ('saml_state_encryption_key',): {
            'max_length': 100,
            'min_length': 10,
        },
        ('service_account_id',): {
            'max_length': 40,
        },
        ('service_account_user_id',): {
            'max_length': 40,
        },
    }

    @property
    def id(self):
       return self.get("id")

    @id.setter
    def id(self, new_value):
       self.id = new_value

    @property
    def issuer(self):
       return self.get("issuer")

    @issuer.setter
    def issuer(self, new_value):
       self.issuer = new_value

    @property
    def enabled(self):
       return self.get("enabled")

    @enabled.setter
    def enabled(self, new_value):
       self.enabled = new_value

    @property
    def org_id(self):
       return self.get("org_id")

    @org_id.setter
    def org_id(self, new_value):
       self.org_id = new_value

    @property
    def theme_file_id(self):
       return self.get("theme_file_id")

    @theme_file_id.setter
    def theme_file_id(self, new_value):
       self.theme_file_id = new_value

    @property
    def upstream_redirect_uri(self):
       return self.get("upstream_redirect_uri")

    @upstream_redirect_uri.setter
    def upstream_redirect_uri(self, new_value):
       self.upstream_redirect_uri = new_value

    @property
    def managed_upstreams(self):
       return self.get("managed_upstreams")

    @managed_upstreams.setter
    def managed_upstreams(self, new_value):
       self.managed_upstreams = new_value

    @property
    def oidc_upstreams(self):
       return self.get("oidc_upstreams")

    @oidc_upstreams.setter
    def oidc_upstreams(self, new_value):
       self.oidc_upstreams = new_value

    @property
    def local_auth_upstreams(self):
       return self.get("local_auth_upstreams")

    @local_auth_upstreams.setter
    def local_auth_upstreams(self, new_value):
       self.local_auth_upstreams = new_value

    @property
    def application_upstreams(self):
       return self.get("application_upstreams")

    @application_upstreams.setter
    def application_upstreams(self, new_value):
       self.application_upstreams = new_value

    @property
    def kerberos_upstreams(self):
       return self.get("kerberos_upstreams")

    @kerberos_upstreams.setter
    def kerberos_upstreams(self, new_value):
       self.kerberos_upstreams = new_value

    @property
    def clients(self):
       return self.get("clients")

    @clients.setter
    def clients(self, new_value):
       self.clients = new_value

    @property
    def upstream_group_mappings(self):
       return self.get("upstream_group_mappings")

    @upstream_group_mappings.setter
    def upstream_group_mappings(self, new_value):
       self.upstream_group_mappings = new_value

    @property
    def name_slug(self):
       return self.get("name_slug")

    @name_slug.setter
    def name_slug(self, new_value):
       self.name_slug = new_value

    @property
    def saml_state_encryption_key(self):
       return self.get("saml_state_encryption_key")

    @saml_state_encryption_key.setter
    def saml_state_encryption_key(self, new_value):
       self.saml_state_encryption_key = new_value

    @property
    def service_account_id(self):
       return self.get("service_account_id")

    @service_account_id.setter
    def service_account_id(self, new_value):
       self.service_account_id = new_value

    @property
    def service_account_user_id(self):
       return self.get("service_account_user_id")

    @service_account_user_id.setter
    def service_account_user_id(self, new_value):
       self.service_account_user_id = new_value

    @property
    def verified_domains(self):
       return self.get("verified_domains")

    @verified_domains.setter
    def verified_domains(self, new_value):
       self.verified_domains = new_value

    @property
    def admin_status(self):
       return self.get("admin_status")

    @admin_status.setter
    def admin_status(self, new_value):
       self.admin_status = new_value

    @property
    def trap_disabled(self):
       return self.get("trap_disabled")

    @trap_disabled.setter
    def trap_disabled(self, new_value):
       self.trap_disabled = new_value

    @property
    def operational_status(self):
       return self.get("operational_status")

    @operational_status.setter
    def operational_status(self, new_value):
       self.operational_status = new_value

    @property
    def parent_issuer(self):
       return self.get("parent_issuer")

    @parent_issuer.setter
    def parent_issuer(self, new_value):
       self.parent_issuer = new_value

    @property
    def status(self):
       return self.get("status")

    @status.setter
    def status(self, new_value):
       self.status = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'issuer': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'enabled': (bool,),  # noqa: E501
            'org_id': (str,),  # noqa: E501
            'theme_file_id': (str,),  # noqa: E501
            'upstream_redirect_uri': (str,),  # noqa: E501
            'managed_upstreams': ([ManagedUpstreamIdentityProvider],),  # noqa: E501
            'oidc_upstreams': ([OIDCUpstreamIdentityProvider],),  # noqa: E501
            'local_auth_upstreams': ([LocalAuthUpstreamIdentityProvider],),  # noqa: E501
            'application_upstreams': ([ApplicationUpstreamIdentityProvider],),  # noqa: E501
            'kerberos_upstreams': ([KerberosUpstreamIdentityProvider],),  # noqa: E501
            'clients': ([IssuerClient],),  # noqa: E501
            'upstream_group_mappings': ([UpstreamGroupMapping],),  # noqa: E501
            'name_slug': (K8sSlug,),  # noqa: E501
            'saml_state_encryption_key': (str,),  # noqa: E501
            'service_account_id': (str,),  # noqa: E501
            'service_account_user_id': (str,),  # noqa: E501
            'verified_domains': ([str],),  # noqa: E501
            'admin_status': (AdminStatus,),  # noqa: E501
            'trap_disabled': (bool,),  # noqa: E501
            'operational_status': (OperationalStatus,),  # noqa: E501
            'parent_issuer': (str, none_type,),  # noqa: E501
            'status': (IssuerStatus,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'issuer': 'issuer',  # noqa: E501
        'id': 'id',  # noqa: E501
        'enabled': 'enabled',  # noqa: E501
        'org_id': 'org_id',  # noqa: E501
        'theme_file_id': 'theme_file_id',  # noqa: E501
        'upstream_redirect_uri': 'upstream_redirect_uri',  # noqa: E501
        'managed_upstreams': 'managed_upstreams',  # noqa: E501
        'oidc_upstreams': 'oidc_upstreams',  # noqa: E501
        'local_auth_upstreams': 'local_auth_upstreams',  # noqa: E501
        'application_upstreams': 'application_upstreams',  # noqa: E501
        'kerberos_upstreams': 'kerberos_upstreams',  # noqa: E501
        'clients': 'clients',  # noqa: E501
        'upstream_group_mappings': 'upstream_group_mappings',  # noqa: E501
        'name_slug': 'name_slug',  # noqa: E501
        'saml_state_encryption_key': 'saml_state_encryption_key',  # noqa: E501
        'service_account_id': 'service_account_id',  # noqa: E501
        'service_account_user_id': 'service_account_user_id',  # noqa: E501
        'verified_domains': 'verified_domains',  # noqa: E501
        'admin_status': 'admin_status',  # noqa: E501
        'trap_disabled': 'trap_disabled',  # noqa: E501
        'operational_status': 'operational_status',  # noqa: E501
        'parent_issuer': 'parent_issuer',  # noqa: E501
        'status': 'status',  # noqa: E501
    }

    read_only_vars = {
        'id',  # noqa: E501
        'clients',  # noqa: E501
        'upstream_group_mappings',  # noqa: E501
        'service_account_id',  # noqa: E501
        'service_account_user_id',  # noqa: E501
        'verified_domains',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, issuer, *args, **kwargs):  # noqa: E501
        """Issuer - a model defined in OpenAPI

        Args:
            issuer (str): connect id issuer

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): Unique identifier. [optional]  # noqa: E501
            enabled (bool): Describes whether or not the issuer is enabled. [optional] if omitted the server will use the default value of True  # noqa: E501
            org_id (str): ID of the organisation which owns the issuer. [optional]  # noqa: E501
            theme_file_id (str): ID of the theme file. The theme file is a zip file containing the web assets to show the client on login.. [optional]  # noqa: E501
            upstream_redirect_uri (str): Upstream redirect URI is the URI to which OpenID Connect upstreams will redirect after authentication. This is provisioned by Agilicus, but must be allowed by the upstream.. [optional]  # noqa: E501
            managed_upstreams ([ManagedUpstreamIdentityProvider]): The set of managed upstream identity providers for this issuer. A managed upstream has its configuration managed by default, and can be enabled or disabled for this issuer via this api.. [optional]  # noqa: E501
            oidc_upstreams ([OIDCUpstreamIdentityProvider]): The set of OpenID Connect upstream identity providers configured for this issuer. An upstream is managed by the client, and can be configured for this issuer via this api.. [optional]  # noqa: E501
            local_auth_upstreams ([LocalAuthUpstreamIdentityProvider]): The set of local authentication upstream identity providers configured for this issuer. A local authentication upstream can be an onsite Agilicus Agent.. [optional]  # noqa: E501
            application_upstreams ([ApplicationUpstreamIdentityProvider]): The set of application upstream identity providers configured for this issuer. Applications that can act as their own source of identity can be used as application upstreams. . [optional]  # noqa: E501
            kerberos_upstreams ([KerberosUpstreamIdentityProvider]): The set of kerberos upstream identity providers for this issuer. Device identity can be used to enable zero-interaction login for users on trusted devices which have already entered their credentials. . [optional]  # noqa: E501
            clients ([IssuerClient]): List of clients. [optional]  # noqa: E501
            upstream_group_mappings ([UpstreamGroupMapping]): List of upstream group mappings. [optional]  # noqa: E501
            name_slug (K8sSlug): [optional]  # noqa: E501
            saml_state_encryption_key (str): The encryption key used to secure the saml state. This is used to encrypt the saml cookie that is used to identify the user. . [optional]  # noqa: E501
            service_account_id (str): Service account GUID used for the issuer. [optional]  # noqa: E501
            service_account_user_id (str): Service account user GUID used for the issuer. [optional]  # noqa: E501
            verified_domains ([str]): The list of verified domains for the issuer. This is used to authorize users with multiple upstream identities but who are represented as a single user in the Agilicus System. For example agilicus.com would allow users whose email ended in @agilicus.com to login from multiple upstream identity providers. . [optional]  # noqa: E501
            admin_status (AdminStatus): [optional]  # noqa: E501
            trap_disabled (bool): Inidicates whether traps (notifications) should be disabled for this entity. A true state indicates notifications will not be sent on transition. . [optional]  # noqa: E501
            operational_status (OperationalStatus): [optional]  # noqa: E501
            parent_issuer (str, none_type): A unique identifier which can be empty. The meaning of it being empty depends on the context in which it is used, but usually it implies that something is not set. . [optional]  # noqa: E501
            status (IssuerStatus): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.issuer = issuer
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, issuer, *args, **kwargs):  # noqa: E501
        """Issuer - a model defined in OpenAPI

        Args:
            issuer (str): connect id issuer

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): Unique identifier. [optional]  # noqa: E501
            enabled (bool): Describes whether or not the issuer is enabled. [optional] if omitted the server will use the default value of True  # noqa: E501
            org_id (str): ID of the organisation which owns the issuer. [optional]  # noqa: E501
            theme_file_id (str): ID of the theme file. The theme file is a zip file containing the web assets to show the client on login.. [optional]  # noqa: E501
            upstream_redirect_uri (str): Upstream redirect URI is the URI to which OpenID Connect upstreams will redirect after authentication. This is provisioned by Agilicus, but must be allowed by the upstream.. [optional]  # noqa: E501
            managed_upstreams ([ManagedUpstreamIdentityProvider]): The set of managed upstream identity providers for this issuer. A managed upstream has its configuration managed by default, and can be enabled or disabled for this issuer via this api.. [optional]  # noqa: E501
            oidc_upstreams ([OIDCUpstreamIdentityProvider]): The set of OpenID Connect upstream identity providers configured for this issuer. An upstream is managed by the client, and can be configured for this issuer via this api.. [optional]  # noqa: E501
            local_auth_upstreams ([LocalAuthUpstreamIdentityProvider]): The set of local authentication upstream identity providers configured for this issuer. A local authentication upstream can be an onsite Agilicus Agent.. [optional]  # noqa: E501
            application_upstreams ([ApplicationUpstreamIdentityProvider]): The set of application upstream identity providers configured for this issuer. Applications that can act as their own source of identity can be used as application upstreams. . [optional]  # noqa: E501
            kerberos_upstreams ([KerberosUpstreamIdentityProvider]): The set of kerberos upstream identity providers for this issuer. Device identity can be used to enable zero-interaction login for users on trusted devices which have already entered their credentials. . [optional]  # noqa: E501
            clients ([IssuerClient]): List of clients. [optional]  # noqa: E501
            upstream_group_mappings ([UpstreamGroupMapping]): List of upstream group mappings. [optional]  # noqa: E501
            name_slug (K8sSlug): [optional]  # noqa: E501
            saml_state_encryption_key (str): The encryption key used to secure the saml state. This is used to encrypt the saml cookie that is used to identify the user. . [optional]  # noqa: E501
            service_account_id (str): Service account GUID used for the issuer. [optional]  # noqa: E501
            service_account_user_id (str): Service account user GUID used for the issuer. [optional]  # noqa: E501
            verified_domains ([str]): The list of verified domains for the issuer. This is used to authorize users with multiple upstream identities but who are represented as a single user in the Agilicus System. For example agilicus.com would allow users whose email ended in @agilicus.com to login from multiple upstream identity providers. . [optional]  # noqa: E501
            admin_status (AdminStatus): [optional]  # noqa: E501
            trap_disabled (bool): Inidicates whether traps (notifications) should be disabled for this entity. A true state indicates notifications will not be sent on transition. . [optional]  # noqa: E501
            operational_status (OperationalStatus): [optional]  # noqa: E501
            parent_issuer (str, none_type): A unique identifier which can be empty. The meaning of it being empty depends on the context in which it is used, but usually it implies that something is not set. . [optional]  # noqa: E501
            status (IssuerStatus): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.issuer = issuer
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

