"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.07
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError


def lazy_import():
    from agilicus_api.model.invalid_policy_template import InvalidPolicyTemplate
    from agilicus_api.model.label_name import LabelName
    from agilicus_api.model.mfa_policy_template import MFAPolicyTemplate
    from agilicus_api.model.rule_config import RuleConfig
    from agilicus_api.model.simple_resource_policy_template import SimpleResourcePolicyTemplate
    from agilicus_api.model.simple_resource_policy_template_structure import SimpleResourcePolicyTemplateStructure
    from agilicus_api.model.source_info_policy_template import SourceInfoPolicyTemplate
    globals()['InvalidPolicyTemplate'] = InvalidPolicyTemplate
    globals()['LabelName'] = LabelName
    globals()['MFAPolicyTemplate'] = MFAPolicyTemplate
    globals()['RuleConfig'] = RuleConfig
    globals()['SimpleResourcePolicyTemplate'] = SimpleResourcePolicyTemplate
    globals()['SimpleResourcePolicyTemplateStructure'] = SimpleResourcePolicyTemplateStructure
    globals()['SourceInfoPolicyTemplate'] = SourceInfoPolicyTemplate


class PolicyTemplate(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('action',): {
            'ALLOW': "allow",
            'DENY': "deny",
        },
    }

    validations = {
        ('log_message',): {
            'max_length': 64,
            'regex': {
                'pattern': r'.*',  # noqa: E501
            },
        },
    }

    @property
    def seconds_since_last_challenge(self):
       return self.get("seconds_since_last_challenge")

    @seconds_since_last_challenge.setter
    def seconds_since_last_challenge(self, new_value):
       self.seconds_since_last_challenge = new_value

    @property
    def labels(self):
       return self.get("labels")

    @labels.setter
    def labels(self, new_value):
       self.labels = new_value

    @property
    def template_type(self):
       return self.get("template_type")

    @template_type.setter
    def template_type(self, new_value):
       self.template_type = new_value

    @property
    def source_subnets(self):
       return self.get("source_subnets")

    @source_subnets.setter
    def source_subnets(self, new_value):
       self.source_subnets = new_value

    @property
    def iso_country_codes(self):
       return self.get("iso_country_codes")

    @iso_country_codes.setter
    def iso_country_codes(self, new_value):
       self.iso_country_codes = new_value

    @property
    def log_message(self):
       return self.get("log_message")

    @log_message.setter
    def log_message(self, new_value):
       self.log_message = new_value

    @property
    def invert(self):
       return self.get("invert")

    @invert.setter
    def invert(self, new_value):
       self.invert = new_value

    @property
    def action(self):
       return self.get("action")

    @action.setter
    def action(self, new_value):
       self.action = new_value

    @property
    def original_template_type(self):
       return self.get("original_template_type")

    @original_template_type.setter
    def original_template_type(self, new_value):
       self.original_template_type = new_value

    @property
    def policy_structure(self):
       return self.get("policy_structure")

    @policy_structure.setter
    def policy_structure(self, new_value):
       self.policy_structure = new_value

    @property
    def rules(self):
       return self.get("rules")

    @rules.setter
    def rules(self, new_value):
       self.rules = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'template_type': (str,),  # noqa: E501
            'log_message': (str,),  # noqa: E501
            'seconds_since_last_challenge': (int,),  # noqa: E501
            'labels': ([LabelName],),  # noqa: E501
            'source_subnets': ([str],),  # noqa: E501
            'iso_country_codes': ([str],),  # noqa: E501
            'invert': (bool,),  # noqa: E501
            'action': (str,),  # noqa: E501
            'original_template_type': (str,),  # noqa: E501
            'policy_structure': ([SimpleResourcePolicyTemplateStructure],),  # noqa: E501
            'rules': ([RuleConfig],),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'InvalidPolicyTemplate': InvalidPolicyTemplate,
            'MFAPolicyTemplate': MFAPolicyTemplate,
            'SimpleResourcePolicyTemplate': SimpleResourcePolicyTemplate,
            'SourceInfoPolicyTemplate': SourceInfoPolicyTemplate,
            'invalid': InvalidPolicyTemplate,
            'mfa': MFAPolicyTemplate,
            'simple_resource': SimpleResourcePolicyTemplate,
            'source_info': SourceInfoPolicyTemplate,
        }
        if not val:
            return None
        return {'template_type': val}


    attribute_map = {
        'template_type': 'template_type',  # noqa: E501
        'log_message': 'log_message',  # noqa: E501
        'seconds_since_last_challenge': 'seconds_since_last_challenge',  # noqa: E501
        'labels': 'labels',  # noqa: E501
        'source_subnets': 'source_subnets',  # noqa: E501
        'iso_country_codes': 'iso_country_codes',  # noqa: E501
        'invert': 'invert',  # noqa: E501
        'action': 'action',  # noqa: E501
        'original_template_type': 'original_template_type',  # noqa: E501
        'policy_structure': 'policy_structure',  # noqa: E501
        'rules': 'rules',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """PolicyTemplate - a model defined in OpenAPI

        Keyword Args:
            template_type (str): The descriminator for the PolicyTemplate. Set this to `simple_resource`
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            log_message (str): If set, will emit a log message with this avalue on match. [optional]  # noqa: E501
            seconds_since_last_challenge (int): Challenge the user if they have not presented a second factor for the current session in the last N seconds. . [optional]  # noqa: E501
            labels ([LabelName]): Restrict the challenge to accesses for resources with one of these labels. . [optional]  # noqa: E501
            source_subnets ([str]): A list of IP subnets. If the request comes from one of them, it will be allowed or denied based on the provided configuration. . [optional]  # noqa: E501
            iso_country_codes ([str]): A list of ISO 3166-1 alpha-2 country codes. If the request comes from one of them, it will be allowed or denied based on the provided configuration. . [optional]  # noqa: E501
            invert (bool): If set to true, will match the request if the source ip is not in the source_subnets list, and the country code is not in the iso_country_codes list. . [optional]  # noqa: E501
            action (str): If set to allow, the request will be allowed if it matches. If set to deny, it will be denied. . [optional]  # noqa: E501
            original_template_type (str): The original type of the template.. [optional]  # noqa: E501
            policy_structure ([SimpleResourcePolicyTemplateStructure]): The list of trees defining the structure of this policy. . [optional]  # noqa: E501
            rules ([RuleConfig]): The rules which may be used in the `policy_structure`. A given rule is only applied by the policy if it is referenced by at least one policy_structure node. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self, from_openapi_data=True)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self


    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """PolicyTemplate - a model defined in OpenAPI

        Keyword Args:
            template_type (str): The descriminator for the PolicyTemplate. Set this to `simple_resource`
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            log_message (str): If set, will emit a log message with this avalue on match. [optional]  # noqa: E501
            seconds_since_last_challenge (int): Challenge the user if they have not presented a second factor for the current session in the last N seconds. . [optional]  # noqa: E501
            labels ([LabelName]): Restrict the challenge to accesses for resources with one of these labels. . [optional]  # noqa: E501
            source_subnets ([str]): A list of IP subnets. If the request comes from one of them, it will be allowed or denied based on the provided configuration. . [optional]  # noqa: E501
            iso_country_codes ([str]): A list of ISO 3166-1 alpha-2 country codes. If the request comes from one of them, it will be allowed or denied based on the provided configuration. . [optional]  # noqa: E501
            invert (bool): If set to true, will match the request if the source ip is not in the source_subnets list, and the country code is not in the iso_country_codes list. . [optional]  # noqa: E501
            action (str): If set to allow, the request will be allowed if it matches. If set to deny, it will be denied. . [optional]  # noqa: E501
            original_template_type (str): The original type of the template.. [optional]  # noqa: E501
            policy_structure ([SimpleResourcePolicyTemplateStructure]): The list of trees defining the structure of this policy. . [optional]  # noqa: E501
            rules ([RuleConfig]): The rules which may be used in the `policy_structure`. A given rule is only applied by the policy if it is referenced by at least one policy_structure node. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")


    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
          ],
          'oneOf': [
              InvalidPolicyTemplate,
              MFAPolicyTemplate,
              SimpleResourcePolicyTemplate,
              SourceInfoPolicyTemplate,
          ],
        }
