"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.07
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError



class SubscriptionUsageInput(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @property
    def num_resources(self):
       return self.get("num_resources")

    @num_resources.setter
    def num_resources(self, new_value):
       self.num_resources = new_value

    @property
    def num_desktops(self):
       return self.get("num_desktops")

    @num_desktops.setter
    def num_desktops(self, new_value):
       self.num_desktops = new_value

    @property
    def num_applications(self):
       return self.get("num_applications")

    @num_applications.setter
    def num_applications(self, new_value):
       self.num_applications = new_value

    @property
    def num_networks(self):
       return self.get("num_networks")

    @num_networks.setter
    def num_networks(self, new_value):
       self.num_networks = new_value

    @property
    def num_ssh(self):
       return self.get("num_ssh")

    @num_ssh.setter
    def num_ssh(self, new_value):
       self.num_ssh = new_value

    @property
    def num_databases(self):
       return self.get("num_databases")

    @num_databases.setter
    def num_databases(self, new_value):
       self.num_databases = new_value

    @property
    def num_resource_groups(self):
       return self.get("num_resource_groups")

    @num_resource_groups.setter
    def num_resource_groups(self, new_value):
       self.num_resource_groups = new_value

    @property
    def num_fileshares(self):
       return self.get("num_fileshares")

    @num_fileshares.setter
    def num_fileshares(self, new_value):
       self.num_fileshares = new_value

    @property
    def num_launchers(self):
       return self.get("num_launchers")

    @num_launchers.setter
    def num_launchers(self, new_value):
       self.num_launchers = new_value

    @property
    def num_users(self):
       return self.get("num_users")

    @num_users.setter
    def num_users(self, new_value):
       self.num_users = new_value

    @property
    def num_groups(self):
       return self.get("num_groups")

    @num_groups.setter
    def num_groups(self, new_value):
       self.num_groups = new_value

    @property
    def num_orgs(self):
       return self.get("num_orgs")

    @num_orgs.setter
    def num_orgs(self, new_value):
       self.num_orgs = new_value

    @property
    def num_connectors(self):
       return self.get("num_connectors")

    @num_connectors.setter
    def num_connectors(self, new_value):
       self.num_connectors = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'num_resources': (int,),  # noqa: E501
            'num_desktops': (int,),  # noqa: E501
            'num_applications': (int,),  # noqa: E501
            'num_networks': (int,),  # noqa: E501
            'num_ssh': (int,),  # noqa: E501
            'num_databases': (int,),  # noqa: E501
            'num_resource_groups': (int,),  # noqa: E501
            'num_fileshares': (int,),  # noqa: E501
            'num_launchers': (int,),  # noqa: E501
            'num_users': (int,),  # noqa: E501
            'num_groups': (int,),  # noqa: E501
            'num_orgs': (int,),  # noqa: E501
            'num_connectors': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'num_resources': 'num_resources',  # noqa: E501
        'num_desktops': 'num_desktops',  # noqa: E501
        'num_applications': 'num_applications',  # noqa: E501
        'num_networks': 'num_networks',  # noqa: E501
        'num_ssh': 'num_ssh',  # noqa: E501
        'num_databases': 'num_databases',  # noqa: E501
        'num_resource_groups': 'num_resource_groups',  # noqa: E501
        'num_fileshares': 'num_fileshares',  # noqa: E501
        'num_launchers': 'num_launchers',  # noqa: E501
        'num_users': 'num_users',  # noqa: E501
        'num_groups': 'num_groups',  # noqa: E501
        'num_orgs': 'num_orgs',  # noqa: E501
        'num_connectors': 'num_connectors',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """SubscriptionUsageInput - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            num_resources (int): The number of resources. Broken out separately both for convenience, but also to ensure that constraints involving the number of resources take into account unknown resource types potentially added in the future. . [optional]  # noqa: E501
            num_desktops (int): The number of desktops.. [optional]  # noqa: E501
            num_applications (int): The number of applications.. [optional]  # noqa: E501
            num_networks (int): The number of networks.. [optional]  # noqa: E501
            num_ssh (int): The number of ssh resources.. [optional]  # noqa: E501
            num_databases (int): The number of databases.. [optional]  # noqa: E501
            num_resource_groups (int): The number of resource groups.. [optional]  # noqa: E501
            num_fileshares (int): The number of fileshares.. [optional]  # noqa: E501
            num_launchers (int): The number of launchers.. [optional]  # noqa: E501
            num_users (int): The number of users.. [optional]  # noqa: E501
            num_groups (int): The number of groups.. [optional]  # noqa: E501
            num_orgs (int): The number of organistions in the subscription.. [optional]  # noqa: E501
            num_connectors (int): The number of connectors in the subscription.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SubscriptionUsageInput - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            num_resources (int): The number of resources. Broken out separately both for convenience, but also to ensure that constraints involving the number of resources take into account unknown resource types potentially added in the future. . [optional]  # noqa: E501
            num_desktops (int): The number of desktops.. [optional]  # noqa: E501
            num_applications (int): The number of applications.. [optional]  # noqa: E501
            num_networks (int): The number of networks.. [optional]  # noqa: E501
            num_ssh (int): The number of ssh resources.. [optional]  # noqa: E501
            num_databases (int): The number of databases.. [optional]  # noqa: E501
            num_resource_groups (int): The number of resource groups.. [optional]  # noqa: E501
            num_fileshares (int): The number of fileshares.. [optional]  # noqa: E501
            num_launchers (int): The number of launchers.. [optional]  # noqa: E501
            num_users (int): The number of users.. [optional]  # noqa: E501
            num_groups (int): The number of groups.. [optional]  # noqa: E501
            num_orgs (int): The number of organistions in the subscription.. [optional]  # noqa: E501
            num_connectors (int): The number of connectors in the subscription.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

