# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2017-09-13 10:39
from __future__ import unicode_literals

from decimal import Decimal
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('structure', '0052_customer_subnets'),
    ]

    operations = [
        migrations.CreateModel(
            name='SlurmPackage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_code', models.CharField(blank=True, max_length=30)),
                ('article_code', models.CharField(blank=True, max_length=30)),
                ('cpu_price', models.DecimalField(decimal_places=10, default=0, max_digits=14, validators=[django.core.validators.MinValueValidator(Decimal('0'))], verbose_name='Price for CPU hour')),
                ('gpu_price', models.DecimalField(decimal_places=10, default=0, max_digits=14, validators=[django.core.validators.MinValueValidator(Decimal('0'))], verbose_name='Price for GPU hour')),
                ('ram_price', models.DecimalField(decimal_places=10, default=0, max_digits=14, validators=[django.core.validators.MinValueValidator(Decimal('0'))], verbose_name='Price for GB RAM')),
                ('service_settings', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='structure.ServiceSettings')),
            ],
            options={
                'abstract': False,
                'verbose_name': 'SLURM package',
                'verbose_name_plural': 'SLURM packages',
            }
        ),
    ]
