"""ToGrill main module"""

from bleak.uuids import register_uuids

from .services import Service

SUPPORTED_DEVICES = {
    "Pro-00",
    "Pro-10",
    "Mini5",
    "MiniClk",
    "MW-01",
    "NEX-01",
    "NEX-02",
    "AT-01",
    "AT-02",
    "Nano",
    "HTD",
    "AP-MTT980",
    "WM-01",
    "NC01",
    "Candy",
    "Pro-01",
    "Pro-02",
    "Pro-03",
    "Pro-04",
    "Pro-05",
    "Pro-06",
    "Pro-07",
    "Pro-08",
    "Pro-09",
    "Pro10",
    "X1",
    "X2",
    "Nano2",
    "Kweight",
    "WPprobe",
    "WPpCHAR",
    "WP-01",
    "WP-02",
    "WP02",
    "WP03",
    "WP03A",
    "WP03B",
    "KT",
    "KT1",
    "KT2",
    "HB1",
    "HB2",
    "DM1",
    "ED1",
    "EN1",
    "EN2",
    "YFC1",
    "YFC2",
    "WPpbcon",
    "WPpbCHG",
    "WPR01",
    "WPR02",
    "WPR03",
    "NPL1",
    "SG1",
    "WPS2",
    "PS2",
    "WPS1",
    "PS1",
    "ES1",
    "SW1",
    "MAY",
    "IGNITE",
    "WP05",
    "WP06",
    "WP07",
    "WP08",
    "WP08N",
    "FC1",
    "FC2",
    "GP1",
    "HL02",
    "TXD01",
    "BI01",
    "BI02",
    "ACCU-PRO",
    "ATK-02",
    "GM1",
    "NanoS",
    "BP55",
    "BP05",
    "BP40",
    "AT-02W1",
    "AT-02W2",
    "AT-02W4",
    "BI01W1",
    "BI01W2",
    "BI01W4",
    "OG2",
    "ALFA01H",
    "AT-03",
}

register_uuids(
    {service.uuid: f"ToGrill {service.__name__}" for service in Service.registry.values()}
)

register_uuids(
    {
        char.uuid: f"ToGrill {service.__name__} {char.name}"
        for service in Service.registry.values()
        for char in service.characteristics()
    }
)
