# rbczpremiumapi
##### API Overview
- Accounts list and balance
- Transaction overview (also for saving accounts)
- Payments import
- Statement list and download
- FX rates

##### Authentication
Before making a call to Premium API, you need to register your app at our _Developer portal_. This is where you get the **ClientID** that your application must send in the request as `X-IBM-Client-Id`. This is the key that grants your app access to the API.

However, this may not be enough. Your application needs to use mTLS to call most operations here. Thus, you not only need _https_ but also a client certificate issued by us. The exception is two operations for FX rates that are accessible also without a client certificate.

Each bank client/user can issue several certificates. Each certificate can permit different sets of operations (http methods) on different bank accounts. All this must be configured in Internet Banking first by each bank client/user (bank clients need to look under _Settings_ and do not forget to download the certificate at the last step). The certificate is downloaded in **PKCS#12** format as **\\*.p12** file and protected by a password chosen by the bank client/user. Yes, your app needs the password as well to get use of the **\\*p12** file for establishing mTLS connection to the bank.

Client certificates issued in Internet Banking for bank clients/users have limited validity (e.g. **5 years**). However, **each year** certificates are automatically blocked and bank client/user must unblock them in Internet Banking. It is possible to do it in advance and prolong the time before the certificate is blocked. Your app should be prepared for these scenarios and it should communicate such cases to your user in advance to provide seamless service and high user-experience of your app.

##### Rate Limiting
The number of requests in each API operation is limited to 10 per client per sliding second and 5000 per client per sliding day. The exception is the 'Download Statement' operation with the limits lowered to 5 per client per sliding second and 1500 per client per sliding day. This is because it transports potentially sizeable binary files. The consumer must be able to handle HTTP status 429 in case of exceeding these limits.

Response headers `X-RateLimit-Limit-Second` and `X-RateLimit-Limit-Day` show the actual limits configured for the specific operation. Response headers `X-RateLimit-Remaining-Second` and `X-RateLimit-Remaining-Day` are returned to help prevent the limits from being exceeded.

##### Notes
Be aware, that in certain error situations, API can return specific error structures along with 5xx status code, which is not explicitely defined below.

##### Quick Start Client
Feel free to download a <a href=\"assets/PremiumApiClient.java\" download>simple Java client</a> that gives you quick access to our API.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.20240910
- Package version: 1.0.0
- Generator version: 7.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/VitexSoftware/python-vitexsoftware-rbczpremiumapi.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/VitexSoftware/python-vitexsoftware-rbczpremiumapi.git`)

Then import the package:
```python
import rbczpremiumapi
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import rbczpremiumapi
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import rbczpremiumapi
from rbczpremiumapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.rb.cz
# See configuration.py for a list of all supported configuration parameters.
configuration = rbczpremiumapi.Configuration(
    host = "https://api.rb.cz"
)



# Enter a context with an instance of the API client
with rbczpremiumapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = rbczpremiumapi.DownloadStatementApi(api_client)
    x_ibm_client_id = 'x_ibm_client_id_example' # str | ClientID obtained from Developer Portal - when you registered your app with us.
    x_request_id = 'x_request_id_example' # str | Unique request id provided by consumer application for reference and auditing.
    accept_language = 'accept_language_example' # str | The Accept-Language request HTTP header is used to determine document  language. Supported languages are `cs` and `en`.
    request_body = rbczpremiumapi.DownloadStatementRequest() # DownloadStatementRequest | 
    psu_ip_address = 'psu_ip_address_example' # str | IP address of a client - the end IP address of the client application (no server) in IPv4 or IPv6 format. If the bank client (your user) uses a browser by which he accesses your server app, we need to know the IP address of his browser. Always provide the closest IP address to the real end-user possible. (optional)

    try:
        api_response = api_instance.download_statement(x_ibm_client_id, x_request_id, accept_language, request_body, psu_ip_address=psu_ip_address)
        print("The response of DownloadStatementApi->download_statement:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DownloadStatementApi->download_statement: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.rb.cz*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DownloadStatementApi* | [**download_statement**](docs/DownloadStatementApi.md#download_statement) | **POST** /rbcz/premium/api/accounts/statements/download | 
*GetAccountBalanceApi* | [**get_balance**](docs/GetAccountBalanceApi.md#get_balance) | **GET** /rbcz/premium/api/accounts/{accountNumber}/balance | 
*GetAccountsApi* | [**get_accounts**](docs/GetAccountsApi.md#get_accounts) | **GET** /rbcz/premium/api/accounts | 
*GetBatchDetailApi* | [**get_batch_detail**](docs/GetBatchDetailApi.md#get_batch_detail) | **GET** /rbcz/premium/api/payments/batches/{batchFileId} | 
*GetFxRatesApi* | [**get_fx_rates**](docs/GetFxRatesApi.md#get_fx_rates) | **GET** /rbcz/premium/api/fxrates/{currencyCode} | 
*GetFxRatesListApi* | [**get_fx_rates_list**](docs/GetFxRatesListApi.md#get_fx_rates_list) | **GET** /rbcz/premium/api/fxrates | 
*GetStatementListApi* | [**get_statements**](docs/GetStatementListApi.md#get_statements) | **POST** /rbcz/premium/api/accounts/statements | 
*GetTransactionListApi* | [**get_transaction_list**](docs/GetTransactionListApi.md#get_transaction_list) | **GET** /rbcz/premium/api/accounts/{accountNumber}/{currencyCode}/transactions | 
*UploadPaymentsApi* | [**import_payments**](docs/UploadPaymentsApi.md#import_payments) | **POST** /rbcz/premium/api/payments/batches | 


## Documentation For Models

 - [CurrencyListSimple](docs/CurrencyListSimple.md)
 - [DownloadStatementRequest](docs/DownloadStatementRequest.md)
 - [ExchangeRate](docs/ExchangeRate.md)
 - [ExchangeRateList](docs/ExchangeRateList.md)
 - [GetAccounts200Response](docs/GetAccounts200Response.md)
 - [GetAccounts200ResponseAccountsInner](docs/GetAccounts200ResponseAccountsInner.md)
 - [GetBalance200Response](docs/GetBalance200Response.md)
 - [GetBalance200ResponseCurrencyFoldersInner](docs/GetBalance200ResponseCurrencyFoldersInner.md)
 - [GetBalance200ResponseCurrencyFoldersInnerBalancesInner](docs/GetBalance200ResponseCurrencyFoldersInnerBalancesInner.md)
 - [GetBalance401Response](docs/GetBalance401Response.md)
 - [GetBalance403Response](docs/GetBalance403Response.md)
 - [GetBalance404Response](docs/GetBalance404Response.md)
 - [GetBalance429Response](docs/GetBalance429Response.md)
 - [GetBatchDetail200Response](docs/GetBatchDetail200Response.md)
 - [GetBatchDetail200ResponseBatchItemsInner](docs/GetBatchDetail200ResponseBatchItemsInner.md)
 - [GetBatchDetail200ResponseBatchItemsInnerAccountInfo](docs/GetBatchDetail200ResponseBatchItemsInnerAccountInfo.md)
 - [GetBatchDetail400Response](docs/GetBatchDetail400Response.md)
 - [GetStatements200Response](docs/GetStatements200Response.md)
 - [GetStatements200ResponseStatementsInner](docs/GetStatements200ResponseStatementsInner.md)
 - [GetStatements400Response](docs/GetStatements400Response.md)
 - [GetStatementsRequest](docs/GetStatementsRequest.md)
 - [GetTransactionList200Response](docs/GetTransactionList200Response.md)
 - [GetTransactionList200ResponseTransactionsInner](docs/GetTransactionList200ResponseTransactionsInner.md)
 - [GetTransactionList200ResponseTransactionsInnerAmount](docs/GetTransactionList200ResponseTransactionsInnerAmount.md)
 - [GetTransactionList200ResponseTransactionsInnerBankTransactionCode](docs/GetTransactionList200ResponseTransactionsInnerBankTransactionCode.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetails](docs/GetTransactionList200ResponseTransactionsInnerEntryDetails.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetails](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetails.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsInstructedAmount](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsInstructedAmount.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsReferences](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsReferences.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedParties](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedParties.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterParty](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterParty.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterPartyAccount](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterPartyAccount.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterPartyOrganisationIdentification](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterPartyOrganisationIdentification.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterPartyOrganisationIdentificationPostalAddress](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterPartyOrganisationIdentificationPostalAddress.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterPartyPostalAddress](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesCounterPartyPostalAddress.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesIntermediaryInstitution](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesIntermediaryInstitution.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesIntermediaryInstitutionPostalAddress](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesIntermediaryInstitutionPostalAddress.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesUltimateCounterParty](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRelatedPartiesUltimateCounterParty.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRemittanceInformation](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRemittanceInformation.md)
 - [GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRemittanceInformationCreditorReferenceInformation](docs/GetTransactionList200ResponseTransactionsInnerEntryDetailsTransactionDetailsRemittanceInformationCreditorReferenceInformation.md)
 - [GetTransactionList400Response](docs/GetTransactionList400Response.md)
 - [ImportPayments200Response](docs/ImportPayments200Response.md)
 - [ImportPayments400Response](docs/ImportPayments400Response.md)
 - [ImportPayments413Response](docs/ImportPayments413Response.md)
 - [ImportPayments415Response](docs/ImportPayments415Response.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author

info@vitexsoftware.cz


