# coding: utf-8

# coding: utf-8

"""
    Production

    ##### API Overview - Accounts list and balance - Transaction overview (also for saving accounts) - Payments import - Statement list and download - FX rates  ##### Authentication Before making a call to Premium API, you need to register your app at our _Developer portal_. This is where you get the **ClientID** that your application must send in the request as &#x60;X-IBM-Client-Id&#x60;. This is the key that grants your app access to the API.  However, this may not be enough. Your application needs to use mTLS to call most operations here. Thus, you not only need _https_ but also a client certificate issued by us. The exception is two operations for FX rates that are accessible also without a client certificate.  Each bank client/user can issue several certificates. Each certificate can permit different sets of operations (http methods) on different bank accounts. All this must be configured in Internet Banking first by each bank client/user (bank clients need to look under _Settings_ and do not forget to download the certificate at the last step). The certificate is downloaded in **PKCS#12** format as **\\*.p12** file and protected by a password chosen by the bank client/user. Yes, your app needs the password as well to get use of the **\\*p12** file for establishing mTLS connection to the bank.  Client certificates issued in Internet Banking for bank clients/users have limited validity (e.g. **5 years**). However, **each year** certificates are automatically blocked and bank client/user must unblock them in Internet Banking. It is possible to do it in advance and prolong the time before the certificate is blocked. Your app should be prepared for these scenarios and it should communicate such cases to your user in advance to provide seamless service and high user-experience of your app.  ##### Rate Limiting The number of requests in each API operation is limited to 10 per client per sliding second and 5000 per client per sliding day. The exception is the &#39;Download Statement&#39; operation with the limits lowered to 5 per client per sliding second and 1500 per client per sliding day. This is because it transports potentially sizeable binary files. The consumer must be able to handle HTTP status 429 in case of exceeding these limits.  Response headers &#x60;X-RateLimit-Limit-Second&#x60; and &#x60;X-RateLimit-Limit-Day&#x60; show the actual limits configured for the specific operation. Response headers &#x60;X-RateLimit-Remaining-Second&#x60; and &#x60;X-RateLimit-Remaining-Day&#x60; are returned to help prevent the limits from being exceeded.  ##### Notes Be aware, that in certain error situations, API can return specific error structures along with 5xx status code, which is not explicitely defined below.  ##### Quick Start Client Feel free to download a &lt;a href&#x3D;\&quot;assets/PremiumApiClient.java\&quot; download&gt;simple Java client&lt;/a&gt; that gives you quick access to our API. 

    The version of the OpenAPI document: 1.1.20240910
    Generated by OpenAPI Generator: https://openapi-generator.tech

    Do not edit the class manually.
"""

from typing import Dict, List, Optional, Union, Any, TYPE_CHECKING
import requests
import json
from urllib.parse import urljoin

# Import necessary dependencies for API operations  
from pydantic import Field, StrictBytes, StrictStr, field_validator
from typing_extensions import Annotated

# Import models and API client
from ..api_client import ApiClient

# Import models for type hints
if TYPE_CHECKING:
    # Import all possible model classes that might be used as return types
    from ..Model.get_balance200_response import GetBalance200Response
    from ..Model.get_balance401_response import GetBalance401Response
    from ..Model.get_balance403_response import GetBalance403Response
    from ..Model.get_balance404_response import GetBalance404Response
    from ..Model.get_balance429_response import GetBalance429Response
    from ..Model.get_accounts200_response import GetAccounts200Response
    from ..Model.get_statements200_response import GetStatements200Response
    from ..Model.get_statements400_response import GetStatements400Response
    from ..Model.get_batch_detail200_response import GetBatchDetail200Response
    from ..Model.get_batch_detail400_response import GetBatchDetail400Response
    from ..Model.get_transaction_list200_response import GetTransactionList200Response
    from ..Model.get_transaction_list400_response import GetTransactionList400Response
    from ..Model.import_payments200_response import ImportPayments200Response
    from ..Model.import_payments400_response import ImportPayments400Response
    from ..Model.import_payments413_response import ImportPayments413Response
    from ..Model.import_payments415_response import ImportPayments415Response
    from ..Model.exchange_rate_list import ExchangeRateList
    from ..Model.currency_list_simple import CurrencyListSimple

class DownloadStatementApi:

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def download_statement(self, x_ibm_client_id, x_request_id, accept_language, request_body, psu_ip_address=None, **kwargs) -> "bytearray":
        """Download the selected statement.  Returns one of the following &#x60;Content-type&#x60; header values depending on  the downloaded document type: &lt;code&gt;application/pdf&lt;/code&gt;, &lt;code&gt;application/xml&lt;/code&gt;, &lt;code&gt;text/mt940&lt;/code&gt;, &lt;code&gt;application/json&lt;/code&gt; (in case of an error). 

        :param x_ibm_client_id: ClientID obtained from Developer Portal - when you registered your app with us. (required)
        :type x_ibm_client_id: str
        :param x_request_id: Unique request id provided by consumer application for reference and auditing. (required)
        :type x_request_id: str
        :param accept_language: The Accept-Language request HTTP header is used to determine document  language. Supported languages are &#x60;cs&#x60; and &#x60;en&#x60;. (required)
        :type accept_language: str
        :param request_body:  (required)
        :type request_body: DownloadStatementRequest
        :param psu_ip_address: IP address of a client - the end IP address of the client application (no server) in IPv4 or IPv6 format. If the bank client (your user) uses a browser by which he accesses your server app, we need to know the IP address of his browser. Always provide the closest IP address to the real end-user possible.
        :type psu_ip_address: str or None
        :param _request_timeout: timeout setting for this request
        :type _request_timeout: int, tuple(int, int), optional
        :param _return_http_data_only: response data without head status code and headers
        :type _return_http_data_only: bool, optional
        :param collection_formats: dict of collection formats for path, query, header, and formData parameters.
        :type collection_formats: dict, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will be returned without reading/decoding response data. Default is True.
        :type _preload_content: bool, optional
        :param _request_auth: set to override the auth_settings for an request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
        :rtype: bytearray
        """
        if x_ibm_client_id is None:
            raise ValueError("Missing the required parameter `x_ibm_client_id` when calling `download_statement`")
        if x_request_id is None:
            raise ValueError("Missing the required parameter `x_request_id` when calling `download_statement`")
        if accept_language is None:
            raise ValueError("Missing the required parameter `accept_language` when calling `download_statement`")
        if request_body is None:
            raise ValueError("Missing the required parameter `request_body` when calling `download_statement`")

        # Construct URL
        url = self.api_client.configuration.host + "/rbcz/premium/api/accounts/statements/download"

        # Prepare headers
        headers = {}
        if x_ibm_client_id is not None:
            headers["X-IBM-Client-Id"] = x_ibm_client_id
        if x_request_id is not None:
            headers["X-Request-Id"] = x_request_id
        if accept_language is not None:
            headers["Accept-Language"] = accept_language
        if psu_ip_address is not None:
            headers["PSU-IP-Address"] = psu_ip_address

        # Prepare query parameters
        query_params = {}

        # Prepare request body
        body = None
        if request_body is not None:
            body = request_body

        # Make request
        response = self.api_client.call_api(
            resource_path="/rbcz/premium/api/accounts/statements/download",
            method="POST",
            headers=headers,
            query_params=query_params,
            body=body,
            response_type="bytearray",
            **kwargs
        )

        return response

