# coding: utf-8

# coding: utf-8

"""
    Production

    ##### API Overview - Accounts list and balance - Transaction overview (also for saving accounts) - Payments import - Statement list and download - FX rates  ##### Authentication Before making a call to Premium API, you need to register your app at our _Developer portal_. This is where you get the **ClientID** that your application must send in the request as &#x60;X-IBM-Client-Id&#x60;. This is the key that grants your app access to the API.  However, this may not be enough. Your application needs to use mTLS to call most operations here. Thus, you not only need _https_ but also a client certificate issued by us. The exception is two operations for FX rates that are accessible also without a client certificate.  Each bank client/user can issue several certificates. Each certificate can permit different sets of operations (http methods) on different bank accounts. All this must be configured in Internet Banking first by each bank client/user (bank clients need to look under _Settings_ and do not forget to download the certificate at the last step). The certificate is downloaded in **PKCS#12** format as **\\*.p12** file and protected by a password chosen by the bank client/user. Yes, your app needs the password as well to get use of the **\\*p12** file for establishing mTLS connection to the bank.  Client certificates issued in Internet Banking for bank clients/users have limited validity (e.g. **5 years**). However, **each year** certificates are automatically blocked and bank client/user must unblock them in Internet Banking. It is possible to do it in advance and prolong the time before the certificate is blocked. Your app should be prepared for these scenarios and it should communicate such cases to your user in advance to provide seamless service and high user-experience of your app.  ##### Rate Limiting The number of requests in each API operation is limited to 10 per client per sliding second and 5000 per client per sliding day. The exception is the &#39;Download Statement&#39; operation with the limits lowered to 5 per client per sliding second and 1500 per client per sliding day. This is because it transports potentially sizeable binary files. The consumer must be able to handle HTTP status 429 in case of exceeding these limits.  Response headers &#x60;X-RateLimit-Limit-Second&#x60; and &#x60;X-RateLimit-Limit-Day&#x60; show the actual limits configured for the specific operation. Response headers &#x60;X-RateLimit-Remaining-Second&#x60; and &#x60;X-RateLimit-Remaining-Day&#x60; are returned to help prevent the limits from being exceeded.  ##### Notes Be aware, that in certain error situations, API can return specific error structures along with 5xx status code, which is not explicitely defined below.  ##### Quick Start Client Feel free to download a &lt;a href&#x3D;\&quot;assets/PremiumApiClient.java\&quot; download&gt;simple Java client&lt;/a&gt; that gives you quick access to our API. 

    The version of the OpenAPI document: 1.1.20240910
    Generated by OpenAPI Generator: https://openapi-generator.tech

    Do not edit the class manually.
"""

from typing import Dict, List, Optional, Union, Any, TYPE_CHECKING
import requests
import json
from urllib.parse import urljoin

# Import necessary dependencies for API operations  
from pydantic import Field, StrictBytes, StrictStr, field_validator
from typing_extensions import Annotated

# Import models and API client
from ..api_client import ApiClient

# Import models for type hints
if TYPE_CHECKING:
    # Import all possible model classes that might be used as return types
    from ..Model.get_balance200_response import GetBalance200Response
    from ..Model.get_balance401_response import GetBalance401Response
    from ..Model.get_balance403_response import GetBalance403Response
    from ..Model.get_balance404_response import GetBalance404Response
    from ..Model.get_balance429_response import GetBalance429Response
    from ..Model.get_accounts200_response import GetAccounts200Response
    from ..Model.get_statements200_response import GetStatements200Response
    from ..Model.get_statements400_response import GetStatements400Response
    from ..Model.get_batch_detail200_response import GetBatchDetail200Response
    from ..Model.get_batch_detail400_response import GetBatchDetail400Response
    from ..Model.get_transaction_list200_response import GetTransactionList200Response
    from ..Model.get_transaction_list400_response import GetTransactionList400Response
    from ..Model.import_payments200_response import ImportPayments200Response
    from ..Model.import_payments400_response import ImportPayments400Response
    from ..Model.import_payments413_response import ImportPayments413Response
    from ..Model.import_payments415_response import ImportPayments415Response
    from ..Model.exchange_rate_list import ExchangeRateList
    from ..Model.currency_list_simple import CurrencyListSimple

class UploadPaymentsApi:

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def import_payments(self, x_ibm_client_id, x_request_id, batch_import_format, request_body, psu_ip_address=None, batch_name=None, batch_combined_payments=None, batch_autocorrect=None, **kwargs) -> "ImportPayments200Response":
        """Importing batch payments in one of [supported formates](https://www.rb.cz/attachments/direct-banking/ekomunikator-datova-struktura.pdf) - see request parameter &#x60;Batch-Import-Format&#x60;.  This is an API alternative to the manual import of batch payments through [Internet Banking](https://www.rb.cz/podnikatele/ucty-a-platebni-styk/prime-bankovnictvi/internetove-bankovnictvi/caste-dotazy/import-hromadnych-plateb).  Imported payments are not immediately processed, they are just loaded into Internet Banking and they still must be authorized/certified in Internet Banking according to client settings of disposable rights and signatures.  Once authorized/certified, uploaded payments will be processed in the Instant payments mode if the following conditions are met&amp;#58; 1. the batch has no more than 100 payments 2. no more than 10 batches per day were uploaded 3. individual payments meet the conditions for Instant payments - see [Instant Payments](https://www.rb.cz/informacni-servis/platebni-styk/tuzemske-platby/okamzite-platby) 4. on the weekend, only payments within our bank are processed as Instant payments  The number of transactions in one request is limited to 15.000 (this can change without prior notice). The limit is not checked during the call,  it is performed later and a possible error is provided in Internet Banking.

        :param x_ibm_client_id: ClientID obtained from Developer Portal - when you registered your app with us. (required)
        :type x_ibm_client_id: str
        :param x_request_id: Unique request id provided by consumer application for reference and auditing. (required)
        :type x_request_id: str
        :param batch_import_format: Format of imported batch. For CCT format please use option SEPA-XML. (required)
        :type batch_import_format: str
        :param request_body:  (required)
        :type request_body: str
        :param psu_ip_address: IP address of a client - the end IP address of the client application (no server) in IPv4 or IPv6 format. If the bank client (your user) uses a browser by which he accesses your server app, we need to know the IP address of his browser. Always provide the closest IP address to the real end-user possible.
        :type psu_ip_address: str or None
        :param batch_name: Batch name, if not present then will be generated in format &#x60;ImportApi_&lt;DDMMYYYY&gt;&#x60;.  If the name is longer than 50 characters, it will be truncated  
        :type batch_name: str or None
        :param batch_combined_payments: Optional header for combined payments. Payments inside the import file are considered as combined in case the header is present and its value is set to &#39;true&#39;. 
        :type batch_combined_payments: bool or None
        :param batch_autocorrect: Flag if valueDate should be autocorrected in the imported file or not. Autocorrection moved valueDate on first available valid  (working) day. Beware that this may affect if the payment will be sent as instant or not since only payments with valueDate same as actual date (during sending of payment to bank) can be sent as instant. 
        :type batch_autocorrect: bool or None
        :param _request_timeout: timeout setting for this request
        :type _request_timeout: int, tuple(int, int), optional
        :param _return_http_data_only: response data without head status code and headers
        :type _return_http_data_only: bool, optional
        :param collection_formats: dict of collection formats for path, query, header, and formData parameters.
        :type collection_formats: dict, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will be returned without reading/decoding response data. Default is True.
        :type _preload_content: bool, optional
        :param _request_auth: set to override the auth_settings for an request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
        :rtype: ImportPayments200Response
        """
        if x_ibm_client_id is None:
            raise ValueError("Missing the required parameter `x_ibm_client_id` when calling `import_payments`")
        if x_request_id is None:
            raise ValueError("Missing the required parameter `x_request_id` when calling `import_payments`")
        if batch_import_format is None:
            raise ValueError("Missing the required parameter `batch_import_format` when calling `import_payments`")
        if request_body is None:
            raise ValueError("Missing the required parameter `request_body` when calling `import_payments`")

        # Construct URL
        url = self.api_client.configuration.host + "/rbcz/premium/api/payments/batches"

        # Prepare headers
        headers = {}
        if x_ibm_client_id is not None:
            headers["X-IBM-Client-Id"] = x_ibm_client_id
        if x_request_id is not None:
            headers["X-Request-Id"] = x_request_id
        if psu_ip_address is not None:
            headers["PSU-IP-Address"] = psu_ip_address
        if batch_import_format is not None:
            headers["Batch-Import-Format"] = batch_import_format
        if batch_name is not None:
            headers["Batch-Name"] = batch_name
        if batch_combined_payments is not None:
            headers["Batch-Combined-Payments"] = batch_combined_payments
        if batch_autocorrect is not None:
            headers["Batch-Autocorrect"] = batch_autocorrect

        # Prepare query parameters
        query_params = {}

        # Prepare request body
        body = None
        if request_body is not None:
            body = request_body

        # Make request
        response = self.api_client.call_api(
            resource_path="/rbcz/premium/api/payments/batches",
            method="POST",
            headers=headers,
            query_params=query_params,
            body=body,
            response_type="ImportPayments200Response",
            **kwargs
        )

        return response

