# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-09-22T10:05:32+00:00

from __future__ import annotations

from typing import Annotated

from centra_sdk.utils.handler_registry import HandlerRegistry
from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *

router = APIRouter(tags=['Agents'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class AgentsHandler:
    def __init__(self):
        pass

    async def set_agent_info(self, body: AgentsInfo) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"set_agent_info not implemented")

    async def update_agent_info(self, body: AgentsInfo) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"update_agent_info not implemented"
        )


@router.post('/v1/consumer/agents-info', response_model=None, tags=['Agents'])
async def set_agent_info(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: AgentsInfo,
) -> None:
    """
    Report info about Centra agents, overrides any previous provided data
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(set_agent_info.__name__, token, body)


@router.put('/v1/consumer/agents-info', response_model=None, tags=['Agents'])
async def update_agent_info(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: AgentsInfo,
) -> None:
    """
    Report Centra agents info, in addition to the already provided data
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(update_agent_info.__name__, token, body)
