# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-09-22T10:05:32+00:00

from __future__ import annotations

from typing import Annotated

from centra_sdk.utils.handler_registry import HandlerRegistry
from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *

router = APIRouter(tags=['Authentication'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class AuthenticationHandler:
    def __init__(self):
        pass

    async def login_user_json(self, body: LoginRequest) -> LoginResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"login_user_json not implemented")

    async def login_user_form(self, request: Request) -> LoginResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"login_user_form not implemented")


@router.post(
    '/v1/login',
    response_model=LoginResponse,
    responses={'401': {'model': UnauthorizedError}, '400': {'model': BadRequestError}},
    tags=['Authentication'],
)
async def login_user_json(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: LoginRequest,
) -> Union[LoginResponse, UnauthorizedError, BadRequestError]:
    """
    User login (JSON)
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(login_user_json.__name__, token, body)


@router.post(
    '/v1/login-form',
    response_model=LoginResponse,
    responses={'401': {'model': UnauthorizedError}, '400': {'model': BadRequestError}},
    tags=['Authentication'],
)
async def login_user_form(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    request: Request,
) -> Union[LoginResponse, UnauthorizedError, BadRequestError]:
    """
    User login (Form)
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(login_user_form.__name__, token, request)
