# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-09-22T10:05:32+00:00

from __future__ import annotations

from typing import Annotated

from centra_sdk.utils.handler_registry import HandlerRegistry
from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *

router = APIRouter(tags=['Inventory'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class InventoryHandler:
    def __init__(self):
        pass

    async def get_labels(
        self,
        cursor: Optional[conint(ge=0)] = 0,
        page_size: Optional[conint(ge=1, le=1000)] = 100,
    ) -> Labels:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"get_labels not implemented")

    async def get_inventory(
        self,
        cursor: Optional[conint(ge=0)] = 0,
        page_size: Optional[conint(ge=1, le=1000)] = 100,
    ) -> Inventory:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"get_inventory not implemented")

    async def push_inventory_of_type(
        self,
        id: str,
        asset_type: InventoryAssetType = ...,
        revision: int = ...,
        reporter: Optional[InventoryReporterType] = None,
        body: Inventory = ...,
    ) -> V1ProviderInventoryIdAssetsAssetTypePostResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"push_inventory_of_type not implemented"
        )

    async def get_asset_id(self, body: LookupRequest) -> InventoryItem:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"get_asset_id not implemented")

    async def get_network_topology(
        self,
        cursor: Optional[conint(ge=0)] = 0,
        page_size: Optional[conint(ge=1, le=1000)] = 100,
    ) -> NetworkTopology:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_network_topology not implemented"
        )


@router.get('/v1/provider/import-labels', response_model=Labels, tags=['Inventory'])
async def get_labels(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    cursor: Optional[conint(ge=0)] = 0,
    page_size: Optional[conint(ge=1, le=1000)] = 100,
) -> Labels:
    """
    Get connector environment labels (with pagination)
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(get_labels.__name__, token, cursor, page_size)


@router.get('/v1/provider/inventory', response_model=Inventory, tags=['Inventory'])
async def get_inventory(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    cursor: Optional[conint(ge=0)] = 0,
    page_size: Optional[conint(ge=1, le=1000)] = 100,
) -> Inventory:
    """
    Retrieve the entire inventory
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(get_inventory.__name__, token, cursor, page_size)


@router.post(
    '/v1/provider/inventory/{id}/assets/{asset_type}',
    response_model=V1ProviderInventoryIdAssetsAssetTypePostResponse,
    responses={'412': {'model': V1ProviderInventoryIdAssetsAssetTypePostResponse1}},
    tags=['Inventory'],
)
async def push_inventory_of_type(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    id: str,
    asset_type: InventoryAssetType = ...,
    revision: int = ...,
    reporter: Optional[InventoryReporterType] = None,
    body: Inventory = ...,
) -> Union[
    V1ProviderInventoryIdAssetsAssetTypePostResponse,
    V1ProviderInventoryIdAssetsAssetTypePostResponse1,
]:
    """
    Report inventory for assets of type 'aset-type'
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(
        push_inventory_of_type.__name__, token, id, asset_type, revision, reporter, body
    )


@router.post('/v1/provider/lookup', response_model=InventoryItem, tags=['Inventory'])
async def get_asset_id(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: LookupRequest,
) -> InventoryItem:
    """
    Retrieve the asset id of the destination side.
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(get_asset_id.__name__, token, body)


@router.get('/v1/provider/topology', response_model=NetworkTopology, tags=['Inventory'])
async def get_network_topology(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    cursor: Optional[conint(ge=0)] = 0,
    page_size: Optional[conint(ge=1, le=1000)] = 100,
) -> NetworkTopology:
    """
    Retrieve network topology information
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(
        get_network_topology.__name__, token, cursor, page_size
    )
