import setuptools
import os
# os.system("SKLEARN_ALLOW_DEPRECATED_SKLEARN_PACKAGE_INSTALL=TRUE")

with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="spiderYa",
    version="0.1.4",
    author="Li Shiying",
    author_email="shiyingli7-c@my.cityu.edu.hk",
    description="Identifying spatially variable interactions",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/deepomicslab/SPIDER",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    
   package_data={'spider': ['lrdb/*.tsv'],
                 'spider': ['R_script/*.R']},
    
    install_requires=[
        'anndata>=0.8.0',
        'numpy',
        'Cython',
        'cellrank',
        'fa2',
        'gseapy',
        'h5py',
        'igraph',
        'leidenalg',
        'louvain',
        'matplotlib',
        'matplotlib-venn',
        'networkx',
        'numba',
        'numpy',
        'pandas',
        'plotly',
        'pygco',
        'scanpy',
        'scgco',
        'scikit-learn',
        'scipy',
        'scvelo',
        'seaborn',
        # 'scikit-learn',
        # 'sklearn',
        'somde',
        'somoclu',
        # 'spaotsc',
        'spatialde',
        'stlearn',
        'umap-learn',
        'statsmodels',
        # 'importlib',
        'scprep',
        'squidpy',
        'magic-impute',
        'NaiveDE',
        'gpflow',
        'tensorflow>=2.12',
    ],
)