# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.service_toggles_config import ServiceTogglesConfig
from .raw_client import AsyncRawServiceTogglesClient, RawServiceTogglesClient


class ServiceTogglesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawServiceTogglesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawServiceTogglesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawServiceTogglesClient
        """
        return self._raw_client

    def get_service_toggles(self, *, request_options: typing.Optional[RequestOptions] = None) -> ServiceTogglesConfig:
        """
        Get Service Toggles

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ServiceTogglesConfig
            Service Toggles

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.service_toggles.get_service_toggles()
        """
        _response = self._raw_client.get_service_toggles(request_options=request_options)
        return _response.data


class AsyncServiceTogglesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawServiceTogglesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawServiceTogglesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawServiceTogglesClient
        """
        return self._raw_client

    async def get_service_toggles(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ServiceTogglesConfig:
        """
        Get Service Toggles

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ServiceTogglesConfig
            Service Toggles

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.service_toggles.get_service_toggles()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_service_toggles(request_options=request_options)
        return _response.data
