# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .llm_as_judge_code import LlmAsJudgeCode
from .trace_filter import TraceFilter
from .trace_thread_llm_as_judge_code import TraceThreadLlmAsJudgeCode
from .trace_thread_user_defined_metric_python_code import TraceThreadUserDefinedMetricPythonCode
from .user_defined_metric_python_code import UserDefinedMetricPythonCode


class Base(UniversalBaseModel):
    id: typing.Optional[str] = None
    project_id: str
    project_name: typing.Optional[str] = None
    name: str
    sampling_rate: typing.Optional[float] = None
    enabled: typing.Optional[bool] = None
    filters: typing.Optional[typing.List[TraceFilter]] = None
    created_at: typing.Optional[dt.datetime] = None
    created_by: typing.Optional[str] = None
    last_updated_at: typing.Optional[dt.datetime] = None
    last_updated_by: typing.Optional[str] = None
    action: typing.Literal["evaluator"] = "evaluator"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AutomationRuleEvaluator_LlmAsJudge(Base):
    type: typing.Literal["llm_as_judge"] = "llm_as_judge"
    code: typing.Optional[LlmAsJudgeCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AutomationRuleEvaluator_UserDefinedMetricPython(Base):
    type: typing.Literal["user_defined_metric_python"] = "user_defined_metric_python"
    code: typing.Optional[UserDefinedMetricPythonCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AutomationRuleEvaluator_TraceThreadLlmAsJudge(Base):
    type: typing.Literal["trace_thread_llm_as_judge"] = "trace_thread_llm_as_judge"
    code: typing.Optional[TraceThreadLlmAsJudgeCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AutomationRuleEvaluator_TraceThreadUserDefinedMetricPython(Base):
    type: typing.Literal["trace_thread_user_defined_metric_python"] = "trace_thread_user_defined_metric_python"
    code: typing.Optional[TraceThreadUserDefinedMetricPythonCode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AutomationRuleEvaluator = typing.Union[
    AutomationRuleEvaluator_LlmAsJudge,
    AutomationRuleEvaluator_UserDefinedMetricPython,
    AutomationRuleEvaluator_TraceThreadLlmAsJudge,
    AutomationRuleEvaluator_TraceThreadUserDefinedMetricPython,
]
