# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .comment import Comment
from .experiment_item_trace_visibility_mode import ExperimentItemTraceVisibilityMode
from .feedback_score import FeedbackScore
from .json_list_string import JsonListString


class ExperimentItem(UniversalBaseModel):
    id: typing.Optional[str] = None
    experiment_id: str
    dataset_item_id: str
    trace_id: str
    input: typing.Optional[JsonListString] = None
    output: typing.Optional[JsonListString] = None
    feedback_scores: typing.Optional[typing.List[FeedbackScore]] = None
    comments: typing.Optional[typing.List[Comment]] = None
    total_estimated_cost: typing.Optional[float] = None
    duration: typing.Optional[float] = None
    usage: typing.Optional[typing.Dict[str, int]] = None
    created_at: typing.Optional[dt.datetime] = None
    last_updated_at: typing.Optional[dt.datetime] = None
    created_by: typing.Optional[str] = None
    last_updated_by: typing.Optional[str] = None
    trace_visibility_mode: typing.Optional[ExperimentItemTraceVisibilityMode] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
