# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .error_info import ErrorInfo
from .json_list_string import JsonListString
from .span_update_type import SpanUpdateType


class SpanUpdate(UniversalBaseModel):
    project_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    If null and project_id not specified, Default Project is assumed
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    If null and project_name not specified, Default Project is assumed
    """

    trace_id: str
    parent_span_id: typing.Optional[str] = None
    name: typing.Optional[str] = None
    type: typing.Optional[SpanUpdateType] = None
    end_time: typing.Optional[dt.datetime] = None
    input: typing.Optional[JsonListString] = None
    output: typing.Optional[JsonListString] = None
    metadata: typing.Optional[JsonListString] = None
    model: typing.Optional[str] = None
    provider: typing.Optional[str] = None
    tags: typing.Optional[typing.List[str]] = None
    usage: typing.Optional[typing.Dict[str, int]] = None
    total_estimated_cost: typing.Optional[float] = None
    error_info: typing.Optional[ErrorInfo] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
